/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.accounts;

import com.schematic.api.core.ClientOptions;
import com.schematic.api.core.RequestOptions;
import com.schematic.api.resources.accounts.requests.CountApiKeysRequest;
import com.schematic.api.resources.accounts.requests.CountApiRequestsRequest;
import com.schematic.api.resources.accounts.requests.CreateApiKeyRequestBody;
import com.schematic.api.resources.accounts.requests.CreateEnvironmentRequestBody;
import com.schematic.api.resources.accounts.requests.ListApiKeysRequest;
import com.schematic.api.resources.accounts.requests.ListApiRequestsRequest;
import com.schematic.api.resources.accounts.requests.ListEnvironmentsRequest;
import com.schematic.api.resources.accounts.requests.UpdateApiKeyRequestBody;
import com.schematic.api.resources.accounts.requests.UpdateEnvironmentRequestBody;
import com.schematic.api.resources.accounts.types.CountApiKeysResponse;
import com.schematic.api.resources.accounts.types.CountApiRequestsResponse;
import com.schematic.api.resources.accounts.types.CreateApiKeyResponse;
import com.schematic.api.resources.accounts.types.CreateEnvironmentResponse;
import com.schematic.api.resources.accounts.types.DeleteApiKeyResponse;
import com.schematic.api.resources.accounts.types.DeleteEnvironmentResponse;
import com.schematic.api.resources.accounts.types.GetApiKeyResponse;
import com.schematic.api.resources.accounts.types.GetApiRequestResponse;
import com.schematic.api.resources.accounts.types.GetEnvironmentResponse;
import com.schematic.api.resources.accounts.types.ListApiKeysResponse;
import com.schematic.api.resources.accounts.types.ListApiRequestsResponse;
import com.schematic.api.resources.accounts.types.ListEnvironmentsResponse;
import com.schematic.api.resources.accounts.types.QuickstartResponse;
import com.schematic.api.resources.accounts.types.UpdateApiKeyResponse;
import com.schematic.api.resources.accounts.types.UpdateEnvironmentResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncAccountsClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawAccountsClient rawClient;

    public AsyncAccountsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawAccountsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawAccountsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<ListApiKeysResponse> listApiKeys(ListApiKeysRequest request) {
        return this.rawClient.listApiKeys(request).thenApply(response -> response.body());
    }

    public CompletableFuture<ListApiKeysResponse> listApiKeys(
            ListApiKeysRequest request, RequestOptions requestOptions) {
        return this.rawClient.listApiKeys(request, requestOptions).thenApply(response -> response.body());
    }

    public CompletableFuture<CreateApiKeyResponse> createApiKey(CreateApiKeyRequestBody request) {
        return this.rawClient.createApiKey(request).thenApply(response -> response.body());
    }

    public CompletableFuture<CreateApiKeyResponse> createApiKey(
            CreateApiKeyRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.createApiKey(request, requestOptions).thenApply(response -> response.body());
    }

    public CompletableFuture<GetApiKeyResponse> getApiKey(String apiKeyId) {
        return this.rawClient.getApiKey(apiKeyId).thenApply(response -> response.body());
    }

    public CompletableFuture<GetApiKeyResponse> getApiKey(String apiKeyId, RequestOptions requestOptions) {
        return this.rawClient.getApiKey(apiKeyId, requestOptions).thenApply(response -> response.body());
    }

    public CompletableFuture<UpdateApiKeyResponse> updateApiKey(String apiKeyId) {
        return this.rawClient.updateApiKey(apiKeyId).thenApply(response -> response.body());
    }

    public CompletableFuture<UpdateApiKeyResponse> updateApiKey(String apiKeyId, UpdateApiKeyRequestBody request) {
        return this.rawClient.updateApiKey(apiKeyId, request).thenApply(response -> response.body());
    }

    public CompletableFuture<UpdateApiKeyResponse> updateApiKey(
            String apiKeyId, UpdateApiKeyRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.updateApiKey(apiKeyId, request, requestOptions).thenApply(response -> response.body());
    }

    public CompletableFuture<DeleteApiKeyResponse> deleteApiKey(String apiKeyId) {
        return this.rawClient.deleteApiKey(apiKeyId).thenApply(response -> response.body());
    }

    public CompletableFuture<DeleteApiKeyResponse> deleteApiKey(String apiKeyId, RequestOptions requestOptions) {
        return this.rawClient.deleteApiKey(apiKeyId, requestOptions).thenApply(response -> response.body());
    }

    public CompletableFuture<CountApiKeysResponse> countApiKeys(CountApiKeysRequest request) {
        return this.rawClient.countApiKeys(request).thenApply(response -> response.body());
    }

    public CompletableFuture<CountApiKeysResponse> countApiKeys(
            CountApiKeysRequest request, RequestOptions requestOptions) {
        return this.rawClient.countApiKeys(request, requestOptions).thenApply(response -> response.body());
    }

    public CompletableFuture<ListApiRequestsResponse> listApiRequests() {
        return this.rawClient.listApiRequests().thenApply(response -> response.body());
    }

    public CompletableFuture<ListApiRequestsResponse> listApiRequests(ListApiRequestsRequest request) {
        return this.rawClient.listApiRequests(request).thenApply(response -> response.body());
    }

    public CompletableFuture<ListApiRequestsResponse> listApiRequests(
            ListApiRequestsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listApiRequests(request, requestOptions).thenApply(response -> response.body());
    }

    public CompletableFuture<GetApiRequestResponse> getApiRequest(String apiRequestId) {
        return this.rawClient.getApiRequest(apiRequestId).thenApply(response -> response.body());
    }

    public CompletableFuture<GetApiRequestResponse> getApiRequest(String apiRequestId, RequestOptions requestOptions) {
        return this.rawClient.getApiRequest(apiRequestId, requestOptions).thenApply(response -> response.body());
    }

    public CompletableFuture<CountApiRequestsResponse> countApiRequests() {
        return this.rawClient.countApiRequests().thenApply(response -> response.body());
    }

    public CompletableFuture<CountApiRequestsResponse> countApiRequests(CountApiRequestsRequest request) {
        return this.rawClient.countApiRequests(request).thenApply(response -> response.body());
    }

    public CompletableFuture<CountApiRequestsResponse> countApiRequests(
            CountApiRequestsRequest request, RequestOptions requestOptions) {
        return this.rawClient.countApiRequests(request, requestOptions).thenApply(response -> response.body());
    }

    public CompletableFuture<ListEnvironmentsResponse> listEnvironments() {
        return this.rawClient.listEnvironments().thenApply(response -> response.body());
    }

    public CompletableFuture<ListEnvironmentsResponse> listEnvironments(ListEnvironmentsRequest request) {
        return this.rawClient.listEnvironments(request).thenApply(response -> response.body());
    }

    public CompletableFuture<ListEnvironmentsResponse> listEnvironments(
            ListEnvironmentsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listEnvironments(request, requestOptions).thenApply(response -> response.body());
    }

    public CompletableFuture<CreateEnvironmentResponse> createEnvironment(CreateEnvironmentRequestBody request) {
        return this.rawClient.createEnvironment(request).thenApply(response -> response.body());
    }

    public CompletableFuture<CreateEnvironmentResponse> createEnvironment(
            CreateEnvironmentRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.createEnvironment(request, requestOptions).thenApply(response -> response.body());
    }

    public CompletableFuture<GetEnvironmentResponse> getEnvironment(String environmentId) {
        return this.rawClient.getEnvironment(environmentId).thenApply(response -> response.body());
    }

    public CompletableFuture<GetEnvironmentResponse> getEnvironment(
            String environmentId, RequestOptions requestOptions) {
        return this.rawClient.getEnvironment(environmentId, requestOptions).thenApply(response -> response.body());
    }

    public CompletableFuture<UpdateEnvironmentResponse> updateEnvironment(String environmentId) {
        return this.rawClient.updateEnvironment(environmentId).thenApply(response -> response.body());
    }

    public CompletableFuture<UpdateEnvironmentResponse> updateEnvironment(
            String environmentId, UpdateEnvironmentRequestBody request) {
        return this.rawClient.updateEnvironment(environmentId, request).thenApply(response -> response.body());
    }

    public CompletableFuture<UpdateEnvironmentResponse> updateEnvironment(
            String environmentId, UpdateEnvironmentRequestBody request, RequestOptions requestOptions) {
        return this.rawClient
                .updateEnvironment(environmentId, request, requestOptions)
                .thenApply(response -> response.body());
    }

    public CompletableFuture<DeleteEnvironmentResponse> deleteEnvironment(String environmentId) {
        return this.rawClient.deleteEnvironment(environmentId).thenApply(response -> response.body());
    }

    public CompletableFuture<DeleteEnvironmentResponse> deleteEnvironment(
            String environmentId, RequestOptions requestOptions) {
        return this.rawClient.deleteEnvironment(environmentId, requestOptions).thenApply(response -> response.body());
    }

    public CompletableFuture<QuickstartResponse> quickstart() {
        return this.rawClient.quickstart().thenApply(response -> response.body());
    }

    public CompletableFuture<QuickstartResponse> quickstart(RequestOptions requestOptions) {
        return this.rawClient.quickstart(requestOptions).thenApply(response -> response.body());
    }
}
