/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.billing.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = SearchBillingPricesParams.Builder.class)
public final class SearchBillingPricesParams {
    private final Optional<Boolean> forInitialPlan;

    private final Optional<Boolean> forTrialExpiryPlan;

    private final Optional<List<String>> ids;

    private final Optional<String> interval;

    private final Optional<Integer> limit;

    private final Optional<Integer> offset;

    private final Optional<Integer> price;

    private final Optional<String> productId;

    private final Optional<String> q;

    private final Optional<Boolean> requiresPaymentMethod;

    private final Optional<SearchBillingPricesResponseParamsTiersMode> tiersMode;

    private final Optional<SearchBillingPricesResponseParamsUsageType> usageType;

    private final Map<String, Object> additionalProperties;

    private SearchBillingPricesParams(
            Optional<Boolean> forInitialPlan,
            Optional<Boolean> forTrialExpiryPlan,
            Optional<List<String>> ids,
            Optional<String> interval,
            Optional<Integer> limit,
            Optional<Integer> offset,
            Optional<Integer> price,
            Optional<String> productId,
            Optional<String> q,
            Optional<Boolean> requiresPaymentMethod,
            Optional<SearchBillingPricesResponseParamsTiersMode> tiersMode,
            Optional<SearchBillingPricesResponseParamsUsageType> usageType,
            Map<String, Object> additionalProperties) {
        this.forInitialPlan = forInitialPlan;
        this.forTrialExpiryPlan = forTrialExpiryPlan;
        this.ids = ids;
        this.interval = interval;
        this.limit = limit;
        this.offset = offset;
        this.price = price;
        this.productId = productId;
        this.q = q;
        this.requiresPaymentMethod = requiresPaymentMethod;
        this.tiersMode = tiersMode;
        this.usageType = usageType;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Filter for prices valid for initial plans (free prices only)
     */
    @JsonProperty("for_initial_plan")
    public Optional<Boolean> getForInitialPlan() {
        return forInitialPlan;
    }

    /**
     * @return Filter for prices valid for trial expiry plans (free prices only)
     */
    @JsonProperty("for_trial_expiry_plan")
    public Optional<Boolean> getForTrialExpiryPlan() {
        return forTrialExpiryPlan;
    }

    @JsonProperty("ids")
    public Optional<List<String>> getIds() {
        return ids;
    }

    @JsonProperty("interval")
    public Optional<String> getInterval() {
        return interval;
    }

    /**
     * @return Page limit (default 100)
     */
    @JsonProperty("limit")
    public Optional<Integer> getLimit() {
        return limit;
    }

    /**
     * @return Page offset (default 0)
     */
    @JsonProperty("offset")
    public Optional<Integer> getOffset() {
        return offset;
    }

    @JsonProperty("price")
    public Optional<Integer> getPrice() {
        return price;
    }

    @JsonProperty("product_id")
    public Optional<String> getProductId() {
        return productId;
    }

    @JsonProperty("q")
    public Optional<String> getQ() {
        return q;
    }

    /**
     * @return Filter for prices that require a payment method (inverse of ForInitialPlan)
     */
    @JsonProperty("requires_payment_method")
    public Optional<Boolean> getRequiresPaymentMethod() {
        return requiresPaymentMethod;
    }

    @JsonProperty("tiers_mode")
    public Optional<SearchBillingPricesResponseParamsTiersMode> getTiersMode() {
        return tiersMode;
    }

    @JsonProperty("usage_type")
    public Optional<SearchBillingPricesResponseParamsUsageType> getUsageType() {
        return usageType;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof SearchBillingPricesParams && equalTo((SearchBillingPricesParams) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SearchBillingPricesParams other) {
        return forInitialPlan.equals(other.forInitialPlan)
                && forTrialExpiryPlan.equals(other.forTrialExpiryPlan)
                && ids.equals(other.ids)
                && interval.equals(other.interval)
                && limit.equals(other.limit)
                && offset.equals(other.offset)
                && price.equals(other.price)
                && productId.equals(other.productId)
                && q.equals(other.q)
                && requiresPaymentMethod.equals(other.requiresPaymentMethod)
                && tiersMode.equals(other.tiersMode)
                && usageType.equals(other.usageType);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.forInitialPlan,
                this.forTrialExpiryPlan,
                this.ids,
                this.interval,
                this.limit,
                this.offset,
                this.price,
                this.productId,
                this.q,
                this.requiresPaymentMethod,
                this.tiersMode,
                this.usageType);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<Boolean> forInitialPlan = Optional.empty();

        private Optional<Boolean> forTrialExpiryPlan = Optional.empty();

        private Optional<List<String>> ids = Optional.empty();

        private Optional<String> interval = Optional.empty();

        private Optional<Integer> limit = Optional.empty();

        private Optional<Integer> offset = Optional.empty();

        private Optional<Integer> price = Optional.empty();

        private Optional<String> productId = Optional.empty();

        private Optional<String> q = Optional.empty();

        private Optional<Boolean> requiresPaymentMethod = Optional.empty();

        private Optional<SearchBillingPricesResponseParamsTiersMode> tiersMode = Optional.empty();

        private Optional<SearchBillingPricesResponseParamsUsageType> usageType = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(SearchBillingPricesParams other) {
            forInitialPlan(other.getForInitialPlan());
            forTrialExpiryPlan(other.getForTrialExpiryPlan());
            ids(other.getIds());
            interval(other.getInterval());
            limit(other.getLimit());
            offset(other.getOffset());
            price(other.getPrice());
            productId(other.getProductId());
            q(other.getQ());
            requiresPaymentMethod(other.getRequiresPaymentMethod());
            tiersMode(other.getTiersMode());
            usageType(other.getUsageType());
            return this;
        }

        /**
         * <p>Filter for prices valid for initial plans (free prices only)</p>
         */
        @JsonSetter(value = "for_initial_plan", nulls = Nulls.SKIP)
        public Builder forInitialPlan(Optional<Boolean> forInitialPlan) {
            this.forInitialPlan = forInitialPlan;
            return this;
        }

        public Builder forInitialPlan(Boolean forInitialPlan) {
            this.forInitialPlan = Optional.ofNullable(forInitialPlan);
            return this;
        }

        /**
         * <p>Filter for prices valid for trial expiry plans (free prices only)</p>
         */
        @JsonSetter(value = "for_trial_expiry_plan", nulls = Nulls.SKIP)
        public Builder forTrialExpiryPlan(Optional<Boolean> forTrialExpiryPlan) {
            this.forTrialExpiryPlan = forTrialExpiryPlan;
            return this;
        }

        public Builder forTrialExpiryPlan(Boolean forTrialExpiryPlan) {
            this.forTrialExpiryPlan = Optional.ofNullable(forTrialExpiryPlan);
            return this;
        }

        @JsonSetter(value = "ids", nulls = Nulls.SKIP)
        public Builder ids(Optional<List<String>> ids) {
            this.ids = ids;
            return this;
        }

        public Builder ids(List<String> ids) {
            this.ids = Optional.ofNullable(ids);
            return this;
        }

        @JsonSetter(value = "interval", nulls = Nulls.SKIP)
        public Builder interval(Optional<String> interval) {
            this.interval = interval;
            return this;
        }

        public Builder interval(String interval) {
            this.interval = Optional.ofNullable(interval);
            return this;
        }

        /**
         * <p>Page limit (default 100)</p>
         */
        @JsonSetter(value = "limit", nulls = Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        /**
         * <p>Page offset (default 0)</p>
         */
        @JsonSetter(value = "offset", nulls = Nulls.SKIP)
        public Builder offset(Optional<Integer> offset) {
            this.offset = offset;
            return this;
        }

        public Builder offset(Integer offset) {
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        @JsonSetter(value = "price", nulls = Nulls.SKIP)
        public Builder price(Optional<Integer> price) {
            this.price = price;
            return this;
        }

        public Builder price(Integer price) {
            this.price = Optional.ofNullable(price);
            return this;
        }

        @JsonSetter(value = "product_id", nulls = Nulls.SKIP)
        public Builder productId(Optional<String> productId) {
            this.productId = productId;
            return this;
        }

        public Builder productId(String productId) {
            this.productId = Optional.ofNullable(productId);
            return this;
        }

        @JsonSetter(value = "q", nulls = Nulls.SKIP)
        public Builder q(Optional<String> q) {
            this.q = q;
            return this;
        }

        public Builder q(String q) {
            this.q = Optional.ofNullable(q);
            return this;
        }

        /**
         * <p>Filter for prices that require a payment method (inverse of ForInitialPlan)</p>
         */
        @JsonSetter(value = "requires_payment_method", nulls = Nulls.SKIP)
        public Builder requiresPaymentMethod(Optional<Boolean> requiresPaymentMethod) {
            this.requiresPaymentMethod = requiresPaymentMethod;
            return this;
        }

        public Builder requiresPaymentMethod(Boolean requiresPaymentMethod) {
            this.requiresPaymentMethod = Optional.ofNullable(requiresPaymentMethod);
            return this;
        }

        @JsonSetter(value = "tiers_mode", nulls = Nulls.SKIP)
        public Builder tiersMode(Optional<SearchBillingPricesResponseParamsTiersMode> tiersMode) {
            this.tiersMode = tiersMode;
            return this;
        }

        public Builder tiersMode(SearchBillingPricesResponseParamsTiersMode tiersMode) {
            this.tiersMode = Optional.ofNullable(tiersMode);
            return this;
        }

        @JsonSetter(value = "usage_type", nulls = Nulls.SKIP)
        public Builder usageType(Optional<SearchBillingPricesResponseParamsUsageType> usageType) {
            this.usageType = usageType;
            return this;
        }

        public Builder usageType(SearchBillingPricesResponseParamsUsageType usageType) {
            this.usageType = Optional.ofNullable(usageType);
            return this;
        }

        public SearchBillingPricesParams build() {
            return new SearchBillingPricesParams(
                    forInitialPlan,
                    forTrialExpiryPlan,
                    ids,
                    interval,
                    limit,
                    offset,
                    price,
                    productId,
                    q,
                    requiresPaymentMethod,
                    tiersMode,
                    usageType,
                    additionalProperties);
        }
    }
}
