/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.companies;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.schematic.api.core.BaseSchematicApiException;
import com.schematic.api.core.BaseSchematicException;
import com.schematic.api.core.BaseSchematicHttpResponse;
import com.schematic.api.core.ClientOptions;
import com.schematic.api.core.MediaTypes;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.core.QueryStringMapper;
import com.schematic.api.core.RequestOptions;
import com.schematic.api.errors.BadRequestError;
import com.schematic.api.errors.ForbiddenError;
import com.schematic.api.errors.InternalServerError;
import com.schematic.api.errors.NotFoundError;
import com.schematic.api.errors.UnauthorizedError;
import com.schematic.api.resources.companies.requests.CountCompaniesForAdvancedFilterRequest;
import com.schematic.api.resources.companies.requests.CountCompaniesRequest;
import com.schematic.api.resources.companies.requests.CountEntityKeyDefinitionsRequest;
import com.schematic.api.resources.companies.requests.CountEntityTraitDefinitionsRequest;
import com.schematic.api.resources.companies.requests.CountPlanTraitsRequest;
import com.schematic.api.resources.companies.requests.CountUsersRequest;
import com.schematic.api.resources.companies.requests.CreateEntityTraitDefinitionRequestBody;
import com.schematic.api.resources.companies.requests.CreatePlanTraitRequestBody;
import com.schematic.api.resources.companies.requests.GetActiveCompanySubscriptionRequest;
import com.schematic.api.resources.companies.requests.GetActiveDealsRequest;
import com.schematic.api.resources.companies.requests.GetEntityTraitValuesRequest;
import com.schematic.api.resources.companies.requests.GetOrCreateCompanyMembershipRequestBody;
import com.schematic.api.resources.companies.requests.ListCompaniesForAdvancedFilterRequest;
import com.schematic.api.resources.companies.requests.ListCompaniesRequest;
import com.schematic.api.resources.companies.requests.ListCompanyMembershipsRequest;
import com.schematic.api.resources.companies.requests.ListEntityKeyDefinitionsRequest;
import com.schematic.api.resources.companies.requests.ListEntityTraitDefinitionsRequest;
import com.schematic.api.resources.companies.requests.ListPlanChangesRequest;
import com.schematic.api.resources.companies.requests.ListPlanTraitsRequest;
import com.schematic.api.resources.companies.requests.ListUsersRequest;
import com.schematic.api.resources.companies.requests.LookupCompanyRequest;
import com.schematic.api.resources.companies.requests.LookupUserRequest;
import com.schematic.api.resources.companies.requests.UpdateEntityTraitDefinitionRequestBody;
import com.schematic.api.resources.companies.requests.UpdatePlanTraitBulkRequestBody;
import com.schematic.api.resources.companies.requests.UpdatePlanTraitRequestBody;
import com.schematic.api.resources.companies.types.CountCompaniesForAdvancedFilterResponse;
import com.schematic.api.resources.companies.types.CountCompaniesResponse;
import com.schematic.api.resources.companies.types.CountEntityKeyDefinitionsResponse;
import com.schematic.api.resources.companies.types.CountEntityTraitDefinitionsResponse;
import com.schematic.api.resources.companies.types.CountPlanTraitsResponse;
import com.schematic.api.resources.companies.types.CountUsersResponse;
import com.schematic.api.resources.companies.types.CreateCompanyResponse;
import com.schematic.api.resources.companies.types.CreatePlanTraitResponse;
import com.schematic.api.resources.companies.types.CreateUserResponse;
import com.schematic.api.resources.companies.types.DeleteCompanyByKeysResponse;
import com.schematic.api.resources.companies.types.DeleteCompanyMembershipResponse;
import com.schematic.api.resources.companies.types.DeleteCompanyResponse;
import com.schematic.api.resources.companies.types.DeletePlanTraitResponse;
import com.schematic.api.resources.companies.types.DeleteUserByKeysResponse;
import com.schematic.api.resources.companies.types.DeleteUserResponse;
import com.schematic.api.resources.companies.types.GetActiveCompanySubscriptionResponse;
import com.schematic.api.resources.companies.types.GetActiveDealsResponse;
import com.schematic.api.resources.companies.types.GetCompanyResponse;
import com.schematic.api.resources.companies.types.GetEntityTraitDefinitionResponse;
import com.schematic.api.resources.companies.types.GetEntityTraitValuesResponse;
import com.schematic.api.resources.companies.types.GetOrCreateCompanyMembershipResponse;
import com.schematic.api.resources.companies.types.GetOrCreateEntityTraitDefinitionResponse;
import com.schematic.api.resources.companies.types.GetPlanChangeResponse;
import com.schematic.api.resources.companies.types.GetPlanTraitResponse;
import com.schematic.api.resources.companies.types.GetUserResponse;
import com.schematic.api.resources.companies.types.ListCompaniesForAdvancedFilterResponse;
import com.schematic.api.resources.companies.types.ListCompaniesResponse;
import com.schematic.api.resources.companies.types.ListCompanyMembershipsResponse;
import com.schematic.api.resources.companies.types.ListEntityKeyDefinitionsResponse;
import com.schematic.api.resources.companies.types.ListEntityTraitDefinitionsResponse;
import com.schematic.api.resources.companies.types.ListPlanChangesResponse;
import com.schematic.api.resources.companies.types.ListPlanTraitsResponse;
import com.schematic.api.resources.companies.types.ListUsersResponse;
import com.schematic.api.resources.companies.types.LookupCompanyResponse;
import com.schematic.api.resources.companies.types.LookupUserResponse;
import com.schematic.api.resources.companies.types.UpdateEntityTraitDefinitionResponse;
import com.schematic.api.resources.companies.types.UpdatePlanTraitResponse;
import com.schematic.api.resources.companies.types.UpdatePlanTraitsBulkResponse;
import com.schematic.api.resources.companies.types.UpsertCompanyResponse;
import com.schematic.api.resources.companies.types.UpsertCompanyTraitResponse;
import com.schematic.api.resources.companies.types.UpsertUserResponse;
import com.schematic.api.resources.companies.types.UpsertUserTraitResponse;
import com.schematic.api.types.ApiError;
import com.schematic.api.types.KeysRequestBody;
import com.schematic.api.types.UpsertCompanyRequestBody;
import com.schematic.api.types.UpsertTraitRequestBody;
import com.schematic.api.types.UpsertUserRequestBody;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class AsyncRawCompaniesClient {
    protected final ClientOptions clientOptions;

    public AsyncRawCompaniesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public CompletableFuture<BaseSchematicHttpResponse<ListCompaniesResponse>> listCompanies() {
        return listCompanies(ListCompaniesRequest.builder().build());
    }

    public CompletableFuture<BaseSchematicHttpResponse<ListCompaniesResponse>> listCompanies(
            ListCompaniesRequest request) {
        return listCompanies(request, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<ListCompaniesResponse>> listCompanies(
            ListCompaniesRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("companies");
        if (request.getPlanId().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "plan_id", request.getPlanId().get(), false);
        }
        if (request.getQ().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "q", request.getQ().get(), false);
        }
        if (request.getWithoutFeatureOverrideFor().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "without_feature_override_for",
                    request.getWithoutFeatureOverrideFor().get(),
                    false);
        }
        if (request.getWithoutPlan().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "without_plan", request.getWithoutPlan().get(), false);
        }
        if (request.getWithSubscription().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "with_subscription", request.getWithSubscription().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getOffset().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "offset", request.getOffset().get(), false);
        }
        if (request.getIds().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "ids", request.getIds().get(), true);
        }
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<ListCompaniesResponse>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListCompaniesResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 400:
                                future.completeExceptionally(new BadRequestError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<BaseSchematicHttpResponse<UpsertCompanyResponse>> upsertCompany(
            UpsertCompanyRequestBody request) {
        return upsertCompany(request, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<UpsertCompanyResponse>> upsertCompany(
            UpsertCompanyRequestBody request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("companies")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new BaseSchematicException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<UpsertCompanyResponse>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), UpsertCompanyResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 400:
                                future.completeExceptionally(new BadRequestError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<BaseSchematicHttpResponse<GetCompanyResponse>> getCompany(String companyId) {
        return getCompany(companyId, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<GetCompanyResponse>> getCompany(
            String companyId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("companies")
                .addPathSegment(companyId)
                .build();
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<GetCompanyResponse>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), GetCompanyResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<BaseSchematicHttpResponse<DeleteCompanyResponse>> deleteCompany(String companyId) {
        return deleteCompany(companyId, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<DeleteCompanyResponse>> deleteCompany(
            String companyId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("companies")
                .addPathSegment(companyId)
                .build();
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("DELETE", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<DeleteCompanyResponse>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), DeleteCompanyResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 400:
                                future.completeExceptionally(new BadRequestError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<BaseSchematicHttpResponse<CountCompaniesResponse>> countCompanies() {
        return countCompanies(CountCompaniesRequest.builder().build());
    }

    public CompletableFuture<BaseSchematicHttpResponse<CountCompaniesResponse>> countCompanies(
            CountCompaniesRequest request) {
        return countCompanies(request, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<CountCompaniesResponse>> countCompanies(
            CountCompaniesRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("companies/count");
        if (request.getPlanId().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "plan_id", request.getPlanId().get(), false);
        }
        if (request.getQ().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "q", request.getQ().get(), false);
        }
        if (request.getWithoutFeatureOverrideFor().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "without_feature_override_for",
                    request.getWithoutFeatureOverrideFor().get(),
                    false);
        }
        if (request.getWithoutPlan().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "without_plan", request.getWithoutPlan().get(), false);
        }
        if (request.getWithSubscription().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "with_subscription", request.getWithSubscription().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getOffset().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "offset", request.getOffset().get(), false);
        }
        if (request.getIds().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "ids", request.getIds().get(), true);
        }
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<CountCompaniesResponse>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBody.string(), CountCompaniesResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 400:
                                future.completeExceptionally(new BadRequestError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<BaseSchematicHttpResponse<CountCompaniesForAdvancedFilterResponse>>
            countCompaniesForAdvancedFilter() {
        return countCompaniesForAdvancedFilter(
                CountCompaniesForAdvancedFilterRequest.builder().build());
    }

    public CompletableFuture<BaseSchematicHttpResponse<CountCompaniesForAdvancedFilterResponse>>
            countCompaniesForAdvancedFilter(CountCompaniesForAdvancedFilterRequest request) {
        return countCompaniesForAdvancedFilter(request, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<CountCompaniesForAdvancedFilterResponse>>
            countCompaniesForAdvancedFilter(
                    CountCompaniesForAdvancedFilterRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("companies/count2");
        if (request.getMonetizedSubscriptions().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "monetized_subscriptions",
                    request.getMonetizedSubscriptions().get(),
                    false);
        }
        if (request.getQ().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "q", request.getQ().get(), false);
        }
        if (request.getWithoutPlan().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "without_plan", request.getWithoutPlan().get(), false);
        }
        if (request.getWithoutSubscription().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "without_subscription",
                    request.getWithoutSubscription().get(),
                    false);
        }
        if (request.getSortOrderColumn().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "sort_order_column", request.getSortOrderColumn().get(), false);
        }
        if (request.getSortOrderDirection().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "sort_order_direction",
                    request.getSortOrderDirection().get(),
                    false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getOffset().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "offset", request.getOffset().get(), false);
        }
        if (request.getIds().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "ids", request.getIds().get(), true);
        }
        if (request.getPlanIds().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "plan_ids", request.getPlanIds().get(), true);
        }
        if (request.getFeatureIds().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "feature_ids", request.getFeatureIds().get(), true);
        }
        if (request.getCreditTypeIds().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "credit_type_ids", request.getCreditTypeIds().get(), true);
        }
        if (request.getSubscriptionStatuses().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "subscription_statuses",
                    request.getSubscriptionStatuses().get(),
                    true);
        }
        if (request.getSubscriptionTypes().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "subscription_types",
                    request.getSubscriptionTypes().get(),
                    true);
        }
        if (request.getDisplayProperties().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "display_properties",
                    request.getDisplayProperties().get(),
                    true);
        }
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<CountCompaniesForAdvancedFilterResponse>> future =
                new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBody.string(), CountCompaniesForAdvancedFilterResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 400:
                                future.completeExceptionally(new BadRequestError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<BaseSchematicHttpResponse<CreateCompanyResponse>> createCompany(
            UpsertCompanyRequestBody request) {
        return createCompany(request, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<CreateCompanyResponse>> createCompany(
            UpsertCompanyRequestBody request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("companies/create")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new BaseSchematicException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<CreateCompanyResponse>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CreateCompanyResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 400:
                                future.completeExceptionally(new BadRequestError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<BaseSchematicHttpResponse<DeleteCompanyByKeysResponse>> deleteCompanyByKeys(
            KeysRequestBody request) {
        return deleteCompanyByKeys(request, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<DeleteCompanyByKeysResponse>> deleteCompanyByKeys(
            KeysRequestBody request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("companies/delete")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new BaseSchematicException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<DeleteCompanyByKeysResponse>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBody.string(), DeleteCompanyByKeysResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 400:
                                future.completeExceptionally(new BadRequestError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<BaseSchematicHttpResponse<ListCompaniesForAdvancedFilterResponse>>
            listCompaniesForAdvancedFilter() {
        return listCompaniesForAdvancedFilter(
                ListCompaniesForAdvancedFilterRequest.builder().build());
    }

    public CompletableFuture<BaseSchematicHttpResponse<ListCompaniesForAdvancedFilterResponse>>
            listCompaniesForAdvancedFilter(ListCompaniesForAdvancedFilterRequest request) {
        return listCompaniesForAdvancedFilter(request, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<ListCompaniesForAdvancedFilterResponse>>
            listCompaniesForAdvancedFilter(
                    ListCompaniesForAdvancedFilterRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("companies/list2");
        if (request.getMonetizedSubscriptions().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "monetized_subscriptions",
                    request.getMonetizedSubscriptions().get(),
                    false);
        }
        if (request.getQ().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "q", request.getQ().get(), false);
        }
        if (request.getWithoutPlan().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "without_plan", request.getWithoutPlan().get(), false);
        }
        if (request.getWithoutSubscription().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "without_subscription",
                    request.getWithoutSubscription().get(),
                    false);
        }
        if (request.getSortOrderColumn().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "sort_order_column", request.getSortOrderColumn().get(), false);
        }
        if (request.getSortOrderDirection().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "sort_order_direction",
                    request.getSortOrderDirection().get(),
                    false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getOffset().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "offset", request.getOffset().get(), false);
        }
        if (request.getIds().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "ids", request.getIds().get(), true);
        }
        if (request.getPlanIds().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "plan_ids", request.getPlanIds().get(), true);
        }
        if (request.getFeatureIds().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "feature_ids", request.getFeatureIds().get(), true);
        }
        if (request.getCreditTypeIds().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "credit_type_ids", request.getCreditTypeIds().get(), true);
        }
        if (request.getSubscriptionStatuses().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "subscription_statuses",
                    request.getSubscriptionStatuses().get(),
                    true);
        }
        if (request.getSubscriptionTypes().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "subscription_types",
                    request.getSubscriptionTypes().get(),
                    true);
        }
        if (request.getDisplayProperties().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "display_properties",
                    request.getDisplayProperties().get(),
                    true);
        }
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<ListCompaniesForAdvancedFilterResponse>> future =
                new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBody.string(), ListCompaniesForAdvancedFilterResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 400:
                                future.completeExceptionally(new BadRequestError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<BaseSchematicHttpResponse<LookupCompanyResponse>> lookupCompany(
            LookupCompanyRequest request) {
        return lookupCompany(request, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<LookupCompanyResponse>> lookupCompany(
            LookupCompanyRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("companies/lookup");
        QueryStringMapper.addQueryParameter(httpUrl, "keys", request.getKeys(), false);
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<LookupCompanyResponse>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), LookupCompanyResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<BaseSchematicHttpResponse<GetActiveDealsResponse>> getActiveDeals(
            GetActiveDealsRequest request) {
        return getActiveDeals(request, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<GetActiveDealsResponse>> getActiveDeals(
            GetActiveDealsRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("company-crm-deals");
        QueryStringMapper.addQueryParameter(httpUrl, "company_id", request.getCompanyId(), false);
        QueryStringMapper.addQueryParameter(httpUrl, "deal_stage", request.getDealStage(), false);
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getOffset().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "offset", request.getOffset().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<GetActiveDealsResponse>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBody.string(), GetActiveDealsResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 400:
                                future.completeExceptionally(new BadRequestError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<BaseSchematicHttpResponse<ListCompanyMembershipsResponse>> listCompanyMemberships() {
        return listCompanyMemberships(ListCompanyMembershipsRequest.builder().build());
    }

    public CompletableFuture<BaseSchematicHttpResponse<ListCompanyMembershipsResponse>> listCompanyMemberships(
            ListCompanyMembershipsRequest request) {
        return listCompanyMemberships(request, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<ListCompanyMembershipsResponse>> listCompanyMemberships(
            ListCompanyMembershipsRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("company-memberships");
        if (request.getCompanyId().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "company_id", request.getCompanyId().get(), false);
        }
        if (request.getUserId().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "user_id", request.getUserId().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getOffset().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "offset", request.getOffset().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<ListCompanyMembershipsResponse>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBody.string(), ListCompanyMembershipsResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 400:
                                future.completeExceptionally(new BadRequestError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<BaseSchematicHttpResponse<GetOrCreateCompanyMembershipResponse>>
            getOrCreateCompanyMembership(GetOrCreateCompanyMembershipRequestBody request) {
        return getOrCreateCompanyMembership(request, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<GetOrCreateCompanyMembershipResponse>>
            getOrCreateCompanyMembership(
                    GetOrCreateCompanyMembershipRequestBody request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("company-memberships")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new BaseSchematicException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<GetOrCreateCompanyMembershipResponse>> future =
                new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBody.string(), GetOrCreateCompanyMembershipResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 400:
                                future.completeExceptionally(new BadRequestError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<BaseSchematicHttpResponse<DeleteCompanyMembershipResponse>> deleteCompanyMembership(
            String companyMembershipId) {
        return deleteCompanyMembership(companyMembershipId, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<DeleteCompanyMembershipResponse>> deleteCompanyMembership(
            String companyMembershipId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("company-memberships")
                .addPathSegment(companyMembershipId)
                .build();
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("DELETE", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<DeleteCompanyMembershipResponse>> future =
                new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBody.string(), DeleteCompanyMembershipResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 400:
                                future.completeExceptionally(new BadRequestError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<BaseSchematicHttpResponse<GetActiveCompanySubscriptionResponse>>
            getActiveCompanySubscription() {
        return getActiveCompanySubscription(
                GetActiveCompanySubscriptionRequest.builder().build());
    }

    public CompletableFuture<BaseSchematicHttpResponse<GetActiveCompanySubscriptionResponse>>
            getActiveCompanySubscription(GetActiveCompanySubscriptionRequest request) {
        return getActiveCompanySubscription(request, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<GetActiveCompanySubscriptionResponse>>
            getActiveCompanySubscription(GetActiveCompanySubscriptionRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("company-subscriptions");
        if (request.getCompanyId().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "company_id", request.getCompanyId().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getOffset().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "offset", request.getOffset().get(), false);
        }
        if (request.getCompanyIds().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "company_ids", request.getCompanyIds().get(), true);
        }
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<GetActiveCompanySubscriptionResponse>> future =
                new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBody.string(), GetActiveCompanySubscriptionResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 400:
                                future.completeExceptionally(new BadRequestError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<BaseSchematicHttpResponse<UpsertCompanyTraitResponse>> upsertCompanyTrait(
            UpsertTraitRequestBody request) {
        return upsertCompanyTrait(request, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<UpsertCompanyTraitResponse>> upsertCompanyTrait(
            UpsertTraitRequestBody request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("company-traits")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new BaseSchematicException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<UpsertCompanyTraitResponse>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBody.string(), UpsertCompanyTraitResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 400:
                                future.completeExceptionally(new BadRequestError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<BaseSchematicHttpResponse<ListEntityKeyDefinitionsResponse>> listEntityKeyDefinitions() {
        return listEntityKeyDefinitions(
                ListEntityKeyDefinitionsRequest.builder().build());
    }

    public CompletableFuture<BaseSchematicHttpResponse<ListEntityKeyDefinitionsResponse>> listEntityKeyDefinitions(
            ListEntityKeyDefinitionsRequest request) {
        return listEntityKeyDefinitions(request, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<ListEntityKeyDefinitionsResponse>> listEntityKeyDefinitions(
            ListEntityKeyDefinitionsRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("entity-key-definitions");
        if (request.getEntityType().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "entity_type", request.getEntityType().get(), false);
        }
        if (request.getQ().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "q", request.getQ().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getOffset().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "offset", request.getOffset().get(), false);
        }
        if (request.getIds().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "ids", request.getIds().get(), true);
        }
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<ListEntityKeyDefinitionsResponse>> future =
                new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBody.string(), ListEntityKeyDefinitionsResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 400:
                                future.completeExceptionally(new BadRequestError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<BaseSchematicHttpResponse<CountEntityKeyDefinitionsResponse>> countEntityKeyDefinitions() {
        return countEntityKeyDefinitions(
                CountEntityKeyDefinitionsRequest.builder().build());
    }

    public CompletableFuture<BaseSchematicHttpResponse<CountEntityKeyDefinitionsResponse>> countEntityKeyDefinitions(
            CountEntityKeyDefinitionsRequest request) {
        return countEntityKeyDefinitions(request, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<CountEntityKeyDefinitionsResponse>> countEntityKeyDefinitions(
            CountEntityKeyDefinitionsRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("entity-key-definitions/count");
        if (request.getEntityType().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "entity_type", request.getEntityType().get(), false);
        }
        if (request.getQ().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "q", request.getQ().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getOffset().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "offset", request.getOffset().get(), false);
        }
        if (request.getIds().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "ids", request.getIds().get(), true);
        }
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<CountEntityKeyDefinitionsResponse>> future =
                new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBody.string(), CountEntityKeyDefinitionsResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 400:
                                future.completeExceptionally(new BadRequestError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<BaseSchematicHttpResponse<ListEntityTraitDefinitionsResponse>>
            listEntityTraitDefinitions() {
        return listEntityTraitDefinitions(
                ListEntityTraitDefinitionsRequest.builder().build());
    }

    public CompletableFuture<BaseSchematicHttpResponse<ListEntityTraitDefinitionsResponse>> listEntityTraitDefinitions(
            ListEntityTraitDefinitionsRequest request) {
        return listEntityTraitDefinitions(request, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<ListEntityTraitDefinitionsResponse>> listEntityTraitDefinitions(
            ListEntityTraitDefinitionsRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("entity-trait-definitions");
        if (request.getEntityType().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "entity_type", request.getEntityType().get(), false);
        }
        if (request.getQ().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "q", request.getQ().get(), false);
        }
        if (request.getTraitType().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "trait_type", request.getTraitType().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getOffset().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "offset", request.getOffset().get(), false);
        }
        if (request.getIds().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "ids", request.getIds().get(), true);
        }
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<ListEntityTraitDefinitionsResponse>> future =
                new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBody.string(), ListEntityTraitDefinitionsResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 400:
                                future.completeExceptionally(new BadRequestError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<BaseSchematicHttpResponse<GetOrCreateEntityTraitDefinitionResponse>>
            getOrCreateEntityTraitDefinition(CreateEntityTraitDefinitionRequestBody request) {
        return getOrCreateEntityTraitDefinition(request, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<GetOrCreateEntityTraitDefinitionResponse>>
            getOrCreateEntityTraitDefinition(
                    CreateEntityTraitDefinitionRequestBody request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("entity-trait-definitions")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new BaseSchematicException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<GetOrCreateEntityTraitDefinitionResponse>> future =
                new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBody.string(), GetOrCreateEntityTraitDefinitionResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 400:
                                future.completeExceptionally(new BadRequestError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<BaseSchematicHttpResponse<GetEntityTraitDefinitionResponse>> getEntityTraitDefinition(
            String entityTraitDefinitionId) {
        return getEntityTraitDefinition(entityTraitDefinitionId, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<GetEntityTraitDefinitionResponse>> getEntityTraitDefinition(
            String entityTraitDefinitionId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("entity-trait-definitions")
                .addPathSegment(entityTraitDefinitionId)
                .build();
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<GetEntityTraitDefinitionResponse>> future =
                new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBody.string(), GetEntityTraitDefinitionResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<BaseSchematicHttpResponse<UpdateEntityTraitDefinitionResponse>>
            updateEntityTraitDefinition(
                    String entityTraitDefinitionId, UpdateEntityTraitDefinitionRequestBody request) {
        return updateEntityTraitDefinition(entityTraitDefinitionId, request, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<UpdateEntityTraitDefinitionResponse>>
            updateEntityTraitDefinition(
                    String entityTraitDefinitionId,
                    UpdateEntityTraitDefinitionRequestBody request,
                    RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("entity-trait-definitions")
                .addPathSegment(entityTraitDefinitionId)
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new BaseSchematicException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("PUT", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<UpdateEntityTraitDefinitionResponse>> future =
                new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBody.string(), UpdateEntityTraitDefinitionResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 400:
                                future.completeExceptionally(new BadRequestError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<BaseSchematicHttpResponse<CountEntityTraitDefinitionsResponse>>
            countEntityTraitDefinitions() {
        return countEntityTraitDefinitions(
                CountEntityTraitDefinitionsRequest.builder().build());
    }

    public CompletableFuture<BaseSchematicHttpResponse<CountEntityTraitDefinitionsResponse>>
            countEntityTraitDefinitions(CountEntityTraitDefinitionsRequest request) {
        return countEntityTraitDefinitions(request, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<CountEntityTraitDefinitionsResponse>>
            countEntityTraitDefinitions(CountEntityTraitDefinitionsRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("entity-trait-definitions/count");
        if (request.getEntityType().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "entity_type", request.getEntityType().get(), false);
        }
        if (request.getQ().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "q", request.getQ().get(), false);
        }
        if (request.getTraitType().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "trait_type", request.getTraitType().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getOffset().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "offset", request.getOffset().get(), false);
        }
        if (request.getIds().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "ids", request.getIds().get(), true);
        }
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<CountEntityTraitDefinitionsResponse>> future =
                new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBody.string(), CountEntityTraitDefinitionsResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 400:
                                future.completeExceptionally(new BadRequestError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<BaseSchematicHttpResponse<GetEntityTraitValuesResponse>> getEntityTraitValues(
            GetEntityTraitValuesRequest request) {
        return getEntityTraitValues(request, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<GetEntityTraitValuesResponse>> getEntityTraitValues(
            GetEntityTraitValuesRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("entity-trait-values");
        QueryStringMapper.addQueryParameter(httpUrl, "definition_id", request.getDefinitionId(), false);
        if (request.getQ().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "q", request.getQ().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getOffset().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "offset", request.getOffset().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<GetEntityTraitValuesResponse>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBody.string(), GetEntityTraitValuesResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 400:
                                future.completeExceptionally(new BadRequestError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<BaseSchematicHttpResponse<ListPlanChangesResponse>> listPlanChanges() {
        return listPlanChanges(ListPlanChangesRequest.builder().build());
    }

    public CompletableFuture<BaseSchematicHttpResponse<ListPlanChangesResponse>> listPlanChanges(
            ListPlanChangesRequest request) {
        return listPlanChanges(request, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<ListPlanChangesResponse>> listPlanChanges(
            ListPlanChangesRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("plan-changes");
        if (request.getAction().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "action", request.getAction().get(), false);
        }
        if (request.getBasePlanAction().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "base_plan_action", request.getBasePlanAction().get(), false);
        }
        if (request.getCompanyId().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "company_id", request.getCompanyId().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getOffset().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "offset", request.getOffset().get(), false);
        }
        if (request.getCompanyIds().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "company_ids", request.getCompanyIds().get(), true);
        }
        if (request.getPlanIds().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "plan_ids", request.getPlanIds().get(), true);
        }
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<ListPlanChangesResponse>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBody.string(), ListPlanChangesResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 400:
                                future.completeExceptionally(new BadRequestError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<BaseSchematicHttpResponse<GetPlanChangeResponse>> getPlanChange(String planChangeId) {
        return getPlanChange(planChangeId, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<GetPlanChangeResponse>> getPlanChange(
            String planChangeId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("plan-changes")
                .addPathSegment(planChangeId)
                .build();
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<GetPlanChangeResponse>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), GetPlanChangeResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<BaseSchematicHttpResponse<ListPlanTraitsResponse>> listPlanTraits() {
        return listPlanTraits(ListPlanTraitsRequest.builder().build());
    }

    public CompletableFuture<BaseSchematicHttpResponse<ListPlanTraitsResponse>> listPlanTraits(
            ListPlanTraitsRequest request) {
        return listPlanTraits(request, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<ListPlanTraitsResponse>> listPlanTraits(
            ListPlanTraitsRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("plan-traits");
        if (request.getPlanId().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "plan_id", request.getPlanId().get(), false);
        }
        if (request.getTraitId().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "trait_id", request.getTraitId().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getOffset().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "offset", request.getOffset().get(), false);
        }
        if (request.getIds().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "ids", request.getIds().get(), true);
        }
        if (request.getTraitIds().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "trait_ids", request.getTraitIds().get(), true);
        }
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<ListPlanTraitsResponse>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBody.string(), ListPlanTraitsResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 400:
                                future.completeExceptionally(new BadRequestError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<BaseSchematicHttpResponse<CreatePlanTraitResponse>> createPlanTrait(
            CreatePlanTraitRequestBody request) {
        return createPlanTrait(request, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<CreatePlanTraitResponse>> createPlanTrait(
            CreatePlanTraitRequestBody request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("plan-traits")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new BaseSchematicException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<CreatePlanTraitResponse>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBody.string(), CreatePlanTraitResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 400:
                                future.completeExceptionally(new BadRequestError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<BaseSchematicHttpResponse<GetPlanTraitResponse>> getPlanTrait(String planTraitId) {
        return getPlanTrait(planTraitId, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<GetPlanTraitResponse>> getPlanTrait(
            String planTraitId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("plan-traits")
                .addPathSegment(planTraitId)
                .build();
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<GetPlanTraitResponse>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), GetPlanTraitResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<BaseSchematicHttpResponse<UpdatePlanTraitResponse>> updatePlanTrait(
            String planTraitId, UpdatePlanTraitRequestBody request) {
        return updatePlanTrait(planTraitId, request, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<UpdatePlanTraitResponse>> updatePlanTrait(
            String planTraitId, UpdatePlanTraitRequestBody request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("plan-traits")
                .addPathSegment(planTraitId)
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new BaseSchematicException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("PUT", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<UpdatePlanTraitResponse>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBody.string(), UpdatePlanTraitResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 400:
                                future.completeExceptionally(new BadRequestError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<BaseSchematicHttpResponse<DeletePlanTraitResponse>> deletePlanTrait(String planTraitId) {
        return deletePlanTrait(planTraitId, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<DeletePlanTraitResponse>> deletePlanTrait(
            String planTraitId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("plan-traits")
                .addPathSegment(planTraitId)
                .build();
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("DELETE", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<DeletePlanTraitResponse>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBody.string(), DeletePlanTraitResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 400:
                                future.completeExceptionally(new BadRequestError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<BaseSchematicHttpResponse<UpdatePlanTraitsBulkResponse>> updatePlanTraitsBulk(
            UpdatePlanTraitBulkRequestBody request) {
        return updatePlanTraitsBulk(request, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<UpdatePlanTraitsBulkResponse>> updatePlanTraitsBulk(
            UpdatePlanTraitBulkRequestBody request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("plan-traits/bulk")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new BaseSchematicException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<UpdatePlanTraitsBulkResponse>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBody.string(), UpdatePlanTraitsBulkResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 400:
                                future.completeExceptionally(new BadRequestError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<BaseSchematicHttpResponse<CountPlanTraitsResponse>> countPlanTraits() {
        return countPlanTraits(CountPlanTraitsRequest.builder().build());
    }

    public CompletableFuture<BaseSchematicHttpResponse<CountPlanTraitsResponse>> countPlanTraits(
            CountPlanTraitsRequest request) {
        return countPlanTraits(request, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<CountPlanTraitsResponse>> countPlanTraits(
            CountPlanTraitsRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("plan-traits/count");
        if (request.getPlanId().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "plan_id", request.getPlanId().get(), false);
        }
        if (request.getTraitId().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "trait_id", request.getTraitId().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getOffset().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "offset", request.getOffset().get(), false);
        }
        if (request.getIds().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "ids", request.getIds().get(), true);
        }
        if (request.getTraitIds().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "trait_ids", request.getTraitIds().get(), true);
        }
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<CountPlanTraitsResponse>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBody.string(), CountPlanTraitsResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 400:
                                future.completeExceptionally(new BadRequestError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<BaseSchematicHttpResponse<UpsertUserTraitResponse>> upsertUserTrait(
            UpsertTraitRequestBody request) {
        return upsertUserTrait(request, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<UpsertUserTraitResponse>> upsertUserTrait(
            UpsertTraitRequestBody request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("user-traits")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new BaseSchematicException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<UpsertUserTraitResponse>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBody.string(), UpsertUserTraitResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 400:
                                future.completeExceptionally(new BadRequestError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<BaseSchematicHttpResponse<ListUsersResponse>> listUsers() {
        return listUsers(ListUsersRequest.builder().build());
    }

    public CompletableFuture<BaseSchematicHttpResponse<ListUsersResponse>> listUsers(ListUsersRequest request) {
        return listUsers(request, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<ListUsersResponse>> listUsers(
            ListUsersRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("users");
        if (request.getCompanyId().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "company_id", request.getCompanyId().get(), false);
        }
        if (request.getPlanId().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "plan_id", request.getPlanId().get(), false);
        }
        if (request.getQ().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "q", request.getQ().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getOffset().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "offset", request.getOffset().get(), false);
        }
        if (request.getIds().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "ids", request.getIds().get(), true);
        }
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<ListUsersResponse>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListUsersResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 400:
                                future.completeExceptionally(new BadRequestError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<BaseSchematicHttpResponse<UpsertUserResponse>> upsertUser(UpsertUserRequestBody request) {
        return upsertUser(request, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<UpsertUserResponse>> upsertUser(
            UpsertUserRequestBody request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("users")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new BaseSchematicException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<UpsertUserResponse>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), UpsertUserResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 400:
                                future.completeExceptionally(new BadRequestError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<BaseSchematicHttpResponse<GetUserResponse>> getUser(String userId) {
        return getUser(userId, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<GetUserResponse>> getUser(
            String userId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("users")
                .addPathSegment(userId)
                .build();
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<GetUserResponse>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), GetUserResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<BaseSchematicHttpResponse<DeleteUserResponse>> deleteUser(String userId) {
        return deleteUser(userId, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<DeleteUserResponse>> deleteUser(
            String userId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("users")
                .addPathSegment(userId)
                .build();
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("DELETE", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<DeleteUserResponse>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), DeleteUserResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 400:
                                future.completeExceptionally(new BadRequestError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<BaseSchematicHttpResponse<CountUsersResponse>> countUsers() {
        return countUsers(CountUsersRequest.builder().build());
    }

    public CompletableFuture<BaseSchematicHttpResponse<CountUsersResponse>> countUsers(CountUsersRequest request) {
        return countUsers(request, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<CountUsersResponse>> countUsers(
            CountUsersRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("users/count");
        if (request.getCompanyId().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "company_id", request.getCompanyId().get(), false);
        }
        if (request.getPlanId().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "plan_id", request.getPlanId().get(), false);
        }
        if (request.getQ().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "q", request.getQ().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getOffset().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "offset", request.getOffset().get(), false);
        }
        if (request.getIds().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "ids", request.getIds().get(), true);
        }
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<CountUsersResponse>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CountUsersResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 400:
                                future.completeExceptionally(new BadRequestError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<BaseSchematicHttpResponse<CreateUserResponse>> createUser(UpsertUserRequestBody request) {
        return createUser(request, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<CreateUserResponse>> createUser(
            UpsertUserRequestBody request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("users/create")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new BaseSchematicException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<CreateUserResponse>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CreateUserResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 400:
                                future.completeExceptionally(new BadRequestError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<BaseSchematicHttpResponse<DeleteUserByKeysResponse>> deleteUserByKeys(
            KeysRequestBody request) {
        return deleteUserByKeys(request, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<DeleteUserByKeysResponse>> deleteUserByKeys(
            KeysRequestBody request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("users/delete")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new BaseSchematicException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<DeleteUserByKeysResponse>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBody.string(), DeleteUserByKeysResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 400:
                                future.completeExceptionally(new BadRequestError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<BaseSchematicHttpResponse<LookupUserResponse>> lookupUser(LookupUserRequest request) {
        return lookupUser(request, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<LookupUserResponse>> lookupUser(
            LookupUserRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("users/lookup");
        QueryStringMapper.addQueryParameter(httpUrl, "keys", request.getKeys(), false);
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<LookupUserResponse>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), LookupUserResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }
}
