/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.companies.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.resources.companies.types.CountEntityTraitDefinitionsRequestEntityType;
import com.schematic.api.resources.companies.types.CountEntityTraitDefinitionsRequestTraitType;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CountEntityTraitDefinitionsRequest.Builder.class)
public final class CountEntityTraitDefinitionsRequest {
    private final Optional<List<String>> ids;

    private final Optional<CountEntityTraitDefinitionsRequestEntityType> entityType;

    private final Optional<String> q;

    private final Optional<CountEntityTraitDefinitionsRequestTraitType> traitType;

    private final Optional<Integer> limit;

    private final Optional<Integer> offset;

    private final Map<String, Object> additionalProperties;

    private CountEntityTraitDefinitionsRequest(
            Optional<List<String>> ids,
            Optional<CountEntityTraitDefinitionsRequestEntityType> entityType,
            Optional<String> q,
            Optional<CountEntityTraitDefinitionsRequestTraitType> traitType,
            Optional<Integer> limit,
            Optional<Integer> offset,
            Map<String, Object> additionalProperties) {
        this.ids = ids;
        this.entityType = entityType;
        this.q = q;
        this.traitType = traitType;
        this.limit = limit;
        this.offset = offset;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("ids")
    public Optional<List<String>> getIds() {
        return ids;
    }

    @JsonProperty("entity_type")
    public Optional<CountEntityTraitDefinitionsRequestEntityType> getEntityType() {
        return entityType;
    }

    @JsonProperty("q")
    public Optional<String> getQ() {
        return q;
    }

    @JsonProperty("trait_type")
    public Optional<CountEntityTraitDefinitionsRequestTraitType> getTraitType() {
        return traitType;
    }

    /**
     * @return Page limit (default 100)
     */
    @JsonProperty("limit")
    public Optional<Integer> getLimit() {
        return limit;
    }

    /**
     * @return Page offset (default 0)
     */
    @JsonProperty("offset")
    public Optional<Integer> getOffset() {
        return offset;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CountEntityTraitDefinitionsRequest
                && equalTo((CountEntityTraitDefinitionsRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CountEntityTraitDefinitionsRequest other) {
        return ids.equals(other.ids)
                && entityType.equals(other.entityType)
                && q.equals(other.q)
                && traitType.equals(other.traitType)
                && limit.equals(other.limit)
                && offset.equals(other.offset);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.ids, this.entityType, this.q, this.traitType, this.limit, this.offset);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<List<String>> ids = Optional.empty();

        private Optional<CountEntityTraitDefinitionsRequestEntityType> entityType = Optional.empty();

        private Optional<String> q = Optional.empty();

        private Optional<CountEntityTraitDefinitionsRequestTraitType> traitType = Optional.empty();

        private Optional<Integer> limit = Optional.empty();

        private Optional<Integer> offset = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(CountEntityTraitDefinitionsRequest other) {
            ids(other.getIds());
            entityType(other.getEntityType());
            q(other.getQ());
            traitType(other.getTraitType());
            limit(other.getLimit());
            offset(other.getOffset());
            return this;
        }

        @JsonSetter(value = "ids", nulls = Nulls.SKIP)
        public Builder ids(Optional<List<String>> ids) {
            this.ids = ids;
            return this;
        }

        public Builder ids(List<String> ids) {
            this.ids = Optional.ofNullable(ids);
            return this;
        }

        public Builder ids(String ids) {
            this.ids = Optional.of(Collections.singletonList(ids));
            return this;
        }

        @JsonSetter(value = "entity_type", nulls = Nulls.SKIP)
        public Builder entityType(Optional<CountEntityTraitDefinitionsRequestEntityType> entityType) {
            this.entityType = entityType;
            return this;
        }

        public Builder entityType(CountEntityTraitDefinitionsRequestEntityType entityType) {
            this.entityType = Optional.ofNullable(entityType);
            return this;
        }

        @JsonSetter(value = "q", nulls = Nulls.SKIP)
        public Builder q(Optional<String> q) {
            this.q = q;
            return this;
        }

        public Builder q(String q) {
            this.q = Optional.ofNullable(q);
            return this;
        }

        @JsonSetter(value = "trait_type", nulls = Nulls.SKIP)
        public Builder traitType(Optional<CountEntityTraitDefinitionsRequestTraitType> traitType) {
            this.traitType = traitType;
            return this;
        }

        public Builder traitType(CountEntityTraitDefinitionsRequestTraitType traitType) {
            this.traitType = Optional.ofNullable(traitType);
            return this;
        }

        /**
         * <p>Page limit (default 100)</p>
         */
        @JsonSetter(value = "limit", nulls = Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        /**
         * <p>Page offset (default 0)</p>
         */
        @JsonSetter(value = "offset", nulls = Nulls.SKIP)
        public Builder offset(Optional<Integer> offset) {
            this.offset = offset;
            return this;
        }

        public Builder offset(Integer offset) {
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        public CountEntityTraitDefinitionsRequest build() {
            return new CountEntityTraitDefinitionsRequest(
                    ids, entityType, q, traitType, limit, offset, additionalProperties);
        }
    }
}
