/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.companies.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ListPlanTraitsRequest.Builder.class)
public final class ListPlanTraitsRequest {
    private final Optional<List<String>> ids;

    private final Optional<List<String>> traitIds;

    private final Optional<String> planId;

    private final Optional<String> traitId;

    private final Optional<Integer> limit;

    private final Optional<Integer> offset;

    private final Map<String, Object> additionalProperties;

    private ListPlanTraitsRequest(
            Optional<List<String>> ids,
            Optional<List<String>> traitIds,
            Optional<String> planId,
            Optional<String> traitId,
            Optional<Integer> limit,
            Optional<Integer> offset,
            Map<String, Object> additionalProperties) {
        this.ids = ids;
        this.traitIds = traitIds;
        this.planId = planId;
        this.traitId = traitId;
        this.limit = limit;
        this.offset = offset;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("ids")
    public Optional<List<String>> getIds() {
        return ids;
    }

    @JsonProperty("trait_ids")
    public Optional<List<String>> getTraitIds() {
        return traitIds;
    }

    @JsonProperty("plan_id")
    public Optional<String> getPlanId() {
        return planId;
    }

    @JsonProperty("trait_id")
    public Optional<String> getTraitId() {
        return traitId;
    }

    /**
     * @return Page limit (default 100)
     */
    @JsonProperty("limit")
    public Optional<Integer> getLimit() {
        return limit;
    }

    /**
     * @return Page offset (default 0)
     */
    @JsonProperty("offset")
    public Optional<Integer> getOffset() {
        return offset;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ListPlanTraitsRequest && equalTo((ListPlanTraitsRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListPlanTraitsRequest other) {
        return ids.equals(other.ids)
                && traitIds.equals(other.traitIds)
                && planId.equals(other.planId)
                && traitId.equals(other.traitId)
                && limit.equals(other.limit)
                && offset.equals(other.offset);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.ids, this.traitIds, this.planId, this.traitId, this.limit, this.offset);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<List<String>> ids = Optional.empty();

        private Optional<List<String>> traitIds = Optional.empty();

        private Optional<String> planId = Optional.empty();

        private Optional<String> traitId = Optional.empty();

        private Optional<Integer> limit = Optional.empty();

        private Optional<Integer> offset = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ListPlanTraitsRequest other) {
            ids(other.getIds());
            traitIds(other.getTraitIds());
            planId(other.getPlanId());
            traitId(other.getTraitId());
            limit(other.getLimit());
            offset(other.getOffset());
            return this;
        }

        @JsonSetter(value = "ids", nulls = Nulls.SKIP)
        public Builder ids(Optional<List<String>> ids) {
            this.ids = ids;
            return this;
        }

        public Builder ids(List<String> ids) {
            this.ids = Optional.ofNullable(ids);
            return this;
        }

        public Builder ids(String ids) {
            this.ids = Optional.of(Collections.singletonList(ids));
            return this;
        }

        @JsonSetter(value = "trait_ids", nulls = Nulls.SKIP)
        public Builder traitIds(Optional<List<String>> traitIds) {
            this.traitIds = traitIds;
            return this;
        }

        public Builder traitIds(List<String> traitIds) {
            this.traitIds = Optional.ofNullable(traitIds);
            return this;
        }

        public Builder traitIds(String traitIds) {
            this.traitIds = Optional.of(Collections.singletonList(traitIds));
            return this;
        }

        @JsonSetter(value = "plan_id", nulls = Nulls.SKIP)
        public Builder planId(Optional<String> planId) {
            this.planId = planId;
            return this;
        }

        public Builder planId(String planId) {
            this.planId = Optional.ofNullable(planId);
            return this;
        }

        @JsonSetter(value = "trait_id", nulls = Nulls.SKIP)
        public Builder traitId(Optional<String> traitId) {
            this.traitId = traitId;
            return this;
        }

        public Builder traitId(String traitId) {
            this.traitId = Optional.ofNullable(traitId);
            return this;
        }

        /**
         * <p>Page limit (default 100)</p>
         */
        @JsonSetter(value = "limit", nulls = Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        /**
         * <p>Page offset (default 0)</p>
         */
        @JsonSetter(value = "offset", nulls = Nulls.SKIP)
        public Builder offset(Optional<Integer> offset) {
            this.offset = offset;
            return this;
        }

        public Builder offset(Integer offset) {
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        public ListPlanTraitsRequest build() {
            return new ListPlanTraitsRequest(ids, traitIds, planId, traitId, limit, offset, additionalProperties);
        }
    }
}
