/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.companies.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.UpdatePlanTraitTraitRequestBody;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = UpdatePlanTraitBulkRequestBody.Builder.class)
public final class UpdatePlanTraitBulkRequestBody {
    private final String planId;

    private final List<UpdatePlanTraitTraitRequestBody> traits;

    private final Map<String, Object> additionalProperties;

    private UpdatePlanTraitBulkRequestBody(
            String planId, List<UpdatePlanTraitTraitRequestBody> traits, Map<String, Object> additionalProperties) {
        this.planId = planId;
        this.traits = traits;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("plan_id")
    public String getPlanId() {
        return planId;
    }

    @JsonProperty("traits")
    public List<UpdatePlanTraitTraitRequestBody> getTraits() {
        return traits;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof UpdatePlanTraitBulkRequestBody && equalTo((UpdatePlanTraitBulkRequestBody) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdatePlanTraitBulkRequestBody other) {
        return planId.equals(other.planId) && traits.equals(other.traits);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.planId, this.traits);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PlanIdStage builder() {
        return new Builder();
    }

    public interface PlanIdStage {
        _FinalStage planId(@NotNull String planId);

        Builder from(UpdatePlanTraitBulkRequestBody other);
    }

    public interface _FinalStage {
        UpdatePlanTraitBulkRequestBody build();

        _FinalStage traits(List<UpdatePlanTraitTraitRequestBody> traits);

        _FinalStage addTraits(UpdatePlanTraitTraitRequestBody traits);

        _FinalStage addAllTraits(List<UpdatePlanTraitTraitRequestBody> traits);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements PlanIdStage, _FinalStage {
        private String planId;

        private List<UpdatePlanTraitTraitRequestBody> traits = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(UpdatePlanTraitBulkRequestBody other) {
            planId(other.getPlanId());
            traits(other.getTraits());
            return this;
        }

        @java.lang.Override
        @JsonSetter("plan_id")
        public _FinalStage planId(@NotNull String planId) {
            this.planId = Objects.requireNonNull(planId, "planId must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllTraits(List<UpdatePlanTraitTraitRequestBody> traits) {
            if (traits != null) {
                this.traits.addAll(traits);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addTraits(UpdatePlanTraitTraitRequestBody traits) {
            this.traits.add(traits);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "traits", nulls = Nulls.SKIP)
        public _FinalStage traits(List<UpdatePlanTraitTraitRequestBody> traits) {
            this.traits.clear();
            if (traits != null) {
                this.traits.addAll(traits);
            }
            return this;
        }

        @java.lang.Override
        public UpdatePlanTraitBulkRequestBody build() {
            return new UpdatePlanTraitBulkRequestBody(planId, traits, additionalProperties);
        }
    }
}
