/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.credits.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.resources.credits.types.CreateCompanyCreditGrantExpiryType;
import com.schematic.api.resources.credits.types.CreateCompanyCreditGrantExpiryUnit;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CreateCompanyCreditGrant.Builder.class)
public final class CreateCompanyCreditGrant {
    private final Optional<Integer> billingPeriodsCount;

    private final String companyId;

    private final String creditId;

    private final Optional<OffsetDateTime> expiresAt;

    private final Optional<CreateCompanyCreditGrantExpiryType> expiryType;

    private final Optional<CreateCompanyCreditGrantExpiryUnit> expiryUnit;

    private final Optional<Integer> expiryUnitCount;

    private final int quantity;

    private final String reason;

    private final Map<String, Object> additionalProperties;

    private CreateCompanyCreditGrant(
            Optional<Integer> billingPeriodsCount,
            String companyId,
            String creditId,
            Optional<OffsetDateTime> expiresAt,
            Optional<CreateCompanyCreditGrantExpiryType> expiryType,
            Optional<CreateCompanyCreditGrantExpiryUnit> expiryUnit,
            Optional<Integer> expiryUnitCount,
            int quantity,
            String reason,
            Map<String, Object> additionalProperties) {
        this.billingPeriodsCount = billingPeriodsCount;
        this.companyId = companyId;
        this.creditId = creditId;
        this.expiresAt = expiresAt;
        this.expiryType = expiryType;
        this.expiryUnit = expiryUnit;
        this.expiryUnitCount = expiryUnitCount;
        this.quantity = quantity;
        this.reason = reason;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("billing_periods_count")
    public Optional<Integer> getBillingPeriodsCount() {
        return billingPeriodsCount;
    }

    @JsonProperty("company_id")
    public String getCompanyId() {
        return companyId;
    }

    @JsonProperty("credit_id")
    public String getCreditId() {
        return creditId;
    }

    @JsonProperty("expires_at")
    public Optional<OffsetDateTime> getExpiresAt() {
        return expiresAt;
    }

    @JsonProperty("expiry_type")
    public Optional<CreateCompanyCreditGrantExpiryType> getExpiryType() {
        return expiryType;
    }

    @JsonProperty("expiry_unit")
    public Optional<CreateCompanyCreditGrantExpiryUnit> getExpiryUnit() {
        return expiryUnit;
    }

    @JsonProperty("expiry_unit_count")
    public Optional<Integer> getExpiryUnitCount() {
        return expiryUnitCount;
    }

    @JsonProperty("quantity")
    public int getQuantity() {
        return quantity;
    }

    @JsonProperty("reason")
    public String getReason() {
        return reason;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CreateCompanyCreditGrant && equalTo((CreateCompanyCreditGrant) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateCompanyCreditGrant other) {
        return billingPeriodsCount.equals(other.billingPeriodsCount)
                && companyId.equals(other.companyId)
                && creditId.equals(other.creditId)
                && expiresAt.equals(other.expiresAt)
                && expiryType.equals(other.expiryType)
                && expiryUnit.equals(other.expiryUnit)
                && expiryUnitCount.equals(other.expiryUnitCount)
                && quantity == other.quantity
                && reason.equals(other.reason);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.billingPeriodsCount,
                this.companyId,
                this.creditId,
                this.expiresAt,
                this.expiryType,
                this.expiryUnit,
                this.expiryUnitCount,
                this.quantity,
                this.reason);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CompanyIdStage builder() {
        return new Builder();
    }

    public interface CompanyIdStage {
        CreditIdStage companyId(@NotNull String companyId);

        Builder from(CreateCompanyCreditGrant other);
    }

    public interface CreditIdStage {
        QuantityStage creditId(@NotNull String creditId);
    }

    public interface QuantityStage {
        ReasonStage quantity(int quantity);
    }

    public interface ReasonStage {
        _FinalStage reason(@NotNull String reason);
    }

    public interface _FinalStage {
        CreateCompanyCreditGrant build();

        _FinalStage billingPeriodsCount(Optional<Integer> billingPeriodsCount);

        _FinalStage billingPeriodsCount(Integer billingPeriodsCount);

        _FinalStage expiresAt(Optional<OffsetDateTime> expiresAt);

        _FinalStage expiresAt(OffsetDateTime expiresAt);

        _FinalStage expiryType(Optional<CreateCompanyCreditGrantExpiryType> expiryType);

        _FinalStage expiryType(CreateCompanyCreditGrantExpiryType expiryType);

        _FinalStage expiryUnit(Optional<CreateCompanyCreditGrantExpiryUnit> expiryUnit);

        _FinalStage expiryUnit(CreateCompanyCreditGrantExpiryUnit expiryUnit);

        _FinalStage expiryUnitCount(Optional<Integer> expiryUnitCount);

        _FinalStage expiryUnitCount(Integer expiryUnitCount);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements CompanyIdStage, CreditIdStage, QuantityStage, ReasonStage, _FinalStage {
        private String companyId;

        private String creditId;

        private int quantity;

        private String reason;

        private Optional<Integer> expiryUnitCount = Optional.empty();

        private Optional<CreateCompanyCreditGrantExpiryUnit> expiryUnit = Optional.empty();

        private Optional<CreateCompanyCreditGrantExpiryType> expiryType = Optional.empty();

        private Optional<OffsetDateTime> expiresAt = Optional.empty();

        private Optional<Integer> billingPeriodsCount = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CreateCompanyCreditGrant other) {
            billingPeriodsCount(other.getBillingPeriodsCount());
            companyId(other.getCompanyId());
            creditId(other.getCreditId());
            expiresAt(other.getExpiresAt());
            expiryType(other.getExpiryType());
            expiryUnit(other.getExpiryUnit());
            expiryUnitCount(other.getExpiryUnitCount());
            quantity(other.getQuantity());
            reason(other.getReason());
            return this;
        }

        @java.lang.Override
        @JsonSetter("company_id")
        public CreditIdStage companyId(@NotNull String companyId) {
            this.companyId = Objects.requireNonNull(companyId, "companyId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("credit_id")
        public QuantityStage creditId(@NotNull String creditId) {
            this.creditId = Objects.requireNonNull(creditId, "creditId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("quantity")
        public ReasonStage quantity(int quantity) {
            this.quantity = quantity;
            return this;
        }

        @java.lang.Override
        @JsonSetter("reason")
        public _FinalStage reason(@NotNull String reason) {
            this.reason = Objects.requireNonNull(reason, "reason must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage expiryUnitCount(Integer expiryUnitCount) {
            this.expiryUnitCount = Optional.ofNullable(expiryUnitCount);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "expiry_unit_count", nulls = Nulls.SKIP)
        public _FinalStage expiryUnitCount(Optional<Integer> expiryUnitCount) {
            this.expiryUnitCount = expiryUnitCount;
            return this;
        }

        @java.lang.Override
        public _FinalStage expiryUnit(CreateCompanyCreditGrantExpiryUnit expiryUnit) {
            this.expiryUnit = Optional.ofNullable(expiryUnit);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "expiry_unit", nulls = Nulls.SKIP)
        public _FinalStage expiryUnit(Optional<CreateCompanyCreditGrantExpiryUnit> expiryUnit) {
            this.expiryUnit = expiryUnit;
            return this;
        }

        @java.lang.Override
        public _FinalStage expiryType(CreateCompanyCreditGrantExpiryType expiryType) {
            this.expiryType = Optional.ofNullable(expiryType);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "expiry_type", nulls = Nulls.SKIP)
        public _FinalStage expiryType(Optional<CreateCompanyCreditGrantExpiryType> expiryType) {
            this.expiryType = expiryType;
            return this;
        }

        @java.lang.Override
        public _FinalStage expiresAt(OffsetDateTime expiresAt) {
            this.expiresAt = Optional.ofNullable(expiresAt);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "expires_at", nulls = Nulls.SKIP)
        public _FinalStage expiresAt(Optional<OffsetDateTime> expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        @java.lang.Override
        public _FinalStage billingPeriodsCount(Integer billingPeriodsCount) {
            this.billingPeriodsCount = Optional.ofNullable(billingPeriodsCount);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "billing_periods_count", nulls = Nulls.SKIP)
        public _FinalStage billingPeriodsCount(Optional<Integer> billingPeriodsCount) {
            this.billingPeriodsCount = billingPeriodsCount;
            return this;
        }

        @java.lang.Override
        public CreateCompanyCreditGrant build() {
            return new CreateCompanyCreditGrant(
                    billingPeriodsCount,
                    companyId,
                    creditId,
                    expiresAt,
                    expiryType,
                    expiryUnit,
                    expiryUnitCount,
                    quantity,
                    reason,
                    additionalProperties);
        }
    }
}
