/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.credits.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.resources.credits.types.GetEnrichedCreditLedgerRequestPeriod;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = GetEnrichedCreditLedgerRequest.Builder.class)
public final class GetEnrichedCreditLedgerRequest {
    private final String companyId;

    private final Optional<String> billingCreditId;

    private final Optional<String> featureId;

    private final GetEnrichedCreditLedgerRequestPeriod period;

    private final Optional<String> startTime;

    private final Optional<String> endTime;

    private final Optional<Integer> limit;

    private final Optional<Integer> offset;

    private final Map<String, Object> additionalProperties;

    private GetEnrichedCreditLedgerRequest(
            String companyId,
            Optional<String> billingCreditId,
            Optional<String> featureId,
            GetEnrichedCreditLedgerRequestPeriod period,
            Optional<String> startTime,
            Optional<String> endTime,
            Optional<Integer> limit,
            Optional<Integer> offset,
            Map<String, Object> additionalProperties) {
        this.companyId = companyId;
        this.billingCreditId = billingCreditId;
        this.featureId = featureId;
        this.period = period;
        this.startTime = startTime;
        this.endTime = endTime;
        this.limit = limit;
        this.offset = offset;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("company_id")
    public String getCompanyId() {
        return companyId;
    }

    @JsonProperty("billing_credit_id")
    public Optional<String> getBillingCreditId() {
        return billingCreditId;
    }

    @JsonProperty("feature_id")
    public Optional<String> getFeatureId() {
        return featureId;
    }

    @JsonProperty("period")
    public GetEnrichedCreditLedgerRequestPeriod getPeriod() {
        return period;
    }

    @JsonProperty("start_time")
    public Optional<String> getStartTime() {
        return startTime;
    }

    @JsonProperty("end_time")
    public Optional<String> getEndTime() {
        return endTime;
    }

    /**
     * @return Page limit (default 100)
     */
    @JsonProperty("limit")
    public Optional<Integer> getLimit() {
        return limit;
    }

    /**
     * @return Page offset (default 0)
     */
    @JsonProperty("offset")
    public Optional<Integer> getOffset() {
        return offset;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof GetEnrichedCreditLedgerRequest && equalTo((GetEnrichedCreditLedgerRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetEnrichedCreditLedgerRequest other) {
        return companyId.equals(other.companyId)
                && billingCreditId.equals(other.billingCreditId)
                && featureId.equals(other.featureId)
                && period.equals(other.period)
                && startTime.equals(other.startTime)
                && endTime.equals(other.endTime)
                && limit.equals(other.limit)
                && offset.equals(other.offset);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.companyId,
                this.billingCreditId,
                this.featureId,
                this.period,
                this.startTime,
                this.endTime,
                this.limit,
                this.offset);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CompanyIdStage builder() {
        return new Builder();
    }

    public interface CompanyIdStage {
        PeriodStage companyId(@NotNull String companyId);

        Builder from(GetEnrichedCreditLedgerRequest other);
    }

    public interface PeriodStage {
        _FinalStage period(@NotNull GetEnrichedCreditLedgerRequestPeriod period);
    }

    public interface _FinalStage {
        GetEnrichedCreditLedgerRequest build();

        _FinalStage billingCreditId(Optional<String> billingCreditId);

        _FinalStage billingCreditId(String billingCreditId);

        _FinalStage featureId(Optional<String> featureId);

        _FinalStage featureId(String featureId);

        _FinalStage startTime(Optional<String> startTime);

        _FinalStage startTime(String startTime);

        _FinalStage endTime(Optional<String> endTime);

        _FinalStage endTime(String endTime);

        /**
         * <p>Page limit (default 100)</p>
         */
        _FinalStage limit(Optional<Integer> limit);

        _FinalStage limit(Integer limit);

        /**
         * <p>Page offset (default 0)</p>
         */
        _FinalStage offset(Optional<Integer> offset);

        _FinalStage offset(Integer offset);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements CompanyIdStage, PeriodStage, _FinalStage {
        private String companyId;

        private GetEnrichedCreditLedgerRequestPeriod period;

        private Optional<Integer> offset = Optional.empty();

        private Optional<Integer> limit = Optional.empty();

        private Optional<String> endTime = Optional.empty();

        private Optional<String> startTime = Optional.empty();

        private Optional<String> featureId = Optional.empty();

        private Optional<String> billingCreditId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(GetEnrichedCreditLedgerRequest other) {
            companyId(other.getCompanyId());
            billingCreditId(other.getBillingCreditId());
            featureId(other.getFeatureId());
            period(other.getPeriod());
            startTime(other.getStartTime());
            endTime(other.getEndTime());
            limit(other.getLimit());
            offset(other.getOffset());
            return this;
        }

        @java.lang.Override
        @JsonSetter("company_id")
        public PeriodStage companyId(@NotNull String companyId) {
            this.companyId = Objects.requireNonNull(companyId, "companyId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("period")
        public _FinalStage period(@NotNull GetEnrichedCreditLedgerRequestPeriod period) {
            this.period = Objects.requireNonNull(period, "period must not be null");
            return this;
        }

        /**
         * <p>Page offset (default 0)</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage offset(Integer offset) {
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        /**
         * <p>Page offset (default 0)</p>
         */
        @java.lang.Override
        @JsonSetter(value = "offset", nulls = Nulls.SKIP)
        public _FinalStage offset(Optional<Integer> offset) {
            this.offset = offset;
            return this;
        }

        /**
         * <p>Page limit (default 100)</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        /**
         * <p>Page limit (default 100)</p>
         */
        @java.lang.Override
        @JsonSetter(value = "limit", nulls = Nulls.SKIP)
        public _FinalStage limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        @java.lang.Override
        public _FinalStage endTime(String endTime) {
            this.endTime = Optional.ofNullable(endTime);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "end_time", nulls = Nulls.SKIP)
        public _FinalStage endTime(Optional<String> endTime) {
            this.endTime = endTime;
            return this;
        }

        @java.lang.Override
        public _FinalStage startTime(String startTime) {
            this.startTime = Optional.ofNullable(startTime);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "start_time", nulls = Nulls.SKIP)
        public _FinalStage startTime(Optional<String> startTime) {
            this.startTime = startTime;
            return this;
        }

        @java.lang.Override
        public _FinalStage featureId(String featureId) {
            this.featureId = Optional.ofNullable(featureId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "feature_id", nulls = Nulls.SKIP)
        public _FinalStage featureId(Optional<String> featureId) {
            this.featureId = featureId;
            return this;
        }

        @java.lang.Override
        public _FinalStage billingCreditId(String billingCreditId) {
            this.billingCreditId = Optional.ofNullable(billingCreditId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "billing_credit_id", nulls = Nulls.SKIP)
        public _FinalStage billingCreditId(Optional<String> billingCreditId) {
            this.billingCreditId = billingCreditId;
            return this;
        }

        @java.lang.Override
        public GetEnrichedCreditLedgerRequest build() {
            return new GetEnrichedCreditLedgerRequest(
                    companyId,
                    billingCreditId,
                    featureId,
                    period,
                    startTime,
                    endTime,
                    limit,
                    offset,
                    additionalProperties);
        }
    }
}
