/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.credits.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CountBillingPlanCreditGrantsParams.Builder.class)
public final class CountBillingPlanCreditGrantsParams {
    private final Optional<String> creditId;

    private final Optional<List<String>> ids;

    private final Optional<Integer> limit;

    private final Optional<Integer> offset;

    private final Optional<String> planId;

    private final Optional<List<String>> planIds;

    private final Map<String, Object> additionalProperties;

    private CountBillingPlanCreditGrantsParams(
            Optional<String> creditId,
            Optional<List<String>> ids,
            Optional<Integer> limit,
            Optional<Integer> offset,
            Optional<String> planId,
            Optional<List<String>> planIds,
            Map<String, Object> additionalProperties) {
        this.creditId = creditId;
        this.ids = ids;
        this.limit = limit;
        this.offset = offset;
        this.planId = planId;
        this.planIds = planIds;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("credit_id")
    public Optional<String> getCreditId() {
        return creditId;
    }

    @JsonProperty("ids")
    public Optional<List<String>> getIds() {
        return ids;
    }

    /**
     * @return Page limit (default 100)
     */
    @JsonProperty("limit")
    public Optional<Integer> getLimit() {
        return limit;
    }

    /**
     * @return Page offset (default 0)
     */
    @JsonProperty("offset")
    public Optional<Integer> getOffset() {
        return offset;
    }

    @JsonProperty("plan_id")
    public Optional<String> getPlanId() {
        return planId;
    }

    @JsonProperty("plan_ids")
    public Optional<List<String>> getPlanIds() {
        return planIds;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CountBillingPlanCreditGrantsParams
                && equalTo((CountBillingPlanCreditGrantsParams) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CountBillingPlanCreditGrantsParams other) {
        return creditId.equals(other.creditId)
                && ids.equals(other.ids)
                && limit.equals(other.limit)
                && offset.equals(other.offset)
                && planId.equals(other.planId)
                && planIds.equals(other.planIds);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.creditId, this.ids, this.limit, this.offset, this.planId, this.planIds);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> creditId = Optional.empty();

        private Optional<List<String>> ids = Optional.empty();

        private Optional<Integer> limit = Optional.empty();

        private Optional<Integer> offset = Optional.empty();

        private Optional<String> planId = Optional.empty();

        private Optional<List<String>> planIds = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(CountBillingPlanCreditGrantsParams other) {
            creditId(other.getCreditId());
            ids(other.getIds());
            limit(other.getLimit());
            offset(other.getOffset());
            planId(other.getPlanId());
            planIds(other.getPlanIds());
            return this;
        }

        @JsonSetter(value = "credit_id", nulls = Nulls.SKIP)
        public Builder creditId(Optional<String> creditId) {
            this.creditId = creditId;
            return this;
        }

        public Builder creditId(String creditId) {
            this.creditId = Optional.ofNullable(creditId);
            return this;
        }

        @JsonSetter(value = "ids", nulls = Nulls.SKIP)
        public Builder ids(Optional<List<String>> ids) {
            this.ids = ids;
            return this;
        }

        public Builder ids(List<String> ids) {
            this.ids = Optional.ofNullable(ids);
            return this;
        }

        /**
         * <p>Page limit (default 100)</p>
         */
        @JsonSetter(value = "limit", nulls = Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        /**
         * <p>Page offset (default 0)</p>
         */
        @JsonSetter(value = "offset", nulls = Nulls.SKIP)
        public Builder offset(Optional<Integer> offset) {
            this.offset = offset;
            return this;
        }

        public Builder offset(Integer offset) {
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        @JsonSetter(value = "plan_id", nulls = Nulls.SKIP)
        public Builder planId(Optional<String> planId) {
            this.planId = planId;
            return this;
        }

        public Builder planId(String planId) {
            this.planId = Optional.ofNullable(planId);
            return this;
        }

        @JsonSetter(value = "plan_ids", nulls = Nulls.SKIP)
        public Builder planIds(Optional<List<String>> planIds) {
            this.planIds = planIds;
            return this;
        }

        public Builder planIds(List<String> planIds) {
            this.planIds = Optional.ofNullable(planIds);
            return this;
        }

        public CountBillingPlanCreditGrantsParams build() {
            return new CountBillingPlanCreditGrantsParams(
                    creditId, ids, limit, offset, planId, planIds, additionalProperties);
        }
    }
}
