/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.dataexports;

import com.schematic.api.core.ClientOptions;
import com.schematic.api.core.RequestOptions;
import com.schematic.api.resources.dataexports.requests.CreateDataExportRequestBody;
import com.schematic.api.resources.dataexports.types.CreateDataExportResponse;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;

public class AsyncDataexportsClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawDataexportsClient rawClient;

    public AsyncDataexportsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawDataexportsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawDataexportsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<CreateDataExportResponse> createDataExport(CreateDataExportRequestBody request) {
        return this.rawClient.createDataExport(request).thenApply(response -> response.body());
    }

    public CompletableFuture<CreateDataExportResponse> createDataExport(
            CreateDataExportRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.createDataExport(request, requestOptions).thenApply(response -> response.body());
    }

    public CompletableFuture<InputStream> getDataExportArtifact(String dataExportId) {
        return this.rawClient.getDataExportArtifact(dataExportId).thenApply(response -> response.body());
    }

    public CompletableFuture<InputStream> getDataExportArtifact(String dataExportId, RequestOptions requestOptions) {
        return this.rawClient
                .getDataExportArtifact(dataExportId, requestOptions)
                .thenApply(response -> response.body());
    }
}
