/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.events;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.schematic.api.core.BaseSchematicApiException;
import com.schematic.api.core.BaseSchematicException;
import com.schematic.api.core.BaseSchematicHttpResponse;
import com.schematic.api.core.ClientOptions;
import com.schematic.api.core.MediaTypes;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.core.QueryStringMapper;
import com.schematic.api.core.RequestOptions;
import com.schematic.api.errors.BadRequestError;
import com.schematic.api.errors.ForbiddenError;
import com.schematic.api.errors.InternalServerError;
import com.schematic.api.errors.NotFoundError;
import com.schematic.api.errors.UnauthorizedError;
import com.schematic.api.resources.events.requests.CreateEventBatchRequestBody;
import com.schematic.api.resources.events.requests.GetEventSummariesRequest;
import com.schematic.api.resources.events.requests.ListEventsRequest;
import com.schematic.api.resources.events.types.CreateEventBatchResponse;
import com.schematic.api.resources.events.types.CreateEventResponse;
import com.schematic.api.resources.events.types.GetEventResponse;
import com.schematic.api.resources.events.types.GetEventSummariesResponse;
import com.schematic.api.resources.events.types.GetSegmentIntegrationStatusResponse;
import com.schematic.api.resources.events.types.ListEventsResponse;
import com.schematic.api.types.ApiError;
import com.schematic.api.types.CreateEventRequestBody;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class AsyncRawEventsClient {
    protected final ClientOptions clientOptions;

    public AsyncRawEventsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public CompletableFuture<BaseSchematicHttpResponse<CreateEventBatchResponse>> createEventBatch(
            CreateEventBatchRequestBody request) {
        return createEventBatch(request, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<CreateEventBatchResponse>> createEventBatch(
            CreateEventBatchRequestBody request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("event-batch")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new BaseSchematicException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<CreateEventBatchResponse>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBody.string(), CreateEventBatchResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 400:
                                future.completeExceptionally(new BadRequestError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<BaseSchematicHttpResponse<GetEventSummariesResponse>> getEventSummaries() {
        return getEventSummaries(GetEventSummariesRequest.builder().build());
    }

    public CompletableFuture<BaseSchematicHttpResponse<GetEventSummariesResponse>> getEventSummaries(
            GetEventSummariesRequest request) {
        return getEventSummaries(request, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<GetEventSummariesResponse>> getEventSummaries(
            GetEventSummariesRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("event-types");
        if (request.getQ().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "q", request.getQ().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getOffset().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "offset", request.getOffset().get(), false);
        }
        if (request.getEventSubtypes().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "event_subtypes", request.getEventSubtypes().get(), true);
        }
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<GetEventSummariesResponse>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBody.string(), GetEventSummariesResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 400:
                                future.completeExceptionally(new BadRequestError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<BaseSchematicHttpResponse<ListEventsResponse>> listEvents() {
        return listEvents(ListEventsRequest.builder().build());
    }

    public CompletableFuture<BaseSchematicHttpResponse<ListEventsResponse>> listEvents(ListEventsRequest request) {
        return listEvents(request, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<ListEventsResponse>> listEvents(
            ListEventsRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("events");
        if (request.getCompanyId().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "company_id", request.getCompanyId().get(), false);
        }
        if (request.getEventSubtype().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "event_subtype", request.getEventSubtype().get(), false);
        }
        if (request.getFlagId().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "flag_id", request.getFlagId().get(), false);
        }
        if (request.getUserId().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "user_id", request.getUserId().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getOffset().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "offset", request.getOffset().get(), false);
        }
        if (request.getEventTypes().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "event_types", request.getEventTypes().get(), true);
        }
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<ListEventsResponse>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListEventsResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 400:
                                future.completeExceptionally(new BadRequestError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<BaseSchematicHttpResponse<CreateEventResponse>> createEvent(
            CreateEventRequestBody request) {
        return createEvent(request, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<CreateEventResponse>> createEvent(
            CreateEventRequestBody request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("events")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new BaseSchematicException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<CreateEventResponse>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CreateEventResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 400:
                                future.completeExceptionally(new BadRequestError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<BaseSchematicHttpResponse<GetEventResponse>> getEvent(String eventId) {
        return getEvent(eventId, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<GetEventResponse>> getEvent(
            String eventId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("events")
                .addPathSegment(eventId)
                .build();
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<GetEventResponse>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), GetEventResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<BaseSchematicHttpResponse<GetSegmentIntegrationStatusResponse>>
            getSegmentIntegrationStatus() {
        return getSegmentIntegrationStatus(null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<GetSegmentIntegrationStatusResponse>>
            getSegmentIntegrationStatus(RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("segment-integration")
                .build();
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<BaseSchematicHttpResponse<GetSegmentIntegrationStatusResponse>> future =
                new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBody.string(), GetSegmentIntegrationStatusResponse.class),
                                response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        switch (response.code()) {
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new BaseSchematicApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }
}
