/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.plangroups;

import com.schematic.api.core.ClientOptions;
import com.schematic.api.core.RequestOptions;
import com.schematic.api.resources.plangroups.requests.CreatePlanGroupRequestBody;
import com.schematic.api.resources.plangroups.requests.UpdatePlanGroupRequestBody;
import com.schematic.api.resources.plangroups.types.CreatePlanGroupResponse;
import com.schematic.api.resources.plangroups.types.GetPlanGroupResponse;
import com.schematic.api.resources.plangroups.types.UpdatePlanGroupResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncPlangroupsClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawPlangroupsClient rawClient;

    public AsyncPlangroupsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawPlangroupsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawPlangroupsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<GetPlanGroupResponse> getPlanGroup() {
        return this.rawClient.getPlanGroup().thenApply(response -> response.body());
    }

    public CompletableFuture<GetPlanGroupResponse> getPlanGroup(RequestOptions requestOptions) {
        return this.rawClient.getPlanGroup(requestOptions).thenApply(response -> response.body());
    }

    public CompletableFuture<CreatePlanGroupResponse> createPlanGroup(CreatePlanGroupRequestBody request) {
        return this.rawClient.createPlanGroup(request).thenApply(response -> response.body());
    }

    public CompletableFuture<CreatePlanGroupResponse> createPlanGroup(
            CreatePlanGroupRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.createPlanGroup(request, requestOptions).thenApply(response -> response.body());
    }

    public CompletableFuture<UpdatePlanGroupResponse> updatePlanGroup(
            String planGroupId, UpdatePlanGroupRequestBody request) {
        return this.rawClient.updatePlanGroup(planGroupId, request).thenApply(response -> response.body());
    }

    public CompletableFuture<UpdatePlanGroupResponse> updatePlanGroup(
            String planGroupId, UpdatePlanGroupRequestBody request, RequestOptions requestOptions) {
        return this.rawClient
                .updatePlanGroup(planGroupId, request, requestOptions)
                .thenApply(response -> response.body());
    }
}
