/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.plans.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.resources.plans.types.UpsertBillingProductRequestBodyChargeType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = UpsertBillingProductRequestBody.Builder.class)
public final class UpsertBillingProductRequestBody {
    private final Optional<String> billingProductId;

    private final UpsertBillingProductRequestBodyChargeType chargeType;

    private final Optional<String> currency;

    private final boolean isTrialable;

    private final Optional<Integer> monthlyPrice;

    private final Optional<String> monthlyPriceId;

    private final Optional<Integer> oneTimePrice;

    private final Optional<String> oneTimePriceId;

    private final Optional<Integer> trialDays;

    private final Optional<Integer> yearlyPrice;

    private final Optional<String> yearlyPriceId;

    private final Map<String, Object> additionalProperties;

    private UpsertBillingProductRequestBody(
            Optional<String> billingProductId,
            UpsertBillingProductRequestBodyChargeType chargeType,
            Optional<String> currency,
            boolean isTrialable,
            Optional<Integer> monthlyPrice,
            Optional<String> monthlyPriceId,
            Optional<Integer> oneTimePrice,
            Optional<String> oneTimePriceId,
            Optional<Integer> trialDays,
            Optional<Integer> yearlyPrice,
            Optional<String> yearlyPriceId,
            Map<String, Object> additionalProperties) {
        this.billingProductId = billingProductId;
        this.chargeType = chargeType;
        this.currency = currency;
        this.isTrialable = isTrialable;
        this.monthlyPrice = monthlyPrice;
        this.monthlyPriceId = monthlyPriceId;
        this.oneTimePrice = oneTimePrice;
        this.oneTimePriceId = oneTimePriceId;
        this.trialDays = trialDays;
        this.yearlyPrice = yearlyPrice;
        this.yearlyPriceId = yearlyPriceId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("billing_product_id")
    public Optional<String> getBillingProductId() {
        return billingProductId;
    }

    @JsonProperty("charge_type")
    public UpsertBillingProductRequestBodyChargeType getChargeType() {
        return chargeType;
    }

    @JsonProperty("currency")
    public Optional<String> getCurrency() {
        return currency;
    }

    @JsonProperty("is_trialable")
    public boolean getIsTrialable() {
        return isTrialable;
    }

    @JsonProperty("monthly_price")
    public Optional<Integer> getMonthlyPrice() {
        return monthlyPrice;
    }

    @JsonProperty("monthly_price_id")
    public Optional<String> getMonthlyPriceId() {
        return monthlyPriceId;
    }

    @JsonProperty("one_time_price")
    public Optional<Integer> getOneTimePrice() {
        return oneTimePrice;
    }

    @JsonProperty("one_time_price_id")
    public Optional<String> getOneTimePriceId() {
        return oneTimePriceId;
    }

    @JsonProperty("trial_days")
    public Optional<Integer> getTrialDays() {
        return trialDays;
    }

    @JsonProperty("yearly_price")
    public Optional<Integer> getYearlyPrice() {
        return yearlyPrice;
    }

    @JsonProperty("yearly_price_id")
    public Optional<String> getYearlyPriceId() {
        return yearlyPriceId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof UpsertBillingProductRequestBody && equalTo((UpsertBillingProductRequestBody) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpsertBillingProductRequestBody other) {
        return billingProductId.equals(other.billingProductId)
                && chargeType.equals(other.chargeType)
                && currency.equals(other.currency)
                && isTrialable == other.isTrialable
                && monthlyPrice.equals(other.monthlyPrice)
                && monthlyPriceId.equals(other.monthlyPriceId)
                && oneTimePrice.equals(other.oneTimePrice)
                && oneTimePriceId.equals(other.oneTimePriceId)
                && trialDays.equals(other.trialDays)
                && yearlyPrice.equals(other.yearlyPrice)
                && yearlyPriceId.equals(other.yearlyPriceId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.billingProductId,
                this.chargeType,
                this.currency,
                this.isTrialable,
                this.monthlyPrice,
                this.monthlyPriceId,
                this.oneTimePrice,
                this.oneTimePriceId,
                this.trialDays,
                this.yearlyPrice,
                this.yearlyPriceId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ChargeTypeStage builder() {
        return new Builder();
    }

    public interface ChargeTypeStage {
        IsTrialableStage chargeType(@NotNull UpsertBillingProductRequestBodyChargeType chargeType);

        Builder from(UpsertBillingProductRequestBody other);
    }

    public interface IsTrialableStage {
        _FinalStage isTrialable(boolean isTrialable);
    }

    public interface _FinalStage {
        UpsertBillingProductRequestBody build();

        _FinalStage billingProductId(Optional<String> billingProductId);

        _FinalStage billingProductId(String billingProductId);

        _FinalStage currency(Optional<String> currency);

        _FinalStage currency(String currency);

        _FinalStage monthlyPrice(Optional<Integer> monthlyPrice);

        _FinalStage monthlyPrice(Integer monthlyPrice);

        _FinalStage monthlyPriceId(Optional<String> monthlyPriceId);

        _FinalStage monthlyPriceId(String monthlyPriceId);

        _FinalStage oneTimePrice(Optional<Integer> oneTimePrice);

        _FinalStage oneTimePrice(Integer oneTimePrice);

        _FinalStage oneTimePriceId(Optional<String> oneTimePriceId);

        _FinalStage oneTimePriceId(String oneTimePriceId);

        _FinalStage trialDays(Optional<Integer> trialDays);

        _FinalStage trialDays(Integer trialDays);

        _FinalStage yearlyPrice(Optional<Integer> yearlyPrice);

        _FinalStage yearlyPrice(Integer yearlyPrice);

        _FinalStage yearlyPriceId(Optional<String> yearlyPriceId);

        _FinalStage yearlyPriceId(String yearlyPriceId);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements ChargeTypeStage, IsTrialableStage, _FinalStage {
        private UpsertBillingProductRequestBodyChargeType chargeType;

        private boolean isTrialable;

        private Optional<String> yearlyPriceId = Optional.empty();

        private Optional<Integer> yearlyPrice = Optional.empty();

        private Optional<Integer> trialDays = Optional.empty();

        private Optional<String> oneTimePriceId = Optional.empty();

        private Optional<Integer> oneTimePrice = Optional.empty();

        private Optional<String> monthlyPriceId = Optional.empty();

        private Optional<Integer> monthlyPrice = Optional.empty();

        private Optional<String> currency = Optional.empty();

        private Optional<String> billingProductId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(UpsertBillingProductRequestBody other) {
            billingProductId(other.getBillingProductId());
            chargeType(other.getChargeType());
            currency(other.getCurrency());
            isTrialable(other.getIsTrialable());
            monthlyPrice(other.getMonthlyPrice());
            monthlyPriceId(other.getMonthlyPriceId());
            oneTimePrice(other.getOneTimePrice());
            oneTimePriceId(other.getOneTimePriceId());
            trialDays(other.getTrialDays());
            yearlyPrice(other.getYearlyPrice());
            yearlyPriceId(other.getYearlyPriceId());
            return this;
        }

        @java.lang.Override
        @JsonSetter("charge_type")
        public IsTrialableStage chargeType(@NotNull UpsertBillingProductRequestBodyChargeType chargeType) {
            this.chargeType = Objects.requireNonNull(chargeType, "chargeType must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("is_trialable")
        public _FinalStage isTrialable(boolean isTrialable) {
            this.isTrialable = isTrialable;
            return this;
        }

        @java.lang.Override
        public _FinalStage yearlyPriceId(String yearlyPriceId) {
            this.yearlyPriceId = Optional.ofNullable(yearlyPriceId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "yearly_price_id", nulls = Nulls.SKIP)
        public _FinalStage yearlyPriceId(Optional<String> yearlyPriceId) {
            this.yearlyPriceId = yearlyPriceId;
            return this;
        }

        @java.lang.Override
        public _FinalStage yearlyPrice(Integer yearlyPrice) {
            this.yearlyPrice = Optional.ofNullable(yearlyPrice);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "yearly_price", nulls = Nulls.SKIP)
        public _FinalStage yearlyPrice(Optional<Integer> yearlyPrice) {
            this.yearlyPrice = yearlyPrice;
            return this;
        }

        @java.lang.Override
        public _FinalStage trialDays(Integer trialDays) {
            this.trialDays = Optional.ofNullable(trialDays);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "trial_days", nulls = Nulls.SKIP)
        public _FinalStage trialDays(Optional<Integer> trialDays) {
            this.trialDays = trialDays;
            return this;
        }

        @java.lang.Override
        public _FinalStage oneTimePriceId(String oneTimePriceId) {
            this.oneTimePriceId = Optional.ofNullable(oneTimePriceId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "one_time_price_id", nulls = Nulls.SKIP)
        public _FinalStage oneTimePriceId(Optional<String> oneTimePriceId) {
            this.oneTimePriceId = oneTimePriceId;
            return this;
        }

        @java.lang.Override
        public _FinalStage oneTimePrice(Integer oneTimePrice) {
            this.oneTimePrice = Optional.ofNullable(oneTimePrice);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "one_time_price", nulls = Nulls.SKIP)
        public _FinalStage oneTimePrice(Optional<Integer> oneTimePrice) {
            this.oneTimePrice = oneTimePrice;
            return this;
        }

        @java.lang.Override
        public _FinalStage monthlyPriceId(String monthlyPriceId) {
            this.monthlyPriceId = Optional.ofNullable(monthlyPriceId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "monthly_price_id", nulls = Nulls.SKIP)
        public _FinalStage monthlyPriceId(Optional<String> monthlyPriceId) {
            this.monthlyPriceId = monthlyPriceId;
            return this;
        }

        @java.lang.Override
        public _FinalStage monthlyPrice(Integer monthlyPrice) {
            this.monthlyPrice = Optional.ofNullable(monthlyPrice);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "monthly_price", nulls = Nulls.SKIP)
        public _FinalStage monthlyPrice(Optional<Integer> monthlyPrice) {
            this.monthlyPrice = monthlyPrice;
            return this;
        }

        @java.lang.Override
        public _FinalStage currency(String currency) {
            this.currency = Optional.ofNullable(currency);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "currency", nulls = Nulls.SKIP)
        public _FinalStage currency(Optional<String> currency) {
            this.currency = currency;
            return this;
        }

        @java.lang.Override
        public _FinalStage billingProductId(String billingProductId) {
            this.billingProductId = Optional.ofNullable(billingProductId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "billing_product_id", nulls = Nulls.SKIP)
        public _FinalStage billingProductId(Optional<String> billingProductId) {
            this.billingProductId = billingProductId;
            return this;
        }

        @java.lang.Override
        public UpsertBillingProductRequestBody build() {
            return new UpsertBillingProductRequestBody(
                    billingProductId,
                    chargeType,
                    currency,
                    isTrialable,
                    monthlyPrice,
                    monthlyPriceId,
                    oneTimePrice,
                    oneTimePriceId,
                    trialDays,
                    yearlyPrice,
                    yearlyPriceId,
                    additionalProperties);
        }
    }
}
