/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.webhooks;

import com.schematic.api.core.ClientOptions;
import com.schematic.api.core.RequestOptions;
import com.schematic.api.resources.webhooks.requests.CountWebhookEventsRequest;
import com.schematic.api.resources.webhooks.requests.CountWebhooksRequest;
import com.schematic.api.resources.webhooks.requests.CreateWebhookRequestBody;
import com.schematic.api.resources.webhooks.requests.ListWebhookEventsRequest;
import com.schematic.api.resources.webhooks.requests.ListWebhooksRequest;
import com.schematic.api.resources.webhooks.requests.UpdateWebhookRequestBody;
import com.schematic.api.resources.webhooks.types.CountWebhookEventsResponse;
import com.schematic.api.resources.webhooks.types.CountWebhooksResponse;
import com.schematic.api.resources.webhooks.types.CreateWebhookResponse;
import com.schematic.api.resources.webhooks.types.DeleteWebhookResponse;
import com.schematic.api.resources.webhooks.types.GetWebhookEventResponse;
import com.schematic.api.resources.webhooks.types.GetWebhookResponse;
import com.schematic.api.resources.webhooks.types.ListWebhookEventsResponse;
import com.schematic.api.resources.webhooks.types.ListWebhooksResponse;
import com.schematic.api.resources.webhooks.types.UpdateWebhookResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncWebhooksClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawWebhooksClient rawClient;

    public AsyncWebhooksClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawWebhooksClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawWebhooksClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<ListWebhookEventsResponse> listWebhookEvents() {
        return this.rawClient.listWebhookEvents().thenApply(response -> response.body());
    }

    public CompletableFuture<ListWebhookEventsResponse> listWebhookEvents(ListWebhookEventsRequest request) {
        return this.rawClient.listWebhookEvents(request).thenApply(response -> response.body());
    }

    public CompletableFuture<ListWebhookEventsResponse> listWebhookEvents(
            ListWebhookEventsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listWebhookEvents(request, requestOptions).thenApply(response -> response.body());
    }

    public CompletableFuture<GetWebhookEventResponse> getWebhookEvent(String webhookEventId) {
        return this.rawClient.getWebhookEvent(webhookEventId).thenApply(response -> response.body());
    }

    public CompletableFuture<GetWebhookEventResponse> getWebhookEvent(
            String webhookEventId, RequestOptions requestOptions) {
        return this.rawClient.getWebhookEvent(webhookEventId, requestOptions).thenApply(response -> response.body());
    }

    public CompletableFuture<CountWebhookEventsResponse> countWebhookEvents() {
        return this.rawClient.countWebhookEvents().thenApply(response -> response.body());
    }

    public CompletableFuture<CountWebhookEventsResponse> countWebhookEvents(CountWebhookEventsRequest request) {
        return this.rawClient.countWebhookEvents(request).thenApply(response -> response.body());
    }

    public CompletableFuture<CountWebhookEventsResponse> countWebhookEvents(
            CountWebhookEventsRequest request, RequestOptions requestOptions) {
        return this.rawClient.countWebhookEvents(request, requestOptions).thenApply(response -> response.body());
    }

    public CompletableFuture<ListWebhooksResponse> listWebhooks() {
        return this.rawClient.listWebhooks().thenApply(response -> response.body());
    }

    public CompletableFuture<ListWebhooksResponse> listWebhooks(ListWebhooksRequest request) {
        return this.rawClient.listWebhooks(request).thenApply(response -> response.body());
    }

    public CompletableFuture<ListWebhooksResponse> listWebhooks(
            ListWebhooksRequest request, RequestOptions requestOptions) {
        return this.rawClient.listWebhooks(request, requestOptions).thenApply(response -> response.body());
    }

    public CompletableFuture<CreateWebhookResponse> createWebhook(CreateWebhookRequestBody request) {
        return this.rawClient.createWebhook(request).thenApply(response -> response.body());
    }

    public CompletableFuture<CreateWebhookResponse> createWebhook(
            CreateWebhookRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.createWebhook(request, requestOptions).thenApply(response -> response.body());
    }

    public CompletableFuture<GetWebhookResponse> getWebhook(String webhookId) {
        return this.rawClient.getWebhook(webhookId).thenApply(response -> response.body());
    }

    public CompletableFuture<GetWebhookResponse> getWebhook(String webhookId, RequestOptions requestOptions) {
        return this.rawClient.getWebhook(webhookId, requestOptions).thenApply(response -> response.body());
    }

    public CompletableFuture<UpdateWebhookResponse> updateWebhook(String webhookId) {
        return this.rawClient.updateWebhook(webhookId).thenApply(response -> response.body());
    }

    public CompletableFuture<UpdateWebhookResponse> updateWebhook(String webhookId, UpdateWebhookRequestBody request) {
        return this.rawClient.updateWebhook(webhookId, request).thenApply(response -> response.body());
    }

    public CompletableFuture<UpdateWebhookResponse> updateWebhook(
            String webhookId, UpdateWebhookRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.updateWebhook(webhookId, request, requestOptions).thenApply(response -> response.body());
    }

    public CompletableFuture<DeleteWebhookResponse> deleteWebhook(String webhookId) {
        return this.rawClient.deleteWebhook(webhookId).thenApply(response -> response.body());
    }

    public CompletableFuture<DeleteWebhookResponse> deleteWebhook(String webhookId, RequestOptions requestOptions) {
        return this.rawClient.deleteWebhook(webhookId, requestOptions).thenApply(response -> response.body());
    }

    public CompletableFuture<CountWebhooksResponse> countWebhooks() {
        return this.rawClient.countWebhooks().thenApply(response -> response.body());
    }

    public CompletableFuture<CountWebhooksResponse> countWebhooks(CountWebhooksRequest request) {
        return this.rawClient.countWebhooks(request).thenApply(response -> response.body());
    }

    public CompletableFuture<CountWebhooksResponse> countWebhooks(
            CountWebhooksRequest request, RequestOptions requestOptions) {
        return this.rawClient.countWebhooks(request, requestOptions).thenApply(response -> response.body());
    }
}
