/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ApiKeyCreateResponseData.Builder.class)
public final class ApiKeyCreateResponseData {
    private final OffsetDateTime createdAt;

    private final Optional<String> description;

    private final Optional<String> environmentId;

    private final String id;

    private final Optional<OffsetDateTime> lastUsedAt;

    private final String name;

    private final List<String> scopes;

    private final String secret;

    private final OffsetDateTime updatedAt;

    private final Map<String, Object> additionalProperties;

    private ApiKeyCreateResponseData(
            OffsetDateTime createdAt,
            Optional<String> description,
            Optional<String> environmentId,
            String id,
            Optional<OffsetDateTime> lastUsedAt,
            String name,
            List<String> scopes,
            String secret,
            OffsetDateTime updatedAt,
            Map<String, Object> additionalProperties) {
        this.createdAt = createdAt;
        this.description = description;
        this.environmentId = environmentId;
        this.id = id;
        this.lastUsedAt = lastUsedAt;
        this.name = name;
        this.scopes = scopes;
        this.secret = secret;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("created_at")
    public OffsetDateTime getCreatedAt() {
        return createdAt;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return description;
    }

    @JsonProperty("environment_id")
    public Optional<String> getEnvironmentId() {
        return environmentId;
    }

    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @JsonProperty("last_used_at")
    public Optional<OffsetDateTime> getLastUsedAt() {
        return lastUsedAt;
    }

    @JsonProperty("name")
    public String getName() {
        return name;
    }

    @JsonProperty("scopes")
    public List<String> getScopes() {
        return scopes;
    }

    @JsonProperty("secret")
    public String getSecret() {
        return secret;
    }

    @JsonProperty("updated_at")
    public OffsetDateTime getUpdatedAt() {
        return updatedAt;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ApiKeyCreateResponseData && equalTo((ApiKeyCreateResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ApiKeyCreateResponseData other) {
        return createdAt.equals(other.createdAt)
                && description.equals(other.description)
                && environmentId.equals(other.environmentId)
                && id.equals(other.id)
                && lastUsedAt.equals(other.lastUsedAt)
                && name.equals(other.name)
                && scopes.equals(other.scopes)
                && secret.equals(other.secret)
                && updatedAt.equals(other.updatedAt);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.createdAt,
                this.description,
                this.environmentId,
                this.id,
                this.lastUsedAt,
                this.name,
                this.scopes,
                this.secret,
                this.updatedAt);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CreatedAtStage builder() {
        return new Builder();
    }

    public interface CreatedAtStage {
        IdStage createdAt(@NotNull OffsetDateTime createdAt);

        Builder from(ApiKeyCreateResponseData other);
    }

    public interface IdStage {
        NameStage id(@NotNull String id);
    }

    public interface NameStage {
        SecretStage name(@NotNull String name);
    }

    public interface SecretStage {
        UpdatedAtStage secret(@NotNull String secret);
    }

    public interface UpdatedAtStage {
        _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt);
    }

    public interface _FinalStage {
        ApiKeyCreateResponseData build();

        _FinalStage description(Optional<String> description);

        _FinalStage description(String description);

        _FinalStage environmentId(Optional<String> environmentId);

        _FinalStage environmentId(String environmentId);

        _FinalStage lastUsedAt(Optional<OffsetDateTime> lastUsedAt);

        _FinalStage lastUsedAt(OffsetDateTime lastUsedAt);

        _FinalStage scopes(List<String> scopes);

        _FinalStage addScopes(String scopes);

        _FinalStage addAllScopes(List<String> scopes);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements CreatedAtStage, IdStage, NameStage, SecretStage, UpdatedAtStage, _FinalStage {
        private OffsetDateTime createdAt;

        private String id;

        private String name;

        private String secret;

        private OffsetDateTime updatedAt;

        private List<String> scopes = new ArrayList<>();

        private Optional<OffsetDateTime> lastUsedAt = Optional.empty();

        private Optional<String> environmentId = Optional.empty();

        private Optional<String> description = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ApiKeyCreateResponseData other) {
            createdAt(other.getCreatedAt());
            description(other.getDescription());
            environmentId(other.getEnvironmentId());
            id(other.getId());
            lastUsedAt(other.getLastUsedAt());
            name(other.getName());
            scopes(other.getScopes());
            secret(other.getSecret());
            updatedAt(other.getUpdatedAt());
            return this;
        }

        @java.lang.Override
        @JsonSetter("created_at")
        public IdStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("name")
        public SecretStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("secret")
        public UpdatedAtStage secret(@NotNull String secret) {
            this.secret = Objects.requireNonNull(secret, "secret must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllScopes(List<String> scopes) {
            if (scopes != null) {
                this.scopes.addAll(scopes);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addScopes(String scopes) {
            this.scopes.add(scopes);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "scopes", nulls = Nulls.SKIP)
        public _FinalStage scopes(List<String> scopes) {
            this.scopes.clear();
            if (scopes != null) {
                this.scopes.addAll(scopes);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage lastUsedAt(OffsetDateTime lastUsedAt) {
            this.lastUsedAt = Optional.ofNullable(lastUsedAt);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "last_used_at", nulls = Nulls.SKIP)
        public _FinalStage lastUsedAt(Optional<OffsetDateTime> lastUsedAt) {
            this.lastUsedAt = lastUsedAt;
            return this;
        }

        @java.lang.Override
        public _FinalStage environmentId(String environmentId) {
            this.environmentId = Optional.ofNullable(environmentId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "environment_id", nulls = Nulls.SKIP)
        public _FinalStage environmentId(Optional<String> environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        @java.lang.Override
        public _FinalStage description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "description", nulls = Nulls.SKIP)
        public _FinalStage description(Optional<String> description) {
            this.description = description;
            return this;
        }

        @java.lang.Override
        public ApiKeyCreateResponseData build() {
            return new ApiKeyCreateResponseData(
                    createdAt,
                    description,
                    environmentId,
                    id,
                    lastUsedAt,
                    name,
                    scopes,
                    secret,
                    updatedAt,
                    additionalProperties);
        }
    }
}
