/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = BillingCreditResponseData.Builder.class)
public final class BillingCreditResponseData {
    private final String burnStrategy;

    private final OffsetDateTime createdAt;

    private final String defaultExpiryUnit;

    private final Optional<Integer> defaultExpiryUnitCount;

    private final String defaultRolloverPolicy;

    private final String description;

    private final Optional<String> icon;

    private final String id;

    private final String name;

    private final Optional<String> pluralName;

    private final Optional<BillingPriceResponseData> price;

    private final Optional<BillingProductResponseData> product;

    private final Optional<String> singularName;

    private final OffsetDateTime updatedAt;

    private final Map<String, Object> additionalProperties;

    private BillingCreditResponseData(
            String burnStrategy,
            OffsetDateTime createdAt,
            String defaultExpiryUnit,
            Optional<Integer> defaultExpiryUnitCount,
            String defaultRolloverPolicy,
            String description,
            Optional<String> icon,
            String id,
            String name,
            Optional<String> pluralName,
            Optional<BillingPriceResponseData> price,
            Optional<BillingProductResponseData> product,
            Optional<String> singularName,
            OffsetDateTime updatedAt,
            Map<String, Object> additionalProperties) {
        this.burnStrategy = burnStrategy;
        this.createdAt = createdAt;
        this.defaultExpiryUnit = defaultExpiryUnit;
        this.defaultExpiryUnitCount = defaultExpiryUnitCount;
        this.defaultRolloverPolicy = defaultRolloverPolicy;
        this.description = description;
        this.icon = icon;
        this.id = id;
        this.name = name;
        this.pluralName = pluralName;
        this.price = price;
        this.product = product;
        this.singularName = singularName;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("burn_strategy")
    public String getBurnStrategy() {
        return burnStrategy;
    }

    @JsonProperty("created_at")
    public OffsetDateTime getCreatedAt() {
        return createdAt;
    }

    @JsonProperty("default_expiry_unit")
    public String getDefaultExpiryUnit() {
        return defaultExpiryUnit;
    }

    @JsonProperty("default_expiry_unit_count")
    public Optional<Integer> getDefaultExpiryUnitCount() {
        return defaultExpiryUnitCount;
    }

    @JsonProperty("default_rollover_policy")
    public String getDefaultRolloverPolicy() {
        return defaultRolloverPolicy;
    }

    @JsonProperty("description")
    public String getDescription() {
        return description;
    }

    @JsonProperty("icon")
    public Optional<String> getIcon() {
        return icon;
    }

    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @JsonProperty("name")
    public String getName() {
        return name;
    }

    @JsonProperty("plural_name")
    public Optional<String> getPluralName() {
        return pluralName;
    }

    @JsonProperty("price")
    public Optional<BillingPriceResponseData> getPrice() {
        return price;
    }

    @JsonProperty("product")
    public Optional<BillingProductResponseData> getProduct() {
        return product;
    }

    @JsonProperty("singular_name")
    public Optional<String> getSingularName() {
        return singularName;
    }

    @JsonProperty("updated_at")
    public OffsetDateTime getUpdatedAt() {
        return updatedAt;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof BillingCreditResponseData && equalTo((BillingCreditResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BillingCreditResponseData other) {
        return burnStrategy.equals(other.burnStrategy)
                && createdAt.equals(other.createdAt)
                && defaultExpiryUnit.equals(other.defaultExpiryUnit)
                && defaultExpiryUnitCount.equals(other.defaultExpiryUnitCount)
                && defaultRolloverPolicy.equals(other.defaultRolloverPolicy)
                && description.equals(other.description)
                && icon.equals(other.icon)
                && id.equals(other.id)
                && name.equals(other.name)
                && pluralName.equals(other.pluralName)
                && price.equals(other.price)
                && product.equals(other.product)
                && singularName.equals(other.singularName)
                && updatedAt.equals(other.updatedAt);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.burnStrategy,
                this.createdAt,
                this.defaultExpiryUnit,
                this.defaultExpiryUnitCount,
                this.defaultRolloverPolicy,
                this.description,
                this.icon,
                this.id,
                this.name,
                this.pluralName,
                this.price,
                this.product,
                this.singularName,
                this.updatedAt);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static BurnStrategyStage builder() {
        return new Builder();
    }

    public interface BurnStrategyStage {
        CreatedAtStage burnStrategy(@NotNull String burnStrategy);

        Builder from(BillingCreditResponseData other);
    }

    public interface CreatedAtStage {
        DefaultExpiryUnitStage createdAt(@NotNull OffsetDateTime createdAt);
    }

    public interface DefaultExpiryUnitStage {
        DefaultRolloverPolicyStage defaultExpiryUnit(@NotNull String defaultExpiryUnit);
    }

    public interface DefaultRolloverPolicyStage {
        DescriptionStage defaultRolloverPolicy(@NotNull String defaultRolloverPolicy);
    }

    public interface DescriptionStage {
        IdStage description(@NotNull String description);
    }

    public interface IdStage {
        NameStage id(@NotNull String id);
    }

    public interface NameStage {
        UpdatedAtStage name(@NotNull String name);
    }

    public interface UpdatedAtStage {
        _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt);
    }

    public interface _FinalStage {
        BillingCreditResponseData build();

        _FinalStage defaultExpiryUnitCount(Optional<Integer> defaultExpiryUnitCount);

        _FinalStage defaultExpiryUnitCount(Integer defaultExpiryUnitCount);

        _FinalStage icon(Optional<String> icon);

        _FinalStage icon(String icon);

        _FinalStage pluralName(Optional<String> pluralName);

        _FinalStage pluralName(String pluralName);

        _FinalStage price(Optional<BillingPriceResponseData> price);

        _FinalStage price(BillingPriceResponseData price);

        _FinalStage product(Optional<BillingProductResponseData> product);

        _FinalStage product(BillingProductResponseData product);

        _FinalStage singularName(Optional<String> singularName);

        _FinalStage singularName(String singularName);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements BurnStrategyStage,
                    CreatedAtStage,
                    DefaultExpiryUnitStage,
                    DefaultRolloverPolicyStage,
                    DescriptionStage,
                    IdStage,
                    NameStage,
                    UpdatedAtStage,
                    _FinalStage {
        private String burnStrategy;

        private OffsetDateTime createdAt;

        private String defaultExpiryUnit;

        private String defaultRolloverPolicy;

        private String description;

        private String id;

        private String name;

        private OffsetDateTime updatedAt;

        private Optional<String> singularName = Optional.empty();

        private Optional<BillingProductResponseData> product = Optional.empty();

        private Optional<BillingPriceResponseData> price = Optional.empty();

        private Optional<String> pluralName = Optional.empty();

        private Optional<String> icon = Optional.empty();

        private Optional<Integer> defaultExpiryUnitCount = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(BillingCreditResponseData other) {
            burnStrategy(other.getBurnStrategy());
            createdAt(other.getCreatedAt());
            defaultExpiryUnit(other.getDefaultExpiryUnit());
            defaultExpiryUnitCount(other.getDefaultExpiryUnitCount());
            defaultRolloverPolicy(other.getDefaultRolloverPolicy());
            description(other.getDescription());
            icon(other.getIcon());
            id(other.getId());
            name(other.getName());
            pluralName(other.getPluralName());
            price(other.getPrice());
            product(other.getProduct());
            singularName(other.getSingularName());
            updatedAt(other.getUpdatedAt());
            return this;
        }

        @java.lang.Override
        @JsonSetter("burn_strategy")
        public CreatedAtStage burnStrategy(@NotNull String burnStrategy) {
            this.burnStrategy = Objects.requireNonNull(burnStrategy, "burnStrategy must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("created_at")
        public DefaultExpiryUnitStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("default_expiry_unit")
        public DefaultRolloverPolicyStage defaultExpiryUnit(@NotNull String defaultExpiryUnit) {
            this.defaultExpiryUnit = Objects.requireNonNull(defaultExpiryUnit, "defaultExpiryUnit must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("default_rollover_policy")
        public DescriptionStage defaultRolloverPolicy(@NotNull String defaultRolloverPolicy) {
            this.defaultRolloverPolicy =
                    Objects.requireNonNull(defaultRolloverPolicy, "defaultRolloverPolicy must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("description")
        public IdStage description(@NotNull String description) {
            this.description = Objects.requireNonNull(description, "description must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("name")
        public UpdatedAtStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage singularName(String singularName) {
            this.singularName = Optional.ofNullable(singularName);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "singular_name", nulls = Nulls.SKIP)
        public _FinalStage singularName(Optional<String> singularName) {
            this.singularName = singularName;
            return this;
        }

        @java.lang.Override
        public _FinalStage product(BillingProductResponseData product) {
            this.product = Optional.ofNullable(product);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "product", nulls = Nulls.SKIP)
        public _FinalStage product(Optional<BillingProductResponseData> product) {
            this.product = product;
            return this;
        }

        @java.lang.Override
        public _FinalStage price(BillingPriceResponseData price) {
            this.price = Optional.ofNullable(price);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "price", nulls = Nulls.SKIP)
        public _FinalStage price(Optional<BillingPriceResponseData> price) {
            this.price = price;
            return this;
        }

        @java.lang.Override
        public _FinalStage pluralName(String pluralName) {
            this.pluralName = Optional.ofNullable(pluralName);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "plural_name", nulls = Nulls.SKIP)
        public _FinalStage pluralName(Optional<String> pluralName) {
            this.pluralName = pluralName;
            return this;
        }

        @java.lang.Override
        public _FinalStage icon(String icon) {
            this.icon = Optional.ofNullable(icon);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "icon", nulls = Nulls.SKIP)
        public _FinalStage icon(Optional<String> icon) {
            this.icon = icon;
            return this;
        }

        @java.lang.Override
        public _FinalStage defaultExpiryUnitCount(Integer defaultExpiryUnitCount) {
            this.defaultExpiryUnitCount = Optional.ofNullable(defaultExpiryUnitCount);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "default_expiry_unit_count", nulls = Nulls.SKIP)
        public _FinalStage defaultExpiryUnitCount(Optional<Integer> defaultExpiryUnitCount) {
            this.defaultExpiryUnitCount = defaultExpiryUnitCount;
            return this;
        }

        @java.lang.Override
        public BillingCreditResponseData build() {
            return new BillingCreditResponseData(
                    burnStrategy,
                    createdAt,
                    defaultExpiryUnit,
                    defaultExpiryUnitCount,
                    defaultRolloverPolicy,
                    description,
                    icon,
                    id,
                    name,
                    pluralName,
                    price,
                    product,
                    singularName,
                    updatedAt,
                    additionalProperties);
        }
    }
}
