/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = BillingCustomerWithSubscriptionsResponseData.Builder.class)
public final class BillingCustomerWithSubscriptionsResponseData {
    private final Optional<String> companyId;

    private final Optional<OffsetDateTime> deletedAt;

    private final String email;

    private final String externalId;

    private final boolean failedToImport;

    private final String id;

    private final String name;

    private final List<BillingCustomerSubscription> subscriptions;

    private final OffsetDateTime updatedAt;

    private final Map<String, Object> additionalProperties;

    private BillingCustomerWithSubscriptionsResponseData(
            Optional<String> companyId,
            Optional<OffsetDateTime> deletedAt,
            String email,
            String externalId,
            boolean failedToImport,
            String id,
            String name,
            List<BillingCustomerSubscription> subscriptions,
            OffsetDateTime updatedAt,
            Map<String, Object> additionalProperties) {
        this.companyId = companyId;
        this.deletedAt = deletedAt;
        this.email = email;
        this.externalId = externalId;
        this.failedToImport = failedToImport;
        this.id = id;
        this.name = name;
        this.subscriptions = subscriptions;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("company_id")
    public Optional<String> getCompanyId() {
        return companyId;
    }

    @JsonProperty("deleted_at")
    public Optional<OffsetDateTime> getDeletedAt() {
        return deletedAt;
    }

    @JsonProperty("email")
    public String getEmail() {
        return email;
    }

    @JsonProperty("external_id")
    public String getExternalId() {
        return externalId;
    }

    @JsonProperty("failed_to_import")
    public boolean getFailedToImport() {
        return failedToImport;
    }

    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @JsonProperty("name")
    public String getName() {
        return name;
    }

    @JsonProperty("subscriptions")
    public List<BillingCustomerSubscription> getSubscriptions() {
        return subscriptions;
    }

    @JsonProperty("updated_at")
    public OffsetDateTime getUpdatedAt() {
        return updatedAt;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof BillingCustomerWithSubscriptionsResponseData
                && equalTo((BillingCustomerWithSubscriptionsResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BillingCustomerWithSubscriptionsResponseData other) {
        return companyId.equals(other.companyId)
                && deletedAt.equals(other.deletedAt)
                && email.equals(other.email)
                && externalId.equals(other.externalId)
                && failedToImport == other.failedToImport
                && id.equals(other.id)
                && name.equals(other.name)
                && subscriptions.equals(other.subscriptions)
                && updatedAt.equals(other.updatedAt);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.companyId,
                this.deletedAt,
                this.email,
                this.externalId,
                this.failedToImport,
                this.id,
                this.name,
                this.subscriptions,
                this.updatedAt);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static EmailStage builder() {
        return new Builder();
    }

    public interface EmailStage {
        ExternalIdStage email(@NotNull String email);

        Builder from(BillingCustomerWithSubscriptionsResponseData other);
    }

    public interface ExternalIdStage {
        FailedToImportStage externalId(@NotNull String externalId);
    }

    public interface FailedToImportStage {
        IdStage failedToImport(boolean failedToImport);
    }

    public interface IdStage {
        NameStage id(@NotNull String id);
    }

    public interface NameStage {
        UpdatedAtStage name(@NotNull String name);
    }

    public interface UpdatedAtStage {
        _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt);
    }

    public interface _FinalStage {
        BillingCustomerWithSubscriptionsResponseData build();

        _FinalStage companyId(Optional<String> companyId);

        _FinalStage companyId(String companyId);

        _FinalStage deletedAt(Optional<OffsetDateTime> deletedAt);

        _FinalStage deletedAt(OffsetDateTime deletedAt);

        _FinalStage subscriptions(List<BillingCustomerSubscription> subscriptions);

        _FinalStage addSubscriptions(BillingCustomerSubscription subscriptions);

        _FinalStage addAllSubscriptions(List<BillingCustomerSubscription> subscriptions);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements EmailStage,
                    ExternalIdStage,
                    FailedToImportStage,
                    IdStage,
                    NameStage,
                    UpdatedAtStage,
                    _FinalStage {
        private String email;

        private String externalId;

        private boolean failedToImport;

        private String id;

        private String name;

        private OffsetDateTime updatedAt;

        private List<BillingCustomerSubscription> subscriptions = new ArrayList<>();

        private Optional<OffsetDateTime> deletedAt = Optional.empty();

        private Optional<String> companyId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(BillingCustomerWithSubscriptionsResponseData other) {
            companyId(other.getCompanyId());
            deletedAt(other.getDeletedAt());
            email(other.getEmail());
            externalId(other.getExternalId());
            failedToImport(other.getFailedToImport());
            id(other.getId());
            name(other.getName());
            subscriptions(other.getSubscriptions());
            updatedAt(other.getUpdatedAt());
            return this;
        }

        @java.lang.Override
        @JsonSetter("email")
        public ExternalIdStage email(@NotNull String email) {
            this.email = Objects.requireNonNull(email, "email must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("external_id")
        public FailedToImportStage externalId(@NotNull String externalId) {
            this.externalId = Objects.requireNonNull(externalId, "externalId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("failed_to_import")
        public IdStage failedToImport(boolean failedToImport) {
            this.failedToImport = failedToImport;
            return this;
        }

        @java.lang.Override
        @JsonSetter("id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("name")
        public UpdatedAtStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllSubscriptions(List<BillingCustomerSubscription> subscriptions) {
            if (subscriptions != null) {
                this.subscriptions.addAll(subscriptions);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addSubscriptions(BillingCustomerSubscription subscriptions) {
            this.subscriptions.add(subscriptions);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "subscriptions", nulls = Nulls.SKIP)
        public _FinalStage subscriptions(List<BillingCustomerSubscription> subscriptions) {
            this.subscriptions.clear();
            if (subscriptions != null) {
                this.subscriptions.addAll(subscriptions);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage deletedAt(OffsetDateTime deletedAt) {
            this.deletedAt = Optional.ofNullable(deletedAt);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "deleted_at", nulls = Nulls.SKIP)
        public _FinalStage deletedAt(Optional<OffsetDateTime> deletedAt) {
            this.deletedAt = deletedAt;
            return this;
        }

        @java.lang.Override
        public _FinalStage companyId(String companyId) {
            this.companyId = Optional.ofNullable(companyId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "company_id", nulls = Nulls.SKIP)
        public _FinalStage companyId(Optional<String> companyId) {
            this.companyId = companyId;
            return this;
        }

        @java.lang.Override
        public BillingCustomerWithSubscriptionsResponseData build() {
            return new BillingCustomerWithSubscriptionsResponseData(
                    companyId,
                    deletedAt,
                    email,
                    externalId,
                    failedToImport,
                    id,
                    name,
                    subscriptions,
                    updatedAt,
                    additionalProperties);
        }
    }
}
