/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = BillingProductForSubscriptionResponseData.Builder.class)
public final class BillingProductForSubscriptionResponseData {
    private final String billingScheme;

    private final Optional<Integer> billingThreshold;

    private final OffsetDateTime createdAt;

    private final String currency;

    private final String environmentId;

    private final String externalId;

    private final String id;

    private final String interval;

    private final Optional<String> meterId;

    private final String name;

    private final int packageSize;

    private final int price;

    private final Optional<String> priceDecimal;

    private final String priceExternalId;

    private final String priceId;

    private final List<BillingProductPriceTierResponseData> priceTier;

    private final double quantity;

    private final String subscriptionId;

    private final Optional<String> subscriptionItemExternalId;

    private final OffsetDateTime updatedAt;

    private final String usageType;

    private final Map<String, Object> additionalProperties;

    private BillingProductForSubscriptionResponseData(
            String billingScheme,
            Optional<Integer> billingThreshold,
            OffsetDateTime createdAt,
            String currency,
            String environmentId,
            String externalId,
            String id,
            String interval,
            Optional<String> meterId,
            String name,
            int packageSize,
            int price,
            Optional<String> priceDecimal,
            String priceExternalId,
            String priceId,
            List<BillingProductPriceTierResponseData> priceTier,
            double quantity,
            String subscriptionId,
            Optional<String> subscriptionItemExternalId,
            OffsetDateTime updatedAt,
            String usageType,
            Map<String, Object> additionalProperties) {
        this.billingScheme = billingScheme;
        this.billingThreshold = billingThreshold;
        this.createdAt = createdAt;
        this.currency = currency;
        this.environmentId = environmentId;
        this.externalId = externalId;
        this.id = id;
        this.interval = interval;
        this.meterId = meterId;
        this.name = name;
        this.packageSize = packageSize;
        this.price = price;
        this.priceDecimal = priceDecimal;
        this.priceExternalId = priceExternalId;
        this.priceId = priceId;
        this.priceTier = priceTier;
        this.quantity = quantity;
        this.subscriptionId = subscriptionId;
        this.subscriptionItemExternalId = subscriptionItemExternalId;
        this.updatedAt = updatedAt;
        this.usageType = usageType;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("billing_scheme")
    public String getBillingScheme() {
        return billingScheme;
    }

    @JsonProperty("billing_threshold")
    public Optional<Integer> getBillingThreshold() {
        return billingThreshold;
    }

    @JsonProperty("created_at")
    public OffsetDateTime getCreatedAt() {
        return createdAt;
    }

    @JsonProperty("currency")
    public String getCurrency() {
        return currency;
    }

    @JsonProperty("environment_id")
    public String getEnvironmentId() {
        return environmentId;
    }

    @JsonProperty("external_id")
    public String getExternalId() {
        return externalId;
    }

    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @JsonProperty("interval")
    public String getInterval() {
        return interval;
    }

    @JsonProperty("meter_id")
    public Optional<String> getMeterId() {
        return meterId;
    }

    @JsonProperty("name")
    public String getName() {
        return name;
    }

    @JsonProperty("package_size")
    public int getPackageSize() {
        return packageSize;
    }

    @JsonProperty("price")
    public int getPrice() {
        return price;
    }

    @JsonProperty("price_decimal")
    public Optional<String> getPriceDecimal() {
        return priceDecimal;
    }

    @JsonProperty("price_external_id")
    public String getPriceExternalId() {
        return priceExternalId;
    }

    @JsonProperty("price_id")
    public String getPriceId() {
        return priceId;
    }

    @JsonProperty("price_tier")
    public List<BillingProductPriceTierResponseData> getPriceTier() {
        return priceTier;
    }

    @JsonProperty("quantity")
    public double getQuantity() {
        return quantity;
    }

    @JsonProperty("subscription_id")
    public String getSubscriptionId() {
        return subscriptionId;
    }

    @JsonProperty("subscription_item_external_id")
    public Optional<String> getSubscriptionItemExternalId() {
        return subscriptionItemExternalId;
    }

    @JsonProperty("updated_at")
    public OffsetDateTime getUpdatedAt() {
        return updatedAt;
    }

    @JsonProperty("usage_type")
    public String getUsageType() {
        return usageType;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof BillingProductForSubscriptionResponseData
                && equalTo((BillingProductForSubscriptionResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BillingProductForSubscriptionResponseData other) {
        return billingScheme.equals(other.billingScheme)
                && billingThreshold.equals(other.billingThreshold)
                && createdAt.equals(other.createdAt)
                && currency.equals(other.currency)
                && environmentId.equals(other.environmentId)
                && externalId.equals(other.externalId)
                && id.equals(other.id)
                && interval.equals(other.interval)
                && meterId.equals(other.meterId)
                && name.equals(other.name)
                && packageSize == other.packageSize
                && price == other.price
                && priceDecimal.equals(other.priceDecimal)
                && priceExternalId.equals(other.priceExternalId)
                && priceId.equals(other.priceId)
                && priceTier.equals(other.priceTier)
                && quantity == other.quantity
                && subscriptionId.equals(other.subscriptionId)
                && subscriptionItemExternalId.equals(other.subscriptionItemExternalId)
                && updatedAt.equals(other.updatedAt)
                && usageType.equals(other.usageType);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.billingScheme,
                this.billingThreshold,
                this.createdAt,
                this.currency,
                this.environmentId,
                this.externalId,
                this.id,
                this.interval,
                this.meterId,
                this.name,
                this.packageSize,
                this.price,
                this.priceDecimal,
                this.priceExternalId,
                this.priceId,
                this.priceTier,
                this.quantity,
                this.subscriptionId,
                this.subscriptionItemExternalId,
                this.updatedAt,
                this.usageType);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static BillingSchemeStage builder() {
        return new Builder();
    }

    public interface BillingSchemeStage {
        CreatedAtStage billingScheme(@NotNull String billingScheme);

        Builder from(BillingProductForSubscriptionResponseData other);
    }

    public interface CreatedAtStage {
        CurrencyStage createdAt(@NotNull OffsetDateTime createdAt);
    }

    public interface CurrencyStage {
        EnvironmentIdStage currency(@NotNull String currency);
    }

    public interface EnvironmentIdStage {
        ExternalIdStage environmentId(@NotNull String environmentId);
    }

    public interface ExternalIdStage {
        IdStage externalId(@NotNull String externalId);
    }

    public interface IdStage {
        IntervalStage id(@NotNull String id);
    }

    public interface IntervalStage {
        NameStage interval(@NotNull String interval);
    }

    public interface NameStage {
        PackageSizeStage name(@NotNull String name);
    }

    public interface PackageSizeStage {
        PriceStage packageSize(int packageSize);
    }

    public interface PriceStage {
        PriceExternalIdStage price(int price);
    }

    public interface PriceExternalIdStage {
        PriceIdStage priceExternalId(@NotNull String priceExternalId);
    }

    public interface PriceIdStage {
        QuantityStage priceId(@NotNull String priceId);
    }

    public interface QuantityStage {
        SubscriptionIdStage quantity(double quantity);
    }

    public interface SubscriptionIdStage {
        UpdatedAtStage subscriptionId(@NotNull String subscriptionId);
    }

    public interface UpdatedAtStage {
        UsageTypeStage updatedAt(@NotNull OffsetDateTime updatedAt);
    }

    public interface UsageTypeStage {
        _FinalStage usageType(@NotNull String usageType);
    }

    public interface _FinalStage {
        BillingProductForSubscriptionResponseData build();

        _FinalStage billingThreshold(Optional<Integer> billingThreshold);

        _FinalStage billingThreshold(Integer billingThreshold);

        _FinalStage meterId(Optional<String> meterId);

        _FinalStage meterId(String meterId);

        _FinalStage priceDecimal(Optional<String> priceDecimal);

        _FinalStage priceDecimal(String priceDecimal);

        _FinalStage priceTier(List<BillingProductPriceTierResponseData> priceTier);

        _FinalStage addPriceTier(BillingProductPriceTierResponseData priceTier);

        _FinalStage addAllPriceTier(List<BillingProductPriceTierResponseData> priceTier);

        _FinalStage subscriptionItemExternalId(Optional<String> subscriptionItemExternalId);

        _FinalStage subscriptionItemExternalId(String subscriptionItemExternalId);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements BillingSchemeStage,
                    CreatedAtStage,
                    CurrencyStage,
                    EnvironmentIdStage,
                    ExternalIdStage,
                    IdStage,
                    IntervalStage,
                    NameStage,
                    PackageSizeStage,
                    PriceStage,
                    PriceExternalIdStage,
                    PriceIdStage,
                    QuantityStage,
                    SubscriptionIdStage,
                    UpdatedAtStage,
                    UsageTypeStage,
                    _FinalStage {
        private String billingScheme;

        private OffsetDateTime createdAt;

        private String currency;

        private String environmentId;

        private String externalId;

        private String id;

        private String interval;

        private String name;

        private int packageSize;

        private int price;

        private String priceExternalId;

        private String priceId;

        private double quantity;

        private String subscriptionId;

        private OffsetDateTime updatedAt;

        private String usageType;

        private Optional<String> subscriptionItemExternalId = Optional.empty();

        private List<BillingProductPriceTierResponseData> priceTier = new ArrayList<>();

        private Optional<String> priceDecimal = Optional.empty();

        private Optional<String> meterId = Optional.empty();

        private Optional<Integer> billingThreshold = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(BillingProductForSubscriptionResponseData other) {
            billingScheme(other.getBillingScheme());
            billingThreshold(other.getBillingThreshold());
            createdAt(other.getCreatedAt());
            currency(other.getCurrency());
            environmentId(other.getEnvironmentId());
            externalId(other.getExternalId());
            id(other.getId());
            interval(other.getInterval());
            meterId(other.getMeterId());
            name(other.getName());
            packageSize(other.getPackageSize());
            price(other.getPrice());
            priceDecimal(other.getPriceDecimal());
            priceExternalId(other.getPriceExternalId());
            priceId(other.getPriceId());
            priceTier(other.getPriceTier());
            quantity(other.getQuantity());
            subscriptionId(other.getSubscriptionId());
            subscriptionItemExternalId(other.getSubscriptionItemExternalId());
            updatedAt(other.getUpdatedAt());
            usageType(other.getUsageType());
            return this;
        }

        @java.lang.Override
        @JsonSetter("billing_scheme")
        public CreatedAtStage billingScheme(@NotNull String billingScheme) {
            this.billingScheme = Objects.requireNonNull(billingScheme, "billingScheme must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("created_at")
        public CurrencyStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("currency")
        public EnvironmentIdStage currency(@NotNull String currency) {
            this.currency = Objects.requireNonNull(currency, "currency must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("environment_id")
        public ExternalIdStage environmentId(@NotNull String environmentId) {
            this.environmentId = Objects.requireNonNull(environmentId, "environmentId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("external_id")
        public IdStage externalId(@NotNull String externalId) {
            this.externalId = Objects.requireNonNull(externalId, "externalId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("id")
        public IntervalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("interval")
        public NameStage interval(@NotNull String interval) {
            this.interval = Objects.requireNonNull(interval, "interval must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("name")
        public PackageSizeStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("package_size")
        public PriceStage packageSize(int packageSize) {
            this.packageSize = packageSize;
            return this;
        }

        @java.lang.Override
        @JsonSetter("price")
        public PriceExternalIdStage price(int price) {
            this.price = price;
            return this;
        }

        @java.lang.Override
        @JsonSetter("price_external_id")
        public PriceIdStage priceExternalId(@NotNull String priceExternalId) {
            this.priceExternalId = Objects.requireNonNull(priceExternalId, "priceExternalId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("price_id")
        public QuantityStage priceId(@NotNull String priceId) {
            this.priceId = Objects.requireNonNull(priceId, "priceId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("quantity")
        public SubscriptionIdStage quantity(double quantity) {
            this.quantity = quantity;
            return this;
        }

        @java.lang.Override
        @JsonSetter("subscription_id")
        public UpdatedAtStage subscriptionId(@NotNull String subscriptionId) {
            this.subscriptionId = Objects.requireNonNull(subscriptionId, "subscriptionId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("updated_at")
        public UsageTypeStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("usage_type")
        public _FinalStage usageType(@NotNull String usageType) {
            this.usageType = Objects.requireNonNull(usageType, "usageType must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage subscriptionItemExternalId(String subscriptionItemExternalId) {
            this.subscriptionItemExternalId = Optional.ofNullable(subscriptionItemExternalId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "subscription_item_external_id", nulls = Nulls.SKIP)
        public _FinalStage subscriptionItemExternalId(Optional<String> subscriptionItemExternalId) {
            this.subscriptionItemExternalId = subscriptionItemExternalId;
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllPriceTier(List<BillingProductPriceTierResponseData> priceTier) {
            if (priceTier != null) {
                this.priceTier.addAll(priceTier);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addPriceTier(BillingProductPriceTierResponseData priceTier) {
            this.priceTier.add(priceTier);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "price_tier", nulls = Nulls.SKIP)
        public _FinalStage priceTier(List<BillingProductPriceTierResponseData> priceTier) {
            this.priceTier.clear();
            if (priceTier != null) {
                this.priceTier.addAll(priceTier);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage priceDecimal(String priceDecimal) {
            this.priceDecimal = Optional.ofNullable(priceDecimal);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "price_decimal", nulls = Nulls.SKIP)
        public _FinalStage priceDecimal(Optional<String> priceDecimal) {
            this.priceDecimal = priceDecimal;
            return this;
        }

        @java.lang.Override
        public _FinalStage meterId(String meterId) {
            this.meterId = Optional.ofNullable(meterId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "meter_id", nulls = Nulls.SKIP)
        public _FinalStage meterId(Optional<String> meterId) {
            this.meterId = meterId;
            return this;
        }

        @java.lang.Override
        public _FinalStage billingThreshold(Integer billingThreshold) {
            this.billingThreshold = Optional.ofNullable(billingThreshold);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "billing_threshold", nulls = Nulls.SKIP)
        public _FinalStage billingThreshold(Optional<Integer> billingThreshold) {
            this.billingThreshold = billingThreshold;
            return this;
        }

        @java.lang.Override
        public BillingProductForSubscriptionResponseData build() {
            return new BillingProductForSubscriptionResponseData(
                    billingScheme,
                    billingThreshold,
                    createdAt,
                    currency,
                    environmentId,
                    externalId,
                    id,
                    interval,
                    meterId,
                    name,
                    packageSize,
                    price,
                    priceDecimal,
                    priceExternalId,
                    priceId,
                    priceTier,
                    quantity,
                    subscriptionId,
                    subscriptionItemExternalId,
                    updatedAt,
                    usageType,
                    additionalProperties);
        }
    }
}
