/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = BillingProductPriceResponseData.Builder.class)
public final class BillingProductPriceResponseData {
    private final String billingScheme;

    private final OffsetDateTime createdAt;

    private final String currency;

    private final String id;

    private final String interval;

    private final boolean isActive;

    private final Optional<String> meterId;

    private final int packageSize;

    private final int price;

    private final Optional<String> priceDecimal;

    private final String priceExternalId;

    private final String productExternalId;

    private final Optional<String> tiersMode;

    private final OffsetDateTime updatedAt;

    private final String usageType;

    private final Map<String, Object> additionalProperties;

    private BillingProductPriceResponseData(
            String billingScheme,
            OffsetDateTime createdAt,
            String currency,
            String id,
            String interval,
            boolean isActive,
            Optional<String> meterId,
            int packageSize,
            int price,
            Optional<String> priceDecimal,
            String priceExternalId,
            String productExternalId,
            Optional<String> tiersMode,
            OffsetDateTime updatedAt,
            String usageType,
            Map<String, Object> additionalProperties) {
        this.billingScheme = billingScheme;
        this.createdAt = createdAt;
        this.currency = currency;
        this.id = id;
        this.interval = interval;
        this.isActive = isActive;
        this.meterId = meterId;
        this.packageSize = packageSize;
        this.price = price;
        this.priceDecimal = priceDecimal;
        this.priceExternalId = priceExternalId;
        this.productExternalId = productExternalId;
        this.tiersMode = tiersMode;
        this.updatedAt = updatedAt;
        this.usageType = usageType;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("billing_scheme")
    public String getBillingScheme() {
        return billingScheme;
    }

    @JsonProperty("created_at")
    public OffsetDateTime getCreatedAt() {
        return createdAt;
    }

    @JsonProperty("currency")
    public String getCurrency() {
        return currency;
    }

    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @JsonProperty("interval")
    public String getInterval() {
        return interval;
    }

    @JsonProperty("is_active")
    public boolean getIsActive() {
        return isActive;
    }

    @JsonProperty("meter_id")
    public Optional<String> getMeterId() {
        return meterId;
    }

    @JsonProperty("package_size")
    public int getPackageSize() {
        return packageSize;
    }

    @JsonProperty("price")
    public int getPrice() {
        return price;
    }

    @JsonProperty("price_decimal")
    public Optional<String> getPriceDecimal() {
        return priceDecimal;
    }

    @JsonProperty("price_external_id")
    public String getPriceExternalId() {
        return priceExternalId;
    }

    @JsonProperty("product_external_id")
    public String getProductExternalId() {
        return productExternalId;
    }

    @JsonProperty("tiers_mode")
    public Optional<String> getTiersMode() {
        return tiersMode;
    }

    @JsonProperty("updated_at")
    public OffsetDateTime getUpdatedAt() {
        return updatedAt;
    }

    @JsonProperty("usage_type")
    public String getUsageType() {
        return usageType;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof BillingProductPriceResponseData && equalTo((BillingProductPriceResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BillingProductPriceResponseData other) {
        return billingScheme.equals(other.billingScheme)
                && createdAt.equals(other.createdAt)
                && currency.equals(other.currency)
                && id.equals(other.id)
                && interval.equals(other.interval)
                && isActive == other.isActive
                && meterId.equals(other.meterId)
                && packageSize == other.packageSize
                && price == other.price
                && priceDecimal.equals(other.priceDecimal)
                && priceExternalId.equals(other.priceExternalId)
                && productExternalId.equals(other.productExternalId)
                && tiersMode.equals(other.tiersMode)
                && updatedAt.equals(other.updatedAt)
                && usageType.equals(other.usageType);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.billingScheme,
                this.createdAt,
                this.currency,
                this.id,
                this.interval,
                this.isActive,
                this.meterId,
                this.packageSize,
                this.price,
                this.priceDecimal,
                this.priceExternalId,
                this.productExternalId,
                this.tiersMode,
                this.updatedAt,
                this.usageType);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static BillingSchemeStage builder() {
        return new Builder();
    }

    public interface BillingSchemeStage {
        CreatedAtStage billingScheme(@NotNull String billingScheme);

        Builder from(BillingProductPriceResponseData other);
    }

    public interface CreatedAtStage {
        CurrencyStage createdAt(@NotNull OffsetDateTime createdAt);
    }

    public interface CurrencyStage {
        IdStage currency(@NotNull String currency);
    }

    public interface IdStage {
        IntervalStage id(@NotNull String id);
    }

    public interface IntervalStage {
        IsActiveStage interval(@NotNull String interval);
    }

    public interface IsActiveStage {
        PackageSizeStage isActive(boolean isActive);
    }

    public interface PackageSizeStage {
        PriceStage packageSize(int packageSize);
    }

    public interface PriceStage {
        PriceExternalIdStage price(int price);
    }

    public interface PriceExternalIdStage {
        ProductExternalIdStage priceExternalId(@NotNull String priceExternalId);
    }

    public interface ProductExternalIdStage {
        UpdatedAtStage productExternalId(@NotNull String productExternalId);
    }

    public interface UpdatedAtStage {
        UsageTypeStage updatedAt(@NotNull OffsetDateTime updatedAt);
    }

    public interface UsageTypeStage {
        _FinalStage usageType(@NotNull String usageType);
    }

    public interface _FinalStage {
        BillingProductPriceResponseData build();

        _FinalStage meterId(Optional<String> meterId);

        _FinalStage meterId(String meterId);

        _FinalStage priceDecimal(Optional<String> priceDecimal);

        _FinalStage priceDecimal(String priceDecimal);

        _FinalStage tiersMode(Optional<String> tiersMode);

        _FinalStage tiersMode(String tiersMode);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements BillingSchemeStage,
                    CreatedAtStage,
                    CurrencyStage,
                    IdStage,
                    IntervalStage,
                    IsActiveStage,
                    PackageSizeStage,
                    PriceStage,
                    PriceExternalIdStage,
                    ProductExternalIdStage,
                    UpdatedAtStage,
                    UsageTypeStage,
                    _FinalStage {
        private String billingScheme;

        private OffsetDateTime createdAt;

        private String currency;

        private String id;

        private String interval;

        private boolean isActive;

        private int packageSize;

        private int price;

        private String priceExternalId;

        private String productExternalId;

        private OffsetDateTime updatedAt;

        private String usageType;

        private Optional<String> tiersMode = Optional.empty();

        private Optional<String> priceDecimal = Optional.empty();

        private Optional<String> meterId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(BillingProductPriceResponseData other) {
            billingScheme(other.getBillingScheme());
            createdAt(other.getCreatedAt());
            currency(other.getCurrency());
            id(other.getId());
            interval(other.getInterval());
            isActive(other.getIsActive());
            meterId(other.getMeterId());
            packageSize(other.getPackageSize());
            price(other.getPrice());
            priceDecimal(other.getPriceDecimal());
            priceExternalId(other.getPriceExternalId());
            productExternalId(other.getProductExternalId());
            tiersMode(other.getTiersMode());
            updatedAt(other.getUpdatedAt());
            usageType(other.getUsageType());
            return this;
        }

        @java.lang.Override
        @JsonSetter("billing_scheme")
        public CreatedAtStage billingScheme(@NotNull String billingScheme) {
            this.billingScheme = Objects.requireNonNull(billingScheme, "billingScheme must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("created_at")
        public CurrencyStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("currency")
        public IdStage currency(@NotNull String currency) {
            this.currency = Objects.requireNonNull(currency, "currency must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("id")
        public IntervalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("interval")
        public IsActiveStage interval(@NotNull String interval) {
            this.interval = Objects.requireNonNull(interval, "interval must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("is_active")
        public PackageSizeStage isActive(boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        @java.lang.Override
        @JsonSetter("package_size")
        public PriceStage packageSize(int packageSize) {
            this.packageSize = packageSize;
            return this;
        }

        @java.lang.Override
        @JsonSetter("price")
        public PriceExternalIdStage price(int price) {
            this.price = price;
            return this;
        }

        @java.lang.Override
        @JsonSetter("price_external_id")
        public ProductExternalIdStage priceExternalId(@NotNull String priceExternalId) {
            this.priceExternalId = Objects.requireNonNull(priceExternalId, "priceExternalId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("product_external_id")
        public UpdatedAtStage productExternalId(@NotNull String productExternalId) {
            this.productExternalId = Objects.requireNonNull(productExternalId, "productExternalId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("updated_at")
        public UsageTypeStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("usage_type")
        public _FinalStage usageType(@NotNull String usageType) {
            this.usageType = Objects.requireNonNull(usageType, "usageType must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage tiersMode(String tiersMode) {
            this.tiersMode = Optional.ofNullable(tiersMode);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "tiers_mode", nulls = Nulls.SKIP)
        public _FinalStage tiersMode(Optional<String> tiersMode) {
            this.tiersMode = tiersMode;
            return this;
        }

        @java.lang.Override
        public _FinalStage priceDecimal(String priceDecimal) {
            this.priceDecimal = Optional.ofNullable(priceDecimal);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "price_decimal", nulls = Nulls.SKIP)
        public _FinalStage priceDecimal(Optional<String> priceDecimal) {
            this.priceDecimal = priceDecimal;
            return this;
        }

        @java.lang.Override
        public _FinalStage meterId(String meterId) {
            this.meterId = Optional.ofNullable(meterId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "meter_id", nulls = Nulls.SKIP)
        public _FinalStage meterId(Optional<String> meterId) {
            this.meterId = meterId;
            return this;
        }

        @java.lang.Override
        public BillingProductPriceResponseData build() {
            return new BillingProductPriceResponseData(
                    billingScheme,
                    createdAt,
                    currency,
                    id,
                    interval,
                    isActive,
                    meterId,
                    packageSize,
                    price,
                    priceDecimal,
                    priceExternalId,
                    productExternalId,
                    tiersMode,
                    updatedAt,
                    usageType,
                    additionalProperties);
        }
    }
}
