/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = BillingProductPricing.Builder.class)
public final class BillingProductPricing {
    private final Optional<Integer> billingThreshold;

    private final String currency;

    private final String interval;

    private final Optional<String> meterId;

    private final Optional<Integer> packageSize;

    private final int price;

    private final Optional<String> priceDecimal;

    private final String priceExternalId;

    private final String productExternalId;

    private final int quantity;

    private final Optional<String> subscriptionItemExternalId;

    private final BillingProductPricingUsageType usageType;

    private final Map<String, Object> additionalProperties;

    private BillingProductPricing(
            Optional<Integer> billingThreshold,
            String currency,
            String interval,
            Optional<String> meterId,
            Optional<Integer> packageSize,
            int price,
            Optional<String> priceDecimal,
            String priceExternalId,
            String productExternalId,
            int quantity,
            Optional<String> subscriptionItemExternalId,
            BillingProductPricingUsageType usageType,
            Map<String, Object> additionalProperties) {
        this.billingThreshold = billingThreshold;
        this.currency = currency;
        this.interval = interval;
        this.meterId = meterId;
        this.packageSize = packageSize;
        this.price = price;
        this.priceDecimal = priceDecimal;
        this.priceExternalId = priceExternalId;
        this.productExternalId = productExternalId;
        this.quantity = quantity;
        this.subscriptionItemExternalId = subscriptionItemExternalId;
        this.usageType = usageType;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("billing_threshold")
    public Optional<Integer> getBillingThreshold() {
        return billingThreshold;
    }

    @JsonProperty("currency")
    public String getCurrency() {
        return currency;
    }

    @JsonProperty("interval")
    public String getInterval() {
        return interval;
    }

    @JsonProperty("meter_id")
    public Optional<String> getMeterId() {
        return meterId;
    }

    @JsonProperty("package_size")
    public Optional<Integer> getPackageSize() {
        return packageSize;
    }

    @JsonProperty("price")
    public int getPrice() {
        return price;
    }

    @JsonProperty("price_decimal")
    public Optional<String> getPriceDecimal() {
        return priceDecimal;
    }

    @JsonProperty("price_external_id")
    public String getPriceExternalId() {
        return priceExternalId;
    }

    @JsonProperty("product_external_id")
    public String getProductExternalId() {
        return productExternalId;
    }

    @JsonProperty("quantity")
    public int getQuantity() {
        return quantity;
    }

    @JsonProperty("subscription_item_external_id")
    public Optional<String> getSubscriptionItemExternalId() {
        return subscriptionItemExternalId;
    }

    @JsonProperty("usage_type")
    public BillingProductPricingUsageType getUsageType() {
        return usageType;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof BillingProductPricing && equalTo((BillingProductPricing) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BillingProductPricing other) {
        return billingThreshold.equals(other.billingThreshold)
                && currency.equals(other.currency)
                && interval.equals(other.interval)
                && meterId.equals(other.meterId)
                && packageSize.equals(other.packageSize)
                && price == other.price
                && priceDecimal.equals(other.priceDecimal)
                && priceExternalId.equals(other.priceExternalId)
                && productExternalId.equals(other.productExternalId)
                && quantity == other.quantity
                && subscriptionItemExternalId.equals(other.subscriptionItemExternalId)
                && usageType.equals(other.usageType);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.billingThreshold,
                this.currency,
                this.interval,
                this.meterId,
                this.packageSize,
                this.price,
                this.priceDecimal,
                this.priceExternalId,
                this.productExternalId,
                this.quantity,
                this.subscriptionItemExternalId,
                this.usageType);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CurrencyStage builder() {
        return new Builder();
    }

    public interface CurrencyStage {
        IntervalStage currency(@NotNull String currency);

        Builder from(BillingProductPricing other);
    }

    public interface IntervalStage {
        PriceStage interval(@NotNull String interval);
    }

    public interface PriceStage {
        PriceExternalIdStage price(int price);
    }

    public interface PriceExternalIdStage {
        ProductExternalIdStage priceExternalId(@NotNull String priceExternalId);
    }

    public interface ProductExternalIdStage {
        QuantityStage productExternalId(@NotNull String productExternalId);
    }

    public interface QuantityStage {
        UsageTypeStage quantity(int quantity);
    }

    public interface UsageTypeStage {
        _FinalStage usageType(@NotNull BillingProductPricingUsageType usageType);
    }

    public interface _FinalStage {
        BillingProductPricing build();

        _FinalStage billingThreshold(Optional<Integer> billingThreshold);

        _FinalStage billingThreshold(Integer billingThreshold);

        _FinalStage meterId(Optional<String> meterId);

        _FinalStage meterId(String meterId);

        _FinalStage packageSize(Optional<Integer> packageSize);

        _FinalStage packageSize(Integer packageSize);

        _FinalStage priceDecimal(Optional<String> priceDecimal);

        _FinalStage priceDecimal(String priceDecimal);

        _FinalStage subscriptionItemExternalId(Optional<String> subscriptionItemExternalId);

        _FinalStage subscriptionItemExternalId(String subscriptionItemExternalId);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements CurrencyStage,
                    IntervalStage,
                    PriceStage,
                    PriceExternalIdStage,
                    ProductExternalIdStage,
                    QuantityStage,
                    UsageTypeStage,
                    _FinalStage {
        private String currency;

        private String interval;

        private int price;

        private String priceExternalId;

        private String productExternalId;

        private int quantity;

        private BillingProductPricingUsageType usageType;

        private Optional<String> subscriptionItemExternalId = Optional.empty();

        private Optional<String> priceDecimal = Optional.empty();

        private Optional<Integer> packageSize = Optional.empty();

        private Optional<String> meterId = Optional.empty();

        private Optional<Integer> billingThreshold = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(BillingProductPricing other) {
            billingThreshold(other.getBillingThreshold());
            currency(other.getCurrency());
            interval(other.getInterval());
            meterId(other.getMeterId());
            packageSize(other.getPackageSize());
            price(other.getPrice());
            priceDecimal(other.getPriceDecimal());
            priceExternalId(other.getPriceExternalId());
            productExternalId(other.getProductExternalId());
            quantity(other.getQuantity());
            subscriptionItemExternalId(other.getSubscriptionItemExternalId());
            usageType(other.getUsageType());
            return this;
        }

        @java.lang.Override
        @JsonSetter("currency")
        public IntervalStage currency(@NotNull String currency) {
            this.currency = Objects.requireNonNull(currency, "currency must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("interval")
        public PriceStage interval(@NotNull String interval) {
            this.interval = Objects.requireNonNull(interval, "interval must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("price")
        public PriceExternalIdStage price(int price) {
            this.price = price;
            return this;
        }

        @java.lang.Override
        @JsonSetter("price_external_id")
        public ProductExternalIdStage priceExternalId(@NotNull String priceExternalId) {
            this.priceExternalId = Objects.requireNonNull(priceExternalId, "priceExternalId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("product_external_id")
        public QuantityStage productExternalId(@NotNull String productExternalId) {
            this.productExternalId = Objects.requireNonNull(productExternalId, "productExternalId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("quantity")
        public UsageTypeStage quantity(int quantity) {
            this.quantity = quantity;
            return this;
        }

        @java.lang.Override
        @JsonSetter("usage_type")
        public _FinalStage usageType(@NotNull BillingProductPricingUsageType usageType) {
            this.usageType = Objects.requireNonNull(usageType, "usageType must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage subscriptionItemExternalId(String subscriptionItemExternalId) {
            this.subscriptionItemExternalId = Optional.ofNullable(subscriptionItemExternalId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "subscription_item_external_id", nulls = Nulls.SKIP)
        public _FinalStage subscriptionItemExternalId(Optional<String> subscriptionItemExternalId) {
            this.subscriptionItemExternalId = subscriptionItemExternalId;
            return this;
        }

        @java.lang.Override
        public _FinalStage priceDecimal(String priceDecimal) {
            this.priceDecimal = Optional.ofNullable(priceDecimal);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "price_decimal", nulls = Nulls.SKIP)
        public _FinalStage priceDecimal(Optional<String> priceDecimal) {
            this.priceDecimal = priceDecimal;
            return this;
        }

        @java.lang.Override
        public _FinalStage packageSize(Integer packageSize) {
            this.packageSize = Optional.ofNullable(packageSize);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "package_size", nulls = Nulls.SKIP)
        public _FinalStage packageSize(Optional<Integer> packageSize) {
            this.packageSize = packageSize;
            return this;
        }

        @java.lang.Override
        public _FinalStage meterId(String meterId) {
            this.meterId = Optional.ofNullable(meterId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "meter_id", nulls = Nulls.SKIP)
        public _FinalStage meterId(Optional<String> meterId) {
            this.meterId = meterId;
            return this;
        }

        @java.lang.Override
        public _FinalStage billingThreshold(Integer billingThreshold) {
            this.billingThreshold = Optional.ofNullable(billingThreshold);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "billing_threshold", nulls = Nulls.SKIP)
        public _FinalStage billingThreshold(Optional<Integer> billingThreshold) {
            this.billingThreshold = billingThreshold;
            return this;
        }

        @java.lang.Override
        public BillingProductPricing build() {
            return new BillingProductPricing(
                    billingThreshold,
                    currency,
                    interval,
                    meterId,
                    packageSize,
                    price,
                    priceDecimal,
                    priceExternalId,
                    productExternalId,
                    quantity,
                    subscriptionItemExternalId,
                    usageType,
                    additionalProperties);
        }
    }
}
