/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = BillingSubscriptionResponseData.Builder.class)
public final class BillingSubscriptionResponseData {
    private final Optional<Integer> cancelAt;

    private final boolean cancelAtPeriodEnd;

    private final Optional<String> companyId;

    private final OffsetDateTime createdAt;

    private final String currency;

    private final String customerExternalId;

    private final Optional<String> defaultPaymentMethodId;

    private final Optional<OffsetDateTime> expiredAt;

    private final String id;

    private final String interval;

    private final Optional<Map<String, JsonNode>> metadata;

    private final int periodEnd;

    private final int periodStart;

    private final String status;

    private final String subscriptionExternalId;

    private final int totalPrice;

    private final Optional<Integer> trialEnd;

    private final Optional<String> trialEndSetting;

    private final Map<String, Object> additionalProperties;

    private BillingSubscriptionResponseData(
            Optional<Integer> cancelAt,
            boolean cancelAtPeriodEnd,
            Optional<String> companyId,
            OffsetDateTime createdAt,
            String currency,
            String customerExternalId,
            Optional<String> defaultPaymentMethodId,
            Optional<OffsetDateTime> expiredAt,
            String id,
            String interval,
            Optional<Map<String, JsonNode>> metadata,
            int periodEnd,
            int periodStart,
            String status,
            String subscriptionExternalId,
            int totalPrice,
            Optional<Integer> trialEnd,
            Optional<String> trialEndSetting,
            Map<String, Object> additionalProperties) {
        this.cancelAt = cancelAt;
        this.cancelAtPeriodEnd = cancelAtPeriodEnd;
        this.companyId = companyId;
        this.createdAt = createdAt;
        this.currency = currency;
        this.customerExternalId = customerExternalId;
        this.defaultPaymentMethodId = defaultPaymentMethodId;
        this.expiredAt = expiredAt;
        this.id = id;
        this.interval = interval;
        this.metadata = metadata;
        this.periodEnd = periodEnd;
        this.periodStart = periodStart;
        this.status = status;
        this.subscriptionExternalId = subscriptionExternalId;
        this.totalPrice = totalPrice;
        this.trialEnd = trialEnd;
        this.trialEndSetting = trialEndSetting;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("cancel_at")
    public Optional<Integer> getCancelAt() {
        return cancelAt;
    }

    @JsonProperty("cancel_at_period_end")
    public boolean getCancelAtPeriodEnd() {
        return cancelAtPeriodEnd;
    }

    @JsonProperty("company_id")
    public Optional<String> getCompanyId() {
        return companyId;
    }

    @JsonProperty("created_at")
    public OffsetDateTime getCreatedAt() {
        return createdAt;
    }

    @JsonProperty("currency")
    public String getCurrency() {
        return currency;
    }

    @JsonProperty("customer_external_id")
    public String getCustomerExternalId() {
        return customerExternalId;
    }

    @JsonProperty("default_payment_method_id")
    public Optional<String> getDefaultPaymentMethodId() {
        return defaultPaymentMethodId;
    }

    @JsonProperty("expired_at")
    public Optional<OffsetDateTime> getExpiredAt() {
        return expiredAt;
    }

    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @JsonProperty("interval")
    public String getInterval() {
        return interval;
    }

    @JsonProperty("metadata")
    public Optional<Map<String, JsonNode>> getMetadata() {
        return metadata;
    }

    @JsonProperty("period_end")
    public int getPeriodEnd() {
        return periodEnd;
    }

    @JsonProperty("period_start")
    public int getPeriodStart() {
        return periodStart;
    }

    @JsonProperty("status")
    public String getStatus() {
        return status;
    }

    @JsonProperty("subscription_external_id")
    public String getSubscriptionExternalId() {
        return subscriptionExternalId;
    }

    @JsonProperty("total_price")
    public int getTotalPrice() {
        return totalPrice;
    }

    @JsonProperty("trial_end")
    public Optional<Integer> getTrialEnd() {
        return trialEnd;
    }

    @JsonProperty("trial_end_setting")
    public Optional<String> getTrialEndSetting() {
        return trialEndSetting;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof BillingSubscriptionResponseData && equalTo((BillingSubscriptionResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BillingSubscriptionResponseData other) {
        return cancelAt.equals(other.cancelAt)
                && cancelAtPeriodEnd == other.cancelAtPeriodEnd
                && companyId.equals(other.companyId)
                && createdAt.equals(other.createdAt)
                && currency.equals(other.currency)
                && customerExternalId.equals(other.customerExternalId)
                && defaultPaymentMethodId.equals(other.defaultPaymentMethodId)
                && expiredAt.equals(other.expiredAt)
                && id.equals(other.id)
                && interval.equals(other.interval)
                && metadata.equals(other.metadata)
                && periodEnd == other.periodEnd
                && periodStart == other.periodStart
                && status.equals(other.status)
                && subscriptionExternalId.equals(other.subscriptionExternalId)
                && totalPrice == other.totalPrice
                && trialEnd.equals(other.trialEnd)
                && trialEndSetting.equals(other.trialEndSetting);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.cancelAt,
                this.cancelAtPeriodEnd,
                this.companyId,
                this.createdAt,
                this.currency,
                this.customerExternalId,
                this.defaultPaymentMethodId,
                this.expiredAt,
                this.id,
                this.interval,
                this.metadata,
                this.periodEnd,
                this.periodStart,
                this.status,
                this.subscriptionExternalId,
                this.totalPrice,
                this.trialEnd,
                this.trialEndSetting);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CancelAtPeriodEndStage builder() {
        return new Builder();
    }

    public interface CancelAtPeriodEndStage {
        CreatedAtStage cancelAtPeriodEnd(boolean cancelAtPeriodEnd);

        Builder from(BillingSubscriptionResponseData other);
    }

    public interface CreatedAtStage {
        CurrencyStage createdAt(@NotNull OffsetDateTime createdAt);
    }

    public interface CurrencyStage {
        CustomerExternalIdStage currency(@NotNull String currency);
    }

    public interface CustomerExternalIdStage {
        IdStage customerExternalId(@NotNull String customerExternalId);
    }

    public interface IdStage {
        IntervalStage id(@NotNull String id);
    }

    public interface IntervalStage {
        PeriodEndStage interval(@NotNull String interval);
    }

    public interface PeriodEndStage {
        PeriodStartStage periodEnd(int periodEnd);
    }

    public interface PeriodStartStage {
        StatusStage periodStart(int periodStart);
    }

    public interface StatusStage {
        SubscriptionExternalIdStage status(@NotNull String status);
    }

    public interface SubscriptionExternalIdStage {
        TotalPriceStage subscriptionExternalId(@NotNull String subscriptionExternalId);
    }

    public interface TotalPriceStage {
        _FinalStage totalPrice(int totalPrice);
    }

    public interface _FinalStage {
        BillingSubscriptionResponseData build();

        _FinalStage cancelAt(Optional<Integer> cancelAt);

        _FinalStage cancelAt(Integer cancelAt);

        _FinalStage companyId(Optional<String> companyId);

        _FinalStage companyId(String companyId);

        _FinalStage defaultPaymentMethodId(Optional<String> defaultPaymentMethodId);

        _FinalStage defaultPaymentMethodId(String defaultPaymentMethodId);

        _FinalStage expiredAt(Optional<OffsetDateTime> expiredAt);

        _FinalStage expiredAt(OffsetDateTime expiredAt);

        _FinalStage metadata(Optional<Map<String, JsonNode>> metadata);

        _FinalStage metadata(Map<String, JsonNode> metadata);

        _FinalStage trialEnd(Optional<Integer> trialEnd);

        _FinalStage trialEnd(Integer trialEnd);

        _FinalStage trialEndSetting(Optional<String> trialEndSetting);

        _FinalStage trialEndSetting(String trialEndSetting);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements CancelAtPeriodEndStage,
                    CreatedAtStage,
                    CurrencyStage,
                    CustomerExternalIdStage,
                    IdStage,
                    IntervalStage,
                    PeriodEndStage,
                    PeriodStartStage,
                    StatusStage,
                    SubscriptionExternalIdStage,
                    TotalPriceStage,
                    _FinalStage {
        private boolean cancelAtPeriodEnd;

        private OffsetDateTime createdAt;

        private String currency;

        private String customerExternalId;

        private String id;

        private String interval;

        private int periodEnd;

        private int periodStart;

        private String status;

        private String subscriptionExternalId;

        private int totalPrice;

        private Optional<String> trialEndSetting = Optional.empty();

        private Optional<Integer> trialEnd = Optional.empty();

        private Optional<Map<String, JsonNode>> metadata = Optional.empty();

        private Optional<OffsetDateTime> expiredAt = Optional.empty();

        private Optional<String> defaultPaymentMethodId = Optional.empty();

        private Optional<String> companyId = Optional.empty();

        private Optional<Integer> cancelAt = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(BillingSubscriptionResponseData other) {
            cancelAt(other.getCancelAt());
            cancelAtPeriodEnd(other.getCancelAtPeriodEnd());
            companyId(other.getCompanyId());
            createdAt(other.getCreatedAt());
            currency(other.getCurrency());
            customerExternalId(other.getCustomerExternalId());
            defaultPaymentMethodId(other.getDefaultPaymentMethodId());
            expiredAt(other.getExpiredAt());
            id(other.getId());
            interval(other.getInterval());
            metadata(other.getMetadata());
            periodEnd(other.getPeriodEnd());
            periodStart(other.getPeriodStart());
            status(other.getStatus());
            subscriptionExternalId(other.getSubscriptionExternalId());
            totalPrice(other.getTotalPrice());
            trialEnd(other.getTrialEnd());
            trialEndSetting(other.getTrialEndSetting());
            return this;
        }

        @java.lang.Override
        @JsonSetter("cancel_at_period_end")
        public CreatedAtStage cancelAtPeriodEnd(boolean cancelAtPeriodEnd) {
            this.cancelAtPeriodEnd = cancelAtPeriodEnd;
            return this;
        }

        @java.lang.Override
        @JsonSetter("created_at")
        public CurrencyStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("currency")
        public CustomerExternalIdStage currency(@NotNull String currency) {
            this.currency = Objects.requireNonNull(currency, "currency must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("customer_external_id")
        public IdStage customerExternalId(@NotNull String customerExternalId) {
            this.customerExternalId = Objects.requireNonNull(customerExternalId, "customerExternalId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("id")
        public IntervalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("interval")
        public PeriodEndStage interval(@NotNull String interval) {
            this.interval = Objects.requireNonNull(interval, "interval must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("period_end")
        public PeriodStartStage periodEnd(int periodEnd) {
            this.periodEnd = periodEnd;
            return this;
        }

        @java.lang.Override
        @JsonSetter("period_start")
        public StatusStage periodStart(int periodStart) {
            this.periodStart = periodStart;
            return this;
        }

        @java.lang.Override
        @JsonSetter("status")
        public SubscriptionExternalIdStage status(@NotNull String status) {
            this.status = Objects.requireNonNull(status, "status must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("subscription_external_id")
        public TotalPriceStage subscriptionExternalId(@NotNull String subscriptionExternalId) {
            this.subscriptionExternalId =
                    Objects.requireNonNull(subscriptionExternalId, "subscriptionExternalId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("total_price")
        public _FinalStage totalPrice(int totalPrice) {
            this.totalPrice = totalPrice;
            return this;
        }

        @java.lang.Override
        public _FinalStage trialEndSetting(String trialEndSetting) {
            this.trialEndSetting = Optional.ofNullable(trialEndSetting);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "trial_end_setting", nulls = Nulls.SKIP)
        public _FinalStage trialEndSetting(Optional<String> trialEndSetting) {
            this.trialEndSetting = trialEndSetting;
            return this;
        }

        @java.lang.Override
        public _FinalStage trialEnd(Integer trialEnd) {
            this.trialEnd = Optional.ofNullable(trialEnd);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "trial_end", nulls = Nulls.SKIP)
        public _FinalStage trialEnd(Optional<Integer> trialEnd) {
            this.trialEnd = trialEnd;
            return this;
        }

        @java.lang.Override
        public _FinalStage metadata(Map<String, JsonNode> metadata) {
            this.metadata = Optional.ofNullable(metadata);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "metadata", nulls = Nulls.SKIP)
        public _FinalStage metadata(Optional<Map<String, JsonNode>> metadata) {
            this.metadata = metadata;
            return this;
        }

        @java.lang.Override
        public _FinalStage expiredAt(OffsetDateTime expiredAt) {
            this.expiredAt = Optional.ofNullable(expiredAt);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "expired_at", nulls = Nulls.SKIP)
        public _FinalStage expiredAt(Optional<OffsetDateTime> expiredAt) {
            this.expiredAt = expiredAt;
            return this;
        }

        @java.lang.Override
        public _FinalStage defaultPaymentMethodId(String defaultPaymentMethodId) {
            this.defaultPaymentMethodId = Optional.ofNullable(defaultPaymentMethodId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "default_payment_method_id", nulls = Nulls.SKIP)
        public _FinalStage defaultPaymentMethodId(Optional<String> defaultPaymentMethodId) {
            this.defaultPaymentMethodId = defaultPaymentMethodId;
            return this;
        }

        @java.lang.Override
        public _FinalStage companyId(String companyId) {
            this.companyId = Optional.ofNullable(companyId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "company_id", nulls = Nulls.SKIP)
        public _FinalStage companyId(Optional<String> companyId) {
            this.companyId = companyId;
            return this;
        }

        @java.lang.Override
        public _FinalStage cancelAt(Integer cancelAt) {
            this.cancelAt = Optional.ofNullable(cancelAt);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "cancel_at", nulls = Nulls.SKIP)
        public _FinalStage cancelAt(Optional<Integer> cancelAt) {
            this.cancelAt = cancelAt;
            return this;
        }

        @java.lang.Override
        public BillingSubscriptionResponseData build() {
            return new BillingSubscriptionResponseData(
                    cancelAt,
                    cancelAtPeriodEnd,
                    companyId,
                    createdAt,
                    currency,
                    customerExternalId,
                    defaultPaymentMethodId,
                    expiredAt,
                    id,
                    interval,
                    metadata,
                    periodEnd,
                    periodStart,
                    status,
                    subscriptionExternalId,
                    totalPrice,
                    trialEnd,
                    trialEndSetting,
                    additionalProperties);
        }
    }
}
