/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CompanyDetailResponseData.Builder.class)
public final class CompanyDetailResponseData {
    private final List<CompanyPlanWithBillingSubView> addOns;

    private final Optional<Map<String, Double>> billingCreditBalances;

    private final Optional<BillingSubscriptionView> billingSubscription;

    private final List<BillingSubscriptionView> billingSubscriptions;

    private final OffsetDateTime createdAt;

    private final Optional<PaymentMethodResponseData> defaultPaymentMethod;

    private final List<EntityTraitDetailResponseData> entityTraits;

    private final String environmentId;

    private final String id;

    private final List<EntityKeyDetailResponseData> keys;

    private final Optional<OffsetDateTime> lastSeenAt;

    private final Optional<String> logoUrl;

    private final List<CompanyEventPeriodMetricsResponseData> metrics;

    private final String name;

    private final List<PaymentMethodResponseData> paymentMethods;

    private final Optional<CompanyPlanWithBillingSubView> plan;

    private final List<GenericPreviewObject> plans;

    private final List<Rule> rules;

    private final Optional<Map<String, JsonNode>> traits;

    private final OffsetDateTime updatedAt;

    private final int userCount;

    private final Map<String, Object> additionalProperties;

    private CompanyDetailResponseData(
            List<CompanyPlanWithBillingSubView> addOns,
            Optional<Map<String, Double>> billingCreditBalances,
            Optional<BillingSubscriptionView> billingSubscription,
            List<BillingSubscriptionView> billingSubscriptions,
            OffsetDateTime createdAt,
            Optional<PaymentMethodResponseData> defaultPaymentMethod,
            List<EntityTraitDetailResponseData> entityTraits,
            String environmentId,
            String id,
            List<EntityKeyDetailResponseData> keys,
            Optional<OffsetDateTime> lastSeenAt,
            Optional<String> logoUrl,
            List<CompanyEventPeriodMetricsResponseData> metrics,
            String name,
            List<PaymentMethodResponseData> paymentMethods,
            Optional<CompanyPlanWithBillingSubView> plan,
            List<GenericPreviewObject> plans,
            List<Rule> rules,
            Optional<Map<String, JsonNode>> traits,
            OffsetDateTime updatedAt,
            int userCount,
            Map<String, Object> additionalProperties) {
        this.addOns = addOns;
        this.billingCreditBalances = billingCreditBalances;
        this.billingSubscription = billingSubscription;
        this.billingSubscriptions = billingSubscriptions;
        this.createdAt = createdAt;
        this.defaultPaymentMethod = defaultPaymentMethod;
        this.entityTraits = entityTraits;
        this.environmentId = environmentId;
        this.id = id;
        this.keys = keys;
        this.lastSeenAt = lastSeenAt;
        this.logoUrl = logoUrl;
        this.metrics = metrics;
        this.name = name;
        this.paymentMethods = paymentMethods;
        this.plan = plan;
        this.plans = plans;
        this.rules = rules;
        this.traits = traits;
        this.updatedAt = updatedAt;
        this.userCount = userCount;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("add_ons")
    public List<CompanyPlanWithBillingSubView> getAddOns() {
        return addOns;
    }

    @JsonProperty("billing_credit_balances")
    public Optional<Map<String, Double>> getBillingCreditBalances() {
        return billingCreditBalances;
    }

    @JsonProperty("billing_subscription")
    public Optional<BillingSubscriptionView> getBillingSubscription() {
        return billingSubscription;
    }

    @JsonProperty("billing_subscriptions")
    public List<BillingSubscriptionView> getBillingSubscriptions() {
        return billingSubscriptions;
    }

    @JsonProperty("created_at")
    public OffsetDateTime getCreatedAt() {
        return createdAt;
    }

    @JsonProperty("default_payment_method")
    public Optional<PaymentMethodResponseData> getDefaultPaymentMethod() {
        return defaultPaymentMethod;
    }

    @JsonProperty("entity_traits")
    public List<EntityTraitDetailResponseData> getEntityTraits() {
        return entityTraits;
    }

    @JsonProperty("environment_id")
    public String getEnvironmentId() {
        return environmentId;
    }

    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @JsonProperty("keys")
    public List<EntityKeyDetailResponseData> getKeys() {
        return keys;
    }

    @JsonProperty("last_seen_at")
    public Optional<OffsetDateTime> getLastSeenAt() {
        return lastSeenAt;
    }

    @JsonProperty("logo_url")
    public Optional<String> getLogoUrl() {
        return logoUrl;
    }

    @JsonProperty("metrics")
    public List<CompanyEventPeriodMetricsResponseData> getMetrics() {
        return metrics;
    }

    @JsonProperty("name")
    public String getName() {
        return name;
    }

    @JsonProperty("payment_methods")
    public List<PaymentMethodResponseData> getPaymentMethods() {
        return paymentMethods;
    }

    @JsonProperty("plan")
    public Optional<CompanyPlanWithBillingSubView> getPlan() {
        return plan;
    }

    @JsonProperty("plans")
    public List<GenericPreviewObject> getPlans() {
        return plans;
    }

    @JsonProperty("rules")
    public List<Rule> getRules() {
        return rules;
    }

    /**
     * @return A map of trait names to trait values
     */
    @JsonProperty("traits")
    public Optional<Map<String, JsonNode>> getTraits() {
        return traits;
    }

    @JsonProperty("updated_at")
    public OffsetDateTime getUpdatedAt() {
        return updatedAt;
    }

    @JsonProperty("user_count")
    public int getUserCount() {
        return userCount;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CompanyDetailResponseData && equalTo((CompanyDetailResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CompanyDetailResponseData other) {
        return addOns.equals(other.addOns)
                && billingCreditBalances.equals(other.billingCreditBalances)
                && billingSubscription.equals(other.billingSubscription)
                && billingSubscriptions.equals(other.billingSubscriptions)
                && createdAt.equals(other.createdAt)
                && defaultPaymentMethod.equals(other.defaultPaymentMethod)
                && entityTraits.equals(other.entityTraits)
                && environmentId.equals(other.environmentId)
                && id.equals(other.id)
                && keys.equals(other.keys)
                && lastSeenAt.equals(other.lastSeenAt)
                && logoUrl.equals(other.logoUrl)
                && metrics.equals(other.metrics)
                && name.equals(other.name)
                && paymentMethods.equals(other.paymentMethods)
                && plan.equals(other.plan)
                && plans.equals(other.plans)
                && rules.equals(other.rules)
                && traits.equals(other.traits)
                && updatedAt.equals(other.updatedAt)
                && userCount == other.userCount;
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.addOns,
                this.billingCreditBalances,
                this.billingSubscription,
                this.billingSubscriptions,
                this.createdAt,
                this.defaultPaymentMethod,
                this.entityTraits,
                this.environmentId,
                this.id,
                this.keys,
                this.lastSeenAt,
                this.logoUrl,
                this.metrics,
                this.name,
                this.paymentMethods,
                this.plan,
                this.plans,
                this.rules,
                this.traits,
                this.updatedAt,
                this.userCount);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CreatedAtStage builder() {
        return new Builder();
    }

    public interface CreatedAtStage {
        EnvironmentIdStage createdAt(@NotNull OffsetDateTime createdAt);

        Builder from(CompanyDetailResponseData other);
    }

    public interface EnvironmentIdStage {
        IdStage environmentId(@NotNull String environmentId);
    }

    public interface IdStage {
        NameStage id(@NotNull String id);
    }

    public interface NameStage {
        UpdatedAtStage name(@NotNull String name);
    }

    public interface UpdatedAtStage {
        UserCountStage updatedAt(@NotNull OffsetDateTime updatedAt);
    }

    public interface UserCountStage {
        _FinalStage userCount(int userCount);
    }

    public interface _FinalStage {
        CompanyDetailResponseData build();

        _FinalStage addOns(List<CompanyPlanWithBillingSubView> addOns);

        _FinalStage addAddOns(CompanyPlanWithBillingSubView addOns);

        _FinalStage addAllAddOns(List<CompanyPlanWithBillingSubView> addOns);

        _FinalStage billingCreditBalances(Optional<Map<String, Double>> billingCreditBalances);

        _FinalStage billingCreditBalances(Map<String, Double> billingCreditBalances);

        _FinalStage billingSubscription(Optional<BillingSubscriptionView> billingSubscription);

        _FinalStage billingSubscription(BillingSubscriptionView billingSubscription);

        _FinalStage billingSubscriptions(List<BillingSubscriptionView> billingSubscriptions);

        _FinalStage addBillingSubscriptions(BillingSubscriptionView billingSubscriptions);

        _FinalStage addAllBillingSubscriptions(List<BillingSubscriptionView> billingSubscriptions);

        _FinalStage defaultPaymentMethod(Optional<PaymentMethodResponseData> defaultPaymentMethod);

        _FinalStage defaultPaymentMethod(PaymentMethodResponseData defaultPaymentMethod);

        _FinalStage entityTraits(List<EntityTraitDetailResponseData> entityTraits);

        _FinalStage addEntityTraits(EntityTraitDetailResponseData entityTraits);

        _FinalStage addAllEntityTraits(List<EntityTraitDetailResponseData> entityTraits);

        _FinalStage keys(List<EntityKeyDetailResponseData> keys);

        _FinalStage addKeys(EntityKeyDetailResponseData keys);

        _FinalStage addAllKeys(List<EntityKeyDetailResponseData> keys);

        _FinalStage lastSeenAt(Optional<OffsetDateTime> lastSeenAt);

        _FinalStage lastSeenAt(OffsetDateTime lastSeenAt);

        _FinalStage logoUrl(Optional<String> logoUrl);

        _FinalStage logoUrl(String logoUrl);

        _FinalStage metrics(List<CompanyEventPeriodMetricsResponseData> metrics);

        _FinalStage addMetrics(CompanyEventPeriodMetricsResponseData metrics);

        _FinalStage addAllMetrics(List<CompanyEventPeriodMetricsResponseData> metrics);

        _FinalStage paymentMethods(List<PaymentMethodResponseData> paymentMethods);

        _FinalStage addPaymentMethods(PaymentMethodResponseData paymentMethods);

        _FinalStage addAllPaymentMethods(List<PaymentMethodResponseData> paymentMethods);

        _FinalStage plan(Optional<CompanyPlanWithBillingSubView> plan);

        _FinalStage plan(CompanyPlanWithBillingSubView plan);

        _FinalStage plans(List<GenericPreviewObject> plans);

        _FinalStage addPlans(GenericPreviewObject plans);

        _FinalStage addAllPlans(List<GenericPreviewObject> plans);

        _FinalStage rules(List<Rule> rules);

        _FinalStage addRules(Rule rules);

        _FinalStage addAllRules(List<Rule> rules);

        /**
         * <p>A map of trait names to trait values</p>
         */
        _FinalStage traits(Optional<Map<String, JsonNode>> traits);

        _FinalStage traits(Map<String, JsonNode> traits);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements CreatedAtStage,
                    EnvironmentIdStage,
                    IdStage,
                    NameStage,
                    UpdatedAtStage,
                    UserCountStage,
                    _FinalStage {
        private OffsetDateTime createdAt;

        private String environmentId;

        private String id;

        private String name;

        private OffsetDateTime updatedAt;

        private int userCount;

        private Optional<Map<String, JsonNode>> traits = Optional.empty();

        private List<Rule> rules = new ArrayList<>();

        private List<GenericPreviewObject> plans = new ArrayList<>();

        private Optional<CompanyPlanWithBillingSubView> plan = Optional.empty();

        private List<PaymentMethodResponseData> paymentMethods = new ArrayList<>();

        private List<CompanyEventPeriodMetricsResponseData> metrics = new ArrayList<>();

        private Optional<String> logoUrl = Optional.empty();

        private Optional<OffsetDateTime> lastSeenAt = Optional.empty();

        private List<EntityKeyDetailResponseData> keys = new ArrayList<>();

        private List<EntityTraitDetailResponseData> entityTraits = new ArrayList<>();

        private Optional<PaymentMethodResponseData> defaultPaymentMethod = Optional.empty();

        private List<BillingSubscriptionView> billingSubscriptions = new ArrayList<>();

        private Optional<BillingSubscriptionView> billingSubscription = Optional.empty();

        private Optional<Map<String, Double>> billingCreditBalances = Optional.empty();

        private List<CompanyPlanWithBillingSubView> addOns = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CompanyDetailResponseData other) {
            addOns(other.getAddOns());
            billingCreditBalances(other.getBillingCreditBalances());
            billingSubscription(other.getBillingSubscription());
            billingSubscriptions(other.getBillingSubscriptions());
            createdAt(other.getCreatedAt());
            defaultPaymentMethod(other.getDefaultPaymentMethod());
            entityTraits(other.getEntityTraits());
            environmentId(other.getEnvironmentId());
            id(other.getId());
            keys(other.getKeys());
            lastSeenAt(other.getLastSeenAt());
            logoUrl(other.getLogoUrl());
            metrics(other.getMetrics());
            name(other.getName());
            paymentMethods(other.getPaymentMethods());
            plan(other.getPlan());
            plans(other.getPlans());
            rules(other.getRules());
            traits(other.getTraits());
            updatedAt(other.getUpdatedAt());
            userCount(other.getUserCount());
            return this;
        }

        @java.lang.Override
        @JsonSetter("created_at")
        public EnvironmentIdStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("environment_id")
        public IdStage environmentId(@NotNull String environmentId) {
            this.environmentId = Objects.requireNonNull(environmentId, "environmentId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("name")
        public UpdatedAtStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("updated_at")
        public UserCountStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("user_count")
        public _FinalStage userCount(int userCount) {
            this.userCount = userCount;
            return this;
        }

        /**
         * <p>A map of trait names to trait values</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage traits(Map<String, JsonNode> traits) {
            this.traits = Optional.ofNullable(traits);
            return this;
        }

        /**
         * <p>A map of trait names to trait values</p>
         */
        @java.lang.Override
        @JsonSetter(value = "traits", nulls = Nulls.SKIP)
        public _FinalStage traits(Optional<Map<String, JsonNode>> traits) {
            this.traits = traits;
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllRules(List<Rule> rules) {
            if (rules != null) {
                this.rules.addAll(rules);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addRules(Rule rules) {
            this.rules.add(rules);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "rules", nulls = Nulls.SKIP)
        public _FinalStage rules(List<Rule> rules) {
            this.rules.clear();
            if (rules != null) {
                this.rules.addAll(rules);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllPlans(List<GenericPreviewObject> plans) {
            if (plans != null) {
                this.plans.addAll(plans);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addPlans(GenericPreviewObject plans) {
            this.plans.add(plans);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "plans", nulls = Nulls.SKIP)
        public _FinalStage plans(List<GenericPreviewObject> plans) {
            this.plans.clear();
            if (plans != null) {
                this.plans.addAll(plans);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage plan(CompanyPlanWithBillingSubView plan) {
            this.plan = Optional.ofNullable(plan);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "plan", nulls = Nulls.SKIP)
        public _FinalStage plan(Optional<CompanyPlanWithBillingSubView> plan) {
            this.plan = plan;
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllPaymentMethods(List<PaymentMethodResponseData> paymentMethods) {
            if (paymentMethods != null) {
                this.paymentMethods.addAll(paymentMethods);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addPaymentMethods(PaymentMethodResponseData paymentMethods) {
            this.paymentMethods.add(paymentMethods);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "payment_methods", nulls = Nulls.SKIP)
        public _FinalStage paymentMethods(List<PaymentMethodResponseData> paymentMethods) {
            this.paymentMethods.clear();
            if (paymentMethods != null) {
                this.paymentMethods.addAll(paymentMethods);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllMetrics(List<CompanyEventPeriodMetricsResponseData> metrics) {
            if (metrics != null) {
                this.metrics.addAll(metrics);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addMetrics(CompanyEventPeriodMetricsResponseData metrics) {
            this.metrics.add(metrics);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "metrics", nulls = Nulls.SKIP)
        public _FinalStage metrics(List<CompanyEventPeriodMetricsResponseData> metrics) {
            this.metrics.clear();
            if (metrics != null) {
                this.metrics.addAll(metrics);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage logoUrl(String logoUrl) {
            this.logoUrl = Optional.ofNullable(logoUrl);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "logo_url", nulls = Nulls.SKIP)
        public _FinalStage logoUrl(Optional<String> logoUrl) {
            this.logoUrl = logoUrl;
            return this;
        }

        @java.lang.Override
        public _FinalStage lastSeenAt(OffsetDateTime lastSeenAt) {
            this.lastSeenAt = Optional.ofNullable(lastSeenAt);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "last_seen_at", nulls = Nulls.SKIP)
        public _FinalStage lastSeenAt(Optional<OffsetDateTime> lastSeenAt) {
            this.lastSeenAt = lastSeenAt;
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllKeys(List<EntityKeyDetailResponseData> keys) {
            if (keys != null) {
                this.keys.addAll(keys);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addKeys(EntityKeyDetailResponseData keys) {
            this.keys.add(keys);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "keys", nulls = Nulls.SKIP)
        public _FinalStage keys(List<EntityKeyDetailResponseData> keys) {
            this.keys.clear();
            if (keys != null) {
                this.keys.addAll(keys);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllEntityTraits(List<EntityTraitDetailResponseData> entityTraits) {
            if (entityTraits != null) {
                this.entityTraits.addAll(entityTraits);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addEntityTraits(EntityTraitDetailResponseData entityTraits) {
            this.entityTraits.add(entityTraits);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "entity_traits", nulls = Nulls.SKIP)
        public _FinalStage entityTraits(List<EntityTraitDetailResponseData> entityTraits) {
            this.entityTraits.clear();
            if (entityTraits != null) {
                this.entityTraits.addAll(entityTraits);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage defaultPaymentMethod(PaymentMethodResponseData defaultPaymentMethod) {
            this.defaultPaymentMethod = Optional.ofNullable(defaultPaymentMethod);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "default_payment_method", nulls = Nulls.SKIP)
        public _FinalStage defaultPaymentMethod(Optional<PaymentMethodResponseData> defaultPaymentMethod) {
            this.defaultPaymentMethod = defaultPaymentMethod;
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllBillingSubscriptions(List<BillingSubscriptionView> billingSubscriptions) {
            if (billingSubscriptions != null) {
                this.billingSubscriptions.addAll(billingSubscriptions);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addBillingSubscriptions(BillingSubscriptionView billingSubscriptions) {
            this.billingSubscriptions.add(billingSubscriptions);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "billing_subscriptions", nulls = Nulls.SKIP)
        public _FinalStage billingSubscriptions(List<BillingSubscriptionView> billingSubscriptions) {
            this.billingSubscriptions.clear();
            if (billingSubscriptions != null) {
                this.billingSubscriptions.addAll(billingSubscriptions);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage billingSubscription(BillingSubscriptionView billingSubscription) {
            this.billingSubscription = Optional.ofNullable(billingSubscription);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "billing_subscription", nulls = Nulls.SKIP)
        public _FinalStage billingSubscription(Optional<BillingSubscriptionView> billingSubscription) {
            this.billingSubscription = billingSubscription;
            return this;
        }

        @java.lang.Override
        public _FinalStage billingCreditBalances(Map<String, Double> billingCreditBalances) {
            this.billingCreditBalances = Optional.ofNullable(billingCreditBalances);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "billing_credit_balances", nulls = Nulls.SKIP)
        public _FinalStage billingCreditBalances(Optional<Map<String, Double>> billingCreditBalances) {
            this.billingCreditBalances = billingCreditBalances;
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllAddOns(List<CompanyPlanWithBillingSubView> addOns) {
            if (addOns != null) {
                this.addOns.addAll(addOns);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addAddOns(CompanyPlanWithBillingSubView addOns) {
            this.addOns.add(addOns);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "add_ons", nulls = Nulls.SKIP)
        public _FinalStage addOns(List<CompanyPlanWithBillingSubView> addOns) {
            this.addOns.clear();
            if (addOns != null) {
                this.addOns.addAll(addOns);
            }
            return this;
        }

        @java.lang.Override
        public CompanyDetailResponseData build() {
            return new CompanyDetailResponseData(
                    addOns,
                    billingCreditBalances,
                    billingSubscription,
                    billingSubscriptions,
                    createdAt,
                    defaultPaymentMethod,
                    entityTraits,
                    environmentId,
                    id,
                    keys,
                    lastSeenAt,
                    logoUrl,
                    metrics,
                    name,
                    paymentMethods,
                    plan,
                    plans,
                    rules,
                    traits,
                    updatedAt,
                    userCount,
                    additionalProperties);
        }
    }
}
