/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ComponentPreviewResponseData.Builder.class)
public final class ComponentPreviewResponseData {
    private final List<CompanyPlanDetailResponseData> activeAddOns;

    private final List<CompanyPlanDetailResponseData> activePlans;

    private final List<UsageBasedEntitlementResponseData> activeUsageBasedEntitlements;

    private final List<CompatiblePlans> addOnCompatibilities;

    private final Optional<ComponentCapabilities> capabilities;

    private final ComponentCheckoutSettings checkoutSettings;

    private final Optional<CompanyDetailResponseData> company;

    private final Optional<ComponentResponseData> component;

    private final List<BillingCreditBundleView> creditBundles;

    private final List<CreditCompanyGrantView> creditGrants;

    private final Optional<PlanDetailResponseData> defaultPlan;

    private final Optional<FeatureUsageDetailResponseData> featureUsage;

    private final List<InvoiceResponseData> invoices;

    private final Optional<PlanDetailResponseData> postTrialPlan;

    private final boolean showCredits;

    private final boolean showPeriodToggle;

    private final boolean showZeroPriceAsFree;

    private final Optional<StripeEmbedInfo> stripeEmbed;

    private final Optional<CompanySubscriptionResponseData> subscription;

    private final Optional<Boolean> trialPaymentMethodRequired;

    private final Optional<InvoiceResponseData> upcomingInvoice;

    private final Map<String, Object> additionalProperties;

    private ComponentPreviewResponseData(
            List<CompanyPlanDetailResponseData> activeAddOns,
            List<CompanyPlanDetailResponseData> activePlans,
            List<UsageBasedEntitlementResponseData> activeUsageBasedEntitlements,
            List<CompatiblePlans> addOnCompatibilities,
            Optional<ComponentCapabilities> capabilities,
            ComponentCheckoutSettings checkoutSettings,
            Optional<CompanyDetailResponseData> company,
            Optional<ComponentResponseData> component,
            List<BillingCreditBundleView> creditBundles,
            List<CreditCompanyGrantView> creditGrants,
            Optional<PlanDetailResponseData> defaultPlan,
            Optional<FeatureUsageDetailResponseData> featureUsage,
            List<InvoiceResponseData> invoices,
            Optional<PlanDetailResponseData> postTrialPlan,
            boolean showCredits,
            boolean showPeriodToggle,
            boolean showZeroPriceAsFree,
            Optional<StripeEmbedInfo> stripeEmbed,
            Optional<CompanySubscriptionResponseData> subscription,
            Optional<Boolean> trialPaymentMethodRequired,
            Optional<InvoiceResponseData> upcomingInvoice,
            Map<String, Object> additionalProperties) {
        this.activeAddOns = activeAddOns;
        this.activePlans = activePlans;
        this.activeUsageBasedEntitlements = activeUsageBasedEntitlements;
        this.addOnCompatibilities = addOnCompatibilities;
        this.capabilities = capabilities;
        this.checkoutSettings = checkoutSettings;
        this.company = company;
        this.component = component;
        this.creditBundles = creditBundles;
        this.creditGrants = creditGrants;
        this.defaultPlan = defaultPlan;
        this.featureUsage = featureUsage;
        this.invoices = invoices;
        this.postTrialPlan = postTrialPlan;
        this.showCredits = showCredits;
        this.showPeriodToggle = showPeriodToggle;
        this.showZeroPriceAsFree = showZeroPriceAsFree;
        this.stripeEmbed = stripeEmbed;
        this.subscription = subscription;
        this.trialPaymentMethodRequired = trialPaymentMethodRequired;
        this.upcomingInvoice = upcomingInvoice;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("active_add_ons")
    public List<CompanyPlanDetailResponseData> getActiveAddOns() {
        return activeAddOns;
    }

    @JsonProperty("active_plans")
    public List<CompanyPlanDetailResponseData> getActivePlans() {
        return activePlans;
    }

    @JsonProperty("active_usage_based_entitlements")
    public List<UsageBasedEntitlementResponseData> getActiveUsageBasedEntitlements() {
        return activeUsageBasedEntitlements;
    }

    @JsonProperty("add_on_compatibilities")
    public List<CompatiblePlans> getAddOnCompatibilities() {
        return addOnCompatibilities;
    }

    @JsonProperty("capabilities")
    public Optional<ComponentCapabilities> getCapabilities() {
        return capabilities;
    }

    @JsonProperty("checkout_settings")
    public ComponentCheckoutSettings getCheckoutSettings() {
        return checkoutSettings;
    }

    @JsonProperty("company")
    public Optional<CompanyDetailResponseData> getCompany() {
        return company;
    }

    @JsonProperty("component")
    public Optional<ComponentResponseData> getComponent() {
        return component;
    }

    @JsonProperty("credit_bundles")
    public List<BillingCreditBundleView> getCreditBundles() {
        return creditBundles;
    }

    @JsonProperty("credit_grants")
    public List<CreditCompanyGrantView> getCreditGrants() {
        return creditGrants;
    }

    @JsonProperty("default_plan")
    public Optional<PlanDetailResponseData> getDefaultPlan() {
        return defaultPlan;
    }

    @JsonProperty("feature_usage")
    public Optional<FeatureUsageDetailResponseData> getFeatureUsage() {
        return featureUsage;
    }

    @JsonProperty("invoices")
    public List<InvoiceResponseData> getInvoices() {
        return invoices;
    }

    @JsonProperty("post_trial_plan")
    public Optional<PlanDetailResponseData> getPostTrialPlan() {
        return postTrialPlan;
    }

    @JsonProperty("show_credits")
    public boolean getShowCredits() {
        return showCredits;
    }

    @JsonProperty("show_period_toggle")
    public boolean getShowPeriodToggle() {
        return showPeriodToggle;
    }

    @JsonProperty("show_zero_price_as_free")
    public boolean getShowZeroPriceAsFree() {
        return showZeroPriceAsFree;
    }

    @JsonProperty("stripe_embed")
    public Optional<StripeEmbedInfo> getStripeEmbed() {
        return stripeEmbed;
    }

    @JsonProperty("subscription")
    public Optional<CompanySubscriptionResponseData> getSubscription() {
        return subscription;
    }

    @JsonProperty("trial_payment_method_required")
    public Optional<Boolean> getTrialPaymentMethodRequired() {
        return trialPaymentMethodRequired;
    }

    @JsonProperty("upcoming_invoice")
    public Optional<InvoiceResponseData> getUpcomingInvoice() {
        return upcomingInvoice;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ComponentPreviewResponseData && equalTo((ComponentPreviewResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ComponentPreviewResponseData other) {
        return activeAddOns.equals(other.activeAddOns)
                && activePlans.equals(other.activePlans)
                && activeUsageBasedEntitlements.equals(other.activeUsageBasedEntitlements)
                && addOnCompatibilities.equals(other.addOnCompatibilities)
                && capabilities.equals(other.capabilities)
                && checkoutSettings.equals(other.checkoutSettings)
                && company.equals(other.company)
                && component.equals(other.component)
                && creditBundles.equals(other.creditBundles)
                && creditGrants.equals(other.creditGrants)
                && defaultPlan.equals(other.defaultPlan)
                && featureUsage.equals(other.featureUsage)
                && invoices.equals(other.invoices)
                && postTrialPlan.equals(other.postTrialPlan)
                && showCredits == other.showCredits
                && showPeriodToggle == other.showPeriodToggle
                && showZeroPriceAsFree == other.showZeroPriceAsFree
                && stripeEmbed.equals(other.stripeEmbed)
                && subscription.equals(other.subscription)
                && trialPaymentMethodRequired.equals(other.trialPaymentMethodRequired)
                && upcomingInvoice.equals(other.upcomingInvoice);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.activeAddOns,
                this.activePlans,
                this.activeUsageBasedEntitlements,
                this.addOnCompatibilities,
                this.capabilities,
                this.checkoutSettings,
                this.company,
                this.component,
                this.creditBundles,
                this.creditGrants,
                this.defaultPlan,
                this.featureUsage,
                this.invoices,
                this.postTrialPlan,
                this.showCredits,
                this.showPeriodToggle,
                this.showZeroPriceAsFree,
                this.stripeEmbed,
                this.subscription,
                this.trialPaymentMethodRequired,
                this.upcomingInvoice);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CheckoutSettingsStage builder() {
        return new Builder();
    }

    public interface CheckoutSettingsStage {
        ShowCreditsStage checkoutSettings(@NotNull ComponentCheckoutSettings checkoutSettings);

        Builder from(ComponentPreviewResponseData other);
    }

    public interface ShowCreditsStage {
        ShowPeriodToggleStage showCredits(boolean showCredits);
    }

    public interface ShowPeriodToggleStage {
        ShowZeroPriceAsFreeStage showPeriodToggle(boolean showPeriodToggle);
    }

    public interface ShowZeroPriceAsFreeStage {
        _FinalStage showZeroPriceAsFree(boolean showZeroPriceAsFree);
    }

    public interface _FinalStage {
        ComponentPreviewResponseData build();

        _FinalStage activeAddOns(List<CompanyPlanDetailResponseData> activeAddOns);

        _FinalStage addActiveAddOns(CompanyPlanDetailResponseData activeAddOns);

        _FinalStage addAllActiveAddOns(List<CompanyPlanDetailResponseData> activeAddOns);

        _FinalStage activePlans(List<CompanyPlanDetailResponseData> activePlans);

        _FinalStage addActivePlans(CompanyPlanDetailResponseData activePlans);

        _FinalStage addAllActivePlans(List<CompanyPlanDetailResponseData> activePlans);

        _FinalStage activeUsageBasedEntitlements(List<UsageBasedEntitlementResponseData> activeUsageBasedEntitlements);

        _FinalStage addActiveUsageBasedEntitlements(UsageBasedEntitlementResponseData activeUsageBasedEntitlements);

        _FinalStage addAllActiveUsageBasedEntitlements(
                List<UsageBasedEntitlementResponseData> activeUsageBasedEntitlements);

        _FinalStage addOnCompatibilities(List<CompatiblePlans> addOnCompatibilities);

        _FinalStage addAddOnCompatibilities(CompatiblePlans addOnCompatibilities);

        _FinalStage addAllAddOnCompatibilities(List<CompatiblePlans> addOnCompatibilities);

        _FinalStage capabilities(Optional<ComponentCapabilities> capabilities);

        _FinalStage capabilities(ComponentCapabilities capabilities);

        _FinalStage company(Optional<CompanyDetailResponseData> company);

        _FinalStage company(CompanyDetailResponseData company);

        _FinalStage component(Optional<ComponentResponseData> component);

        _FinalStage component(ComponentResponseData component);

        _FinalStage creditBundles(List<BillingCreditBundleView> creditBundles);

        _FinalStage addCreditBundles(BillingCreditBundleView creditBundles);

        _FinalStage addAllCreditBundles(List<BillingCreditBundleView> creditBundles);

        _FinalStage creditGrants(List<CreditCompanyGrantView> creditGrants);

        _FinalStage addCreditGrants(CreditCompanyGrantView creditGrants);

        _FinalStage addAllCreditGrants(List<CreditCompanyGrantView> creditGrants);

        _FinalStage defaultPlan(Optional<PlanDetailResponseData> defaultPlan);

        _FinalStage defaultPlan(PlanDetailResponseData defaultPlan);

        _FinalStage featureUsage(Optional<FeatureUsageDetailResponseData> featureUsage);

        _FinalStage featureUsage(FeatureUsageDetailResponseData featureUsage);

        _FinalStage invoices(List<InvoiceResponseData> invoices);

        _FinalStage addInvoices(InvoiceResponseData invoices);

        _FinalStage addAllInvoices(List<InvoiceResponseData> invoices);

        _FinalStage postTrialPlan(Optional<PlanDetailResponseData> postTrialPlan);

        _FinalStage postTrialPlan(PlanDetailResponseData postTrialPlan);

        _FinalStage stripeEmbed(Optional<StripeEmbedInfo> stripeEmbed);

        _FinalStage stripeEmbed(StripeEmbedInfo stripeEmbed);

        _FinalStage subscription(Optional<CompanySubscriptionResponseData> subscription);

        _FinalStage subscription(CompanySubscriptionResponseData subscription);

        _FinalStage trialPaymentMethodRequired(Optional<Boolean> trialPaymentMethodRequired);

        _FinalStage trialPaymentMethodRequired(Boolean trialPaymentMethodRequired);

        _FinalStage upcomingInvoice(Optional<InvoiceResponseData> upcomingInvoice);

        _FinalStage upcomingInvoice(InvoiceResponseData upcomingInvoice);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements CheckoutSettingsStage,
                    ShowCreditsStage,
                    ShowPeriodToggleStage,
                    ShowZeroPriceAsFreeStage,
                    _FinalStage {
        private ComponentCheckoutSettings checkoutSettings;

        private boolean showCredits;

        private boolean showPeriodToggle;

        private boolean showZeroPriceAsFree;

        private Optional<InvoiceResponseData> upcomingInvoice = Optional.empty();

        private Optional<Boolean> trialPaymentMethodRequired = Optional.empty();

        private Optional<CompanySubscriptionResponseData> subscription = Optional.empty();

        private Optional<StripeEmbedInfo> stripeEmbed = Optional.empty();

        private Optional<PlanDetailResponseData> postTrialPlan = Optional.empty();

        private List<InvoiceResponseData> invoices = new ArrayList<>();

        private Optional<FeatureUsageDetailResponseData> featureUsage = Optional.empty();

        private Optional<PlanDetailResponseData> defaultPlan = Optional.empty();

        private List<CreditCompanyGrantView> creditGrants = new ArrayList<>();

        private List<BillingCreditBundleView> creditBundles = new ArrayList<>();

        private Optional<ComponentResponseData> component = Optional.empty();

        private Optional<CompanyDetailResponseData> company = Optional.empty();

        private Optional<ComponentCapabilities> capabilities = Optional.empty();

        private List<CompatiblePlans> addOnCompatibilities = new ArrayList<>();

        private List<UsageBasedEntitlementResponseData> activeUsageBasedEntitlements = new ArrayList<>();

        private List<CompanyPlanDetailResponseData> activePlans = new ArrayList<>();

        private List<CompanyPlanDetailResponseData> activeAddOns = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ComponentPreviewResponseData other) {
            activeAddOns(other.getActiveAddOns());
            activePlans(other.getActivePlans());
            activeUsageBasedEntitlements(other.getActiveUsageBasedEntitlements());
            addOnCompatibilities(other.getAddOnCompatibilities());
            capabilities(other.getCapabilities());
            checkoutSettings(other.getCheckoutSettings());
            company(other.getCompany());
            component(other.getComponent());
            creditBundles(other.getCreditBundles());
            creditGrants(other.getCreditGrants());
            defaultPlan(other.getDefaultPlan());
            featureUsage(other.getFeatureUsage());
            invoices(other.getInvoices());
            postTrialPlan(other.getPostTrialPlan());
            showCredits(other.getShowCredits());
            showPeriodToggle(other.getShowPeriodToggle());
            showZeroPriceAsFree(other.getShowZeroPriceAsFree());
            stripeEmbed(other.getStripeEmbed());
            subscription(other.getSubscription());
            trialPaymentMethodRequired(other.getTrialPaymentMethodRequired());
            upcomingInvoice(other.getUpcomingInvoice());
            return this;
        }

        @java.lang.Override
        @JsonSetter("checkout_settings")
        public ShowCreditsStage checkoutSettings(@NotNull ComponentCheckoutSettings checkoutSettings) {
            this.checkoutSettings = Objects.requireNonNull(checkoutSettings, "checkoutSettings must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("show_credits")
        public ShowPeriodToggleStage showCredits(boolean showCredits) {
            this.showCredits = showCredits;
            return this;
        }

        @java.lang.Override
        @JsonSetter("show_period_toggle")
        public ShowZeroPriceAsFreeStage showPeriodToggle(boolean showPeriodToggle) {
            this.showPeriodToggle = showPeriodToggle;
            return this;
        }

        @java.lang.Override
        @JsonSetter("show_zero_price_as_free")
        public _FinalStage showZeroPriceAsFree(boolean showZeroPriceAsFree) {
            this.showZeroPriceAsFree = showZeroPriceAsFree;
            return this;
        }

        @java.lang.Override
        public _FinalStage upcomingInvoice(InvoiceResponseData upcomingInvoice) {
            this.upcomingInvoice = Optional.ofNullable(upcomingInvoice);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "upcoming_invoice", nulls = Nulls.SKIP)
        public _FinalStage upcomingInvoice(Optional<InvoiceResponseData> upcomingInvoice) {
            this.upcomingInvoice = upcomingInvoice;
            return this;
        }

        @java.lang.Override
        public _FinalStage trialPaymentMethodRequired(Boolean trialPaymentMethodRequired) {
            this.trialPaymentMethodRequired = Optional.ofNullable(trialPaymentMethodRequired);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "trial_payment_method_required", nulls = Nulls.SKIP)
        public _FinalStage trialPaymentMethodRequired(Optional<Boolean> trialPaymentMethodRequired) {
            this.trialPaymentMethodRequired = trialPaymentMethodRequired;
            return this;
        }

        @java.lang.Override
        public _FinalStage subscription(CompanySubscriptionResponseData subscription) {
            this.subscription = Optional.ofNullable(subscription);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "subscription", nulls = Nulls.SKIP)
        public _FinalStage subscription(Optional<CompanySubscriptionResponseData> subscription) {
            this.subscription = subscription;
            return this;
        }

        @java.lang.Override
        public _FinalStage stripeEmbed(StripeEmbedInfo stripeEmbed) {
            this.stripeEmbed = Optional.ofNullable(stripeEmbed);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "stripe_embed", nulls = Nulls.SKIP)
        public _FinalStage stripeEmbed(Optional<StripeEmbedInfo> stripeEmbed) {
            this.stripeEmbed = stripeEmbed;
            return this;
        }

        @java.lang.Override
        public _FinalStage postTrialPlan(PlanDetailResponseData postTrialPlan) {
            this.postTrialPlan = Optional.ofNullable(postTrialPlan);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "post_trial_plan", nulls = Nulls.SKIP)
        public _FinalStage postTrialPlan(Optional<PlanDetailResponseData> postTrialPlan) {
            this.postTrialPlan = postTrialPlan;
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllInvoices(List<InvoiceResponseData> invoices) {
            if (invoices != null) {
                this.invoices.addAll(invoices);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addInvoices(InvoiceResponseData invoices) {
            this.invoices.add(invoices);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "invoices", nulls = Nulls.SKIP)
        public _FinalStage invoices(List<InvoiceResponseData> invoices) {
            this.invoices.clear();
            if (invoices != null) {
                this.invoices.addAll(invoices);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage featureUsage(FeatureUsageDetailResponseData featureUsage) {
            this.featureUsage = Optional.ofNullable(featureUsage);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "feature_usage", nulls = Nulls.SKIP)
        public _FinalStage featureUsage(Optional<FeatureUsageDetailResponseData> featureUsage) {
            this.featureUsage = featureUsage;
            return this;
        }

        @java.lang.Override
        public _FinalStage defaultPlan(PlanDetailResponseData defaultPlan) {
            this.defaultPlan = Optional.ofNullable(defaultPlan);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "default_plan", nulls = Nulls.SKIP)
        public _FinalStage defaultPlan(Optional<PlanDetailResponseData> defaultPlan) {
            this.defaultPlan = defaultPlan;
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllCreditGrants(List<CreditCompanyGrantView> creditGrants) {
            if (creditGrants != null) {
                this.creditGrants.addAll(creditGrants);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addCreditGrants(CreditCompanyGrantView creditGrants) {
            this.creditGrants.add(creditGrants);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "credit_grants", nulls = Nulls.SKIP)
        public _FinalStage creditGrants(List<CreditCompanyGrantView> creditGrants) {
            this.creditGrants.clear();
            if (creditGrants != null) {
                this.creditGrants.addAll(creditGrants);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllCreditBundles(List<BillingCreditBundleView> creditBundles) {
            if (creditBundles != null) {
                this.creditBundles.addAll(creditBundles);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addCreditBundles(BillingCreditBundleView creditBundles) {
            this.creditBundles.add(creditBundles);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "credit_bundles", nulls = Nulls.SKIP)
        public _FinalStage creditBundles(List<BillingCreditBundleView> creditBundles) {
            this.creditBundles.clear();
            if (creditBundles != null) {
                this.creditBundles.addAll(creditBundles);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage component(ComponentResponseData component) {
            this.component = Optional.ofNullable(component);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "component", nulls = Nulls.SKIP)
        public _FinalStage component(Optional<ComponentResponseData> component) {
            this.component = component;
            return this;
        }

        @java.lang.Override
        public _FinalStage company(CompanyDetailResponseData company) {
            this.company = Optional.ofNullable(company);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "company", nulls = Nulls.SKIP)
        public _FinalStage company(Optional<CompanyDetailResponseData> company) {
            this.company = company;
            return this;
        }

        @java.lang.Override
        public _FinalStage capabilities(ComponentCapabilities capabilities) {
            this.capabilities = Optional.ofNullable(capabilities);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "capabilities", nulls = Nulls.SKIP)
        public _FinalStage capabilities(Optional<ComponentCapabilities> capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllAddOnCompatibilities(List<CompatiblePlans> addOnCompatibilities) {
            if (addOnCompatibilities != null) {
                this.addOnCompatibilities.addAll(addOnCompatibilities);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addAddOnCompatibilities(CompatiblePlans addOnCompatibilities) {
            this.addOnCompatibilities.add(addOnCompatibilities);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "add_on_compatibilities", nulls = Nulls.SKIP)
        public _FinalStage addOnCompatibilities(List<CompatiblePlans> addOnCompatibilities) {
            this.addOnCompatibilities.clear();
            if (addOnCompatibilities != null) {
                this.addOnCompatibilities.addAll(addOnCompatibilities);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllActiveUsageBasedEntitlements(
                List<UsageBasedEntitlementResponseData> activeUsageBasedEntitlements) {
            if (activeUsageBasedEntitlements != null) {
                this.activeUsageBasedEntitlements.addAll(activeUsageBasedEntitlements);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addActiveUsageBasedEntitlements(
                UsageBasedEntitlementResponseData activeUsageBasedEntitlements) {
            this.activeUsageBasedEntitlements.add(activeUsageBasedEntitlements);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "active_usage_based_entitlements", nulls = Nulls.SKIP)
        public _FinalStage activeUsageBasedEntitlements(
                List<UsageBasedEntitlementResponseData> activeUsageBasedEntitlements) {
            this.activeUsageBasedEntitlements.clear();
            if (activeUsageBasedEntitlements != null) {
                this.activeUsageBasedEntitlements.addAll(activeUsageBasedEntitlements);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllActivePlans(List<CompanyPlanDetailResponseData> activePlans) {
            if (activePlans != null) {
                this.activePlans.addAll(activePlans);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addActivePlans(CompanyPlanDetailResponseData activePlans) {
            this.activePlans.add(activePlans);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "active_plans", nulls = Nulls.SKIP)
        public _FinalStage activePlans(List<CompanyPlanDetailResponseData> activePlans) {
            this.activePlans.clear();
            if (activePlans != null) {
                this.activePlans.addAll(activePlans);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllActiveAddOns(List<CompanyPlanDetailResponseData> activeAddOns) {
            if (activeAddOns != null) {
                this.activeAddOns.addAll(activeAddOns);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addActiveAddOns(CompanyPlanDetailResponseData activeAddOns) {
            this.activeAddOns.add(activeAddOns);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "active_add_ons", nulls = Nulls.SKIP)
        public _FinalStage activeAddOns(List<CompanyPlanDetailResponseData> activeAddOns) {
            this.activeAddOns.clear();
            if (activeAddOns != null) {
                this.activeAddOns.addAll(activeAddOns);
            }
            return this;
        }

        @java.lang.Override
        public ComponentPreviewResponseData build() {
            return new ComponentPreviewResponseData(
                    activeAddOns,
                    activePlans,
                    activeUsageBasedEntitlements,
                    addOnCompatibilities,
                    capabilities,
                    checkoutSettings,
                    company,
                    component,
                    creditBundles,
                    creditGrants,
                    defaultPlan,
                    featureUsage,
                    invoices,
                    postTrialPlan,
                    showCredits,
                    showPeriodToggle,
                    showZeroPriceAsFree,
                    stripeEmbed,
                    subscription,
                    trialPaymentMethodRequired,
                    upcomingInvoice,
                    additionalProperties);
        }
    }
}
