/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ComponentResponseData.Builder.class)
public final class ComponentResponseData {
    private final Optional<Map<String, Double>> ast;

    private final OffsetDateTime createdAt;

    private final String id;

    private final String name;

    private final String state;

    private final String type;

    private final OffsetDateTime updatedAt;

    private final Map<String, Object> additionalProperties;

    private ComponentResponseData(
            Optional<Map<String, Double>> ast,
            OffsetDateTime createdAt,
            String id,
            String name,
            String state,
            String type,
            OffsetDateTime updatedAt,
            Map<String, Object> additionalProperties) {
        this.ast = ast;
        this.createdAt = createdAt;
        this.id = id;
        this.name = name;
        this.state = state;
        this.type = type;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("ast")
    public Optional<Map<String, Double>> getAst() {
        return ast;
    }

    @JsonProperty("created_at")
    public OffsetDateTime getCreatedAt() {
        return createdAt;
    }

    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @JsonProperty("name")
    public String getName() {
        return name;
    }

    @JsonProperty("state")
    public String getState() {
        return state;
    }

    @JsonProperty("type")
    public String getType() {
        return type;
    }

    @JsonProperty("updated_at")
    public OffsetDateTime getUpdatedAt() {
        return updatedAt;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ComponentResponseData && equalTo((ComponentResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ComponentResponseData other) {
        return ast.equals(other.ast)
                && createdAt.equals(other.createdAt)
                && id.equals(other.id)
                && name.equals(other.name)
                && state.equals(other.state)
                && type.equals(other.type)
                && updatedAt.equals(other.updatedAt);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.ast, this.createdAt, this.id, this.name, this.state, this.type, this.updatedAt);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CreatedAtStage builder() {
        return new Builder();
    }

    public interface CreatedAtStage {
        IdStage createdAt(@NotNull OffsetDateTime createdAt);

        Builder from(ComponentResponseData other);
    }

    public interface IdStage {
        NameStage id(@NotNull String id);
    }

    public interface NameStage {
        StateStage name(@NotNull String name);
    }

    public interface StateStage {
        TypeStage state(@NotNull String state);
    }

    public interface TypeStage {
        UpdatedAtStage type(@NotNull String type);
    }

    public interface UpdatedAtStage {
        _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt);
    }

    public interface _FinalStage {
        ComponentResponseData build();

        _FinalStage ast(Optional<Map<String, Double>> ast);

        _FinalStage ast(Map<String, Double> ast);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements CreatedAtStage, IdStage, NameStage, StateStage, TypeStage, UpdatedAtStage, _FinalStage {
        private OffsetDateTime createdAt;

        private String id;

        private String name;

        private String state;

        private String type;

        private OffsetDateTime updatedAt;

        private Optional<Map<String, Double>> ast = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ComponentResponseData other) {
            ast(other.getAst());
            createdAt(other.getCreatedAt());
            id(other.getId());
            name(other.getName());
            state(other.getState());
            type(other.getType());
            updatedAt(other.getUpdatedAt());
            return this;
        }

        @java.lang.Override
        @JsonSetter("created_at")
        public IdStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("name")
        public StateStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("state")
        public TypeStage state(@NotNull String state) {
            this.state = Objects.requireNonNull(state, "state must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("type")
        public UpdatedAtStage type(@NotNull String type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage ast(Map<String, Double> ast) {
            this.ast = Optional.ofNullable(ast);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "ast", nulls = Nulls.SKIP)
        public _FinalStage ast(Optional<Map<String, Double>> ast) {
            this.ast = ast;
            return this;
        }

        @java.lang.Override
        public ComponentResponseData build() {
            return new ComponentResponseData(ast, createdAt, id, name, state, type, updatedAt, additionalProperties);
        }
    }
}
