/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = Condition.Builder.class)
public final class Condition {
    private final String accountId;

    private final Optional<TraitDefinition> comparisonTraitDefinition;

    private final String conditionType;

    private final Optional<Double> consumptionRate;

    private final Optional<String> creditId;

    private final String environmentId;

    private final Optional<String> eventSubtype;

    private final String id;

    private final Optional<String> metricPeriod;

    private final Optional<String> metricPeriodMonthReset;

    private final Optional<Integer> metricValue;

    private final String operator;

    private final List<String> resourceIds;

    private final Optional<TraitDefinition> traitDefinition;

    private final String traitValue;

    private final Map<String, Object> additionalProperties;

    private Condition(
            String accountId,
            Optional<TraitDefinition> comparisonTraitDefinition,
            String conditionType,
            Optional<Double> consumptionRate,
            Optional<String> creditId,
            String environmentId,
            Optional<String> eventSubtype,
            String id,
            Optional<String> metricPeriod,
            Optional<String> metricPeriodMonthReset,
            Optional<Integer> metricValue,
            String operator,
            List<String> resourceIds,
            Optional<TraitDefinition> traitDefinition,
            String traitValue,
            Map<String, Object> additionalProperties) {
        this.accountId = accountId;
        this.comparisonTraitDefinition = comparisonTraitDefinition;
        this.conditionType = conditionType;
        this.consumptionRate = consumptionRate;
        this.creditId = creditId;
        this.environmentId = environmentId;
        this.eventSubtype = eventSubtype;
        this.id = id;
        this.metricPeriod = metricPeriod;
        this.metricPeriodMonthReset = metricPeriodMonthReset;
        this.metricValue = metricValue;
        this.operator = operator;
        this.resourceIds = resourceIds;
        this.traitDefinition = traitDefinition;
        this.traitValue = traitValue;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("account_id")
    public String getAccountId() {
        return accountId;
    }

    @JsonProperty("comparison_trait_definition")
    public Optional<TraitDefinition> getComparisonTraitDefinition() {
        return comparisonTraitDefinition;
    }

    @JsonProperty("condition_type")
    public String getConditionType() {
        return conditionType;
    }

    @JsonProperty("consumption_rate")
    public Optional<Double> getConsumptionRate() {
        return consumptionRate;
    }

    @JsonProperty("credit_id")
    public Optional<String> getCreditId() {
        return creditId;
    }

    @JsonProperty("environment_id")
    public String getEnvironmentId() {
        return environmentId;
    }

    @JsonProperty("event_subtype")
    public Optional<String> getEventSubtype() {
        return eventSubtype;
    }

    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @JsonProperty("metric_period")
    public Optional<String> getMetricPeriod() {
        return metricPeriod;
    }

    @JsonProperty("metric_period_month_reset")
    public Optional<String> getMetricPeriodMonthReset() {
        return metricPeriodMonthReset;
    }

    @JsonProperty("metric_value")
    public Optional<Integer> getMetricValue() {
        return metricValue;
    }

    @JsonProperty("operator")
    public String getOperator() {
        return operator;
    }

    @JsonProperty("resource_ids")
    public List<String> getResourceIds() {
        return resourceIds;
    }

    @JsonProperty("trait_definition")
    public Optional<TraitDefinition> getTraitDefinition() {
        return traitDefinition;
    }

    @JsonProperty("trait_value")
    public String getTraitValue() {
        return traitValue;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof Condition && equalTo((Condition) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Condition other) {
        return accountId.equals(other.accountId)
                && comparisonTraitDefinition.equals(other.comparisonTraitDefinition)
                && conditionType.equals(other.conditionType)
                && consumptionRate.equals(other.consumptionRate)
                && creditId.equals(other.creditId)
                && environmentId.equals(other.environmentId)
                && eventSubtype.equals(other.eventSubtype)
                && id.equals(other.id)
                && metricPeriod.equals(other.metricPeriod)
                && metricPeriodMonthReset.equals(other.metricPeriodMonthReset)
                && metricValue.equals(other.metricValue)
                && operator.equals(other.operator)
                && resourceIds.equals(other.resourceIds)
                && traitDefinition.equals(other.traitDefinition)
                && traitValue.equals(other.traitValue);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.accountId,
                this.comparisonTraitDefinition,
                this.conditionType,
                this.consumptionRate,
                this.creditId,
                this.environmentId,
                this.eventSubtype,
                this.id,
                this.metricPeriod,
                this.metricPeriodMonthReset,
                this.metricValue,
                this.operator,
                this.resourceIds,
                this.traitDefinition,
                this.traitValue);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AccountIdStage builder() {
        return new Builder();
    }

    public interface AccountIdStage {
        ConditionTypeStage accountId(@NotNull String accountId);

        Builder from(Condition other);
    }

    public interface ConditionTypeStage {
        EnvironmentIdStage conditionType(@NotNull String conditionType);
    }

    public interface EnvironmentIdStage {
        IdStage environmentId(@NotNull String environmentId);
    }

    public interface IdStage {
        OperatorStage id(@NotNull String id);
    }

    public interface OperatorStage {
        TraitValueStage operator(@NotNull String operator);
    }

    public interface TraitValueStage {
        _FinalStage traitValue(@NotNull String traitValue);
    }

    public interface _FinalStage {
        Condition build();

        _FinalStage comparisonTraitDefinition(Optional<TraitDefinition> comparisonTraitDefinition);

        _FinalStage comparisonTraitDefinition(TraitDefinition comparisonTraitDefinition);

        _FinalStage consumptionRate(Optional<Double> consumptionRate);

        _FinalStage consumptionRate(Double consumptionRate);

        _FinalStage creditId(Optional<String> creditId);

        _FinalStage creditId(String creditId);

        _FinalStage eventSubtype(Optional<String> eventSubtype);

        _FinalStage eventSubtype(String eventSubtype);

        _FinalStage metricPeriod(Optional<String> metricPeriod);

        _FinalStage metricPeriod(String metricPeriod);

        _FinalStage metricPeriodMonthReset(Optional<String> metricPeriodMonthReset);

        _FinalStage metricPeriodMonthReset(String metricPeriodMonthReset);

        _FinalStage metricValue(Optional<Integer> metricValue);

        _FinalStage metricValue(Integer metricValue);

        _FinalStage resourceIds(List<String> resourceIds);

        _FinalStage addResourceIds(String resourceIds);

        _FinalStage addAllResourceIds(List<String> resourceIds);

        _FinalStage traitDefinition(Optional<TraitDefinition> traitDefinition);

        _FinalStage traitDefinition(TraitDefinition traitDefinition);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements AccountIdStage,
                    ConditionTypeStage,
                    EnvironmentIdStage,
                    IdStage,
                    OperatorStage,
                    TraitValueStage,
                    _FinalStage {
        private String accountId;

        private String conditionType;

        private String environmentId;

        private String id;

        private String operator;

        private String traitValue;

        private Optional<TraitDefinition> traitDefinition = Optional.empty();

        private List<String> resourceIds = new ArrayList<>();

        private Optional<Integer> metricValue = Optional.empty();

        private Optional<String> metricPeriodMonthReset = Optional.empty();

        private Optional<String> metricPeriod = Optional.empty();

        private Optional<String> eventSubtype = Optional.empty();

        private Optional<String> creditId = Optional.empty();

        private Optional<Double> consumptionRate = Optional.empty();

        private Optional<TraitDefinition> comparisonTraitDefinition = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(Condition other) {
            accountId(other.getAccountId());
            comparisonTraitDefinition(other.getComparisonTraitDefinition());
            conditionType(other.getConditionType());
            consumptionRate(other.getConsumptionRate());
            creditId(other.getCreditId());
            environmentId(other.getEnvironmentId());
            eventSubtype(other.getEventSubtype());
            id(other.getId());
            metricPeriod(other.getMetricPeriod());
            metricPeriodMonthReset(other.getMetricPeriodMonthReset());
            metricValue(other.getMetricValue());
            operator(other.getOperator());
            resourceIds(other.getResourceIds());
            traitDefinition(other.getTraitDefinition());
            traitValue(other.getTraitValue());
            return this;
        }

        @java.lang.Override
        @JsonSetter("account_id")
        public ConditionTypeStage accountId(@NotNull String accountId) {
            this.accountId = Objects.requireNonNull(accountId, "accountId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("condition_type")
        public EnvironmentIdStage conditionType(@NotNull String conditionType) {
            this.conditionType = Objects.requireNonNull(conditionType, "conditionType must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("environment_id")
        public IdStage environmentId(@NotNull String environmentId) {
            this.environmentId = Objects.requireNonNull(environmentId, "environmentId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("id")
        public OperatorStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("operator")
        public TraitValueStage operator(@NotNull String operator) {
            this.operator = Objects.requireNonNull(operator, "operator must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("trait_value")
        public _FinalStage traitValue(@NotNull String traitValue) {
            this.traitValue = Objects.requireNonNull(traitValue, "traitValue must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage traitDefinition(TraitDefinition traitDefinition) {
            this.traitDefinition = Optional.ofNullable(traitDefinition);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "trait_definition", nulls = Nulls.SKIP)
        public _FinalStage traitDefinition(Optional<TraitDefinition> traitDefinition) {
            this.traitDefinition = traitDefinition;
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllResourceIds(List<String> resourceIds) {
            if (resourceIds != null) {
                this.resourceIds.addAll(resourceIds);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addResourceIds(String resourceIds) {
            this.resourceIds.add(resourceIds);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "resource_ids", nulls = Nulls.SKIP)
        public _FinalStage resourceIds(List<String> resourceIds) {
            this.resourceIds.clear();
            if (resourceIds != null) {
                this.resourceIds.addAll(resourceIds);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage metricValue(Integer metricValue) {
            this.metricValue = Optional.ofNullable(metricValue);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "metric_value", nulls = Nulls.SKIP)
        public _FinalStage metricValue(Optional<Integer> metricValue) {
            this.metricValue = metricValue;
            return this;
        }

        @java.lang.Override
        public _FinalStage metricPeriodMonthReset(String metricPeriodMonthReset) {
            this.metricPeriodMonthReset = Optional.ofNullable(metricPeriodMonthReset);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "metric_period_month_reset", nulls = Nulls.SKIP)
        public _FinalStage metricPeriodMonthReset(Optional<String> metricPeriodMonthReset) {
            this.metricPeriodMonthReset = metricPeriodMonthReset;
            return this;
        }

        @java.lang.Override
        public _FinalStage metricPeriod(String metricPeriod) {
            this.metricPeriod = Optional.ofNullable(metricPeriod);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "metric_period", nulls = Nulls.SKIP)
        public _FinalStage metricPeriod(Optional<String> metricPeriod) {
            this.metricPeriod = metricPeriod;
            return this;
        }

        @java.lang.Override
        public _FinalStage eventSubtype(String eventSubtype) {
            this.eventSubtype = Optional.ofNullable(eventSubtype);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "event_subtype", nulls = Nulls.SKIP)
        public _FinalStage eventSubtype(Optional<String> eventSubtype) {
            this.eventSubtype = eventSubtype;
            return this;
        }

        @java.lang.Override
        public _FinalStage creditId(String creditId) {
            this.creditId = Optional.ofNullable(creditId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "credit_id", nulls = Nulls.SKIP)
        public _FinalStage creditId(Optional<String> creditId) {
            this.creditId = creditId;
            return this;
        }

        @java.lang.Override
        public _FinalStage consumptionRate(Double consumptionRate) {
            this.consumptionRate = Optional.ofNullable(consumptionRate);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "consumption_rate", nulls = Nulls.SKIP)
        public _FinalStage consumptionRate(Optional<Double> consumptionRate) {
            this.consumptionRate = consumptionRate;
            return this;
        }

        @java.lang.Override
        public _FinalStage comparisonTraitDefinition(TraitDefinition comparisonTraitDefinition) {
            this.comparisonTraitDefinition = Optional.ofNullable(comparisonTraitDefinition);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "comparison_trait_definition", nulls = Nulls.SKIP)
        public _FinalStage comparisonTraitDefinition(Optional<TraitDefinition> comparisonTraitDefinition) {
            this.comparisonTraitDefinition = comparisonTraitDefinition;
            return this;
        }

        @java.lang.Override
        public Condition build() {
            return new Condition(
                    accountId,
                    comparisonTraitDefinition,
                    conditionType,
                    consumptionRate,
                    creditId,
                    environmentId,
                    eventSubtype,
                    id,
                    metricPeriod,
                    metricPeriodMonthReset,
                    metricValue,
                    operator,
                    resourceIds,
                    traitDefinition,
                    traitValue,
                    additionalProperties);
        }
    }
}
