/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ConditionGroup.Builder.class)
public final class ConditionGroup {
    private final List<Condition> conditions;

    private final Map<String, Object> additionalProperties;

    private ConditionGroup(List<Condition> conditions, Map<String, Object> additionalProperties) {
        this.conditions = conditions;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("conditions")
    public List<Condition> getConditions() {
        return conditions;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ConditionGroup && equalTo((ConditionGroup) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConditionGroup other) {
        return conditions.equals(other.conditions);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.conditions);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private List<Condition> conditions = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ConditionGroup other) {
            conditions(other.getConditions());
            return this;
        }

        @JsonSetter(value = "conditions", nulls = Nulls.SKIP)
        public Builder conditions(List<Condition> conditions) {
            this.conditions.clear();
            if (conditions != null) {
                this.conditions.addAll(conditions);
            }
            return this;
        }

        public Builder addConditions(Condition conditions) {
            this.conditions.add(conditions);
            return this;
        }

        public Builder addAllConditions(List<Condition> conditions) {
            if (conditions != null) {
                this.conditions.addAll(conditions);
            }
            return this;
        }

        public ConditionGroup build() {
            return new ConditionGroup(conditions, additionalProperties);
        }
    }
}
