/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CouponRequestBody.Builder.class)
public final class CouponRequestBody {
    private final int amountOff;

    private final Optional<String> currency;

    private final String duration;

    private final int durationInMonths;

    private final int maxRedemptions;

    private final String name;

    private final double percentOff;

    private final int timesRedeemed;

    private final Map<String, Object> additionalProperties;

    private CouponRequestBody(
            int amountOff,
            Optional<String> currency,
            String duration,
            int durationInMonths,
            int maxRedemptions,
            String name,
            double percentOff,
            int timesRedeemed,
            Map<String, Object> additionalProperties) {
        this.amountOff = amountOff;
        this.currency = currency;
        this.duration = duration;
        this.durationInMonths = durationInMonths;
        this.maxRedemptions = maxRedemptions;
        this.name = name;
        this.percentOff = percentOff;
        this.timesRedeemed = timesRedeemed;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("amount_off")
    public int getAmountOff() {
        return amountOff;
    }

    @JsonProperty("currency")
    public Optional<String> getCurrency() {
        return currency;
    }

    @JsonProperty("duration")
    public String getDuration() {
        return duration;
    }

    @JsonProperty("duration_in_months")
    public int getDurationInMonths() {
        return durationInMonths;
    }

    @JsonProperty("max_redemptions")
    public int getMaxRedemptions() {
        return maxRedemptions;
    }

    @JsonProperty("name")
    public String getName() {
        return name;
    }

    @JsonProperty("percent_off")
    public double getPercentOff() {
        return percentOff;
    }

    @JsonProperty("times_redeemed")
    public int getTimesRedeemed() {
        return timesRedeemed;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CouponRequestBody && equalTo((CouponRequestBody) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CouponRequestBody other) {
        return amountOff == other.amountOff
                && currency.equals(other.currency)
                && duration.equals(other.duration)
                && durationInMonths == other.durationInMonths
                && maxRedemptions == other.maxRedemptions
                && name.equals(other.name)
                && percentOff == other.percentOff
                && timesRedeemed == other.timesRedeemed;
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.amountOff,
                this.currency,
                this.duration,
                this.durationInMonths,
                this.maxRedemptions,
                this.name,
                this.percentOff,
                this.timesRedeemed);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AmountOffStage builder() {
        return new Builder();
    }

    public interface AmountOffStage {
        DurationStage amountOff(int amountOff);

        Builder from(CouponRequestBody other);
    }

    public interface DurationStage {
        DurationInMonthsStage duration(@NotNull String duration);
    }

    public interface DurationInMonthsStage {
        MaxRedemptionsStage durationInMonths(int durationInMonths);
    }

    public interface MaxRedemptionsStage {
        NameStage maxRedemptions(int maxRedemptions);
    }

    public interface NameStage {
        PercentOffStage name(@NotNull String name);
    }

    public interface PercentOffStage {
        TimesRedeemedStage percentOff(double percentOff);
    }

    public interface TimesRedeemedStage {
        _FinalStage timesRedeemed(int timesRedeemed);
    }

    public interface _FinalStage {
        CouponRequestBody build();

        _FinalStage currency(Optional<String> currency);

        _FinalStage currency(String currency);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements AmountOffStage,
                    DurationStage,
                    DurationInMonthsStage,
                    MaxRedemptionsStage,
                    NameStage,
                    PercentOffStage,
                    TimesRedeemedStage,
                    _FinalStage {
        private int amountOff;

        private String duration;

        private int durationInMonths;

        private int maxRedemptions;

        private String name;

        private double percentOff;

        private int timesRedeemed;

        private Optional<String> currency = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CouponRequestBody other) {
            amountOff(other.getAmountOff());
            currency(other.getCurrency());
            duration(other.getDuration());
            durationInMonths(other.getDurationInMonths());
            maxRedemptions(other.getMaxRedemptions());
            name(other.getName());
            percentOff(other.getPercentOff());
            timesRedeemed(other.getTimesRedeemed());
            return this;
        }

        @java.lang.Override
        @JsonSetter("amount_off")
        public DurationStage amountOff(int amountOff) {
            this.amountOff = amountOff;
            return this;
        }

        @java.lang.Override
        @JsonSetter("duration")
        public DurationInMonthsStage duration(@NotNull String duration) {
            this.duration = Objects.requireNonNull(duration, "duration must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("duration_in_months")
        public MaxRedemptionsStage durationInMonths(int durationInMonths) {
            this.durationInMonths = durationInMonths;
            return this;
        }

        @java.lang.Override
        @JsonSetter("max_redemptions")
        public NameStage maxRedemptions(int maxRedemptions) {
            this.maxRedemptions = maxRedemptions;
            return this;
        }

        @java.lang.Override
        @JsonSetter("name")
        public PercentOffStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("percent_off")
        public TimesRedeemedStage percentOff(double percentOff) {
            this.percentOff = percentOff;
            return this;
        }

        @java.lang.Override
        @JsonSetter("times_redeemed")
        public _FinalStage timesRedeemed(int timesRedeemed) {
            this.timesRedeemed = timesRedeemed;
            return this;
        }

        @java.lang.Override
        public _FinalStage currency(String currency) {
            this.currency = Optional.ofNullable(currency);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "currency", nulls = Nulls.SKIP)
        public _FinalStage currency(Optional<String> currency) {
            this.currency = currency;
            return this;
        }

        @java.lang.Override
        public CouponRequestBody build() {
            return new CouponRequestBody(
                    amountOff,
                    currency,
                    duration,
                    durationInMonths,
                    maxRedemptions,
                    name,
                    percentOff,
                    timesRedeemed,
                    additionalProperties);
        }
    }
}
