/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CreditBundlePurchaseResponseData.Builder.class)
public final class CreditBundlePurchaseResponseData {
    private final Optional<BillingCreditBundleResponseData> bundle;

    private final int quantity;

    private final int total;

    private final Map<String, Object> additionalProperties;

    private CreditBundlePurchaseResponseData(
            Optional<BillingCreditBundleResponseData> bundle,
            int quantity,
            int total,
            Map<String, Object> additionalProperties) {
        this.bundle = bundle;
        this.quantity = quantity;
        this.total = total;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("bundle")
    public Optional<BillingCreditBundleResponseData> getBundle() {
        return bundle;
    }

    @JsonProperty("quantity")
    public int getQuantity() {
        return quantity;
    }

    @JsonProperty("total")
    public int getTotal() {
        return total;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CreditBundlePurchaseResponseData && equalTo((CreditBundlePurchaseResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreditBundlePurchaseResponseData other) {
        return bundle.equals(other.bundle) && quantity == other.quantity && total == other.total;
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.bundle, this.quantity, this.total);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static QuantityStage builder() {
        return new Builder();
    }

    public interface QuantityStage {
        TotalStage quantity(int quantity);

        Builder from(CreditBundlePurchaseResponseData other);
    }

    public interface TotalStage {
        _FinalStage total(int total);
    }

    public interface _FinalStage {
        CreditBundlePurchaseResponseData build();

        _FinalStage bundle(Optional<BillingCreditBundleResponseData> bundle);

        _FinalStage bundle(BillingCreditBundleResponseData bundle);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements QuantityStage, TotalStage, _FinalStage {
        private int quantity;

        private int total;

        private Optional<BillingCreditBundleResponseData> bundle = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CreditBundlePurchaseResponseData other) {
            bundle(other.getBundle());
            quantity(other.getQuantity());
            total(other.getTotal());
            return this;
        }

        @java.lang.Override
        @JsonSetter("quantity")
        public TotalStage quantity(int quantity) {
            this.quantity = quantity;
            return this;
        }

        @java.lang.Override
        @JsonSetter("total")
        public _FinalStage total(int total) {
            this.total = total;
            return this;
        }

        @java.lang.Override
        public _FinalStage bundle(BillingCreditBundleResponseData bundle) {
            this.bundle = Optional.ofNullable(bundle);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "bundle", nulls = Nulls.SKIP)
        public _FinalStage bundle(Optional<BillingCreditBundleResponseData> bundle) {
            this.bundle = bundle;
            return this;
        }

        @java.lang.Override
        public CreditBundlePurchaseResponseData build() {
            return new CreditBundlePurchaseResponseData(bundle, quantity, total, additionalProperties);
        }
    }
}
