/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CreditGrantDetail.Builder.class)
public final class CreditGrantDetail {
    private final Optional<String> creditTypeIcon;

    private final Optional<OffsetDateTime> expiresAt;

    private final CreditGrantDetailGrantReason grantReason;

    private final double quantity;

    private final Map<String, Object> additionalProperties;

    private CreditGrantDetail(
            Optional<String> creditTypeIcon,
            Optional<OffsetDateTime> expiresAt,
            CreditGrantDetailGrantReason grantReason,
            double quantity,
            Map<String, Object> additionalProperties) {
        this.creditTypeIcon = creditTypeIcon;
        this.expiresAt = expiresAt;
        this.grantReason = grantReason;
        this.quantity = quantity;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("credit_type_icon")
    public Optional<String> getCreditTypeIcon() {
        return creditTypeIcon;
    }

    @JsonProperty("expires_at")
    public Optional<OffsetDateTime> getExpiresAt() {
        return expiresAt;
    }

    @JsonProperty("grant_reason")
    public CreditGrantDetailGrantReason getGrantReason() {
        return grantReason;
    }

    @JsonProperty("quantity")
    public double getQuantity() {
        return quantity;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CreditGrantDetail && equalTo((CreditGrantDetail) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreditGrantDetail other) {
        return creditTypeIcon.equals(other.creditTypeIcon)
                && expiresAt.equals(other.expiresAt)
                && grantReason.equals(other.grantReason)
                && quantity == other.quantity;
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.creditTypeIcon, this.expiresAt, this.grantReason, this.quantity);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static GrantReasonStage builder() {
        return new Builder();
    }

    public interface GrantReasonStage {
        QuantityStage grantReason(@NotNull CreditGrantDetailGrantReason grantReason);

        Builder from(CreditGrantDetail other);
    }

    public interface QuantityStage {
        _FinalStage quantity(double quantity);
    }

    public interface _FinalStage {
        CreditGrantDetail build();

        _FinalStage creditTypeIcon(Optional<String> creditTypeIcon);

        _FinalStage creditTypeIcon(String creditTypeIcon);

        _FinalStage expiresAt(Optional<OffsetDateTime> expiresAt);

        _FinalStage expiresAt(OffsetDateTime expiresAt);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements GrantReasonStage, QuantityStage, _FinalStage {
        private CreditGrantDetailGrantReason grantReason;

        private double quantity;

        private Optional<OffsetDateTime> expiresAt = Optional.empty();

        private Optional<String> creditTypeIcon = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CreditGrantDetail other) {
            creditTypeIcon(other.getCreditTypeIcon());
            expiresAt(other.getExpiresAt());
            grantReason(other.getGrantReason());
            quantity(other.getQuantity());
            return this;
        }

        @java.lang.Override
        @JsonSetter("grant_reason")
        public QuantityStage grantReason(@NotNull CreditGrantDetailGrantReason grantReason) {
            this.grantReason = Objects.requireNonNull(grantReason, "grantReason must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("quantity")
        public _FinalStage quantity(double quantity) {
            this.quantity = quantity;
            return this;
        }

        @java.lang.Override
        public _FinalStage expiresAt(OffsetDateTime expiresAt) {
            this.expiresAt = Optional.ofNullable(expiresAt);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "expires_at", nulls = Nulls.SKIP)
        public _FinalStage expiresAt(Optional<OffsetDateTime> expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        @java.lang.Override
        public _FinalStage creditTypeIcon(String creditTypeIcon) {
            this.creditTypeIcon = Optional.ofNullable(creditTypeIcon);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "credit_type_icon", nulls = Nulls.SKIP)
        public _FinalStage creditTypeIcon(Optional<String> creditTypeIcon) {
            this.creditTypeIcon = creditTypeIcon;
            return this;
        }

        @java.lang.Override
        public CreditGrantDetail build() {
            return new CreditGrantDetail(creditTypeIcon, expiresAt, grantReason, quantity, additionalProperties);
        }
    }
}
