/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CreditTriggerConfig.Builder.class)
public final class CreditTriggerConfig {
    private final String creditId;

    private final Map<String, Object> additionalProperties;

    private CreditTriggerConfig(String creditId, Map<String, Object> additionalProperties) {
        this.creditId = creditId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("credit_id")
    public String getCreditId() {
        return creditId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CreditTriggerConfig && equalTo((CreditTriggerConfig) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreditTriggerConfig other) {
        return creditId.equals(other.creditId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.creditId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CreditIdStage builder() {
        return new Builder();
    }

    public interface CreditIdStage {
        _FinalStage creditId(@NotNull String creditId);

        Builder from(CreditTriggerConfig other);
    }

    public interface _FinalStage {
        CreditTriggerConfig build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements CreditIdStage, _FinalStage {
        private String creditId;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CreditTriggerConfig other) {
            creditId(other.getCreditId());
            return this;
        }

        @java.lang.Override
        @JsonSetter("credit_id")
        public _FinalStage creditId(@NotNull String creditId) {
            this.creditId = Objects.requireNonNull(creditId, "creditId must not be null");
            return this;
        }

        @java.lang.Override
        public CreditTriggerConfig build() {
            return new CreditTriggerConfig(creditId, additionalProperties);
        }
    }
}
