/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ManagePlanRequest.Builder.class)
public final class ManagePlanRequest {
    private final List<PlanSelection> addOnSelections;

    private final Optional<String> basePlanId;

    private final Optional<String> basePlanPriceId;

    private final String companyId;

    private final Optional<String> couponExternalId;

    private final List<UpdateCreditBundleRequestBody> creditBundles;

    private final List<UpdatePayInAdvanceRequestBody> payInAdvanceEntitlements;

    private final Optional<String> paymentMethodExternalId;

    private final Optional<String> promoCode;

    private final Map<String, Object> additionalProperties;

    private ManagePlanRequest(
            List<PlanSelection> addOnSelections,
            Optional<String> basePlanId,
            Optional<String> basePlanPriceId,
            String companyId,
            Optional<String> couponExternalId,
            List<UpdateCreditBundleRequestBody> creditBundles,
            List<UpdatePayInAdvanceRequestBody> payInAdvanceEntitlements,
            Optional<String> paymentMethodExternalId,
            Optional<String> promoCode,
            Map<String, Object> additionalProperties) {
        this.addOnSelections = addOnSelections;
        this.basePlanId = basePlanId;
        this.basePlanPriceId = basePlanPriceId;
        this.companyId = companyId;
        this.couponExternalId = couponExternalId;
        this.creditBundles = creditBundles;
        this.payInAdvanceEntitlements = payInAdvanceEntitlements;
        this.paymentMethodExternalId = paymentMethodExternalId;
        this.promoCode = promoCode;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("add_on_selections")
    public List<PlanSelection> getAddOnSelections() {
        return addOnSelections;
    }

    @JsonProperty("base_plan_id")
    public Optional<String> getBasePlanId() {
        return basePlanId;
    }

    @JsonProperty("base_plan_price_id")
    public Optional<String> getBasePlanPriceId() {
        return basePlanPriceId;
    }

    @JsonProperty("company_id")
    public String getCompanyId() {
        return companyId;
    }

    @JsonProperty("coupon_external_id")
    public Optional<String> getCouponExternalId() {
        return couponExternalId;
    }

    @JsonProperty("credit_bundles")
    public List<UpdateCreditBundleRequestBody> getCreditBundles() {
        return creditBundles;
    }

    @JsonProperty("pay_in_advance_entitlements")
    public List<UpdatePayInAdvanceRequestBody> getPayInAdvanceEntitlements() {
        return payInAdvanceEntitlements;
    }

    @JsonProperty("payment_method_external_id")
    public Optional<String> getPaymentMethodExternalId() {
        return paymentMethodExternalId;
    }

    @JsonProperty("promo_code")
    public Optional<String> getPromoCode() {
        return promoCode;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ManagePlanRequest && equalTo((ManagePlanRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ManagePlanRequest other) {
        return addOnSelections.equals(other.addOnSelections)
                && basePlanId.equals(other.basePlanId)
                && basePlanPriceId.equals(other.basePlanPriceId)
                && companyId.equals(other.companyId)
                && couponExternalId.equals(other.couponExternalId)
                && creditBundles.equals(other.creditBundles)
                && payInAdvanceEntitlements.equals(other.payInAdvanceEntitlements)
                && paymentMethodExternalId.equals(other.paymentMethodExternalId)
                && promoCode.equals(other.promoCode);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.addOnSelections,
                this.basePlanId,
                this.basePlanPriceId,
                this.companyId,
                this.couponExternalId,
                this.creditBundles,
                this.payInAdvanceEntitlements,
                this.paymentMethodExternalId,
                this.promoCode);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CompanyIdStage builder() {
        return new Builder();
    }

    public interface CompanyIdStage {
        _FinalStage companyId(@NotNull String companyId);

        Builder from(ManagePlanRequest other);
    }

    public interface _FinalStage {
        ManagePlanRequest build();

        _FinalStage addOnSelections(List<PlanSelection> addOnSelections);

        _FinalStage addAddOnSelections(PlanSelection addOnSelections);

        _FinalStage addAllAddOnSelections(List<PlanSelection> addOnSelections);

        _FinalStage basePlanId(Optional<String> basePlanId);

        _FinalStage basePlanId(String basePlanId);

        _FinalStage basePlanPriceId(Optional<String> basePlanPriceId);

        _FinalStage basePlanPriceId(String basePlanPriceId);

        _FinalStage couponExternalId(Optional<String> couponExternalId);

        _FinalStage couponExternalId(String couponExternalId);

        _FinalStage creditBundles(List<UpdateCreditBundleRequestBody> creditBundles);

        _FinalStage addCreditBundles(UpdateCreditBundleRequestBody creditBundles);

        _FinalStage addAllCreditBundles(List<UpdateCreditBundleRequestBody> creditBundles);

        _FinalStage payInAdvanceEntitlements(List<UpdatePayInAdvanceRequestBody> payInAdvanceEntitlements);

        _FinalStage addPayInAdvanceEntitlements(UpdatePayInAdvanceRequestBody payInAdvanceEntitlements);

        _FinalStage addAllPayInAdvanceEntitlements(List<UpdatePayInAdvanceRequestBody> payInAdvanceEntitlements);

        _FinalStage paymentMethodExternalId(Optional<String> paymentMethodExternalId);

        _FinalStage paymentMethodExternalId(String paymentMethodExternalId);

        _FinalStage promoCode(Optional<String> promoCode);

        _FinalStage promoCode(String promoCode);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements CompanyIdStage, _FinalStage {
        private String companyId;

        private Optional<String> promoCode = Optional.empty();

        private Optional<String> paymentMethodExternalId = Optional.empty();

        private List<UpdatePayInAdvanceRequestBody> payInAdvanceEntitlements = new ArrayList<>();

        private List<UpdateCreditBundleRequestBody> creditBundles = new ArrayList<>();

        private Optional<String> couponExternalId = Optional.empty();

        private Optional<String> basePlanPriceId = Optional.empty();

        private Optional<String> basePlanId = Optional.empty();

        private List<PlanSelection> addOnSelections = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ManagePlanRequest other) {
            addOnSelections(other.getAddOnSelections());
            basePlanId(other.getBasePlanId());
            basePlanPriceId(other.getBasePlanPriceId());
            companyId(other.getCompanyId());
            couponExternalId(other.getCouponExternalId());
            creditBundles(other.getCreditBundles());
            payInAdvanceEntitlements(other.getPayInAdvanceEntitlements());
            paymentMethodExternalId(other.getPaymentMethodExternalId());
            promoCode(other.getPromoCode());
            return this;
        }

        @java.lang.Override
        @JsonSetter("company_id")
        public _FinalStage companyId(@NotNull String companyId) {
            this.companyId = Objects.requireNonNull(companyId, "companyId must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage promoCode(String promoCode) {
            this.promoCode = Optional.ofNullable(promoCode);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "promo_code", nulls = Nulls.SKIP)
        public _FinalStage promoCode(Optional<String> promoCode) {
            this.promoCode = promoCode;
            return this;
        }

        @java.lang.Override
        public _FinalStage paymentMethodExternalId(String paymentMethodExternalId) {
            this.paymentMethodExternalId = Optional.ofNullable(paymentMethodExternalId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "payment_method_external_id", nulls = Nulls.SKIP)
        public _FinalStage paymentMethodExternalId(Optional<String> paymentMethodExternalId) {
            this.paymentMethodExternalId = paymentMethodExternalId;
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllPayInAdvanceEntitlements(
                List<UpdatePayInAdvanceRequestBody> payInAdvanceEntitlements) {
            if (payInAdvanceEntitlements != null) {
                this.payInAdvanceEntitlements.addAll(payInAdvanceEntitlements);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addPayInAdvanceEntitlements(UpdatePayInAdvanceRequestBody payInAdvanceEntitlements) {
            this.payInAdvanceEntitlements.add(payInAdvanceEntitlements);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "pay_in_advance_entitlements", nulls = Nulls.SKIP)
        public _FinalStage payInAdvanceEntitlements(List<UpdatePayInAdvanceRequestBody> payInAdvanceEntitlements) {
            this.payInAdvanceEntitlements.clear();
            if (payInAdvanceEntitlements != null) {
                this.payInAdvanceEntitlements.addAll(payInAdvanceEntitlements);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllCreditBundles(List<UpdateCreditBundleRequestBody> creditBundles) {
            if (creditBundles != null) {
                this.creditBundles.addAll(creditBundles);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addCreditBundles(UpdateCreditBundleRequestBody creditBundles) {
            this.creditBundles.add(creditBundles);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "credit_bundles", nulls = Nulls.SKIP)
        public _FinalStage creditBundles(List<UpdateCreditBundleRequestBody> creditBundles) {
            this.creditBundles.clear();
            if (creditBundles != null) {
                this.creditBundles.addAll(creditBundles);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage couponExternalId(String couponExternalId) {
            this.couponExternalId = Optional.ofNullable(couponExternalId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "coupon_external_id", nulls = Nulls.SKIP)
        public _FinalStage couponExternalId(Optional<String> couponExternalId) {
            this.couponExternalId = couponExternalId;
            return this;
        }

        @java.lang.Override
        public _FinalStage basePlanPriceId(String basePlanPriceId) {
            this.basePlanPriceId = Optional.ofNullable(basePlanPriceId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "base_plan_price_id", nulls = Nulls.SKIP)
        public _FinalStage basePlanPriceId(Optional<String> basePlanPriceId) {
            this.basePlanPriceId = basePlanPriceId;
            return this;
        }

        @java.lang.Override
        public _FinalStage basePlanId(String basePlanId) {
            this.basePlanId = Optional.ofNullable(basePlanId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "base_plan_id", nulls = Nulls.SKIP)
        public _FinalStage basePlanId(Optional<String> basePlanId) {
            this.basePlanId = basePlanId;
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllAddOnSelections(List<PlanSelection> addOnSelections) {
            if (addOnSelections != null) {
                this.addOnSelections.addAll(addOnSelections);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addAddOnSelections(PlanSelection addOnSelections) {
            this.addOnSelections.add(addOnSelections);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "add_on_selections", nulls = Nulls.SKIP)
        public _FinalStage addOnSelections(List<PlanSelection> addOnSelections) {
            this.addOnSelections.clear();
            if (addOnSelections != null) {
                this.addOnSelections.addAll(addOnSelections);
            }
            return this;
        }

        @java.lang.Override
        public ManagePlanRequest build() {
            return new ManagePlanRequest(
                    addOnSelections,
                    basePlanId,
                    basePlanPriceId,
                    companyId,
                    couponExternalId,
                    creditBundles,
                    payInAdvanceEntitlements,
                    paymentMethodExternalId,
                    promoCode,
                    additionalProperties);
        }
    }
}
