/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = OrderedPlansInGroup.Builder.class)
public final class OrderedPlansInGroup {
    private final Optional<List<EntitlementsInPlan>> entitlements;

    private final String planId;

    private final Map<String, Object> additionalProperties;

    private OrderedPlansInGroup(
            Optional<List<EntitlementsInPlan>> entitlements, String planId, Map<String, Object> additionalProperties) {
        this.entitlements = entitlements;
        this.planId = planId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("entitlements")
    public Optional<List<EntitlementsInPlan>> getEntitlements() {
        return entitlements;
    }

    @JsonProperty("plan_id")
    public String getPlanId() {
        return planId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof OrderedPlansInGroup && equalTo((OrderedPlansInGroup) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OrderedPlansInGroup other) {
        return entitlements.equals(other.entitlements) && planId.equals(other.planId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.entitlements, this.planId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PlanIdStage builder() {
        return new Builder();
    }

    public interface PlanIdStage {
        _FinalStage planId(@NotNull String planId);

        Builder from(OrderedPlansInGroup other);
    }

    public interface _FinalStage {
        OrderedPlansInGroup build();

        _FinalStage entitlements(Optional<List<EntitlementsInPlan>> entitlements);

        _FinalStage entitlements(List<EntitlementsInPlan> entitlements);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements PlanIdStage, _FinalStage {
        private String planId;

        private Optional<List<EntitlementsInPlan>> entitlements = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(OrderedPlansInGroup other) {
            entitlements(other.getEntitlements());
            planId(other.getPlanId());
            return this;
        }

        @java.lang.Override
        @JsonSetter("plan_id")
        public _FinalStage planId(@NotNull String planId) {
            this.planId = Objects.requireNonNull(planId, "planId must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage entitlements(List<EntitlementsInPlan> entitlements) {
            this.entitlements = Optional.ofNullable(entitlements);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "entitlements", nulls = Nulls.SKIP)
        public _FinalStage entitlements(Optional<List<EntitlementsInPlan>> entitlements) {
            this.entitlements = entitlements;
            return this;
        }

        @java.lang.Override
        public OrderedPlansInGroup build() {
            return new OrderedPlansInGroup(entitlements, planId, additionalProperties);
        }
    }
}
