/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = PlanChangeResponseData.Builder.class)
public final class PlanChangeResponseData {
    private final PlanChangeResponseDataAction action;

    private final PlanChangeResponseDataActorType actorType;

    private final List<PlanSnapshotView> addOnsAdded;

    private final List<PlanSnapshotView> addOnsRemoved;

    private final Optional<ApiKeyResponseData> apiKey;

    private final Optional<ApiKeyRequestListResponseData> apiKeyRequest;

    private final Optional<PlanSnapshotView> basePlan;

    private final Optional<PlanChangeResponseDataBasePlanAction> basePlanAction;

    private final Optional<CompanyResponseData> company;

    private final String companyId;

    private final OffsetDateTime createdAt;

    private final String environmentId;

    private final String id;

    private final Optional<PlanSnapshotView> previousBasePlan;

    private final Optional<String> requestId;

    private final Optional<PlanChangeResponseDataSubscriptionChangeAction> subscriptionChangeAction;

    private final List<SubscriptionTraitUpdate> traitsUpdated;

    private final OffsetDateTime updatedAt;

    private final Optional<String> userId;

    private final Optional<String> userName;

    private final Map<String, Object> additionalProperties;

    private PlanChangeResponseData(
            PlanChangeResponseDataAction action,
            PlanChangeResponseDataActorType actorType,
            List<PlanSnapshotView> addOnsAdded,
            List<PlanSnapshotView> addOnsRemoved,
            Optional<ApiKeyResponseData> apiKey,
            Optional<ApiKeyRequestListResponseData> apiKeyRequest,
            Optional<PlanSnapshotView> basePlan,
            Optional<PlanChangeResponseDataBasePlanAction> basePlanAction,
            Optional<CompanyResponseData> company,
            String companyId,
            OffsetDateTime createdAt,
            String environmentId,
            String id,
            Optional<PlanSnapshotView> previousBasePlan,
            Optional<String> requestId,
            Optional<PlanChangeResponseDataSubscriptionChangeAction> subscriptionChangeAction,
            List<SubscriptionTraitUpdate> traitsUpdated,
            OffsetDateTime updatedAt,
            Optional<String> userId,
            Optional<String> userName,
            Map<String, Object> additionalProperties) {
        this.action = action;
        this.actorType = actorType;
        this.addOnsAdded = addOnsAdded;
        this.addOnsRemoved = addOnsRemoved;
        this.apiKey = apiKey;
        this.apiKeyRequest = apiKeyRequest;
        this.basePlan = basePlan;
        this.basePlanAction = basePlanAction;
        this.company = company;
        this.companyId = companyId;
        this.createdAt = createdAt;
        this.environmentId = environmentId;
        this.id = id;
        this.previousBasePlan = previousBasePlan;
        this.requestId = requestId;
        this.subscriptionChangeAction = subscriptionChangeAction;
        this.traitsUpdated = traitsUpdated;
        this.updatedAt = updatedAt;
        this.userId = userId;
        this.userName = userName;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("action")
    public PlanChangeResponseDataAction getAction() {
        return action;
    }

    @JsonProperty("actor_type")
    public PlanChangeResponseDataActorType getActorType() {
        return actorType;
    }

    @JsonProperty("add_ons_added")
    public List<PlanSnapshotView> getAddOnsAdded() {
        return addOnsAdded;
    }

    @JsonProperty("add_ons_removed")
    public List<PlanSnapshotView> getAddOnsRemoved() {
        return addOnsRemoved;
    }

    @JsonProperty("api_key")
    public Optional<ApiKeyResponseData> getApiKey() {
        return apiKey;
    }

    @JsonProperty("api_key_request")
    public Optional<ApiKeyRequestListResponseData> getApiKeyRequest() {
        return apiKeyRequest;
    }

    @JsonProperty("base_plan")
    public Optional<PlanSnapshotView> getBasePlan() {
        return basePlan;
    }

    /**
     * @return Any special behavior that affected the assignment of the base plan during this change.
     */
    @JsonProperty("base_plan_action")
    public Optional<PlanChangeResponseDataBasePlanAction> getBasePlanAction() {
        return basePlanAction;
    }

    @JsonProperty("company")
    public Optional<CompanyResponseData> getCompany() {
        return company;
    }

    @JsonProperty("company_id")
    public String getCompanyId() {
        return companyId;
    }

    @JsonProperty("created_at")
    public OffsetDateTime getCreatedAt() {
        return createdAt;
    }

    @JsonProperty("environment_id")
    public String getEnvironmentId() {
        return environmentId;
    }

    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @JsonProperty("previous_base_plan")
    public Optional<PlanSnapshotView> getPreviousBasePlan() {
        return previousBasePlan;
    }

    @JsonProperty("request_id")
    public Optional<String> getRequestId() {
        return requestId;
    }

    /**
     * @return If a subscription was changed as a part of this plan change, indicates the type of change that was made.
     */
    @JsonProperty("subscription_change_action")
    public Optional<PlanChangeResponseDataSubscriptionChangeAction> getSubscriptionChangeAction() {
        return subscriptionChangeAction;
    }

    /**
     * @return Any traits were updated as part of this plan change (via pay-in-advance entitlements).
     */
    @JsonProperty("traits_updated")
    public List<SubscriptionTraitUpdate> getTraitsUpdated() {
        return traitsUpdated;
    }

    @JsonProperty("updated_at")
    public OffsetDateTime getUpdatedAt() {
        return updatedAt;
    }

    @JsonProperty("user_id")
    public Optional<String> getUserId() {
        return userId;
    }

    @JsonProperty("user_name")
    public Optional<String> getUserName() {
        return userName;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof PlanChangeResponseData && equalTo((PlanChangeResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PlanChangeResponseData other) {
        return action.equals(other.action)
                && actorType.equals(other.actorType)
                && addOnsAdded.equals(other.addOnsAdded)
                && addOnsRemoved.equals(other.addOnsRemoved)
                && apiKey.equals(other.apiKey)
                && apiKeyRequest.equals(other.apiKeyRequest)
                && basePlan.equals(other.basePlan)
                && basePlanAction.equals(other.basePlanAction)
                && company.equals(other.company)
                && companyId.equals(other.companyId)
                && createdAt.equals(other.createdAt)
                && environmentId.equals(other.environmentId)
                && id.equals(other.id)
                && previousBasePlan.equals(other.previousBasePlan)
                && requestId.equals(other.requestId)
                && subscriptionChangeAction.equals(other.subscriptionChangeAction)
                && traitsUpdated.equals(other.traitsUpdated)
                && updatedAt.equals(other.updatedAt)
                && userId.equals(other.userId)
                && userName.equals(other.userName);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.action,
                this.actorType,
                this.addOnsAdded,
                this.addOnsRemoved,
                this.apiKey,
                this.apiKeyRequest,
                this.basePlan,
                this.basePlanAction,
                this.company,
                this.companyId,
                this.createdAt,
                this.environmentId,
                this.id,
                this.previousBasePlan,
                this.requestId,
                this.subscriptionChangeAction,
                this.traitsUpdated,
                this.updatedAt,
                this.userId,
                this.userName);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ActionStage builder() {
        return new Builder();
    }

    public interface ActionStage {
        ActorTypeStage action(@NotNull PlanChangeResponseDataAction action);

        Builder from(PlanChangeResponseData other);
    }

    public interface ActorTypeStage {
        CompanyIdStage actorType(@NotNull PlanChangeResponseDataActorType actorType);
    }

    public interface CompanyIdStage {
        CreatedAtStage companyId(@NotNull String companyId);
    }

    public interface CreatedAtStage {
        EnvironmentIdStage createdAt(@NotNull OffsetDateTime createdAt);
    }

    public interface EnvironmentIdStage {
        IdStage environmentId(@NotNull String environmentId);
    }

    public interface IdStage {
        UpdatedAtStage id(@NotNull String id);
    }

    public interface UpdatedAtStage {
        _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt);
    }

    public interface _FinalStage {
        PlanChangeResponseData build();

        _FinalStage addOnsAdded(List<PlanSnapshotView> addOnsAdded);

        _FinalStage addAddOnsAdded(PlanSnapshotView addOnsAdded);

        _FinalStage addAllAddOnsAdded(List<PlanSnapshotView> addOnsAdded);

        _FinalStage addOnsRemoved(List<PlanSnapshotView> addOnsRemoved);

        _FinalStage addAddOnsRemoved(PlanSnapshotView addOnsRemoved);

        _FinalStage addAllAddOnsRemoved(List<PlanSnapshotView> addOnsRemoved);

        _FinalStage apiKey(Optional<ApiKeyResponseData> apiKey);

        _FinalStage apiKey(ApiKeyResponseData apiKey);

        _FinalStage apiKeyRequest(Optional<ApiKeyRequestListResponseData> apiKeyRequest);

        _FinalStage apiKeyRequest(ApiKeyRequestListResponseData apiKeyRequest);

        _FinalStage basePlan(Optional<PlanSnapshotView> basePlan);

        _FinalStage basePlan(PlanSnapshotView basePlan);

        /**
         * <p>Any special behavior that affected the assignment of the base plan during this change.</p>
         */
        _FinalStage basePlanAction(Optional<PlanChangeResponseDataBasePlanAction> basePlanAction);

        _FinalStage basePlanAction(PlanChangeResponseDataBasePlanAction basePlanAction);

        _FinalStage company(Optional<CompanyResponseData> company);

        _FinalStage company(CompanyResponseData company);

        _FinalStage previousBasePlan(Optional<PlanSnapshotView> previousBasePlan);

        _FinalStage previousBasePlan(PlanSnapshotView previousBasePlan);

        _FinalStage requestId(Optional<String> requestId);

        _FinalStage requestId(String requestId);

        /**
         * <p>If a subscription was changed as a part of this plan change, indicates the type of change that was made.</p>
         */
        _FinalStage subscriptionChangeAction(
                Optional<PlanChangeResponseDataSubscriptionChangeAction> subscriptionChangeAction);

        _FinalStage subscriptionChangeAction(PlanChangeResponseDataSubscriptionChangeAction subscriptionChangeAction);

        /**
         * <p>Any traits were updated as part of this plan change (via pay-in-advance entitlements).</p>
         */
        _FinalStage traitsUpdated(List<SubscriptionTraitUpdate> traitsUpdated);

        _FinalStage addTraitsUpdated(SubscriptionTraitUpdate traitsUpdated);

        _FinalStage addAllTraitsUpdated(List<SubscriptionTraitUpdate> traitsUpdated);

        _FinalStage userId(Optional<String> userId);

        _FinalStage userId(String userId);

        _FinalStage userName(Optional<String> userName);

        _FinalStage userName(String userName);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements ActionStage,
                    ActorTypeStage,
                    CompanyIdStage,
                    CreatedAtStage,
                    EnvironmentIdStage,
                    IdStage,
                    UpdatedAtStage,
                    _FinalStage {
        private PlanChangeResponseDataAction action;

        private PlanChangeResponseDataActorType actorType;

        private String companyId;

        private OffsetDateTime createdAt;

        private String environmentId;

        private String id;

        private OffsetDateTime updatedAt;

        private Optional<String> userName = Optional.empty();

        private Optional<String> userId = Optional.empty();

        private List<SubscriptionTraitUpdate> traitsUpdated = new ArrayList<>();

        private Optional<PlanChangeResponseDataSubscriptionChangeAction> subscriptionChangeAction = Optional.empty();

        private Optional<String> requestId = Optional.empty();

        private Optional<PlanSnapshotView> previousBasePlan = Optional.empty();

        private Optional<CompanyResponseData> company = Optional.empty();

        private Optional<PlanChangeResponseDataBasePlanAction> basePlanAction = Optional.empty();

        private Optional<PlanSnapshotView> basePlan = Optional.empty();

        private Optional<ApiKeyRequestListResponseData> apiKeyRequest = Optional.empty();

        private Optional<ApiKeyResponseData> apiKey = Optional.empty();

        private List<PlanSnapshotView> addOnsRemoved = new ArrayList<>();

        private List<PlanSnapshotView> addOnsAdded = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(PlanChangeResponseData other) {
            action(other.getAction());
            actorType(other.getActorType());
            addOnsAdded(other.getAddOnsAdded());
            addOnsRemoved(other.getAddOnsRemoved());
            apiKey(other.getApiKey());
            apiKeyRequest(other.getApiKeyRequest());
            basePlan(other.getBasePlan());
            basePlanAction(other.getBasePlanAction());
            company(other.getCompany());
            companyId(other.getCompanyId());
            createdAt(other.getCreatedAt());
            environmentId(other.getEnvironmentId());
            id(other.getId());
            previousBasePlan(other.getPreviousBasePlan());
            requestId(other.getRequestId());
            subscriptionChangeAction(other.getSubscriptionChangeAction());
            traitsUpdated(other.getTraitsUpdated());
            updatedAt(other.getUpdatedAt());
            userId(other.getUserId());
            userName(other.getUserName());
            return this;
        }

        @java.lang.Override
        @JsonSetter("action")
        public ActorTypeStage action(@NotNull PlanChangeResponseDataAction action) {
            this.action = Objects.requireNonNull(action, "action must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("actor_type")
        public CompanyIdStage actorType(@NotNull PlanChangeResponseDataActorType actorType) {
            this.actorType = Objects.requireNonNull(actorType, "actorType must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("company_id")
        public CreatedAtStage companyId(@NotNull String companyId) {
            this.companyId = Objects.requireNonNull(companyId, "companyId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("created_at")
        public EnvironmentIdStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("environment_id")
        public IdStage environmentId(@NotNull String environmentId) {
            this.environmentId = Objects.requireNonNull(environmentId, "environmentId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("id")
        public UpdatedAtStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage userName(String userName) {
            this.userName = Optional.ofNullable(userName);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "user_name", nulls = Nulls.SKIP)
        public _FinalStage userName(Optional<String> userName) {
            this.userName = userName;
            return this;
        }

        @java.lang.Override
        public _FinalStage userId(String userId) {
            this.userId = Optional.ofNullable(userId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "user_id", nulls = Nulls.SKIP)
        public _FinalStage userId(Optional<String> userId) {
            this.userId = userId;
            return this;
        }

        /**
         * <p>Any traits were updated as part of this plan change (via pay-in-advance entitlements).</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addAllTraitsUpdated(List<SubscriptionTraitUpdate> traitsUpdated) {
            if (traitsUpdated != null) {
                this.traitsUpdated.addAll(traitsUpdated);
            }
            return this;
        }

        /**
         * <p>Any traits were updated as part of this plan change (via pay-in-advance entitlements).</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addTraitsUpdated(SubscriptionTraitUpdate traitsUpdated) {
            this.traitsUpdated.add(traitsUpdated);
            return this;
        }

        /**
         * <p>Any traits were updated as part of this plan change (via pay-in-advance entitlements).</p>
         */
        @java.lang.Override
        @JsonSetter(value = "traits_updated", nulls = Nulls.SKIP)
        public _FinalStage traitsUpdated(List<SubscriptionTraitUpdate> traitsUpdated) {
            this.traitsUpdated.clear();
            if (traitsUpdated != null) {
                this.traitsUpdated.addAll(traitsUpdated);
            }
            return this;
        }

        /**
         * <p>If a subscription was changed as a part of this plan change, indicates the type of change that was made.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage subscriptionChangeAction(
                PlanChangeResponseDataSubscriptionChangeAction subscriptionChangeAction) {
            this.subscriptionChangeAction = Optional.ofNullable(subscriptionChangeAction);
            return this;
        }

        /**
         * <p>If a subscription was changed as a part of this plan change, indicates the type of change that was made.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "subscription_change_action", nulls = Nulls.SKIP)
        public _FinalStage subscriptionChangeAction(
                Optional<PlanChangeResponseDataSubscriptionChangeAction> subscriptionChangeAction) {
            this.subscriptionChangeAction = subscriptionChangeAction;
            return this;
        }

        @java.lang.Override
        public _FinalStage requestId(String requestId) {
            this.requestId = Optional.ofNullable(requestId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "request_id", nulls = Nulls.SKIP)
        public _FinalStage requestId(Optional<String> requestId) {
            this.requestId = requestId;
            return this;
        }

        @java.lang.Override
        public _FinalStage previousBasePlan(PlanSnapshotView previousBasePlan) {
            this.previousBasePlan = Optional.ofNullable(previousBasePlan);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "previous_base_plan", nulls = Nulls.SKIP)
        public _FinalStage previousBasePlan(Optional<PlanSnapshotView> previousBasePlan) {
            this.previousBasePlan = previousBasePlan;
            return this;
        }

        @java.lang.Override
        public _FinalStage company(CompanyResponseData company) {
            this.company = Optional.ofNullable(company);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "company", nulls = Nulls.SKIP)
        public _FinalStage company(Optional<CompanyResponseData> company) {
            this.company = company;
            return this;
        }

        /**
         * <p>Any special behavior that affected the assignment of the base plan during this change.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage basePlanAction(PlanChangeResponseDataBasePlanAction basePlanAction) {
            this.basePlanAction = Optional.ofNullable(basePlanAction);
            return this;
        }

        /**
         * <p>Any special behavior that affected the assignment of the base plan during this change.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "base_plan_action", nulls = Nulls.SKIP)
        public _FinalStage basePlanAction(Optional<PlanChangeResponseDataBasePlanAction> basePlanAction) {
            this.basePlanAction = basePlanAction;
            return this;
        }

        @java.lang.Override
        public _FinalStage basePlan(PlanSnapshotView basePlan) {
            this.basePlan = Optional.ofNullable(basePlan);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "base_plan", nulls = Nulls.SKIP)
        public _FinalStage basePlan(Optional<PlanSnapshotView> basePlan) {
            this.basePlan = basePlan;
            return this;
        }

        @java.lang.Override
        public _FinalStage apiKeyRequest(ApiKeyRequestListResponseData apiKeyRequest) {
            this.apiKeyRequest = Optional.ofNullable(apiKeyRequest);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "api_key_request", nulls = Nulls.SKIP)
        public _FinalStage apiKeyRequest(Optional<ApiKeyRequestListResponseData> apiKeyRequest) {
            this.apiKeyRequest = apiKeyRequest;
            return this;
        }

        @java.lang.Override
        public _FinalStage apiKey(ApiKeyResponseData apiKey) {
            this.apiKey = Optional.ofNullable(apiKey);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "api_key", nulls = Nulls.SKIP)
        public _FinalStage apiKey(Optional<ApiKeyResponseData> apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllAddOnsRemoved(List<PlanSnapshotView> addOnsRemoved) {
            if (addOnsRemoved != null) {
                this.addOnsRemoved.addAll(addOnsRemoved);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addAddOnsRemoved(PlanSnapshotView addOnsRemoved) {
            this.addOnsRemoved.add(addOnsRemoved);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "add_ons_removed", nulls = Nulls.SKIP)
        public _FinalStage addOnsRemoved(List<PlanSnapshotView> addOnsRemoved) {
            this.addOnsRemoved.clear();
            if (addOnsRemoved != null) {
                this.addOnsRemoved.addAll(addOnsRemoved);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllAddOnsAdded(List<PlanSnapshotView> addOnsAdded) {
            if (addOnsAdded != null) {
                this.addOnsAdded.addAll(addOnsAdded);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addAddOnsAdded(PlanSnapshotView addOnsAdded) {
            this.addOnsAdded.add(addOnsAdded);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "add_ons_added", nulls = Nulls.SKIP)
        public _FinalStage addOnsAdded(List<PlanSnapshotView> addOnsAdded) {
            this.addOnsAdded.clear();
            if (addOnsAdded != null) {
                this.addOnsAdded.addAll(addOnsAdded);
            }
            return this;
        }

        @java.lang.Override
        public PlanChangeResponseData build() {
            return new PlanChangeResponseData(
                    action,
                    actorType,
                    addOnsAdded,
                    addOnsRemoved,
                    apiKey,
                    apiKeyRequest,
                    basePlan,
                    basePlanAction,
                    company,
                    companyId,
                    createdAt,
                    environmentId,
                    id,
                    previousBasePlan,
                    requestId,
                    subscriptionChangeAction,
                    traitsUpdated,
                    updatedAt,
                    userId,
                    userName,
                    additionalProperties);
        }
    }
}
