/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = PlanCreditGrantView.Builder.class)
public final class PlanCreditGrantView {
    private final OffsetDateTime createdAt;

    private final int creditAmount;

    private final String creditDescription;

    private final Optional<String> creditIcon;

    private final String creditId;

    private final String creditName;

    private final Optional<String> expiryType;

    private final Optional<String> expiryUnit;

    private final Optional<Integer> expiryUnitCount;

    private final String id;

    private final String planId;

    private final String planName;

    private final Optional<String> pluralName;

    private final String resetCadence;

    private final String resetStart;

    private final String resetType;

    private final Optional<String> singularName;

    private final OffsetDateTime updatedAt;

    private final Map<String, Object> additionalProperties;

    private PlanCreditGrantView(
            OffsetDateTime createdAt,
            int creditAmount,
            String creditDescription,
            Optional<String> creditIcon,
            String creditId,
            String creditName,
            Optional<String> expiryType,
            Optional<String> expiryUnit,
            Optional<Integer> expiryUnitCount,
            String id,
            String planId,
            String planName,
            Optional<String> pluralName,
            String resetCadence,
            String resetStart,
            String resetType,
            Optional<String> singularName,
            OffsetDateTime updatedAt,
            Map<String, Object> additionalProperties) {
        this.createdAt = createdAt;
        this.creditAmount = creditAmount;
        this.creditDescription = creditDescription;
        this.creditIcon = creditIcon;
        this.creditId = creditId;
        this.creditName = creditName;
        this.expiryType = expiryType;
        this.expiryUnit = expiryUnit;
        this.expiryUnitCount = expiryUnitCount;
        this.id = id;
        this.planId = planId;
        this.planName = planName;
        this.pluralName = pluralName;
        this.resetCadence = resetCadence;
        this.resetStart = resetStart;
        this.resetType = resetType;
        this.singularName = singularName;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("created_at")
    public OffsetDateTime getCreatedAt() {
        return createdAt;
    }

    @JsonProperty("credit_amount")
    public int getCreditAmount() {
        return creditAmount;
    }

    @JsonProperty("credit_description")
    public String getCreditDescription() {
        return creditDescription;
    }

    @JsonProperty("credit_icon")
    public Optional<String> getCreditIcon() {
        return creditIcon;
    }

    @JsonProperty("credit_id")
    public String getCreditId() {
        return creditId;
    }

    @JsonProperty("credit_name")
    public String getCreditName() {
        return creditName;
    }

    @JsonProperty("expiry_type")
    public Optional<String> getExpiryType() {
        return expiryType;
    }

    @JsonProperty("expiry_unit")
    public Optional<String> getExpiryUnit() {
        return expiryUnit;
    }

    @JsonProperty("expiry_unit_count")
    public Optional<Integer> getExpiryUnitCount() {
        return expiryUnitCount;
    }

    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @JsonProperty("plan_id")
    public String getPlanId() {
        return planId;
    }

    @JsonProperty("plan_name")
    public String getPlanName() {
        return planName;
    }

    @JsonProperty("plural_name")
    public Optional<String> getPluralName() {
        return pluralName;
    }

    @JsonProperty("reset_cadence")
    public String getResetCadence() {
        return resetCadence;
    }

    @JsonProperty("reset_start")
    public String getResetStart() {
        return resetStart;
    }

    @JsonProperty("reset_type")
    public String getResetType() {
        return resetType;
    }

    @JsonProperty("singular_name")
    public Optional<String> getSingularName() {
        return singularName;
    }

    @JsonProperty("updated_at")
    public OffsetDateTime getUpdatedAt() {
        return updatedAt;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof PlanCreditGrantView && equalTo((PlanCreditGrantView) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PlanCreditGrantView other) {
        return createdAt.equals(other.createdAt)
                && creditAmount == other.creditAmount
                && creditDescription.equals(other.creditDescription)
                && creditIcon.equals(other.creditIcon)
                && creditId.equals(other.creditId)
                && creditName.equals(other.creditName)
                && expiryType.equals(other.expiryType)
                && expiryUnit.equals(other.expiryUnit)
                && expiryUnitCount.equals(other.expiryUnitCount)
                && id.equals(other.id)
                && planId.equals(other.planId)
                && planName.equals(other.planName)
                && pluralName.equals(other.pluralName)
                && resetCadence.equals(other.resetCadence)
                && resetStart.equals(other.resetStart)
                && resetType.equals(other.resetType)
                && singularName.equals(other.singularName)
                && updatedAt.equals(other.updatedAt);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.createdAt,
                this.creditAmount,
                this.creditDescription,
                this.creditIcon,
                this.creditId,
                this.creditName,
                this.expiryType,
                this.expiryUnit,
                this.expiryUnitCount,
                this.id,
                this.planId,
                this.planName,
                this.pluralName,
                this.resetCadence,
                this.resetStart,
                this.resetType,
                this.singularName,
                this.updatedAt);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CreatedAtStage builder() {
        return new Builder();
    }

    public interface CreatedAtStage {
        CreditAmountStage createdAt(@NotNull OffsetDateTime createdAt);

        Builder from(PlanCreditGrantView other);
    }

    public interface CreditAmountStage {
        CreditDescriptionStage creditAmount(int creditAmount);
    }

    public interface CreditDescriptionStage {
        CreditIdStage creditDescription(@NotNull String creditDescription);
    }

    public interface CreditIdStage {
        CreditNameStage creditId(@NotNull String creditId);
    }

    public interface CreditNameStage {
        IdStage creditName(@NotNull String creditName);
    }

    public interface IdStage {
        PlanIdStage id(@NotNull String id);
    }

    public interface PlanIdStage {
        PlanNameStage planId(@NotNull String planId);
    }

    public interface PlanNameStage {
        ResetCadenceStage planName(@NotNull String planName);
    }

    public interface ResetCadenceStage {
        ResetStartStage resetCadence(@NotNull String resetCadence);
    }

    public interface ResetStartStage {
        ResetTypeStage resetStart(@NotNull String resetStart);
    }

    public interface ResetTypeStage {
        UpdatedAtStage resetType(@NotNull String resetType);
    }

    public interface UpdatedAtStage {
        _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt);
    }

    public interface _FinalStage {
        PlanCreditGrantView build();

        _FinalStage creditIcon(Optional<String> creditIcon);

        _FinalStage creditIcon(String creditIcon);

        _FinalStage expiryType(Optional<String> expiryType);

        _FinalStage expiryType(String expiryType);

        _FinalStage expiryUnit(Optional<String> expiryUnit);

        _FinalStage expiryUnit(String expiryUnit);

        _FinalStage expiryUnitCount(Optional<Integer> expiryUnitCount);

        _FinalStage expiryUnitCount(Integer expiryUnitCount);

        _FinalStage pluralName(Optional<String> pluralName);

        _FinalStage pluralName(String pluralName);

        _FinalStage singularName(Optional<String> singularName);

        _FinalStage singularName(String singularName);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements CreatedAtStage,
                    CreditAmountStage,
                    CreditDescriptionStage,
                    CreditIdStage,
                    CreditNameStage,
                    IdStage,
                    PlanIdStage,
                    PlanNameStage,
                    ResetCadenceStage,
                    ResetStartStage,
                    ResetTypeStage,
                    UpdatedAtStage,
                    _FinalStage {
        private OffsetDateTime createdAt;

        private int creditAmount;

        private String creditDescription;

        private String creditId;

        private String creditName;

        private String id;

        private String planId;

        private String planName;

        private String resetCadence;

        private String resetStart;

        private String resetType;

        private OffsetDateTime updatedAt;

        private Optional<String> singularName = Optional.empty();

        private Optional<String> pluralName = Optional.empty();

        private Optional<Integer> expiryUnitCount = Optional.empty();

        private Optional<String> expiryUnit = Optional.empty();

        private Optional<String> expiryType = Optional.empty();

        private Optional<String> creditIcon = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(PlanCreditGrantView other) {
            createdAt(other.getCreatedAt());
            creditAmount(other.getCreditAmount());
            creditDescription(other.getCreditDescription());
            creditIcon(other.getCreditIcon());
            creditId(other.getCreditId());
            creditName(other.getCreditName());
            expiryType(other.getExpiryType());
            expiryUnit(other.getExpiryUnit());
            expiryUnitCount(other.getExpiryUnitCount());
            id(other.getId());
            planId(other.getPlanId());
            planName(other.getPlanName());
            pluralName(other.getPluralName());
            resetCadence(other.getResetCadence());
            resetStart(other.getResetStart());
            resetType(other.getResetType());
            singularName(other.getSingularName());
            updatedAt(other.getUpdatedAt());
            return this;
        }

        @java.lang.Override
        @JsonSetter("created_at")
        public CreditAmountStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("credit_amount")
        public CreditDescriptionStage creditAmount(int creditAmount) {
            this.creditAmount = creditAmount;
            return this;
        }

        @java.lang.Override
        @JsonSetter("credit_description")
        public CreditIdStage creditDescription(@NotNull String creditDescription) {
            this.creditDescription = Objects.requireNonNull(creditDescription, "creditDescription must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("credit_id")
        public CreditNameStage creditId(@NotNull String creditId) {
            this.creditId = Objects.requireNonNull(creditId, "creditId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("credit_name")
        public IdStage creditName(@NotNull String creditName) {
            this.creditName = Objects.requireNonNull(creditName, "creditName must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("id")
        public PlanIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("plan_id")
        public PlanNameStage planId(@NotNull String planId) {
            this.planId = Objects.requireNonNull(planId, "planId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("plan_name")
        public ResetCadenceStage planName(@NotNull String planName) {
            this.planName = Objects.requireNonNull(planName, "planName must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("reset_cadence")
        public ResetStartStage resetCadence(@NotNull String resetCadence) {
            this.resetCadence = Objects.requireNonNull(resetCadence, "resetCadence must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("reset_start")
        public ResetTypeStage resetStart(@NotNull String resetStart) {
            this.resetStart = Objects.requireNonNull(resetStart, "resetStart must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("reset_type")
        public UpdatedAtStage resetType(@NotNull String resetType) {
            this.resetType = Objects.requireNonNull(resetType, "resetType must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage singularName(String singularName) {
            this.singularName = Optional.ofNullable(singularName);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "singular_name", nulls = Nulls.SKIP)
        public _FinalStage singularName(Optional<String> singularName) {
            this.singularName = singularName;
            return this;
        }

        @java.lang.Override
        public _FinalStage pluralName(String pluralName) {
            this.pluralName = Optional.ofNullable(pluralName);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "plural_name", nulls = Nulls.SKIP)
        public _FinalStage pluralName(Optional<String> pluralName) {
            this.pluralName = pluralName;
            return this;
        }

        @java.lang.Override
        public _FinalStage expiryUnitCount(Integer expiryUnitCount) {
            this.expiryUnitCount = Optional.ofNullable(expiryUnitCount);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "expiry_unit_count", nulls = Nulls.SKIP)
        public _FinalStage expiryUnitCount(Optional<Integer> expiryUnitCount) {
            this.expiryUnitCount = expiryUnitCount;
            return this;
        }

        @java.lang.Override
        public _FinalStage expiryUnit(String expiryUnit) {
            this.expiryUnit = Optional.ofNullable(expiryUnit);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "expiry_unit", nulls = Nulls.SKIP)
        public _FinalStage expiryUnit(Optional<String> expiryUnit) {
            this.expiryUnit = expiryUnit;
            return this;
        }

        @java.lang.Override
        public _FinalStage expiryType(String expiryType) {
            this.expiryType = Optional.ofNullable(expiryType);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "expiry_type", nulls = Nulls.SKIP)
        public _FinalStage expiryType(Optional<String> expiryType) {
            this.expiryType = expiryType;
            return this;
        }

        @java.lang.Override
        public _FinalStage creditIcon(String creditIcon) {
            this.creditIcon = Optional.ofNullable(creditIcon);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "credit_icon", nulls = Nulls.SKIP)
        public _FinalStage creditIcon(Optional<String> creditIcon) {
            this.creditIcon = creditIcon;
            return this;
        }

        @java.lang.Override
        public PlanCreditGrantView build() {
            return new PlanCreditGrantView(
                    createdAt,
                    creditAmount,
                    creditDescription,
                    creditIcon,
                    creditId,
                    creditName,
                    expiryType,
                    expiryUnit,
                    expiryUnitCount,
                    id,
                    planId,
                    planName,
                    pluralName,
                    resetCadence,
                    resetStart,
                    resetType,
                    singularName,
                    updatedAt,
                    additionalProperties);
        }
    }
}
