/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = PlanDetailResponseData.Builder.class)
public final class PlanDetailResponseData {
    private final Optional<String> audienceType;

    private final Optional<BillingProductDetailResponseData> billingProduct;

    private final String chargeType;

    private final int companyCount;

    private final String controlledBy;

    private final OffsetDateTime createdAt;

    private final String description;

    private final List<FeatureDetailResponseData> features;

    private final String icon;

    private final String id;

    private final Optional<List<BillingPlanCreditGrantResponseData>> includedCreditGrants;

    private final boolean isDefault;

    private final boolean isFree;

    private final boolean isTrialable;

    private final Optional<BillingPriceResponseData> monthlyPrice;

    private final String name;

    private final Optional<BillingPriceResponseData> oneTimePrice;

    private final String planType;

    private final Optional<Integer> trialDays;

    private final OffsetDateTime updatedAt;

    private final Optional<BillingPriceResponseData> yearlyPrice;

    private final Map<String, Object> additionalProperties;

    private PlanDetailResponseData(
            Optional<String> audienceType,
            Optional<BillingProductDetailResponseData> billingProduct,
            String chargeType,
            int companyCount,
            String controlledBy,
            OffsetDateTime createdAt,
            String description,
            List<FeatureDetailResponseData> features,
            String icon,
            String id,
            Optional<List<BillingPlanCreditGrantResponseData>> includedCreditGrants,
            boolean isDefault,
            boolean isFree,
            boolean isTrialable,
            Optional<BillingPriceResponseData> monthlyPrice,
            String name,
            Optional<BillingPriceResponseData> oneTimePrice,
            String planType,
            Optional<Integer> trialDays,
            OffsetDateTime updatedAt,
            Optional<BillingPriceResponseData> yearlyPrice,
            Map<String, Object> additionalProperties) {
        this.audienceType = audienceType;
        this.billingProduct = billingProduct;
        this.chargeType = chargeType;
        this.companyCount = companyCount;
        this.controlledBy = controlledBy;
        this.createdAt = createdAt;
        this.description = description;
        this.features = features;
        this.icon = icon;
        this.id = id;
        this.includedCreditGrants = includedCreditGrants;
        this.isDefault = isDefault;
        this.isFree = isFree;
        this.isTrialable = isTrialable;
        this.monthlyPrice = monthlyPrice;
        this.name = name;
        this.oneTimePrice = oneTimePrice;
        this.planType = planType;
        this.trialDays = trialDays;
        this.updatedAt = updatedAt;
        this.yearlyPrice = yearlyPrice;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("audience_type")
    public Optional<String> getAudienceType() {
        return audienceType;
    }

    @JsonProperty("billing_product")
    public Optional<BillingProductDetailResponseData> getBillingProduct() {
        return billingProduct;
    }

    @JsonProperty("charge_type")
    public String getChargeType() {
        return chargeType;
    }

    @JsonProperty("company_count")
    public int getCompanyCount() {
        return companyCount;
    }

    @JsonProperty("controlled_by")
    public String getControlledBy() {
        return controlledBy;
    }

    @JsonProperty("created_at")
    public OffsetDateTime getCreatedAt() {
        return createdAt;
    }

    @JsonProperty("description")
    public String getDescription() {
        return description;
    }

    @JsonProperty("features")
    public List<FeatureDetailResponseData> getFeatures() {
        return features;
    }

    @JsonProperty("icon")
    public String getIcon() {
        return icon;
    }

    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @JsonProperty("included_credit_grants")
    public Optional<List<BillingPlanCreditGrantResponseData>> getIncludedCreditGrants() {
        return includedCreditGrants;
    }

    @JsonProperty("is_default")
    public boolean getIsDefault() {
        return isDefault;
    }

    @JsonProperty("is_free")
    public boolean getIsFree() {
        return isFree;
    }

    @JsonProperty("is_trialable")
    public boolean getIsTrialable() {
        return isTrialable;
    }

    @JsonProperty("monthly_price")
    public Optional<BillingPriceResponseData> getMonthlyPrice() {
        return monthlyPrice;
    }

    @JsonProperty("name")
    public String getName() {
        return name;
    }

    @JsonProperty("one_time_price")
    public Optional<BillingPriceResponseData> getOneTimePrice() {
        return oneTimePrice;
    }

    @JsonProperty("plan_type")
    public String getPlanType() {
        return planType;
    }

    @JsonProperty("trial_days")
    public Optional<Integer> getTrialDays() {
        return trialDays;
    }

    @JsonProperty("updated_at")
    public OffsetDateTime getUpdatedAt() {
        return updatedAt;
    }

    @JsonProperty("yearly_price")
    public Optional<BillingPriceResponseData> getYearlyPrice() {
        return yearlyPrice;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof PlanDetailResponseData && equalTo((PlanDetailResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PlanDetailResponseData other) {
        return audienceType.equals(other.audienceType)
                && billingProduct.equals(other.billingProduct)
                && chargeType.equals(other.chargeType)
                && companyCount == other.companyCount
                && controlledBy.equals(other.controlledBy)
                && createdAt.equals(other.createdAt)
                && description.equals(other.description)
                && features.equals(other.features)
                && icon.equals(other.icon)
                && id.equals(other.id)
                && includedCreditGrants.equals(other.includedCreditGrants)
                && isDefault == other.isDefault
                && isFree == other.isFree
                && isTrialable == other.isTrialable
                && monthlyPrice.equals(other.monthlyPrice)
                && name.equals(other.name)
                && oneTimePrice.equals(other.oneTimePrice)
                && planType.equals(other.planType)
                && trialDays.equals(other.trialDays)
                && updatedAt.equals(other.updatedAt)
                && yearlyPrice.equals(other.yearlyPrice);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.audienceType,
                this.billingProduct,
                this.chargeType,
                this.companyCount,
                this.controlledBy,
                this.createdAt,
                this.description,
                this.features,
                this.icon,
                this.id,
                this.includedCreditGrants,
                this.isDefault,
                this.isFree,
                this.isTrialable,
                this.monthlyPrice,
                this.name,
                this.oneTimePrice,
                this.planType,
                this.trialDays,
                this.updatedAt,
                this.yearlyPrice);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ChargeTypeStage builder() {
        return new Builder();
    }

    public interface ChargeTypeStage {
        CompanyCountStage chargeType(@NotNull String chargeType);

        Builder from(PlanDetailResponseData other);
    }

    public interface CompanyCountStage {
        ControlledByStage companyCount(int companyCount);
    }

    public interface ControlledByStage {
        CreatedAtStage controlledBy(@NotNull String controlledBy);
    }

    public interface CreatedAtStage {
        DescriptionStage createdAt(@NotNull OffsetDateTime createdAt);
    }

    public interface DescriptionStage {
        IconStage description(@NotNull String description);
    }

    public interface IconStage {
        IdStage icon(@NotNull String icon);
    }

    public interface IdStage {
        IsDefaultStage id(@NotNull String id);
    }

    public interface IsDefaultStage {
        IsFreeStage isDefault(boolean isDefault);
    }

    public interface IsFreeStage {
        IsTrialableStage isFree(boolean isFree);
    }

    public interface IsTrialableStage {
        NameStage isTrialable(boolean isTrialable);
    }

    public interface NameStage {
        PlanTypeStage name(@NotNull String name);
    }

    public interface PlanTypeStage {
        UpdatedAtStage planType(@NotNull String planType);
    }

    public interface UpdatedAtStage {
        _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt);
    }

    public interface _FinalStage {
        PlanDetailResponseData build();

        _FinalStage audienceType(Optional<String> audienceType);

        _FinalStage audienceType(String audienceType);

        _FinalStage billingProduct(Optional<BillingProductDetailResponseData> billingProduct);

        _FinalStage billingProduct(BillingProductDetailResponseData billingProduct);

        _FinalStage features(List<FeatureDetailResponseData> features);

        _FinalStage addFeatures(FeatureDetailResponseData features);

        _FinalStage addAllFeatures(List<FeatureDetailResponseData> features);

        _FinalStage includedCreditGrants(Optional<List<BillingPlanCreditGrantResponseData>> includedCreditGrants);

        _FinalStage includedCreditGrants(List<BillingPlanCreditGrantResponseData> includedCreditGrants);

        _FinalStage monthlyPrice(Optional<BillingPriceResponseData> monthlyPrice);

        _FinalStage monthlyPrice(BillingPriceResponseData monthlyPrice);

        _FinalStage oneTimePrice(Optional<BillingPriceResponseData> oneTimePrice);

        _FinalStage oneTimePrice(BillingPriceResponseData oneTimePrice);

        _FinalStage trialDays(Optional<Integer> trialDays);

        _FinalStage trialDays(Integer trialDays);

        _FinalStage yearlyPrice(Optional<BillingPriceResponseData> yearlyPrice);

        _FinalStage yearlyPrice(BillingPriceResponseData yearlyPrice);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements ChargeTypeStage,
                    CompanyCountStage,
                    ControlledByStage,
                    CreatedAtStage,
                    DescriptionStage,
                    IconStage,
                    IdStage,
                    IsDefaultStage,
                    IsFreeStage,
                    IsTrialableStage,
                    NameStage,
                    PlanTypeStage,
                    UpdatedAtStage,
                    _FinalStage {
        private String chargeType;

        private int companyCount;

        private String controlledBy;

        private OffsetDateTime createdAt;

        private String description;

        private String icon;

        private String id;

        private boolean isDefault;

        private boolean isFree;

        private boolean isTrialable;

        private String name;

        private String planType;

        private OffsetDateTime updatedAt;

        private Optional<BillingPriceResponseData> yearlyPrice = Optional.empty();

        private Optional<Integer> trialDays = Optional.empty();

        private Optional<BillingPriceResponseData> oneTimePrice = Optional.empty();

        private Optional<BillingPriceResponseData> monthlyPrice = Optional.empty();

        private Optional<List<BillingPlanCreditGrantResponseData>> includedCreditGrants = Optional.empty();

        private List<FeatureDetailResponseData> features = new ArrayList<>();

        private Optional<BillingProductDetailResponseData> billingProduct = Optional.empty();

        private Optional<String> audienceType = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(PlanDetailResponseData other) {
            audienceType(other.getAudienceType());
            billingProduct(other.getBillingProduct());
            chargeType(other.getChargeType());
            companyCount(other.getCompanyCount());
            controlledBy(other.getControlledBy());
            createdAt(other.getCreatedAt());
            description(other.getDescription());
            features(other.getFeatures());
            icon(other.getIcon());
            id(other.getId());
            includedCreditGrants(other.getIncludedCreditGrants());
            isDefault(other.getIsDefault());
            isFree(other.getIsFree());
            isTrialable(other.getIsTrialable());
            monthlyPrice(other.getMonthlyPrice());
            name(other.getName());
            oneTimePrice(other.getOneTimePrice());
            planType(other.getPlanType());
            trialDays(other.getTrialDays());
            updatedAt(other.getUpdatedAt());
            yearlyPrice(other.getYearlyPrice());
            return this;
        }

        @java.lang.Override
        @JsonSetter("charge_type")
        public CompanyCountStage chargeType(@NotNull String chargeType) {
            this.chargeType = Objects.requireNonNull(chargeType, "chargeType must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("company_count")
        public ControlledByStage companyCount(int companyCount) {
            this.companyCount = companyCount;
            return this;
        }

        @java.lang.Override
        @JsonSetter("controlled_by")
        public CreatedAtStage controlledBy(@NotNull String controlledBy) {
            this.controlledBy = Objects.requireNonNull(controlledBy, "controlledBy must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("created_at")
        public DescriptionStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("description")
        public IconStage description(@NotNull String description) {
            this.description = Objects.requireNonNull(description, "description must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("icon")
        public IdStage icon(@NotNull String icon) {
            this.icon = Objects.requireNonNull(icon, "icon must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("id")
        public IsDefaultStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("is_default")
        public IsFreeStage isDefault(boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        @java.lang.Override
        @JsonSetter("is_free")
        public IsTrialableStage isFree(boolean isFree) {
            this.isFree = isFree;
            return this;
        }

        @java.lang.Override
        @JsonSetter("is_trialable")
        public NameStage isTrialable(boolean isTrialable) {
            this.isTrialable = isTrialable;
            return this;
        }

        @java.lang.Override
        @JsonSetter("name")
        public PlanTypeStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("plan_type")
        public UpdatedAtStage planType(@NotNull String planType) {
            this.planType = Objects.requireNonNull(planType, "planType must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage yearlyPrice(BillingPriceResponseData yearlyPrice) {
            this.yearlyPrice = Optional.ofNullable(yearlyPrice);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "yearly_price", nulls = Nulls.SKIP)
        public _FinalStage yearlyPrice(Optional<BillingPriceResponseData> yearlyPrice) {
            this.yearlyPrice = yearlyPrice;
            return this;
        }

        @java.lang.Override
        public _FinalStage trialDays(Integer trialDays) {
            this.trialDays = Optional.ofNullable(trialDays);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "trial_days", nulls = Nulls.SKIP)
        public _FinalStage trialDays(Optional<Integer> trialDays) {
            this.trialDays = trialDays;
            return this;
        }

        @java.lang.Override
        public _FinalStage oneTimePrice(BillingPriceResponseData oneTimePrice) {
            this.oneTimePrice = Optional.ofNullable(oneTimePrice);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "one_time_price", nulls = Nulls.SKIP)
        public _FinalStage oneTimePrice(Optional<BillingPriceResponseData> oneTimePrice) {
            this.oneTimePrice = oneTimePrice;
            return this;
        }

        @java.lang.Override
        public _FinalStage monthlyPrice(BillingPriceResponseData monthlyPrice) {
            this.monthlyPrice = Optional.ofNullable(monthlyPrice);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "monthly_price", nulls = Nulls.SKIP)
        public _FinalStage monthlyPrice(Optional<BillingPriceResponseData> monthlyPrice) {
            this.monthlyPrice = monthlyPrice;
            return this;
        }

        @java.lang.Override
        public _FinalStage includedCreditGrants(List<BillingPlanCreditGrantResponseData> includedCreditGrants) {
            this.includedCreditGrants = Optional.ofNullable(includedCreditGrants);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "included_credit_grants", nulls = Nulls.SKIP)
        public _FinalStage includedCreditGrants(
                Optional<List<BillingPlanCreditGrantResponseData>> includedCreditGrants) {
            this.includedCreditGrants = includedCreditGrants;
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllFeatures(List<FeatureDetailResponseData> features) {
            if (features != null) {
                this.features.addAll(features);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addFeatures(FeatureDetailResponseData features) {
            this.features.add(features);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "features", nulls = Nulls.SKIP)
        public _FinalStage features(List<FeatureDetailResponseData> features) {
            this.features.clear();
            if (features != null) {
                this.features.addAll(features);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage billingProduct(BillingProductDetailResponseData billingProduct) {
            this.billingProduct = Optional.ofNullable(billingProduct);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "billing_product", nulls = Nulls.SKIP)
        public _FinalStage billingProduct(Optional<BillingProductDetailResponseData> billingProduct) {
            this.billingProduct = billingProduct;
            return this;
        }

        @java.lang.Override
        public _FinalStage audienceType(String audienceType) {
            this.audienceType = Optional.ofNullable(audienceType);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "audience_type", nulls = Nulls.SKIP)
        public _FinalStage audienceType(Optional<String> audienceType) {
            this.audienceType = audienceType;
            return this;
        }

        @java.lang.Override
        public PlanDetailResponseData build() {
            return new PlanDetailResponseData(
                    audienceType,
                    billingProduct,
                    chargeType,
                    companyCount,
                    controlledBy,
                    createdAt,
                    description,
                    features,
                    icon,
                    id,
                    includedCreditGrants,
                    isDefault,
                    isFree,
                    isTrialable,
                    monthlyPrice,
                    name,
                    oneTimePrice,
                    planType,
                    trialDays,
                    updatedAt,
                    yearlyPrice,
                    additionalProperties);
        }
    }
}
