/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = PlanEntitlementsOrder.Builder.class)
public final class PlanEntitlementsOrder {
    private final String planEntitlementId;

    private final Optional<Boolean> visible;

    private final Map<String, Object> additionalProperties;

    private PlanEntitlementsOrder(
            String planEntitlementId, Optional<Boolean> visible, Map<String, Object> additionalProperties) {
        this.planEntitlementId = planEntitlementId;
        this.visible = visible;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("plan_entitlement_id")
    public String getPlanEntitlementId() {
        return planEntitlementId;
    }

    @JsonProperty("visible")
    public Optional<Boolean> getVisible() {
        return visible;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof PlanEntitlementsOrder && equalTo((PlanEntitlementsOrder) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PlanEntitlementsOrder other) {
        return planEntitlementId.equals(other.planEntitlementId) && visible.equals(other.visible);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.planEntitlementId, this.visible);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PlanEntitlementIdStage builder() {
        return new Builder();
    }

    public interface PlanEntitlementIdStage {
        _FinalStage planEntitlementId(@NotNull String planEntitlementId);

        Builder from(PlanEntitlementsOrder other);
    }

    public interface _FinalStage {
        PlanEntitlementsOrder build();

        _FinalStage visible(Optional<Boolean> visible);

        _FinalStage visible(Boolean visible);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements PlanEntitlementIdStage, _FinalStage {
        private String planEntitlementId;

        private Optional<Boolean> visible = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(PlanEntitlementsOrder other) {
            planEntitlementId(other.getPlanEntitlementId());
            visible(other.getVisible());
            return this;
        }

        @java.lang.Override
        @JsonSetter("plan_entitlement_id")
        public _FinalStage planEntitlementId(@NotNull String planEntitlementId) {
            this.planEntitlementId = Objects.requireNonNull(planEntitlementId, "planEntitlementId must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage visible(Boolean visible) {
            this.visible = Optional.ofNullable(visible);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "visible", nulls = Nulls.SKIP)
        public _FinalStage visible(Optional<Boolean> visible) {
            this.visible = visible;
            return this;
        }

        @java.lang.Override
        public PlanEntitlementsOrder build() {
            return new PlanEntitlementsOrder(planEntitlementId, visible, additionalProperties);
        }
    }
}
