/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = PlanSnapshotView.Builder.class)
public final class PlanSnapshotView {
    private final boolean deleted;

    private final String description;

    private final String icon;

    private final String id;

    private final String name;

    private final Map<String, Object> additionalProperties;

    private PlanSnapshotView(
            boolean deleted,
            String description,
            String icon,
            String id,
            String name,
            Map<String, Object> additionalProperties) {
        this.deleted = deleted;
        this.description = description;
        this.icon = icon;
        this.id = id;
        this.name = name;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("deleted")
    public boolean getDeleted() {
        return deleted;
    }

    @JsonProperty("description")
    public String getDescription() {
        return description;
    }

    @JsonProperty("icon")
    public String getIcon() {
        return icon;
    }

    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @JsonProperty("name")
    public String getName() {
        return name;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof PlanSnapshotView && equalTo((PlanSnapshotView) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PlanSnapshotView other) {
        return deleted == other.deleted
                && description.equals(other.description)
                && icon.equals(other.icon)
                && id.equals(other.id)
                && name.equals(other.name);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.deleted, this.description, this.icon, this.id, this.name);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DeletedStage builder() {
        return new Builder();
    }

    public interface DeletedStage {
        DescriptionStage deleted(boolean deleted);

        Builder from(PlanSnapshotView other);
    }

    public interface DescriptionStage {
        IconStage description(@NotNull String description);
    }

    public interface IconStage {
        IdStage icon(@NotNull String icon);
    }

    public interface IdStage {
        NameStage id(@NotNull String id);
    }

    public interface NameStage {
        _FinalStage name(@NotNull String name);
    }

    public interface _FinalStage {
        PlanSnapshotView build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements DeletedStage, DescriptionStage, IconStage, IdStage, NameStage, _FinalStage {
        private boolean deleted;

        private String description;

        private String icon;

        private String id;

        private String name;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(PlanSnapshotView other) {
            deleted(other.getDeleted());
            description(other.getDescription());
            icon(other.getIcon());
            id(other.getId());
            name(other.getName());
            return this;
        }

        @java.lang.Override
        @JsonSetter("deleted")
        public DescriptionStage deleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        @java.lang.Override
        @JsonSetter("description")
        public IconStage description(@NotNull String description) {
            this.description = Objects.requireNonNull(description, "description must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("icon")
        public IdStage icon(@NotNull String icon) {
            this.icon = Objects.requireNonNull(icon, "icon must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("name")
        public _FinalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @java.lang.Override
        public PlanSnapshotView build() {
            return new PlanSnapshotView(deleted, description, icon, id, name, additionalProperties);
        }
    }
}
