/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = PreviewSubscriptionChangeResponseData.Builder.class)
public final class PreviewSubscriptionChangeResponseData {
    private final int amountOff;

    private final int dueNow;

    private final Optional<PreviewSubscriptionFinanceResponseData> finance;

    private final int newCharges;

    private final boolean paymentMethodRequired;

    private final double percentOff;

    private final OffsetDateTime periodStart;

    private final boolean promoCodeApplied;

    private final int proration;

    private final Optional<OffsetDateTime> trialEnd;

    private final List<FeatureUsageResponseData> usageViolations;

    private final Map<String, Object> additionalProperties;

    private PreviewSubscriptionChangeResponseData(
            int amountOff,
            int dueNow,
            Optional<PreviewSubscriptionFinanceResponseData> finance,
            int newCharges,
            boolean paymentMethodRequired,
            double percentOff,
            OffsetDateTime periodStart,
            boolean promoCodeApplied,
            int proration,
            Optional<OffsetDateTime> trialEnd,
            List<FeatureUsageResponseData> usageViolations,
            Map<String, Object> additionalProperties) {
        this.amountOff = amountOff;
        this.dueNow = dueNow;
        this.finance = finance;
        this.newCharges = newCharges;
        this.paymentMethodRequired = paymentMethodRequired;
        this.percentOff = percentOff;
        this.periodStart = periodStart;
        this.promoCodeApplied = promoCodeApplied;
        this.proration = proration;
        this.trialEnd = trialEnd;
        this.usageViolations = usageViolations;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("amount_off")
    public int getAmountOff() {
        return amountOff;
    }

    @JsonProperty("due_now")
    public int getDueNow() {
        return dueNow;
    }

    @JsonProperty("finance")
    public Optional<PreviewSubscriptionFinanceResponseData> getFinance() {
        return finance;
    }

    @JsonProperty("new_charges")
    public int getNewCharges() {
        return newCharges;
    }

    @JsonProperty("payment_method_required")
    public boolean getPaymentMethodRequired() {
        return paymentMethodRequired;
    }

    @JsonProperty("percent_off")
    public double getPercentOff() {
        return percentOff;
    }

    @JsonProperty("period_start")
    public OffsetDateTime getPeriodStart() {
        return periodStart;
    }

    @JsonProperty("promo_code_applied")
    public boolean getPromoCodeApplied() {
        return promoCodeApplied;
    }

    @JsonProperty("proration")
    public int getProration() {
        return proration;
    }

    @JsonProperty("trial_end")
    public Optional<OffsetDateTime> getTrialEnd() {
        return trialEnd;
    }

    @JsonProperty("usage_violations")
    public List<FeatureUsageResponseData> getUsageViolations() {
        return usageViolations;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof PreviewSubscriptionChangeResponseData
                && equalTo((PreviewSubscriptionChangeResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PreviewSubscriptionChangeResponseData other) {
        return amountOff == other.amountOff
                && dueNow == other.dueNow
                && finance.equals(other.finance)
                && newCharges == other.newCharges
                && paymentMethodRequired == other.paymentMethodRequired
                && percentOff == other.percentOff
                && periodStart.equals(other.periodStart)
                && promoCodeApplied == other.promoCodeApplied
                && proration == other.proration
                && trialEnd.equals(other.trialEnd)
                && usageViolations.equals(other.usageViolations);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.amountOff,
                this.dueNow,
                this.finance,
                this.newCharges,
                this.paymentMethodRequired,
                this.percentOff,
                this.periodStart,
                this.promoCodeApplied,
                this.proration,
                this.trialEnd,
                this.usageViolations);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AmountOffStage builder() {
        return new Builder();
    }

    public interface AmountOffStage {
        DueNowStage amountOff(int amountOff);

        Builder from(PreviewSubscriptionChangeResponseData other);
    }

    public interface DueNowStage {
        NewChargesStage dueNow(int dueNow);
    }

    public interface NewChargesStage {
        PaymentMethodRequiredStage newCharges(int newCharges);
    }

    public interface PaymentMethodRequiredStage {
        PercentOffStage paymentMethodRequired(boolean paymentMethodRequired);
    }

    public interface PercentOffStage {
        PeriodStartStage percentOff(double percentOff);
    }

    public interface PeriodStartStage {
        PromoCodeAppliedStage periodStart(@NotNull OffsetDateTime periodStart);
    }

    public interface PromoCodeAppliedStage {
        ProrationStage promoCodeApplied(boolean promoCodeApplied);
    }

    public interface ProrationStage {
        _FinalStage proration(int proration);
    }

    public interface _FinalStage {
        PreviewSubscriptionChangeResponseData build();

        _FinalStage finance(Optional<PreviewSubscriptionFinanceResponseData> finance);

        _FinalStage finance(PreviewSubscriptionFinanceResponseData finance);

        _FinalStage trialEnd(Optional<OffsetDateTime> trialEnd);

        _FinalStage trialEnd(OffsetDateTime trialEnd);

        _FinalStage usageViolations(List<FeatureUsageResponseData> usageViolations);

        _FinalStage addUsageViolations(FeatureUsageResponseData usageViolations);

        _FinalStage addAllUsageViolations(List<FeatureUsageResponseData> usageViolations);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements AmountOffStage,
                    DueNowStage,
                    NewChargesStage,
                    PaymentMethodRequiredStage,
                    PercentOffStage,
                    PeriodStartStage,
                    PromoCodeAppliedStage,
                    ProrationStage,
                    _FinalStage {
        private int amountOff;

        private int dueNow;

        private int newCharges;

        private boolean paymentMethodRequired;

        private double percentOff;

        private OffsetDateTime periodStart;

        private boolean promoCodeApplied;

        private int proration;

        private List<FeatureUsageResponseData> usageViolations = new ArrayList<>();

        private Optional<OffsetDateTime> trialEnd = Optional.empty();

        private Optional<PreviewSubscriptionFinanceResponseData> finance = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(PreviewSubscriptionChangeResponseData other) {
            amountOff(other.getAmountOff());
            dueNow(other.getDueNow());
            finance(other.getFinance());
            newCharges(other.getNewCharges());
            paymentMethodRequired(other.getPaymentMethodRequired());
            percentOff(other.getPercentOff());
            periodStart(other.getPeriodStart());
            promoCodeApplied(other.getPromoCodeApplied());
            proration(other.getProration());
            trialEnd(other.getTrialEnd());
            usageViolations(other.getUsageViolations());
            return this;
        }

        @java.lang.Override
        @JsonSetter("amount_off")
        public DueNowStage amountOff(int amountOff) {
            this.amountOff = amountOff;
            return this;
        }

        @java.lang.Override
        @JsonSetter("due_now")
        public NewChargesStage dueNow(int dueNow) {
            this.dueNow = dueNow;
            return this;
        }

        @java.lang.Override
        @JsonSetter("new_charges")
        public PaymentMethodRequiredStage newCharges(int newCharges) {
            this.newCharges = newCharges;
            return this;
        }

        @java.lang.Override
        @JsonSetter("payment_method_required")
        public PercentOffStage paymentMethodRequired(boolean paymentMethodRequired) {
            this.paymentMethodRequired = paymentMethodRequired;
            return this;
        }

        @java.lang.Override
        @JsonSetter("percent_off")
        public PeriodStartStage percentOff(double percentOff) {
            this.percentOff = percentOff;
            return this;
        }

        @java.lang.Override
        @JsonSetter("period_start")
        public PromoCodeAppliedStage periodStart(@NotNull OffsetDateTime periodStart) {
            this.periodStart = Objects.requireNonNull(periodStart, "periodStart must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("promo_code_applied")
        public ProrationStage promoCodeApplied(boolean promoCodeApplied) {
            this.promoCodeApplied = promoCodeApplied;
            return this;
        }

        @java.lang.Override
        @JsonSetter("proration")
        public _FinalStage proration(int proration) {
            this.proration = proration;
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllUsageViolations(List<FeatureUsageResponseData> usageViolations) {
            if (usageViolations != null) {
                this.usageViolations.addAll(usageViolations);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addUsageViolations(FeatureUsageResponseData usageViolations) {
            this.usageViolations.add(usageViolations);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "usage_violations", nulls = Nulls.SKIP)
        public _FinalStage usageViolations(List<FeatureUsageResponseData> usageViolations) {
            this.usageViolations.clear();
            if (usageViolations != null) {
                this.usageViolations.addAll(usageViolations);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage trialEnd(OffsetDateTime trialEnd) {
            this.trialEnd = Optional.ofNullable(trialEnd);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "trial_end", nulls = Nulls.SKIP)
        public _FinalStage trialEnd(Optional<OffsetDateTime> trialEnd) {
            this.trialEnd = trialEnd;
            return this;
        }

        @java.lang.Override
        public _FinalStage finance(PreviewSubscriptionFinanceResponseData finance) {
            this.finance = Optional.ofNullable(finance);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "finance", nulls = Nulls.SKIP)
        public _FinalStage finance(Optional<PreviewSubscriptionFinanceResponseData> finance) {
            this.finance = finance;
            return this;
        }

        @java.lang.Override
        public PreviewSubscriptionChangeResponseData build() {
            return new PreviewSubscriptionChangeResponseData(
                    amountOff,
                    dueNow,
                    finance,
                    newCharges,
                    paymentMethodRequired,
                    percentOff,
                    periodStart,
                    promoCodeApplied,
                    proration,
                    trialEnd,
                    usageViolations,
                    additionalProperties);
        }
    }
}
