/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = UpdateCreditBundleRequestBody.Builder.class)
public final class UpdateCreditBundleRequestBody {
    private final String bundleId;

    private final int quantity;

    private final Map<String, Object> additionalProperties;

    private UpdateCreditBundleRequestBody(String bundleId, int quantity, Map<String, Object> additionalProperties) {
        this.bundleId = bundleId;
        this.quantity = quantity;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("bundle_id")
    public String getBundleId() {
        return bundleId;
    }

    @JsonProperty("quantity")
    public int getQuantity() {
        return quantity;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof UpdateCreditBundleRequestBody && equalTo((UpdateCreditBundleRequestBody) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateCreditBundleRequestBody other) {
        return bundleId.equals(other.bundleId) && quantity == other.quantity;
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.bundleId, this.quantity);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static BundleIdStage builder() {
        return new Builder();
    }

    public interface BundleIdStage {
        QuantityStage bundleId(@NotNull String bundleId);

        Builder from(UpdateCreditBundleRequestBody other);
    }

    public interface QuantityStage {
        _FinalStage quantity(int quantity);
    }

    public interface _FinalStage {
        UpdateCreditBundleRequestBody build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements BundleIdStage, QuantityStage, _FinalStage {
        private String bundleId;

        private int quantity;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(UpdateCreditBundleRequestBody other) {
            bundleId(other.getBundleId());
            quantity(other.getQuantity());
            return this;
        }

        @java.lang.Override
        @JsonSetter("bundle_id")
        public QuantityStage bundleId(@NotNull String bundleId) {
            this.bundleId = Objects.requireNonNull(bundleId, "bundleId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("quantity")
        public _FinalStage quantity(int quantity) {
            this.quantity = quantity;
            return this;
        }

        @java.lang.Override
        public UpdateCreditBundleRequestBody build() {
            return new UpdateCreditBundleRequestBody(bundleId, quantity, additionalProperties);
        }
    }
}
