/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = UsageBasedEntitlementResponseData.Builder.class)
public final class UsageBasedEntitlementResponseData {
    private final Optional<Integer> billingThreshold;

    private final Optional<Double> consumptionRate;

    private final String featureId;

    private final Optional<BillingPriceView> meteredPrice;

    private final Optional<String> metricPeriod;

    private final Optional<String> metricPeriodMonthReset;

    private final Optional<BillingPriceView> monthlyUsageBasedPrice;

    private final Optional<String> priceBehavior;

    private final Optional<Boolean> valueBool;

    private final Optional<Integer> valueNumeric;

    private final String valueType;

    private final Optional<BillingPriceView> yearlyUsageBasedPrice;

    private final Map<String, Object> additionalProperties;

    private UsageBasedEntitlementResponseData(
            Optional<Integer> billingThreshold,
            Optional<Double> consumptionRate,
            String featureId,
            Optional<BillingPriceView> meteredPrice,
            Optional<String> metricPeriod,
            Optional<String> metricPeriodMonthReset,
            Optional<BillingPriceView> monthlyUsageBasedPrice,
            Optional<String> priceBehavior,
            Optional<Boolean> valueBool,
            Optional<Integer> valueNumeric,
            String valueType,
            Optional<BillingPriceView> yearlyUsageBasedPrice,
            Map<String, Object> additionalProperties) {
        this.billingThreshold = billingThreshold;
        this.consumptionRate = consumptionRate;
        this.featureId = featureId;
        this.meteredPrice = meteredPrice;
        this.metricPeriod = metricPeriod;
        this.metricPeriodMonthReset = metricPeriodMonthReset;
        this.monthlyUsageBasedPrice = monthlyUsageBasedPrice;
        this.priceBehavior = priceBehavior;
        this.valueBool = valueBool;
        this.valueNumeric = valueNumeric;
        this.valueType = valueType;
        this.yearlyUsageBasedPrice = yearlyUsageBasedPrice;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("billing_threshold")
    public Optional<Integer> getBillingThreshold() {
        return billingThreshold;
    }

    @JsonProperty("consumption_rate")
    public Optional<Double> getConsumptionRate() {
        return consumptionRate;
    }

    @JsonProperty("feature_id")
    public String getFeatureId() {
        return featureId;
    }

    @JsonProperty("metered_price")
    public Optional<BillingPriceView> getMeteredPrice() {
        return meteredPrice;
    }

    @JsonProperty("metric_period")
    public Optional<String> getMetricPeriod() {
        return metricPeriod;
    }

    @JsonProperty("metric_period_month_reset")
    public Optional<String> getMetricPeriodMonthReset() {
        return metricPeriodMonthReset;
    }

    @JsonProperty("monthly_usage_based_price")
    public Optional<BillingPriceView> getMonthlyUsageBasedPrice() {
        return monthlyUsageBasedPrice;
    }

    @JsonProperty("price_behavior")
    public Optional<String> getPriceBehavior() {
        return priceBehavior;
    }

    @JsonProperty("value_bool")
    public Optional<Boolean> getValueBool() {
        return valueBool;
    }

    @JsonProperty("value_numeric")
    public Optional<Integer> getValueNumeric() {
        return valueNumeric;
    }

    @JsonProperty("value_type")
    public String getValueType() {
        return valueType;
    }

    @JsonProperty("yearly_usage_based_price")
    public Optional<BillingPriceView> getYearlyUsageBasedPrice() {
        return yearlyUsageBasedPrice;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof UsageBasedEntitlementResponseData && equalTo((UsageBasedEntitlementResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UsageBasedEntitlementResponseData other) {
        return billingThreshold.equals(other.billingThreshold)
                && consumptionRate.equals(other.consumptionRate)
                && featureId.equals(other.featureId)
                && meteredPrice.equals(other.meteredPrice)
                && metricPeriod.equals(other.metricPeriod)
                && metricPeriodMonthReset.equals(other.metricPeriodMonthReset)
                && monthlyUsageBasedPrice.equals(other.monthlyUsageBasedPrice)
                && priceBehavior.equals(other.priceBehavior)
                && valueBool.equals(other.valueBool)
                && valueNumeric.equals(other.valueNumeric)
                && valueType.equals(other.valueType)
                && yearlyUsageBasedPrice.equals(other.yearlyUsageBasedPrice);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.billingThreshold,
                this.consumptionRate,
                this.featureId,
                this.meteredPrice,
                this.metricPeriod,
                this.metricPeriodMonthReset,
                this.monthlyUsageBasedPrice,
                this.priceBehavior,
                this.valueBool,
                this.valueNumeric,
                this.valueType,
                this.yearlyUsageBasedPrice);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static FeatureIdStage builder() {
        return new Builder();
    }

    public interface FeatureIdStage {
        ValueTypeStage featureId(@NotNull String featureId);

        Builder from(UsageBasedEntitlementResponseData other);
    }

    public interface ValueTypeStage {
        _FinalStage valueType(@NotNull String valueType);
    }

    public interface _FinalStage {
        UsageBasedEntitlementResponseData build();

        _FinalStage billingThreshold(Optional<Integer> billingThreshold);

        _FinalStage billingThreshold(Integer billingThreshold);

        _FinalStage consumptionRate(Optional<Double> consumptionRate);

        _FinalStage consumptionRate(Double consumptionRate);

        _FinalStage meteredPrice(Optional<BillingPriceView> meteredPrice);

        _FinalStage meteredPrice(BillingPriceView meteredPrice);

        _FinalStage metricPeriod(Optional<String> metricPeriod);

        _FinalStage metricPeriod(String metricPeriod);

        _FinalStage metricPeriodMonthReset(Optional<String> metricPeriodMonthReset);

        _FinalStage metricPeriodMonthReset(String metricPeriodMonthReset);

        _FinalStage monthlyUsageBasedPrice(Optional<BillingPriceView> monthlyUsageBasedPrice);

        _FinalStage monthlyUsageBasedPrice(BillingPriceView monthlyUsageBasedPrice);

        _FinalStage priceBehavior(Optional<String> priceBehavior);

        _FinalStage priceBehavior(String priceBehavior);

        _FinalStage valueBool(Optional<Boolean> valueBool);

        _FinalStage valueBool(Boolean valueBool);

        _FinalStage valueNumeric(Optional<Integer> valueNumeric);

        _FinalStage valueNumeric(Integer valueNumeric);

        _FinalStage yearlyUsageBasedPrice(Optional<BillingPriceView> yearlyUsageBasedPrice);

        _FinalStage yearlyUsageBasedPrice(BillingPriceView yearlyUsageBasedPrice);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements FeatureIdStage, ValueTypeStage, _FinalStage {
        private String featureId;

        private String valueType;

        private Optional<BillingPriceView> yearlyUsageBasedPrice = Optional.empty();

        private Optional<Integer> valueNumeric = Optional.empty();

        private Optional<Boolean> valueBool = Optional.empty();

        private Optional<String> priceBehavior = Optional.empty();

        private Optional<BillingPriceView> monthlyUsageBasedPrice = Optional.empty();

        private Optional<String> metricPeriodMonthReset = Optional.empty();

        private Optional<String> metricPeriod = Optional.empty();

        private Optional<BillingPriceView> meteredPrice = Optional.empty();

        private Optional<Double> consumptionRate = Optional.empty();

        private Optional<Integer> billingThreshold = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(UsageBasedEntitlementResponseData other) {
            billingThreshold(other.getBillingThreshold());
            consumptionRate(other.getConsumptionRate());
            featureId(other.getFeatureId());
            meteredPrice(other.getMeteredPrice());
            metricPeriod(other.getMetricPeriod());
            metricPeriodMonthReset(other.getMetricPeriodMonthReset());
            monthlyUsageBasedPrice(other.getMonthlyUsageBasedPrice());
            priceBehavior(other.getPriceBehavior());
            valueBool(other.getValueBool());
            valueNumeric(other.getValueNumeric());
            valueType(other.getValueType());
            yearlyUsageBasedPrice(other.getYearlyUsageBasedPrice());
            return this;
        }

        @java.lang.Override
        @JsonSetter("feature_id")
        public ValueTypeStage featureId(@NotNull String featureId) {
            this.featureId = Objects.requireNonNull(featureId, "featureId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("value_type")
        public _FinalStage valueType(@NotNull String valueType) {
            this.valueType = Objects.requireNonNull(valueType, "valueType must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage yearlyUsageBasedPrice(BillingPriceView yearlyUsageBasedPrice) {
            this.yearlyUsageBasedPrice = Optional.ofNullable(yearlyUsageBasedPrice);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "yearly_usage_based_price", nulls = Nulls.SKIP)
        public _FinalStage yearlyUsageBasedPrice(Optional<BillingPriceView> yearlyUsageBasedPrice) {
            this.yearlyUsageBasedPrice = yearlyUsageBasedPrice;
            return this;
        }

        @java.lang.Override
        public _FinalStage valueNumeric(Integer valueNumeric) {
            this.valueNumeric = Optional.ofNullable(valueNumeric);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "value_numeric", nulls = Nulls.SKIP)
        public _FinalStage valueNumeric(Optional<Integer> valueNumeric) {
            this.valueNumeric = valueNumeric;
            return this;
        }

        @java.lang.Override
        public _FinalStage valueBool(Boolean valueBool) {
            this.valueBool = Optional.ofNullable(valueBool);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "value_bool", nulls = Nulls.SKIP)
        public _FinalStage valueBool(Optional<Boolean> valueBool) {
            this.valueBool = valueBool;
            return this;
        }

        @java.lang.Override
        public _FinalStage priceBehavior(String priceBehavior) {
            this.priceBehavior = Optional.ofNullable(priceBehavior);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "price_behavior", nulls = Nulls.SKIP)
        public _FinalStage priceBehavior(Optional<String> priceBehavior) {
            this.priceBehavior = priceBehavior;
            return this;
        }

        @java.lang.Override
        public _FinalStage monthlyUsageBasedPrice(BillingPriceView monthlyUsageBasedPrice) {
            this.monthlyUsageBasedPrice = Optional.ofNullable(monthlyUsageBasedPrice);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "monthly_usage_based_price", nulls = Nulls.SKIP)
        public _FinalStage monthlyUsageBasedPrice(Optional<BillingPriceView> monthlyUsageBasedPrice) {
            this.monthlyUsageBasedPrice = monthlyUsageBasedPrice;
            return this;
        }

        @java.lang.Override
        public _FinalStage metricPeriodMonthReset(String metricPeriodMonthReset) {
            this.metricPeriodMonthReset = Optional.ofNullable(metricPeriodMonthReset);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "metric_period_month_reset", nulls = Nulls.SKIP)
        public _FinalStage metricPeriodMonthReset(Optional<String> metricPeriodMonthReset) {
            this.metricPeriodMonthReset = metricPeriodMonthReset;
            return this;
        }

        @java.lang.Override
        public _FinalStage metricPeriod(String metricPeriod) {
            this.metricPeriod = Optional.ofNullable(metricPeriod);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "metric_period", nulls = Nulls.SKIP)
        public _FinalStage metricPeriod(Optional<String> metricPeriod) {
            this.metricPeriod = metricPeriod;
            return this;
        }

        @java.lang.Override
        public _FinalStage meteredPrice(BillingPriceView meteredPrice) {
            this.meteredPrice = Optional.ofNullable(meteredPrice);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "metered_price", nulls = Nulls.SKIP)
        public _FinalStage meteredPrice(Optional<BillingPriceView> meteredPrice) {
            this.meteredPrice = meteredPrice;
            return this;
        }

        @java.lang.Override
        public _FinalStage consumptionRate(Double consumptionRate) {
            this.consumptionRate = Optional.ofNullable(consumptionRate);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "consumption_rate", nulls = Nulls.SKIP)
        public _FinalStage consumptionRate(Optional<Double> consumptionRate) {
            this.consumptionRate = consumptionRate;
            return this;
        }

        @java.lang.Override
        public _FinalStage billingThreshold(Integer billingThreshold) {
            this.billingThreshold = Optional.ofNullable(billingThreshold);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "billing_threshold", nulls = Nulls.SKIP)
        public _FinalStage billingThreshold(Optional<Integer> billingThreshold) {
            this.billingThreshold = billingThreshold;
            return this;
        }

        @java.lang.Override
        public UsageBasedEntitlementResponseData build() {
            return new UsageBasedEntitlementResponseData(
                    billingThreshold,
                    consumptionRate,
                    featureId,
                    meteredPrice,
                    metricPeriod,
                    metricPeriodMonthReset,
                    monthlyUsageBasedPrice,
                    priceBehavior,
                    valueBool,
                    valueNumeric,
                    valueType,
                    yearlyUsageBasedPrice,
                    additionalProperties);
        }
    }
}
