/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = UserDetailResponseData.Builder.class)
public final class UserDetailResponseData {
    private final List<CompanyMembershipDetailResponseData> companyMemberships;

    private final OffsetDateTime createdAt;

    private final List<EntityTraitDetailResponseData> entityTraits;

    private final String environmentId;

    private final String id;

    private final List<EntityKeyDetailResponseData> keys;

    private final Optional<OffsetDateTime> lastSeenAt;

    private final String name;

    private final Optional<Map<String, JsonNode>> traits;

    private final OffsetDateTime updatedAt;

    private final Map<String, Object> additionalProperties;

    private UserDetailResponseData(
            List<CompanyMembershipDetailResponseData> companyMemberships,
            OffsetDateTime createdAt,
            List<EntityTraitDetailResponseData> entityTraits,
            String environmentId,
            String id,
            List<EntityKeyDetailResponseData> keys,
            Optional<OffsetDateTime> lastSeenAt,
            String name,
            Optional<Map<String, JsonNode>> traits,
            OffsetDateTime updatedAt,
            Map<String, Object> additionalProperties) {
        this.companyMemberships = companyMemberships;
        this.createdAt = createdAt;
        this.entityTraits = entityTraits;
        this.environmentId = environmentId;
        this.id = id;
        this.keys = keys;
        this.lastSeenAt = lastSeenAt;
        this.name = name;
        this.traits = traits;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("company_memberships")
    public List<CompanyMembershipDetailResponseData> getCompanyMemberships() {
        return companyMemberships;
    }

    @JsonProperty("created_at")
    public OffsetDateTime getCreatedAt() {
        return createdAt;
    }

    @JsonProperty("entity_traits")
    public List<EntityTraitDetailResponseData> getEntityTraits() {
        return entityTraits;
    }

    @JsonProperty("environment_id")
    public String getEnvironmentId() {
        return environmentId;
    }

    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @JsonProperty("keys")
    public List<EntityKeyDetailResponseData> getKeys() {
        return keys;
    }

    @JsonProperty("last_seen_at")
    public Optional<OffsetDateTime> getLastSeenAt() {
        return lastSeenAt;
    }

    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * @return A map of trait names to trait values
     */
    @JsonProperty("traits")
    public Optional<Map<String, JsonNode>> getTraits() {
        return traits;
    }

    @JsonProperty("updated_at")
    public OffsetDateTime getUpdatedAt() {
        return updatedAt;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof UserDetailResponseData && equalTo((UserDetailResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UserDetailResponseData other) {
        return companyMemberships.equals(other.companyMemberships)
                && createdAt.equals(other.createdAt)
                && entityTraits.equals(other.entityTraits)
                && environmentId.equals(other.environmentId)
                && id.equals(other.id)
                && keys.equals(other.keys)
                && lastSeenAt.equals(other.lastSeenAt)
                && name.equals(other.name)
                && traits.equals(other.traits)
                && updatedAt.equals(other.updatedAt);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.companyMemberships,
                this.createdAt,
                this.entityTraits,
                this.environmentId,
                this.id,
                this.keys,
                this.lastSeenAt,
                this.name,
                this.traits,
                this.updatedAt);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CreatedAtStage builder() {
        return new Builder();
    }

    public interface CreatedAtStage {
        EnvironmentIdStage createdAt(@NotNull OffsetDateTime createdAt);

        Builder from(UserDetailResponseData other);
    }

    public interface EnvironmentIdStage {
        IdStage environmentId(@NotNull String environmentId);
    }

    public interface IdStage {
        NameStage id(@NotNull String id);
    }

    public interface NameStage {
        UpdatedAtStage name(@NotNull String name);
    }

    public interface UpdatedAtStage {
        _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt);
    }

    public interface _FinalStage {
        UserDetailResponseData build();

        _FinalStage companyMemberships(List<CompanyMembershipDetailResponseData> companyMemberships);

        _FinalStage addCompanyMemberships(CompanyMembershipDetailResponseData companyMemberships);

        _FinalStage addAllCompanyMemberships(List<CompanyMembershipDetailResponseData> companyMemberships);

        _FinalStage entityTraits(List<EntityTraitDetailResponseData> entityTraits);

        _FinalStage addEntityTraits(EntityTraitDetailResponseData entityTraits);

        _FinalStage addAllEntityTraits(List<EntityTraitDetailResponseData> entityTraits);

        _FinalStage keys(List<EntityKeyDetailResponseData> keys);

        _FinalStage addKeys(EntityKeyDetailResponseData keys);

        _FinalStage addAllKeys(List<EntityKeyDetailResponseData> keys);

        _FinalStage lastSeenAt(Optional<OffsetDateTime> lastSeenAt);

        _FinalStage lastSeenAt(OffsetDateTime lastSeenAt);

        /**
         * <p>A map of trait names to trait values</p>
         */
        _FinalStage traits(Optional<Map<String, JsonNode>> traits);

        _FinalStage traits(Map<String, JsonNode> traits);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements CreatedAtStage, EnvironmentIdStage, IdStage, NameStage, UpdatedAtStage, _FinalStage {
        private OffsetDateTime createdAt;

        private String environmentId;

        private String id;

        private String name;

        private OffsetDateTime updatedAt;

        private Optional<Map<String, JsonNode>> traits = Optional.empty();

        private Optional<OffsetDateTime> lastSeenAt = Optional.empty();

        private List<EntityKeyDetailResponseData> keys = new ArrayList<>();

        private List<EntityTraitDetailResponseData> entityTraits = new ArrayList<>();

        private List<CompanyMembershipDetailResponseData> companyMemberships = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(UserDetailResponseData other) {
            companyMemberships(other.getCompanyMemberships());
            createdAt(other.getCreatedAt());
            entityTraits(other.getEntityTraits());
            environmentId(other.getEnvironmentId());
            id(other.getId());
            keys(other.getKeys());
            lastSeenAt(other.getLastSeenAt());
            name(other.getName());
            traits(other.getTraits());
            updatedAt(other.getUpdatedAt());
            return this;
        }

        @java.lang.Override
        @JsonSetter("created_at")
        public EnvironmentIdStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("environment_id")
        public IdStage environmentId(@NotNull String environmentId) {
            this.environmentId = Objects.requireNonNull(environmentId, "environmentId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("name")
        public UpdatedAtStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        /**
         * <p>A map of trait names to trait values</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage traits(Map<String, JsonNode> traits) {
            this.traits = Optional.ofNullable(traits);
            return this;
        }

        /**
         * <p>A map of trait names to trait values</p>
         */
        @java.lang.Override
        @JsonSetter(value = "traits", nulls = Nulls.SKIP)
        public _FinalStage traits(Optional<Map<String, JsonNode>> traits) {
            this.traits = traits;
            return this;
        }

        @java.lang.Override
        public _FinalStage lastSeenAt(OffsetDateTime lastSeenAt) {
            this.lastSeenAt = Optional.ofNullable(lastSeenAt);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "last_seen_at", nulls = Nulls.SKIP)
        public _FinalStage lastSeenAt(Optional<OffsetDateTime> lastSeenAt) {
            this.lastSeenAt = lastSeenAt;
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllKeys(List<EntityKeyDetailResponseData> keys) {
            if (keys != null) {
                this.keys.addAll(keys);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addKeys(EntityKeyDetailResponseData keys) {
            this.keys.add(keys);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "keys", nulls = Nulls.SKIP)
        public _FinalStage keys(List<EntityKeyDetailResponseData> keys) {
            this.keys.clear();
            if (keys != null) {
                this.keys.addAll(keys);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllEntityTraits(List<EntityTraitDetailResponseData> entityTraits) {
            if (entityTraits != null) {
                this.entityTraits.addAll(entityTraits);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addEntityTraits(EntityTraitDetailResponseData entityTraits) {
            this.entityTraits.add(entityTraits);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "entity_traits", nulls = Nulls.SKIP)
        public _FinalStage entityTraits(List<EntityTraitDetailResponseData> entityTraits) {
            this.entityTraits.clear();
            if (entityTraits != null) {
                this.entityTraits.addAll(entityTraits);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllCompanyMemberships(List<CompanyMembershipDetailResponseData> companyMemberships) {
            if (companyMemberships != null) {
                this.companyMemberships.addAll(companyMemberships);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addCompanyMemberships(CompanyMembershipDetailResponseData companyMemberships) {
            this.companyMemberships.add(companyMemberships);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "company_memberships", nulls = Nulls.SKIP)
        public _FinalStage companyMemberships(List<CompanyMembershipDetailResponseData> companyMemberships) {
            this.companyMemberships.clear();
            if (companyMemberships != null) {
                this.companyMemberships.addAll(companyMemberships);
            }
            return this;
        }

        @java.lang.Override
        public UserDetailResponseData build() {
            return new UserDetailResponseData(
                    companyMemberships,
                    createdAt,
                    entityTraits,
                    environmentId,
                    id,
                    keys,
                    lastSeenAt,
                    name,
                    traits,
                    updatedAt,
                    additionalProperties);
        }
    }
}
