/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.accounts.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ListApiKeysParams.Builder.class)
public final class ListApiKeysParams {
    private final Optional<String> environmentId;

    private final Optional<Integer> limit;

    private final Optional<Integer> offset;

    private final Optional<Boolean> requireEnvironment;

    private final Map<String, Object> additionalProperties;

    private ListApiKeysParams(
            Optional<String> environmentId,
            Optional<Integer> limit,
            Optional<Integer> offset,
            Optional<Boolean> requireEnvironment,
            Map<String, Object> additionalProperties) {
        this.environmentId = environmentId;
        this.limit = limit;
        this.offset = offset;
        this.requireEnvironment = requireEnvironment;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("environment_id")
    public Optional<String> getEnvironmentId() {
        return environmentId;
    }

    /**
     * @return Page limit (default 100)
     */
    @JsonProperty("limit")
    public Optional<Integer> getLimit() {
        return limit;
    }

    /**
     * @return Page offset (default 0)
     */
    @JsonProperty("offset")
    public Optional<Integer> getOffset() {
        return offset;
    }

    @JsonProperty("require_environment")
    public Optional<Boolean> getRequireEnvironment() {
        return requireEnvironment;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ListApiKeysParams && equalTo((ListApiKeysParams) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListApiKeysParams other) {
        return environmentId.equals(other.environmentId)
                && limit.equals(other.limit)
                && offset.equals(other.offset)
                && requireEnvironment.equals(other.requireEnvironment);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.environmentId, this.limit, this.offset, this.requireEnvironment);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> environmentId = Optional.empty();

        private Optional<Integer> limit = Optional.empty();

        private Optional<Integer> offset = Optional.empty();

        private Optional<Boolean> requireEnvironment = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ListApiKeysParams other) {
            environmentId(other.getEnvironmentId());
            limit(other.getLimit());
            offset(other.getOffset());
            requireEnvironment(other.getRequireEnvironment());
            return this;
        }

        @JsonSetter(value = "environment_id", nulls = Nulls.SKIP)
        public Builder environmentId(Optional<String> environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = Optional.ofNullable(environmentId);
            return this;
        }

        /**
         * <p>Page limit (default 100)</p>
         */
        @JsonSetter(value = "limit", nulls = Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        /**
         * <p>Page offset (default 0)</p>
         */
        @JsonSetter(value = "offset", nulls = Nulls.SKIP)
        public Builder offset(Optional<Integer> offset) {
            this.offset = offset;
            return this;
        }

        public Builder offset(Integer offset) {
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        @JsonSetter(value = "require_environment", nulls = Nulls.SKIP)
        public Builder requireEnvironment(Optional<Boolean> requireEnvironment) {
            this.requireEnvironment = requireEnvironment;
            return this;
        }

        public Builder requireEnvironment(Boolean requireEnvironment) {
            this.requireEnvironment = Optional.ofNullable(requireEnvironment);
            return this;
        }

        public ListApiKeysParams build() {
            return new ListApiKeysParams(environmentId, limit, offset, requireEnvironment, additionalProperties);
        }
    }
}
