/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.billing.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CreateBillingProductRequestBody.Builder.class)
public final class CreateBillingProductRequestBody {
    private final String externalId;

    private final Optional<Boolean> isActive;

    private final String name;

    private final double price;

    private final Map<String, Object> additionalProperties;

    private CreateBillingProductRequestBody(
            String externalId,
            Optional<Boolean> isActive,
            String name,
            double price,
            Map<String, Object> additionalProperties) {
        this.externalId = externalId;
        this.isActive = isActive;
        this.name = name;
        this.price = price;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("external_id")
    public String getExternalId() {
        return externalId;
    }

    @JsonProperty("is_active")
    public Optional<Boolean> getIsActive() {
        return isActive;
    }

    @JsonProperty("name")
    public String getName() {
        return name;
    }

    @JsonProperty("price")
    public double getPrice() {
        return price;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CreateBillingProductRequestBody && equalTo((CreateBillingProductRequestBody) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateBillingProductRequestBody other) {
        return externalId.equals(other.externalId)
                && isActive.equals(other.isActive)
                && name.equals(other.name)
                && price == other.price;
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.externalId, this.isActive, this.name, this.price);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ExternalIdStage builder() {
        return new Builder();
    }

    public interface ExternalIdStage {
        NameStage externalId(@NotNull String externalId);

        Builder from(CreateBillingProductRequestBody other);
    }

    public interface NameStage {
        PriceStage name(@NotNull String name);
    }

    public interface PriceStage {
        _FinalStage price(double price);
    }

    public interface _FinalStage {
        CreateBillingProductRequestBody build();

        _FinalStage isActive(Optional<Boolean> isActive);

        _FinalStage isActive(Boolean isActive);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements ExternalIdStage, NameStage, PriceStage, _FinalStage {
        private String externalId;

        private String name;

        private double price;

        private Optional<Boolean> isActive = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CreateBillingProductRequestBody other) {
            externalId(other.getExternalId());
            isActive(other.getIsActive());
            name(other.getName());
            price(other.getPrice());
            return this;
        }

        @java.lang.Override
        @JsonSetter("external_id")
        public NameStage externalId(@NotNull String externalId) {
            this.externalId = Objects.requireNonNull(externalId, "externalId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("name")
        public PriceStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("price")
        public _FinalStage price(double price) {
            this.price = price;
            return this;
        }

        @java.lang.Override
        public _FinalStage isActive(Boolean isActive) {
            this.isActive = Optional.ofNullable(isActive);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "is_active", nulls = Nulls.SKIP)
        public _FinalStage isActive(Optional<Boolean> isActive) {
            this.isActive = isActive;
            return this;
        }

        @java.lang.Override
        public CreateBillingProductRequestBody build() {
            return new CreateBillingProductRequestBody(externalId, isActive, name, price, additionalProperties);
        }
    }
}
