/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.billing.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CreatePaymentMethodRequestBody.Builder.class)
public final class CreatePaymentMethodRequestBody {
    private final Optional<String> accountLast4;

    private final Optional<String> accountName;

    private final Optional<String> bankName;

    private final Optional<String> billingEmail;

    private final Optional<String> billingName;

    private final Optional<String> cardBrand;

    private final Optional<Integer> cardExpMonth;

    private final Optional<Integer> cardExpYear;

    private final Optional<String> cardLast4;

    private final String customerExternalId;

    private final String externalId;

    private final String paymentMethodType;

    private final Map<String, Object> additionalProperties;

    private CreatePaymentMethodRequestBody(
            Optional<String> accountLast4,
            Optional<String> accountName,
            Optional<String> bankName,
            Optional<String> billingEmail,
            Optional<String> billingName,
            Optional<String> cardBrand,
            Optional<Integer> cardExpMonth,
            Optional<Integer> cardExpYear,
            Optional<String> cardLast4,
            String customerExternalId,
            String externalId,
            String paymentMethodType,
            Map<String, Object> additionalProperties) {
        this.accountLast4 = accountLast4;
        this.accountName = accountName;
        this.bankName = bankName;
        this.billingEmail = billingEmail;
        this.billingName = billingName;
        this.cardBrand = cardBrand;
        this.cardExpMonth = cardExpMonth;
        this.cardExpYear = cardExpYear;
        this.cardLast4 = cardLast4;
        this.customerExternalId = customerExternalId;
        this.externalId = externalId;
        this.paymentMethodType = paymentMethodType;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("account_last4")
    public Optional<String> getAccountLast4() {
        return accountLast4;
    }

    @JsonProperty("account_name")
    public Optional<String> getAccountName() {
        return accountName;
    }

    @JsonProperty("bank_name")
    public Optional<String> getBankName() {
        return bankName;
    }

    @JsonProperty("billing_email")
    public Optional<String> getBillingEmail() {
        return billingEmail;
    }

    @JsonProperty("billing_name")
    public Optional<String> getBillingName() {
        return billingName;
    }

    @JsonProperty("card_brand")
    public Optional<String> getCardBrand() {
        return cardBrand;
    }

    @JsonProperty("card_exp_month")
    public Optional<Integer> getCardExpMonth() {
        return cardExpMonth;
    }

    @JsonProperty("card_exp_year")
    public Optional<Integer> getCardExpYear() {
        return cardExpYear;
    }

    @JsonProperty("card_last4")
    public Optional<String> getCardLast4() {
        return cardLast4;
    }

    @JsonProperty("customer_external_id")
    public String getCustomerExternalId() {
        return customerExternalId;
    }

    @JsonProperty("external_id")
    public String getExternalId() {
        return externalId;
    }

    @JsonProperty("payment_method_type")
    public String getPaymentMethodType() {
        return paymentMethodType;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CreatePaymentMethodRequestBody && equalTo((CreatePaymentMethodRequestBody) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreatePaymentMethodRequestBody other) {
        return accountLast4.equals(other.accountLast4)
                && accountName.equals(other.accountName)
                && bankName.equals(other.bankName)
                && billingEmail.equals(other.billingEmail)
                && billingName.equals(other.billingName)
                && cardBrand.equals(other.cardBrand)
                && cardExpMonth.equals(other.cardExpMonth)
                && cardExpYear.equals(other.cardExpYear)
                && cardLast4.equals(other.cardLast4)
                && customerExternalId.equals(other.customerExternalId)
                && externalId.equals(other.externalId)
                && paymentMethodType.equals(other.paymentMethodType);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.accountLast4,
                this.accountName,
                this.bankName,
                this.billingEmail,
                this.billingName,
                this.cardBrand,
                this.cardExpMonth,
                this.cardExpYear,
                this.cardLast4,
                this.customerExternalId,
                this.externalId,
                this.paymentMethodType);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CustomerExternalIdStage builder() {
        return new Builder();
    }

    public interface CustomerExternalIdStage {
        ExternalIdStage customerExternalId(@NotNull String customerExternalId);

        Builder from(CreatePaymentMethodRequestBody other);
    }

    public interface ExternalIdStage {
        PaymentMethodTypeStage externalId(@NotNull String externalId);
    }

    public interface PaymentMethodTypeStage {
        _FinalStage paymentMethodType(@NotNull String paymentMethodType);
    }

    public interface _FinalStage {
        CreatePaymentMethodRequestBody build();

        _FinalStage accountLast4(Optional<String> accountLast4);

        _FinalStage accountLast4(String accountLast4);

        _FinalStage accountName(Optional<String> accountName);

        _FinalStage accountName(String accountName);

        _FinalStage bankName(Optional<String> bankName);

        _FinalStage bankName(String bankName);

        _FinalStage billingEmail(Optional<String> billingEmail);

        _FinalStage billingEmail(String billingEmail);

        _FinalStage billingName(Optional<String> billingName);

        _FinalStage billingName(String billingName);

        _FinalStage cardBrand(Optional<String> cardBrand);

        _FinalStage cardBrand(String cardBrand);

        _FinalStage cardExpMonth(Optional<Integer> cardExpMonth);

        _FinalStage cardExpMonth(Integer cardExpMonth);

        _FinalStage cardExpYear(Optional<Integer> cardExpYear);

        _FinalStage cardExpYear(Integer cardExpYear);

        _FinalStage cardLast4(Optional<String> cardLast4);

        _FinalStage cardLast4(String cardLast4);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements CustomerExternalIdStage, ExternalIdStage, PaymentMethodTypeStage, _FinalStage {
        private String customerExternalId;

        private String externalId;

        private String paymentMethodType;

        private Optional<String> cardLast4 = Optional.empty();

        private Optional<Integer> cardExpYear = Optional.empty();

        private Optional<Integer> cardExpMonth = Optional.empty();

        private Optional<String> cardBrand = Optional.empty();

        private Optional<String> billingName = Optional.empty();

        private Optional<String> billingEmail = Optional.empty();

        private Optional<String> bankName = Optional.empty();

        private Optional<String> accountName = Optional.empty();

        private Optional<String> accountLast4 = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CreatePaymentMethodRequestBody other) {
            accountLast4(other.getAccountLast4());
            accountName(other.getAccountName());
            bankName(other.getBankName());
            billingEmail(other.getBillingEmail());
            billingName(other.getBillingName());
            cardBrand(other.getCardBrand());
            cardExpMonth(other.getCardExpMonth());
            cardExpYear(other.getCardExpYear());
            cardLast4(other.getCardLast4());
            customerExternalId(other.getCustomerExternalId());
            externalId(other.getExternalId());
            paymentMethodType(other.getPaymentMethodType());
            return this;
        }

        @java.lang.Override
        @JsonSetter("customer_external_id")
        public ExternalIdStage customerExternalId(@NotNull String customerExternalId) {
            this.customerExternalId = Objects.requireNonNull(customerExternalId, "customerExternalId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("external_id")
        public PaymentMethodTypeStage externalId(@NotNull String externalId) {
            this.externalId = Objects.requireNonNull(externalId, "externalId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("payment_method_type")
        public _FinalStage paymentMethodType(@NotNull String paymentMethodType) {
            this.paymentMethodType = Objects.requireNonNull(paymentMethodType, "paymentMethodType must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage cardLast4(String cardLast4) {
            this.cardLast4 = Optional.ofNullable(cardLast4);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "card_last4", nulls = Nulls.SKIP)
        public _FinalStage cardLast4(Optional<String> cardLast4) {
            this.cardLast4 = cardLast4;
            return this;
        }

        @java.lang.Override
        public _FinalStage cardExpYear(Integer cardExpYear) {
            this.cardExpYear = Optional.ofNullable(cardExpYear);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "card_exp_year", nulls = Nulls.SKIP)
        public _FinalStage cardExpYear(Optional<Integer> cardExpYear) {
            this.cardExpYear = cardExpYear;
            return this;
        }

        @java.lang.Override
        public _FinalStage cardExpMonth(Integer cardExpMonth) {
            this.cardExpMonth = Optional.ofNullable(cardExpMonth);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "card_exp_month", nulls = Nulls.SKIP)
        public _FinalStage cardExpMonth(Optional<Integer> cardExpMonth) {
            this.cardExpMonth = cardExpMonth;
            return this;
        }

        @java.lang.Override
        public _FinalStage cardBrand(String cardBrand) {
            this.cardBrand = Optional.ofNullable(cardBrand);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "card_brand", nulls = Nulls.SKIP)
        public _FinalStage cardBrand(Optional<String> cardBrand) {
            this.cardBrand = cardBrand;
            return this;
        }

        @java.lang.Override
        public _FinalStage billingName(String billingName) {
            this.billingName = Optional.ofNullable(billingName);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "billing_name", nulls = Nulls.SKIP)
        public _FinalStage billingName(Optional<String> billingName) {
            this.billingName = billingName;
            return this;
        }

        @java.lang.Override
        public _FinalStage billingEmail(String billingEmail) {
            this.billingEmail = Optional.ofNullable(billingEmail);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "billing_email", nulls = Nulls.SKIP)
        public _FinalStage billingEmail(Optional<String> billingEmail) {
            this.billingEmail = billingEmail;
            return this;
        }

        @java.lang.Override
        public _FinalStage bankName(String bankName) {
            this.bankName = Optional.ofNullable(bankName);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "bank_name", nulls = Nulls.SKIP)
        public _FinalStage bankName(Optional<String> bankName) {
            this.bankName = bankName;
            return this;
        }

        @java.lang.Override
        public _FinalStage accountName(String accountName) {
            this.accountName = Optional.ofNullable(accountName);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "account_name", nulls = Nulls.SKIP)
        public _FinalStage accountName(Optional<String> accountName) {
            this.accountName = accountName;
            return this;
        }

        @java.lang.Override
        public _FinalStage accountLast4(String accountLast4) {
            this.accountLast4 = Optional.ofNullable(accountLast4);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "account_last4", nulls = Nulls.SKIP)
        public _FinalStage accountLast4(Optional<String> accountLast4) {
            this.accountLast4 = accountLast4;
            return this;
        }

        @java.lang.Override
        public CreatePaymentMethodRequestBody build() {
            return new CreatePaymentMethodRequestBody(
                    accountLast4,
                    accountName,
                    bankName,
                    billingEmail,
                    billingName,
                    cardBrand,
                    cardExpMonth,
                    cardExpYear,
                    cardLast4,
                    customerExternalId,
                    externalId,
                    paymentMethodType,
                    additionalProperties);
        }
    }
}
