/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.billing.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.resources.billing.types.ListProductPricesRequestPriceUsageType;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ListProductPricesRequest.Builder.class)
public final class ListProductPricesRequest {
    private final Optional<List<String>> ids;

    private final Optional<String> name;

    private final Optional<String> q;

    private final Optional<ListProductPricesRequestPriceUsageType> priceUsageType;

    private final Optional<Boolean> withoutLinkedToPlan;

    private final Optional<Boolean> withOneTimeCharges;

    private final Optional<Boolean> withZeroPrice;

    private final Optional<Boolean> withPricesOnly;

    private final Optional<Boolean> isActive;

    private final Optional<Integer> limit;

    private final Optional<Integer> offset;

    private final Map<String, Object> additionalProperties;

    private ListProductPricesRequest(
            Optional<List<String>> ids,
            Optional<String> name,
            Optional<String> q,
            Optional<ListProductPricesRequestPriceUsageType> priceUsageType,
            Optional<Boolean> withoutLinkedToPlan,
            Optional<Boolean> withOneTimeCharges,
            Optional<Boolean> withZeroPrice,
            Optional<Boolean> withPricesOnly,
            Optional<Boolean> isActive,
            Optional<Integer> limit,
            Optional<Integer> offset,
            Map<String, Object> additionalProperties) {
        this.ids = ids;
        this.name = name;
        this.q = q;
        this.priceUsageType = priceUsageType;
        this.withoutLinkedToPlan = withoutLinkedToPlan;
        this.withOneTimeCharges = withOneTimeCharges;
        this.withZeroPrice = withZeroPrice;
        this.withPricesOnly = withPricesOnly;
        this.isActive = isActive;
        this.limit = limit;
        this.offset = offset;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("ids")
    public Optional<List<String>> getIds() {
        return ids;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return name;
    }

    @JsonProperty("q")
    public Optional<String> getQ() {
        return q;
    }

    @JsonProperty("price_usage_type")
    public Optional<ListProductPricesRequestPriceUsageType> getPriceUsageType() {
        return priceUsageType;
    }

    /**
     * @return Filter products that are not linked to any plan
     */
    @JsonProperty("without_linked_to_plan")
    public Optional<Boolean> getWithoutLinkedToPlan() {
        return withoutLinkedToPlan;
    }

    /**
     * @return Filter products that are one time charges
     */
    @JsonProperty("with_one_time_charges")
    public Optional<Boolean> getWithOneTimeCharges() {
        return withOneTimeCharges;
    }

    /**
     * @return Filter products that have zero price for free subscription type
     */
    @JsonProperty("with_zero_price")
    public Optional<Boolean> getWithZeroPrice() {
        return withZeroPrice;
    }

    /**
     * @return Filter products that have prices
     */
    @JsonProperty("with_prices_only")
    public Optional<Boolean> getWithPricesOnly() {
        return withPricesOnly;
    }

    /**
     * @return Filter products that are active
     */
    @JsonProperty("is_active")
    public Optional<Boolean> getIsActive() {
        return isActive;
    }

    /**
     * @return Page limit (default 100)
     */
    @JsonProperty("limit")
    public Optional<Integer> getLimit() {
        return limit;
    }

    /**
     * @return Page offset (default 0)
     */
    @JsonProperty("offset")
    public Optional<Integer> getOffset() {
        return offset;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ListProductPricesRequest && equalTo((ListProductPricesRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListProductPricesRequest other) {
        return ids.equals(other.ids)
                && name.equals(other.name)
                && q.equals(other.q)
                && priceUsageType.equals(other.priceUsageType)
                && withoutLinkedToPlan.equals(other.withoutLinkedToPlan)
                && withOneTimeCharges.equals(other.withOneTimeCharges)
                && withZeroPrice.equals(other.withZeroPrice)
                && withPricesOnly.equals(other.withPricesOnly)
                && isActive.equals(other.isActive)
                && limit.equals(other.limit)
                && offset.equals(other.offset);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.ids,
                this.name,
                this.q,
                this.priceUsageType,
                this.withoutLinkedToPlan,
                this.withOneTimeCharges,
                this.withZeroPrice,
                this.withPricesOnly,
                this.isActive,
                this.limit,
                this.offset);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<List<String>> ids = Optional.empty();

        private Optional<String> name = Optional.empty();

        private Optional<String> q = Optional.empty();

        private Optional<ListProductPricesRequestPriceUsageType> priceUsageType = Optional.empty();

        private Optional<Boolean> withoutLinkedToPlan = Optional.empty();

        private Optional<Boolean> withOneTimeCharges = Optional.empty();

        private Optional<Boolean> withZeroPrice = Optional.empty();

        private Optional<Boolean> withPricesOnly = Optional.empty();

        private Optional<Boolean> isActive = Optional.empty();

        private Optional<Integer> limit = Optional.empty();

        private Optional<Integer> offset = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ListProductPricesRequest other) {
            ids(other.getIds());
            name(other.getName());
            q(other.getQ());
            priceUsageType(other.getPriceUsageType());
            withoutLinkedToPlan(other.getWithoutLinkedToPlan());
            withOneTimeCharges(other.getWithOneTimeCharges());
            withZeroPrice(other.getWithZeroPrice());
            withPricesOnly(other.getWithPricesOnly());
            isActive(other.getIsActive());
            limit(other.getLimit());
            offset(other.getOffset());
            return this;
        }

        @JsonSetter(value = "ids", nulls = Nulls.SKIP)
        public Builder ids(Optional<List<String>> ids) {
            this.ids = ids;
            return this;
        }

        public Builder ids(List<String> ids) {
            this.ids = Optional.ofNullable(ids);
            return this;
        }

        public Builder ids(String ids) {
            this.ids = Optional.of(Collections.singletonList(ids));
            return this;
        }

        @JsonSetter(value = "name", nulls = Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @JsonSetter(value = "q", nulls = Nulls.SKIP)
        public Builder q(Optional<String> q) {
            this.q = q;
            return this;
        }

        public Builder q(String q) {
            this.q = Optional.ofNullable(q);
            return this;
        }

        @JsonSetter(value = "price_usage_type", nulls = Nulls.SKIP)
        public Builder priceUsageType(Optional<ListProductPricesRequestPriceUsageType> priceUsageType) {
            this.priceUsageType = priceUsageType;
            return this;
        }

        public Builder priceUsageType(ListProductPricesRequestPriceUsageType priceUsageType) {
            this.priceUsageType = Optional.ofNullable(priceUsageType);
            return this;
        }

        /**
         * <p>Filter products that are not linked to any plan</p>
         */
        @JsonSetter(value = "without_linked_to_plan", nulls = Nulls.SKIP)
        public Builder withoutLinkedToPlan(Optional<Boolean> withoutLinkedToPlan) {
            this.withoutLinkedToPlan = withoutLinkedToPlan;
            return this;
        }

        public Builder withoutLinkedToPlan(Boolean withoutLinkedToPlan) {
            this.withoutLinkedToPlan = Optional.ofNullable(withoutLinkedToPlan);
            return this;
        }

        /**
         * <p>Filter products that are one time charges</p>
         */
        @JsonSetter(value = "with_one_time_charges", nulls = Nulls.SKIP)
        public Builder withOneTimeCharges(Optional<Boolean> withOneTimeCharges) {
            this.withOneTimeCharges = withOneTimeCharges;
            return this;
        }

        public Builder withOneTimeCharges(Boolean withOneTimeCharges) {
            this.withOneTimeCharges = Optional.ofNullable(withOneTimeCharges);
            return this;
        }

        /**
         * <p>Filter products that have zero price for free subscription type</p>
         */
        @JsonSetter(value = "with_zero_price", nulls = Nulls.SKIP)
        public Builder withZeroPrice(Optional<Boolean> withZeroPrice) {
            this.withZeroPrice = withZeroPrice;
            return this;
        }

        public Builder withZeroPrice(Boolean withZeroPrice) {
            this.withZeroPrice = Optional.ofNullable(withZeroPrice);
            return this;
        }

        /**
         * <p>Filter products that have prices</p>
         */
        @JsonSetter(value = "with_prices_only", nulls = Nulls.SKIP)
        public Builder withPricesOnly(Optional<Boolean> withPricesOnly) {
            this.withPricesOnly = withPricesOnly;
            return this;
        }

        public Builder withPricesOnly(Boolean withPricesOnly) {
            this.withPricesOnly = Optional.ofNullable(withPricesOnly);
            return this;
        }

        /**
         * <p>Filter products that are active</p>
         */
        @JsonSetter(value = "is_active", nulls = Nulls.SKIP)
        public Builder isActive(Optional<Boolean> isActive) {
            this.isActive = isActive;
            return this;
        }

        public Builder isActive(Boolean isActive) {
            this.isActive = Optional.ofNullable(isActive);
            return this;
        }

        /**
         * <p>Page limit (default 100)</p>
         */
        @JsonSetter(value = "limit", nulls = Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        /**
         * <p>Page offset (default 0)</p>
         */
        @JsonSetter(value = "offset", nulls = Nulls.SKIP)
        public Builder offset(Optional<Integer> offset) {
            this.offset = offset;
            return this;
        }

        public Builder offset(Integer offset) {
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        public ListProductPricesRequest build() {
            return new ListProductPricesRequest(
                    ids,
                    name,
                    q,
                    priceUsageType,
                    withoutLinkedToPlan,
                    withOneTimeCharges,
                    withZeroPrice,
                    withPricesOnly,
                    isActive,
                    limit,
                    offset,
                    additionalProperties);
        }
    }
}
