/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.billing.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ListInvoicesParams.Builder.class)
public final class ListInvoicesParams {
    private final Optional<String> companyId;

    private final Optional<String> customerExternalId;

    private final Optional<Integer> limit;

    private final Optional<Integer> offset;

    private final Optional<String> subscriptionExternalId;

    private final Map<String, Object> additionalProperties;

    private ListInvoicesParams(
            Optional<String> companyId,
            Optional<String> customerExternalId,
            Optional<Integer> limit,
            Optional<Integer> offset,
            Optional<String> subscriptionExternalId,
            Map<String, Object> additionalProperties) {
        this.companyId = companyId;
        this.customerExternalId = customerExternalId;
        this.limit = limit;
        this.offset = offset;
        this.subscriptionExternalId = subscriptionExternalId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("company_id")
    public Optional<String> getCompanyId() {
        return companyId;
    }

    @JsonProperty("customer_external_id")
    public Optional<String> getCustomerExternalId() {
        return customerExternalId;
    }

    /**
     * @return Page limit (default 100)
     */
    @JsonProperty("limit")
    public Optional<Integer> getLimit() {
        return limit;
    }

    /**
     * @return Page offset (default 0)
     */
    @JsonProperty("offset")
    public Optional<Integer> getOffset() {
        return offset;
    }

    @JsonProperty("subscription_external_id")
    public Optional<String> getSubscriptionExternalId() {
        return subscriptionExternalId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ListInvoicesParams && equalTo((ListInvoicesParams) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListInvoicesParams other) {
        return companyId.equals(other.companyId)
                && customerExternalId.equals(other.customerExternalId)
                && limit.equals(other.limit)
                && offset.equals(other.offset)
                && subscriptionExternalId.equals(other.subscriptionExternalId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.companyId, this.customerExternalId, this.limit, this.offset, this.subscriptionExternalId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> companyId = Optional.empty();

        private Optional<String> customerExternalId = Optional.empty();

        private Optional<Integer> limit = Optional.empty();

        private Optional<Integer> offset = Optional.empty();

        private Optional<String> subscriptionExternalId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ListInvoicesParams other) {
            companyId(other.getCompanyId());
            customerExternalId(other.getCustomerExternalId());
            limit(other.getLimit());
            offset(other.getOffset());
            subscriptionExternalId(other.getSubscriptionExternalId());
            return this;
        }

        @JsonSetter(value = "company_id", nulls = Nulls.SKIP)
        public Builder companyId(Optional<String> companyId) {
            this.companyId = companyId;
            return this;
        }

        public Builder companyId(String companyId) {
            this.companyId = Optional.ofNullable(companyId);
            return this;
        }

        @JsonSetter(value = "customer_external_id", nulls = Nulls.SKIP)
        public Builder customerExternalId(Optional<String> customerExternalId) {
            this.customerExternalId = customerExternalId;
            return this;
        }

        public Builder customerExternalId(String customerExternalId) {
            this.customerExternalId = Optional.ofNullable(customerExternalId);
            return this;
        }

        /**
         * <p>Page limit (default 100)</p>
         */
        @JsonSetter(value = "limit", nulls = Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        /**
         * <p>Page offset (default 0)</p>
         */
        @JsonSetter(value = "offset", nulls = Nulls.SKIP)
        public Builder offset(Optional<Integer> offset) {
            this.offset = offset;
            return this;
        }

        public Builder offset(Integer offset) {
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        @JsonSetter(value = "subscription_external_id", nulls = Nulls.SKIP)
        public Builder subscriptionExternalId(Optional<String> subscriptionExternalId) {
            this.subscriptionExternalId = subscriptionExternalId;
            return this;
        }

        public Builder subscriptionExternalId(String subscriptionExternalId) {
            this.subscriptionExternalId = Optional.ofNullable(subscriptionExternalId);
            return this;
        }

        public ListInvoicesParams build() {
            return new ListInvoicesParams(
                    companyId, customerExternalId, limit, offset, subscriptionExternalId, additionalProperties);
        }
    }
}
