/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.checkout;

import com.schematic.api.core.ClientOptions;
import com.schematic.api.core.RequestOptions;
import com.schematic.api.resources.checkout.requests.CheckoutDataRequestBody;
import com.schematic.api.resources.checkout.requests.UpdateTrialEndRequestBody;
import com.schematic.api.resources.checkout.types.CheckoutInternalResponse;
import com.schematic.api.resources.checkout.types.GetCheckoutDataResponse;
import com.schematic.api.resources.checkout.types.ManagePlanResponse;
import com.schematic.api.resources.checkout.types.PreviewCheckoutInternalResponse;
import com.schematic.api.resources.checkout.types.PreviewManagePlanResponse;
import com.schematic.api.resources.checkout.types.UpdateCustomerSubscriptionTrialEndResponse;
import com.schematic.api.types.ChangeSubscriptionInternalRequestBody;
import com.schematic.api.types.ManagePlanRequest;
import java.util.concurrent.CompletableFuture;

public class AsyncCheckoutClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawCheckoutClient rawClient;

    public AsyncCheckoutClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawCheckoutClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawCheckoutClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<CheckoutInternalResponse> internal(ChangeSubscriptionInternalRequestBody request) {
        return this.rawClient.internal(request).thenApply(response -> response.body());
    }

    public CompletableFuture<CheckoutInternalResponse> internal(
            ChangeSubscriptionInternalRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.internal(request, requestOptions).thenApply(response -> response.body());
    }

    public CompletableFuture<GetCheckoutDataResponse> getCheckoutData(CheckoutDataRequestBody request) {
        return this.rawClient.getCheckoutData(request).thenApply(response -> response.body());
    }

    public CompletableFuture<GetCheckoutDataResponse> getCheckoutData(
            CheckoutDataRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.getCheckoutData(request, requestOptions).thenApply(response -> response.body());
    }

    public CompletableFuture<PreviewCheckoutInternalResponse> previewCheckoutInternal(
            ChangeSubscriptionInternalRequestBody request) {
        return this.rawClient.previewCheckoutInternal(request).thenApply(response -> response.body());
    }

    public CompletableFuture<PreviewCheckoutInternalResponse> previewCheckoutInternal(
            ChangeSubscriptionInternalRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.previewCheckoutInternal(request, requestOptions).thenApply(response -> response.body());
    }

    public CompletableFuture<ManagePlanResponse> managePlan(ManagePlanRequest request) {
        return this.rawClient.managePlan(request).thenApply(response -> response.body());
    }

    public CompletableFuture<ManagePlanResponse> managePlan(ManagePlanRequest request, RequestOptions requestOptions) {
        return this.rawClient.managePlan(request, requestOptions).thenApply(response -> response.body());
    }

    public CompletableFuture<PreviewManagePlanResponse> previewManagePlan(ManagePlanRequest request) {
        return this.rawClient.previewManagePlan(request).thenApply(response -> response.body());
    }

    public CompletableFuture<PreviewManagePlanResponse> previewManagePlan(
            ManagePlanRequest request, RequestOptions requestOptions) {
        return this.rawClient.previewManagePlan(request, requestOptions).thenApply(response -> response.body());
    }

    public CompletableFuture<UpdateCustomerSubscriptionTrialEndResponse> updateCustomerSubscriptionTrialEnd(
            String subscriptionId) {
        return this.rawClient.updateCustomerSubscriptionTrialEnd(subscriptionId).thenApply(response -> response.body());
    }

    public CompletableFuture<UpdateCustomerSubscriptionTrialEndResponse> updateCustomerSubscriptionTrialEnd(
            String subscriptionId, UpdateTrialEndRequestBody request) {
        return this.rawClient
                .updateCustomerSubscriptionTrialEnd(subscriptionId, request)
                .thenApply(response -> response.body());
    }

    public CompletableFuture<UpdateCustomerSubscriptionTrialEndResponse> updateCustomerSubscriptionTrialEnd(
            String subscriptionId, UpdateTrialEndRequestBody request, RequestOptions requestOptions) {
        return this.rawClient
                .updateCustomerSubscriptionTrialEnd(subscriptionId, request, requestOptions)
                .thenApply(response -> response.body());
    }
}
