/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.companies.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.resources.companies.types.ListCompaniesForAdvancedFilterRequestSortOrderDirection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ListCompaniesForAdvancedFilterRequest.Builder.class)
public final class ListCompaniesForAdvancedFilterRequest {
    private final Optional<List<String>> ids;

    private final Optional<List<String>> planIds;

    private final Optional<List<String>> featureIds;

    private final Optional<List<String>> creditTypeIds;

    private final Optional<List<String>> subscriptionStatuses;

    private final Optional<List<String>> subscriptionTypes;

    private final Optional<List<String>> displayProperties;

    private final Optional<Boolean> monetizedSubscriptions;

    private final Optional<String> q;

    private final Optional<Boolean> withoutPlan;

    private final Optional<Boolean> withoutSubscription;

    private final Optional<String> sortOrderColumn;

    private final Optional<ListCompaniesForAdvancedFilterRequestSortOrderDirection> sortOrderDirection;

    private final Optional<Integer> limit;

    private final Optional<Integer> offset;

    private final Map<String, Object> additionalProperties;

    private ListCompaniesForAdvancedFilterRequest(
            Optional<List<String>> ids,
            Optional<List<String>> planIds,
            Optional<List<String>> featureIds,
            Optional<List<String>> creditTypeIds,
            Optional<List<String>> subscriptionStatuses,
            Optional<List<String>> subscriptionTypes,
            Optional<List<String>> displayProperties,
            Optional<Boolean> monetizedSubscriptions,
            Optional<String> q,
            Optional<Boolean> withoutPlan,
            Optional<Boolean> withoutSubscription,
            Optional<String> sortOrderColumn,
            Optional<ListCompaniesForAdvancedFilterRequestSortOrderDirection> sortOrderDirection,
            Optional<Integer> limit,
            Optional<Integer> offset,
            Map<String, Object> additionalProperties) {
        this.ids = ids;
        this.planIds = planIds;
        this.featureIds = featureIds;
        this.creditTypeIds = creditTypeIds;
        this.subscriptionStatuses = subscriptionStatuses;
        this.subscriptionTypes = subscriptionTypes;
        this.displayProperties = displayProperties;
        this.monetizedSubscriptions = monetizedSubscriptions;
        this.q = q;
        this.withoutPlan = withoutPlan;
        this.withoutSubscription = withoutSubscription;
        this.sortOrderColumn = sortOrderColumn;
        this.sortOrderDirection = sortOrderDirection;
        this.limit = limit;
        this.offset = offset;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Filter companies by multiple company IDs (starts with comp_)
     */
    @JsonProperty("ids")
    public Optional<List<String>> getIds() {
        return ids;
    }

    /**
     * @return Filter companies by one or more plan IDs (each ID starts with plan_)
     */
    @JsonProperty("plan_ids")
    public Optional<List<String>> getPlanIds() {
        return planIds;
    }

    /**
     * @return Filter companies by one or more feature IDs (each ID starts with feat_)
     */
    @JsonProperty("feature_ids")
    public Optional<List<String>> getFeatureIds() {
        return featureIds;
    }

    /**
     * @return Filter companies by one or more credit type IDs (each ID starts with bcrd_)
     */
    @JsonProperty("credit_type_ids")
    public Optional<List<String>> getCreditTypeIds() {
        return creditTypeIds;
    }

    /**
     * @return Filter companies by one or more subscription statuses (active, canceled, expired, incomplete, incomplete_expired, past_due, paused, trialing, unpaid)
     */
    @JsonProperty("subscription_statuses")
    public Optional<List<String>> getSubscriptionStatuses() {
        return subscriptionStatuses;
    }

    /**
     * @return Filter companies by one or more subscription types (paid, free, trial)
     */
    @JsonProperty("subscription_types")
    public Optional<List<String>> getSubscriptionTypes() {
        return subscriptionTypes;
    }

    /**
     * @return Select the display columns to return (e.g. plan, subscription, users, last_seen_at)
     */
    @JsonProperty("display_properties")
    public Optional<List<String>> getDisplayProperties() {
        return displayProperties;
    }

    /**
     * @return Filter companies that have monetized subscriptions
     */
    @JsonProperty("monetized_subscriptions")
    public Optional<Boolean> getMonetizedSubscriptions() {
        return monetizedSubscriptions;
    }

    /**
     * @return Search for companies by name, keys or string traits
     */
    @JsonProperty("q")
    public Optional<String> getQ() {
        return q;
    }

    /**
     * @return Filter out companies that have a plan
     */
    @JsonProperty("without_plan")
    public Optional<Boolean> getWithoutPlan() {
        return withoutPlan;
    }

    /**
     * @return Filter out companies that have a subscription
     */
    @JsonProperty("without_subscription")
    public Optional<Boolean> getWithoutSubscription() {
        return withoutSubscription;
    }

    /**
     * @return Column to sort by (e.g. name, created_at, last_seen_at)
     */
    @JsonProperty("sort_order_column")
    public Optional<String> getSortOrderColumn() {
        return sortOrderColumn;
    }

    /**
     * @return Direction to sort by (asc or desc)
     */
    @JsonProperty("sort_order_direction")
    public Optional<ListCompaniesForAdvancedFilterRequestSortOrderDirection> getSortOrderDirection() {
        return sortOrderDirection;
    }

    /**
     * @return Page limit (default 100)
     */
    @JsonProperty("limit")
    public Optional<Integer> getLimit() {
        return limit;
    }

    /**
     * @return Page offset (default 0)
     */
    @JsonProperty("offset")
    public Optional<Integer> getOffset() {
        return offset;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ListCompaniesForAdvancedFilterRequest
                && equalTo((ListCompaniesForAdvancedFilterRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListCompaniesForAdvancedFilterRequest other) {
        return ids.equals(other.ids)
                && planIds.equals(other.planIds)
                && featureIds.equals(other.featureIds)
                && creditTypeIds.equals(other.creditTypeIds)
                && subscriptionStatuses.equals(other.subscriptionStatuses)
                && subscriptionTypes.equals(other.subscriptionTypes)
                && displayProperties.equals(other.displayProperties)
                && monetizedSubscriptions.equals(other.monetizedSubscriptions)
                && q.equals(other.q)
                && withoutPlan.equals(other.withoutPlan)
                && withoutSubscription.equals(other.withoutSubscription)
                && sortOrderColumn.equals(other.sortOrderColumn)
                && sortOrderDirection.equals(other.sortOrderDirection)
                && limit.equals(other.limit)
                && offset.equals(other.offset);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.ids,
                this.planIds,
                this.featureIds,
                this.creditTypeIds,
                this.subscriptionStatuses,
                this.subscriptionTypes,
                this.displayProperties,
                this.monetizedSubscriptions,
                this.q,
                this.withoutPlan,
                this.withoutSubscription,
                this.sortOrderColumn,
                this.sortOrderDirection,
                this.limit,
                this.offset);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<List<String>> ids = Optional.empty();

        private Optional<List<String>> planIds = Optional.empty();

        private Optional<List<String>> featureIds = Optional.empty();

        private Optional<List<String>> creditTypeIds = Optional.empty();

        private Optional<List<String>> subscriptionStatuses = Optional.empty();

        private Optional<List<String>> subscriptionTypes = Optional.empty();

        private Optional<List<String>> displayProperties = Optional.empty();

        private Optional<Boolean> monetizedSubscriptions = Optional.empty();

        private Optional<String> q = Optional.empty();

        private Optional<Boolean> withoutPlan = Optional.empty();

        private Optional<Boolean> withoutSubscription = Optional.empty();

        private Optional<String> sortOrderColumn = Optional.empty();

        private Optional<ListCompaniesForAdvancedFilterRequestSortOrderDirection> sortOrderDirection = Optional.empty();

        private Optional<Integer> limit = Optional.empty();

        private Optional<Integer> offset = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ListCompaniesForAdvancedFilterRequest other) {
            ids(other.getIds());
            planIds(other.getPlanIds());
            featureIds(other.getFeatureIds());
            creditTypeIds(other.getCreditTypeIds());
            subscriptionStatuses(other.getSubscriptionStatuses());
            subscriptionTypes(other.getSubscriptionTypes());
            displayProperties(other.getDisplayProperties());
            monetizedSubscriptions(other.getMonetizedSubscriptions());
            q(other.getQ());
            withoutPlan(other.getWithoutPlan());
            withoutSubscription(other.getWithoutSubscription());
            sortOrderColumn(other.getSortOrderColumn());
            sortOrderDirection(other.getSortOrderDirection());
            limit(other.getLimit());
            offset(other.getOffset());
            return this;
        }

        /**
         * <p>Filter companies by multiple company IDs (starts with comp_)</p>
         */
        @JsonSetter(value = "ids", nulls = Nulls.SKIP)
        public Builder ids(Optional<List<String>> ids) {
            this.ids = ids;
            return this;
        }

        public Builder ids(List<String> ids) {
            this.ids = Optional.ofNullable(ids);
            return this;
        }

        public Builder ids(String ids) {
            this.ids = Optional.of(Collections.singletonList(ids));
            return this;
        }

        /**
         * <p>Filter companies by one or more plan IDs (each ID starts with plan_)</p>
         */
        @JsonSetter(value = "plan_ids", nulls = Nulls.SKIP)
        public Builder planIds(Optional<List<String>> planIds) {
            this.planIds = planIds;
            return this;
        }

        public Builder planIds(List<String> planIds) {
            this.planIds = Optional.ofNullable(planIds);
            return this;
        }

        public Builder planIds(String planIds) {
            this.planIds = Optional.of(Collections.singletonList(planIds));
            return this;
        }

        /**
         * <p>Filter companies by one or more feature IDs (each ID starts with feat_)</p>
         */
        @JsonSetter(value = "feature_ids", nulls = Nulls.SKIP)
        public Builder featureIds(Optional<List<String>> featureIds) {
            this.featureIds = featureIds;
            return this;
        }

        public Builder featureIds(List<String> featureIds) {
            this.featureIds = Optional.ofNullable(featureIds);
            return this;
        }

        public Builder featureIds(String featureIds) {
            this.featureIds = Optional.of(Collections.singletonList(featureIds));
            return this;
        }

        /**
         * <p>Filter companies by one or more credit type IDs (each ID starts with bcrd_)</p>
         */
        @JsonSetter(value = "credit_type_ids", nulls = Nulls.SKIP)
        public Builder creditTypeIds(Optional<List<String>> creditTypeIds) {
            this.creditTypeIds = creditTypeIds;
            return this;
        }

        public Builder creditTypeIds(List<String> creditTypeIds) {
            this.creditTypeIds = Optional.ofNullable(creditTypeIds);
            return this;
        }

        public Builder creditTypeIds(String creditTypeIds) {
            this.creditTypeIds = Optional.of(Collections.singletonList(creditTypeIds));
            return this;
        }

        /**
         * <p>Filter companies by one or more subscription statuses (active, canceled, expired, incomplete, incomplete_expired, past_due, paused, trialing, unpaid)</p>
         */
        @JsonSetter(value = "subscription_statuses", nulls = Nulls.SKIP)
        public Builder subscriptionStatuses(Optional<List<String>> subscriptionStatuses) {
            this.subscriptionStatuses = subscriptionStatuses;
            return this;
        }

        public Builder subscriptionStatuses(List<String> subscriptionStatuses) {
            this.subscriptionStatuses = Optional.ofNullable(subscriptionStatuses);
            return this;
        }

        public Builder subscriptionStatuses(String subscriptionStatuses) {
            this.subscriptionStatuses = Optional.of(Collections.singletonList(subscriptionStatuses));
            return this;
        }

        /**
         * <p>Filter companies by one or more subscription types (paid, free, trial)</p>
         */
        @JsonSetter(value = "subscription_types", nulls = Nulls.SKIP)
        public Builder subscriptionTypes(Optional<List<String>> subscriptionTypes) {
            this.subscriptionTypes = subscriptionTypes;
            return this;
        }

        public Builder subscriptionTypes(List<String> subscriptionTypes) {
            this.subscriptionTypes = Optional.ofNullable(subscriptionTypes);
            return this;
        }

        public Builder subscriptionTypes(String subscriptionTypes) {
            this.subscriptionTypes = Optional.of(Collections.singletonList(subscriptionTypes));
            return this;
        }

        /**
         * <p>Select the display columns to return (e.g. plan, subscription, users, last_seen_at)</p>
         */
        @JsonSetter(value = "display_properties", nulls = Nulls.SKIP)
        public Builder displayProperties(Optional<List<String>> displayProperties) {
            this.displayProperties = displayProperties;
            return this;
        }

        public Builder displayProperties(List<String> displayProperties) {
            this.displayProperties = Optional.ofNullable(displayProperties);
            return this;
        }

        public Builder displayProperties(String displayProperties) {
            this.displayProperties = Optional.of(Collections.singletonList(displayProperties));
            return this;
        }

        /**
         * <p>Filter companies that have monetized subscriptions</p>
         */
        @JsonSetter(value = "monetized_subscriptions", nulls = Nulls.SKIP)
        public Builder monetizedSubscriptions(Optional<Boolean> monetizedSubscriptions) {
            this.monetizedSubscriptions = monetizedSubscriptions;
            return this;
        }

        public Builder monetizedSubscriptions(Boolean monetizedSubscriptions) {
            this.monetizedSubscriptions = Optional.ofNullable(monetizedSubscriptions);
            return this;
        }

        /**
         * <p>Search for companies by name, keys or string traits</p>
         */
        @JsonSetter(value = "q", nulls = Nulls.SKIP)
        public Builder q(Optional<String> q) {
            this.q = q;
            return this;
        }

        public Builder q(String q) {
            this.q = Optional.ofNullable(q);
            return this;
        }

        /**
         * <p>Filter out companies that have a plan</p>
         */
        @JsonSetter(value = "without_plan", nulls = Nulls.SKIP)
        public Builder withoutPlan(Optional<Boolean> withoutPlan) {
            this.withoutPlan = withoutPlan;
            return this;
        }

        public Builder withoutPlan(Boolean withoutPlan) {
            this.withoutPlan = Optional.ofNullable(withoutPlan);
            return this;
        }

        /**
         * <p>Filter out companies that have a subscription</p>
         */
        @JsonSetter(value = "without_subscription", nulls = Nulls.SKIP)
        public Builder withoutSubscription(Optional<Boolean> withoutSubscription) {
            this.withoutSubscription = withoutSubscription;
            return this;
        }

        public Builder withoutSubscription(Boolean withoutSubscription) {
            this.withoutSubscription = Optional.ofNullable(withoutSubscription);
            return this;
        }

        /**
         * <p>Column to sort by (e.g. name, created_at, last_seen_at)</p>
         */
        @JsonSetter(value = "sort_order_column", nulls = Nulls.SKIP)
        public Builder sortOrderColumn(Optional<String> sortOrderColumn) {
            this.sortOrderColumn = sortOrderColumn;
            return this;
        }

        public Builder sortOrderColumn(String sortOrderColumn) {
            this.sortOrderColumn = Optional.ofNullable(sortOrderColumn);
            return this;
        }

        /**
         * <p>Direction to sort by (asc or desc)</p>
         */
        @JsonSetter(value = "sort_order_direction", nulls = Nulls.SKIP)
        public Builder sortOrderDirection(
                Optional<ListCompaniesForAdvancedFilterRequestSortOrderDirection> sortOrderDirection) {
            this.sortOrderDirection = sortOrderDirection;
            return this;
        }

        public Builder sortOrderDirection(ListCompaniesForAdvancedFilterRequestSortOrderDirection sortOrderDirection) {
            this.sortOrderDirection = Optional.ofNullable(sortOrderDirection);
            return this;
        }

        /**
         * <p>Page limit (default 100)</p>
         */
        @JsonSetter(value = "limit", nulls = Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        /**
         * <p>Page offset (default 0)</p>
         */
        @JsonSetter(value = "offset", nulls = Nulls.SKIP)
        public Builder offset(Optional<Integer> offset) {
            this.offset = offset;
            return this;
        }

        public Builder offset(Integer offset) {
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        public ListCompaniesForAdvancedFilterRequest build() {
            return new ListCompaniesForAdvancedFilterRequest(
                    ids,
                    planIds,
                    featureIds,
                    creditTypeIds,
                    subscriptionStatuses,
                    subscriptionTypes,
                    displayProperties,
                    monetizedSubscriptions,
                    q,
                    withoutPlan,
                    withoutSubscription,
                    sortOrderColumn,
                    sortOrderDirection,
                    limit,
                    offset,
                    additionalProperties);
        }
    }
}
