/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.companies.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = UpdatePlanTraitRequestBody.Builder.class)
public final class UpdatePlanTraitRequestBody {
    private final String planId;

    private final String traitValue;

    private final Map<String, Object> additionalProperties;

    private UpdatePlanTraitRequestBody(String planId, String traitValue, Map<String, Object> additionalProperties) {
        this.planId = planId;
        this.traitValue = traitValue;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("plan_id")
    public String getPlanId() {
        return planId;
    }

    @JsonProperty("trait_value")
    public String getTraitValue() {
        return traitValue;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof UpdatePlanTraitRequestBody && equalTo((UpdatePlanTraitRequestBody) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdatePlanTraitRequestBody other) {
        return planId.equals(other.planId) && traitValue.equals(other.traitValue);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.planId, this.traitValue);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PlanIdStage builder() {
        return new Builder();
    }

    public interface PlanIdStage {
        TraitValueStage planId(@NotNull String planId);

        Builder from(UpdatePlanTraitRequestBody other);
    }

    public interface TraitValueStage {
        _FinalStage traitValue(@NotNull String traitValue);
    }

    public interface _FinalStage {
        UpdatePlanTraitRequestBody build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements PlanIdStage, TraitValueStage, _FinalStage {
        private String planId;

        private String traitValue;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(UpdatePlanTraitRequestBody other) {
            planId(other.getPlanId());
            traitValue(other.getTraitValue());
            return this;
        }

        @java.lang.Override
        @JsonSetter("plan_id")
        public TraitValueStage planId(@NotNull String planId) {
            this.planId = Objects.requireNonNull(planId, "planId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("trait_value")
        public _FinalStage traitValue(@NotNull String traitValue) {
            this.traitValue = Objects.requireNonNull(traitValue, "traitValue must not be null");
            return this;
        }

        @java.lang.Override
        public UpdatePlanTraitRequestBody build() {
            return new UpdatePlanTraitRequestBody(planId, traitValue, additionalProperties);
        }
    }
}
