/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.companies.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ListCompaniesForAdvancedFilterParams.Builder.class)
public final class ListCompaniesForAdvancedFilterParams {
    private final Optional<List<String>> creditTypeIds;

    private final Optional<List<String>> displayProperties;

    private final Optional<List<String>> featureIds;

    private final Optional<List<String>> ids;

    private final Optional<Integer> limit;

    private final Optional<Boolean> monetizedSubscriptions;

    private final Optional<Integer> offset;

    private final Optional<List<String>> planIds;

    private final Optional<String> q;

    private final Optional<String> sortOrderColumn;

    private final Optional<ListCompaniesForAdvancedFilterResponseParamsSortOrderDirection> sortOrderDirection;

    private final Optional<List<String>> subscriptionStatuses;

    private final Optional<List<String>> subscriptionTypes;

    private final Optional<Boolean> withoutPlan;

    private final Optional<Boolean> withoutSubscription;

    private final Map<String, Object> additionalProperties;

    private ListCompaniesForAdvancedFilterParams(
            Optional<List<String>> creditTypeIds,
            Optional<List<String>> displayProperties,
            Optional<List<String>> featureIds,
            Optional<List<String>> ids,
            Optional<Integer> limit,
            Optional<Boolean> monetizedSubscriptions,
            Optional<Integer> offset,
            Optional<List<String>> planIds,
            Optional<String> q,
            Optional<String> sortOrderColumn,
            Optional<ListCompaniesForAdvancedFilterResponseParamsSortOrderDirection> sortOrderDirection,
            Optional<List<String>> subscriptionStatuses,
            Optional<List<String>> subscriptionTypes,
            Optional<Boolean> withoutPlan,
            Optional<Boolean> withoutSubscription,
            Map<String, Object> additionalProperties) {
        this.creditTypeIds = creditTypeIds;
        this.displayProperties = displayProperties;
        this.featureIds = featureIds;
        this.ids = ids;
        this.limit = limit;
        this.monetizedSubscriptions = monetizedSubscriptions;
        this.offset = offset;
        this.planIds = planIds;
        this.q = q;
        this.sortOrderColumn = sortOrderColumn;
        this.sortOrderDirection = sortOrderDirection;
        this.subscriptionStatuses = subscriptionStatuses;
        this.subscriptionTypes = subscriptionTypes;
        this.withoutPlan = withoutPlan;
        this.withoutSubscription = withoutSubscription;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Filter companies by one or more credit type IDs (each ID starts with bcrd_)
     */
    @JsonProperty("credit_type_ids")
    public Optional<List<String>> getCreditTypeIds() {
        return creditTypeIds;
    }

    /**
     * @return Select the display columns to return (e.g. plan, subscription, users, last_seen_at)
     */
    @JsonProperty("display_properties")
    public Optional<List<String>> getDisplayProperties() {
        return displayProperties;
    }

    /**
     * @return Filter companies by one or more feature IDs (each ID starts with feat_)
     */
    @JsonProperty("feature_ids")
    public Optional<List<String>> getFeatureIds() {
        return featureIds;
    }

    /**
     * @return Filter companies by multiple company IDs (starts with comp_)
     */
    @JsonProperty("ids")
    public Optional<List<String>> getIds() {
        return ids;
    }

    /**
     * @return Page limit (default 100)
     */
    @JsonProperty("limit")
    public Optional<Integer> getLimit() {
        return limit;
    }

    /**
     * @return Filter companies that have monetized subscriptions
     */
    @JsonProperty("monetized_subscriptions")
    public Optional<Boolean> getMonetizedSubscriptions() {
        return monetizedSubscriptions;
    }

    /**
     * @return Page offset (default 0)
     */
    @JsonProperty("offset")
    public Optional<Integer> getOffset() {
        return offset;
    }

    /**
     * @return Filter companies by one or more plan IDs (each ID starts with plan_)
     */
    @JsonProperty("plan_ids")
    public Optional<List<String>> getPlanIds() {
        return planIds;
    }

    /**
     * @return Search for companies by name, keys or string traits
     */
    @JsonProperty("q")
    public Optional<String> getQ() {
        return q;
    }

    /**
     * @return Column to sort by (e.g. name, created_at, last_seen_at)
     */
    @JsonProperty("sort_order_column")
    public Optional<String> getSortOrderColumn() {
        return sortOrderColumn;
    }

    /**
     * @return Direction to sort by (asc or desc)
     */
    @JsonProperty("sort_order_direction")
    public Optional<ListCompaniesForAdvancedFilterResponseParamsSortOrderDirection> getSortOrderDirection() {
        return sortOrderDirection;
    }

    /**
     * @return Filter companies by one or more subscription statuses (active, canceled, expired, incomplete, incomplete_expired, past_due, paused, trialing, unpaid)
     */
    @JsonProperty("subscription_statuses")
    public Optional<List<String>> getSubscriptionStatuses() {
        return subscriptionStatuses;
    }

    /**
     * @return Filter companies by one or more subscription types (paid, free, trial)
     */
    @JsonProperty("subscription_types")
    public Optional<List<String>> getSubscriptionTypes() {
        return subscriptionTypes;
    }

    /**
     * @return Filter out companies that have a plan
     */
    @JsonProperty("without_plan")
    public Optional<Boolean> getWithoutPlan() {
        return withoutPlan;
    }

    /**
     * @return Filter out companies that have a subscription
     */
    @JsonProperty("without_subscription")
    public Optional<Boolean> getWithoutSubscription() {
        return withoutSubscription;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ListCompaniesForAdvancedFilterParams
                && equalTo((ListCompaniesForAdvancedFilterParams) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListCompaniesForAdvancedFilterParams other) {
        return creditTypeIds.equals(other.creditTypeIds)
                && displayProperties.equals(other.displayProperties)
                && featureIds.equals(other.featureIds)
                && ids.equals(other.ids)
                && limit.equals(other.limit)
                && monetizedSubscriptions.equals(other.monetizedSubscriptions)
                && offset.equals(other.offset)
                && planIds.equals(other.planIds)
                && q.equals(other.q)
                && sortOrderColumn.equals(other.sortOrderColumn)
                && sortOrderDirection.equals(other.sortOrderDirection)
                && subscriptionStatuses.equals(other.subscriptionStatuses)
                && subscriptionTypes.equals(other.subscriptionTypes)
                && withoutPlan.equals(other.withoutPlan)
                && withoutSubscription.equals(other.withoutSubscription);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.creditTypeIds,
                this.displayProperties,
                this.featureIds,
                this.ids,
                this.limit,
                this.monetizedSubscriptions,
                this.offset,
                this.planIds,
                this.q,
                this.sortOrderColumn,
                this.sortOrderDirection,
                this.subscriptionStatuses,
                this.subscriptionTypes,
                this.withoutPlan,
                this.withoutSubscription);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<List<String>> creditTypeIds = Optional.empty();

        private Optional<List<String>> displayProperties = Optional.empty();

        private Optional<List<String>> featureIds = Optional.empty();

        private Optional<List<String>> ids = Optional.empty();

        private Optional<Integer> limit = Optional.empty();

        private Optional<Boolean> monetizedSubscriptions = Optional.empty();

        private Optional<Integer> offset = Optional.empty();

        private Optional<List<String>> planIds = Optional.empty();

        private Optional<String> q = Optional.empty();

        private Optional<String> sortOrderColumn = Optional.empty();

        private Optional<ListCompaniesForAdvancedFilterResponseParamsSortOrderDirection> sortOrderDirection =
                Optional.empty();

        private Optional<List<String>> subscriptionStatuses = Optional.empty();

        private Optional<List<String>> subscriptionTypes = Optional.empty();

        private Optional<Boolean> withoutPlan = Optional.empty();

        private Optional<Boolean> withoutSubscription = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ListCompaniesForAdvancedFilterParams other) {
            creditTypeIds(other.getCreditTypeIds());
            displayProperties(other.getDisplayProperties());
            featureIds(other.getFeatureIds());
            ids(other.getIds());
            limit(other.getLimit());
            monetizedSubscriptions(other.getMonetizedSubscriptions());
            offset(other.getOffset());
            planIds(other.getPlanIds());
            q(other.getQ());
            sortOrderColumn(other.getSortOrderColumn());
            sortOrderDirection(other.getSortOrderDirection());
            subscriptionStatuses(other.getSubscriptionStatuses());
            subscriptionTypes(other.getSubscriptionTypes());
            withoutPlan(other.getWithoutPlan());
            withoutSubscription(other.getWithoutSubscription());
            return this;
        }

        /**
         * <p>Filter companies by one or more credit type IDs (each ID starts with bcrd_)</p>
         */
        @JsonSetter(value = "credit_type_ids", nulls = Nulls.SKIP)
        public Builder creditTypeIds(Optional<List<String>> creditTypeIds) {
            this.creditTypeIds = creditTypeIds;
            return this;
        }

        public Builder creditTypeIds(List<String> creditTypeIds) {
            this.creditTypeIds = Optional.ofNullable(creditTypeIds);
            return this;
        }

        /**
         * <p>Select the display columns to return (e.g. plan, subscription, users, last_seen_at)</p>
         */
        @JsonSetter(value = "display_properties", nulls = Nulls.SKIP)
        public Builder displayProperties(Optional<List<String>> displayProperties) {
            this.displayProperties = displayProperties;
            return this;
        }

        public Builder displayProperties(List<String> displayProperties) {
            this.displayProperties = Optional.ofNullable(displayProperties);
            return this;
        }

        /**
         * <p>Filter companies by one or more feature IDs (each ID starts with feat_)</p>
         */
        @JsonSetter(value = "feature_ids", nulls = Nulls.SKIP)
        public Builder featureIds(Optional<List<String>> featureIds) {
            this.featureIds = featureIds;
            return this;
        }

        public Builder featureIds(List<String> featureIds) {
            this.featureIds = Optional.ofNullable(featureIds);
            return this;
        }

        /**
         * <p>Filter companies by multiple company IDs (starts with comp_)</p>
         */
        @JsonSetter(value = "ids", nulls = Nulls.SKIP)
        public Builder ids(Optional<List<String>> ids) {
            this.ids = ids;
            return this;
        }

        public Builder ids(List<String> ids) {
            this.ids = Optional.ofNullable(ids);
            return this;
        }

        /**
         * <p>Page limit (default 100)</p>
         */
        @JsonSetter(value = "limit", nulls = Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        /**
         * <p>Filter companies that have monetized subscriptions</p>
         */
        @JsonSetter(value = "monetized_subscriptions", nulls = Nulls.SKIP)
        public Builder monetizedSubscriptions(Optional<Boolean> monetizedSubscriptions) {
            this.monetizedSubscriptions = monetizedSubscriptions;
            return this;
        }

        public Builder monetizedSubscriptions(Boolean monetizedSubscriptions) {
            this.monetizedSubscriptions = Optional.ofNullable(monetizedSubscriptions);
            return this;
        }

        /**
         * <p>Page offset (default 0)</p>
         */
        @JsonSetter(value = "offset", nulls = Nulls.SKIP)
        public Builder offset(Optional<Integer> offset) {
            this.offset = offset;
            return this;
        }

        public Builder offset(Integer offset) {
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        /**
         * <p>Filter companies by one or more plan IDs (each ID starts with plan_)</p>
         */
        @JsonSetter(value = "plan_ids", nulls = Nulls.SKIP)
        public Builder planIds(Optional<List<String>> planIds) {
            this.planIds = planIds;
            return this;
        }

        public Builder planIds(List<String> planIds) {
            this.planIds = Optional.ofNullable(planIds);
            return this;
        }

        /**
         * <p>Search for companies by name, keys or string traits</p>
         */
        @JsonSetter(value = "q", nulls = Nulls.SKIP)
        public Builder q(Optional<String> q) {
            this.q = q;
            return this;
        }

        public Builder q(String q) {
            this.q = Optional.ofNullable(q);
            return this;
        }

        /**
         * <p>Column to sort by (e.g. name, created_at, last_seen_at)</p>
         */
        @JsonSetter(value = "sort_order_column", nulls = Nulls.SKIP)
        public Builder sortOrderColumn(Optional<String> sortOrderColumn) {
            this.sortOrderColumn = sortOrderColumn;
            return this;
        }

        public Builder sortOrderColumn(String sortOrderColumn) {
            this.sortOrderColumn = Optional.ofNullable(sortOrderColumn);
            return this;
        }

        /**
         * <p>Direction to sort by (asc or desc)</p>
         */
        @JsonSetter(value = "sort_order_direction", nulls = Nulls.SKIP)
        public Builder sortOrderDirection(
                Optional<ListCompaniesForAdvancedFilterResponseParamsSortOrderDirection> sortOrderDirection) {
            this.sortOrderDirection = sortOrderDirection;
            return this;
        }

        public Builder sortOrderDirection(
                ListCompaniesForAdvancedFilterResponseParamsSortOrderDirection sortOrderDirection) {
            this.sortOrderDirection = Optional.ofNullable(sortOrderDirection);
            return this;
        }

        /**
         * <p>Filter companies by one or more subscription statuses (active, canceled, expired, incomplete, incomplete_expired, past_due, paused, trialing, unpaid)</p>
         */
        @JsonSetter(value = "subscription_statuses", nulls = Nulls.SKIP)
        public Builder subscriptionStatuses(Optional<List<String>> subscriptionStatuses) {
            this.subscriptionStatuses = subscriptionStatuses;
            return this;
        }

        public Builder subscriptionStatuses(List<String> subscriptionStatuses) {
            this.subscriptionStatuses = Optional.ofNullable(subscriptionStatuses);
            return this;
        }

        /**
         * <p>Filter companies by one or more subscription types (paid, free, trial)</p>
         */
        @JsonSetter(value = "subscription_types", nulls = Nulls.SKIP)
        public Builder subscriptionTypes(Optional<List<String>> subscriptionTypes) {
            this.subscriptionTypes = subscriptionTypes;
            return this;
        }

        public Builder subscriptionTypes(List<String> subscriptionTypes) {
            this.subscriptionTypes = Optional.ofNullable(subscriptionTypes);
            return this;
        }

        /**
         * <p>Filter out companies that have a plan</p>
         */
        @JsonSetter(value = "without_plan", nulls = Nulls.SKIP)
        public Builder withoutPlan(Optional<Boolean> withoutPlan) {
            this.withoutPlan = withoutPlan;
            return this;
        }

        public Builder withoutPlan(Boolean withoutPlan) {
            this.withoutPlan = Optional.ofNullable(withoutPlan);
            return this;
        }

        /**
         * <p>Filter out companies that have a subscription</p>
         */
        @JsonSetter(value = "without_subscription", nulls = Nulls.SKIP)
        public Builder withoutSubscription(Optional<Boolean> withoutSubscription) {
            this.withoutSubscription = withoutSubscription;
            return this;
        }

        public Builder withoutSubscription(Boolean withoutSubscription) {
            this.withoutSubscription = Optional.ofNullable(withoutSubscription);
            return this;
        }

        public ListCompaniesForAdvancedFilterParams build() {
            return new ListCompaniesForAdvancedFilterParams(
                    creditTypeIds,
                    displayProperties,
                    featureIds,
                    ids,
                    limit,
                    monetizedSubscriptions,
                    offset,
                    planIds,
                    q,
                    sortOrderColumn,
                    sortOrderDirection,
                    subscriptionStatuses,
                    subscriptionTypes,
                    withoutPlan,
                    withoutSubscription,
                    additionalProperties);
        }
    }
}
